/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.tileentities.machines;

import appeng.api.config.Actionable;
import appeng.api.config.PowerMultiplier;
import appeng.api.implementations.IPowerChannelState;
import appeng.api.networking.GridFlags;
import appeng.api.networking.security.BaseActionSource;
import appeng.api.networking.security.IActionHost;
import appeng.api.networking.security.MachineSource;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.data.IAEFluidStack;
import appeng.api.storage.data.IAEStack;
import appeng.api.util.AECableType;
import appeng.core.localization.WailaText;
import appeng.me.GridAccessException;
import appeng.me.helpers.AENetworkProxy;
import appeng.me.helpers.IGridProxyable;
import appeng.util.item.AEFluidStack;
import com.gtnewhorizons.modularui.api.ModularUITextures;
import com.gtnewhorizons.modularui.api.drawable.AdaptableUITexture;
import com.gtnewhorizons.modularui.api.drawable.IDrawable;
import com.gtnewhorizons.modularui.api.drawable.Text;
import com.gtnewhorizons.modularui.api.fluids.IFluidTanksHandler;
import com.gtnewhorizons.modularui.api.math.Alignment;
import com.gtnewhorizons.modularui.api.math.Color;
import com.gtnewhorizons.modularui.api.math.Pos2d;
import com.gtnewhorizons.modularui.api.math.Size;
import com.gtnewhorizons.modularui.api.screen.ModularWindow;
import com.gtnewhorizons.modularui.api.screen.UIBuildContext;
import com.gtnewhorizons.modularui.api.widget.Interactable;
import com.gtnewhorizons.modularui.api.widget.Widget;
import com.gtnewhorizons.modularui.common.fluid.FluidStackTank;
import com.gtnewhorizons.modularui.common.widget.ButtonWidget;
import com.gtnewhorizons.modularui.common.widget.DrawableWidget;
import com.gtnewhorizons.modularui.common.widget.FakeSyncWidget;
import com.gtnewhorizons.modularui.common.widget.FluidSlotWidget;
import com.gtnewhorizons.modularui.common.widget.SlotGroup;
import com.gtnewhorizons.modularui.common.widget.TextWidget;
import com.gtnewhorizons.modularui.common.widget.textfield.NumericWidget;
import gregtech.api.enums.GT_Values;
import gregtech.api.enums.ItemList;
import gregtech.api.enums.Textures;
import gregtech.api.gui.modularui.GT_UITextures;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.modularui.IAddGregtechLogo;
import gregtech.api.interfaces.modularui.IAddUIWidgets;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_Input;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_MultiBlockBase;
import gregtech.api.recipe.check.CheckRecipeResult;
import gregtech.api.recipe.check.CheckRecipeResultRegistry;
import gregtech.api.recipe.check.SimpleCheckRecipeResult;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GT_Utility;
import gregtech.api.util.shutdown.ShutDownReasonRegistry;
import gregtech.common.tileentities.machines.IRecipeProcessingAwareHatch;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidStack;

public class GT_MetaTileEntity_Hatch_Input_ME
extends GT_MetaTileEntity_Hatch_Input
implements IPowerChannelState,
IAddGregtechLogo,
IAddUIWidgets,
IRecipeProcessingAwareHatch {
    private static final int SLOT_COUNT = 16;
    protected final FluidStack[] storedFluids = new FluidStack[16];
    protected final FluidStack[] storedInformationFluids = new FluidStack[16];
    protected final FluidStack[] shadowStoredFluids = new FluidStack[16];
    private final int[] savedStackSizes = new int[16];
    private boolean additionalConnection = false;
    protected BaseActionSource requestSource = null;
    @Nullable
    protected AENetworkProxy gridProxy = null;
    private final boolean autoPullAvailable;
    protected boolean autoPullFluidList = false;
    protected int minAutoPullAmount = 1;
    private int autoPullRefreshTime = 100;
    protected boolean processingRecipe = false;
    protected static final int CONFIG_WINDOW_ID = 10;
    protected static final FluidStack[] EMPTY_FLUID_STACK = new FluidStack[0];

    public GT_MetaTileEntity_Hatch_Input_ME(int aID, boolean autoPullAvailable, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional, autoPullAvailable ? 10 : 8, 1, GT_MetaTileEntity_Hatch_Input_ME.getDescriptionArray(autoPullAvailable));
        this.autoPullAvailable = autoPullAvailable;
    }

    public GT_MetaTileEntity_Hatch_Input_ME(String aName, boolean autoPullAvailable, int aTier, String[] aDescription, ITexture[][][] aTextures) {
        super(aName, 1, aTier, aDescription, aTextures);
        this.autoPullAvailable = autoPullAvailable;
    }

    @Override
    public MetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new GT_MetaTileEntity_Hatch_Input_ME(this.mName, this.autoPullAvailable, (int)this.mTier, this.mDescriptionArray, this.mTextures);
    }

    @Override
    public ITexture[] getTexturesActive(ITexture aBaseTexture) {
        return new ITexture[]{aBaseTexture, TextureFactory.of(Textures.BlockIcons.OVERLAY_ME_INPUT_FLUID_HATCH_ACTIVE)};
    }

    @Override
    public ITexture[] getTexturesInactive(ITexture aBaseTexture) {
        return new ITexture[]{aBaseTexture, TextureFactory.of(Textures.BlockIcons.OVERLAY_ME_INPUT_FLUID_HATCH)};
    }

    @Override
    public void onPostTick(IGregTechTileEntity aBaseMetaTileEntity, long aTimer) {
        if (this.getBaseMetaTileEntity().isServerSide()) {
            if (aTimer % (long)this.autoPullRefreshTime == 0L && this.autoPullFluidList) {
                this.refreshFluidList();
            }
            if (aTimer % 20L == 0L) {
                this.getBaseMetaTileEntity().setActive(this.isActive());
            }
        }
        super.onPostTick(aBaseMetaTileEntity, aTimer);
    }

    private void refreshFluidList() {
        AENetworkProxy proxy = this.getProxy();
        if (proxy == null || !proxy.isActive()) {
            return;
        }
        try {
            IMEMonitor sg = proxy.getStorage().getFluidInventory();
            Iterator iterator = sg.getStorageList().iterator();
            int index = 0;
            while (iterator.hasNext() && index < 16) {
                FluidStack fluidStack;
                IAEFluidStack currItem = (IAEFluidStack)iterator.next();
                if (currItem.getStackSize() < (long)this.minAutoPullAmount) continue;
                this.storedFluids[index] = fluidStack = GT_Utility.copyAmount(1, currItem.getFluidStack());
                ++index;
            }
            for (int i = index; i < 16; ++i) {
                this.storedFluids[i] = null;
            }
        }
        catch (GridAccessException gridAccessException) {
            // empty catch block
        }
    }

    @Override
    public boolean displaysStackSize() {
        return true;
    }

    protected void setSavedFluid(int i, FluidStack stack) {
        this.shadowStoredFluids[i] = stack;
        this.savedStackSizes[i] = stack == null ? 0 : stack.amount;
    }

    public FluidStack[] getStoredFluids() {
        if (!this.processingRecipe) {
            return EMPTY_FLUID_STACK;
        }
        AENetworkProxy proxy = this.getProxy();
        if (proxy == null || !proxy.isActive()) {
            return EMPTY_FLUID_STACK;
        }
        this.updateAllInformationSlots();
        for (int i = 0; i < 16; ++i) {
            if (this.storedFluids[i] == null) {
                this.setSavedFluid(i, null);
                continue;
            }
            FluidStack fluidStackWithAmount = this.storedInformationFluids[i];
            if (fluidStackWithAmount == null) continue;
            this.setSavedFluid(i, fluidStackWithAmount);
        }
        return this.shadowStoredFluids;
    }

    @Override
    public FluidStack drain(ForgeDirection side, FluidStack aFluid, boolean doDrain) {
        if (side != ForgeDirection.UNKNOWN) {
            return null;
        }
        FluidStack stored = this.getMatchingFluidStack(aFluid);
        if (stored == null) {
            return null;
        }
        FluidStack drained = GT_Utility.copyAmount(Math.min(stored.amount, aFluid.amount), stored);
        if (doDrain) {
            stored.amount -= drained.amount;
        }
        return drained;
    }

    @Override
    public void startRecipeProcessing() {
        this.processingRecipe = true;
        this.updateAllInformationSlots();
    }

    @Override
    public CheckRecipeResult endRecipeProcessing(GT_MetaTileEntity_MultiBlockBase controller) {
        CheckRecipeResult checkRecipeResult = CheckRecipeResultRegistry.SUCCESSFUL;
        AENetworkProxy proxy = this.getProxy();
        for (int i = 0; i < 16; ++i) {
            FluidStack oldStack = this.shadowStoredFluids[i];
            int toExtract = this.savedStackSizes[i] - (oldStack != null ? oldStack.amount : 0);
            if (toExtract <= 0) continue;
            try {
                IMEMonitor sg = proxy.getStorage().getFluidInventory();
                AEFluidStack request = AEFluidStack.create((Object)this.storedFluids[i]);
                request.setStackSize((long)toExtract);
                IAEFluidStack extractionResult = (IAEFluidStack)sg.extractItems((IAEStack)request, Actionable.MODULATE, this.getRequestSource());
                proxy.getEnergy().extractAEPower((double)toExtract, Actionable.MODULATE, PowerMultiplier.CONFIG);
                if (extractionResult == null || extractionResult.getStackSize() != (long)toExtract) {
                    controller.stopMachine(ShutDownReasonRegistry.CRITICAL_NONE);
                    checkRecipeResult = SimpleCheckRecipeResult.ofFailurePersistOnShutdown("stocking_hatch_fail_extraction");
                }
            }
            catch (GridAccessException ignored) {
                controller.stopMachine(ShutDownReasonRegistry.CRITICAL_NONE);
                checkRecipeResult = SimpleCheckRecipeResult.ofFailurePersistOnShutdown("stocking_hatch_fail_extraction");
            }
            this.setSavedFluid(i, null);
            if (this.storedInformationFluids[i] == null || this.storedInformationFluids[i].amount > 0) continue;
            this.storedInformationFluids[i] = null;
        }
        this.processingRecipe = false;
        return checkRecipeResult;
    }

    @Override
    public void onFirstTick(IGregTechTileEntity aBaseMetaTileEntity) {
        super.onFirstTick(aBaseMetaTileEntity);
        this.getProxy().onReady();
    }

    @Override
    public AECableType getCableConnectionType(ForgeDirection forgeDirection) {
        return this.isOutputFacing(forgeDirection) ? AECableType.SMART : AECableType.NONE;
    }

    private void updateValidGridProxySides() {
        if (this.additionalConnection) {
            this.getProxy().setValidSides(EnumSet.complementOf(EnumSet.of(ForgeDirection.UNKNOWN)));
        } else {
            this.getProxy().setValidSides(EnumSet.of(this.getBaseMetaTileEntity().getFrontFacing()));
        }
    }

    @Override
    public void onFacingChange() {
        this.updateValidGridProxySides();
    }

    @Override
    public boolean onWireCutterRightClick(ForgeDirection side, ForgeDirection wrenchingSide, EntityPlayer aPlayer, float aX, float aY, float aZ) {
        this.additionalConnection = !this.additionalConnection;
        this.updateValidGridProxySides();
        aPlayer.func_146105_b((IChatComponent)new ChatComponentTranslation("GT5U.hatch.additionalConnection." + this.additionalConnection, new Object[0]));
        return true;
    }

    @Override
    public AENetworkProxy getProxy() {
        if (this.gridProxy == null && this.getBaseMetaTileEntity() instanceof IGridProxyable) {
            this.gridProxy = new AENetworkProxy((IGridProxyable)this.getBaseMetaTileEntity(), "proxy", this.autoPullAvailable ? ItemList.Hatch_Input_ME_Advanced.get(1L, new Object[0]) : ItemList.Hatch_Input_ME.get(1L, new Object[0]), true);
            this.gridProxy.setFlags(new GridFlags[]{GridFlags.REQUIRE_CHANNEL});
            this.updateValidGridProxySides();
            if (this.getBaseMetaTileEntity().getWorld() != null) {
                this.gridProxy.setOwner(this.getBaseMetaTileEntity().getWorld().func_72924_a(this.getBaseMetaTileEntity().getOwnerName()));
            }
        }
        return this.gridProxy;
    }

    public boolean isPowered() {
        return this.getProxy() != null && this.getProxy().isPowered();
    }

    public boolean isActive() {
        return this.getProxy() != null && this.getProxy().isActive();
    }

    private void setAutoPullFluidList(boolean pullFluidList) {
        if (!this.autoPullAvailable) {
            return;
        }
        this.autoPullFluidList = pullFluidList;
        if (!this.autoPullFluidList) {
            Arrays.fill(this.storedFluids, null);
        } else {
            this.refreshFluidList();
        }
        this.updateAllInformationSlots();
    }

    private void updateAllInformationSlots() {
        for (int index = 0; index < 16; ++index) {
            this.updateInformationSlot(index);
        }
    }

    public void updateInformationSlot(int index) {
        if (index < 0 || index >= 16) {
            return;
        }
        FluidStack fluidStack = this.storedFluids[index];
        if (fluidStack == null) {
            this.storedInformationFluids[index] = null;
            return;
        }
        AENetworkProxy proxy = this.getProxy();
        if (proxy == null || !proxy.isActive()) {
            this.storedInformationFluids[index] = null;
            return;
        }
        try {
            FluidStack resultFluid;
            IMEMonitor sg = proxy.getStorage().getFluidInventory();
            AEFluidStack request = AEFluidStack.create((Object)fluidStack);
            request.setStackSize(Integer.MAX_VALUE);
            IAEFluidStack result = (IAEFluidStack)sg.extractItems((IAEStack)request, Actionable.SIMULATE, this.getRequestSource());
            this.storedInformationFluids[index] = resultFluid = result != null ? result.getFluidStack() : null;
        }
        catch (GridAccessException gridAccessException) {
            // empty catch block
        }
    }

    private BaseActionSource getRequestSource() {
        if (this.requestSource == null) {
            this.requestSource = new MachineSource((IActionHost)this.getBaseMetaTileEntity());
        }
        return this.requestSource;
    }

    public FluidStack getMatchingFluidStack(FluidStack fluidStack) {
        if (fluidStack == null) {
            return null;
        }
        AENetworkProxy proxy = this.getProxy();
        if (proxy == null || !proxy.isActive()) {
            return null;
        }
        for (int i = 0; i < this.storedFluids.length; ++i) {
            if (this.storedFluids[i] == null || !GT_Utility.areFluidsEqual(fluidStack, this.storedFluids[i], false)) continue;
            this.updateInformationSlot(i);
            if (this.storedInformationFluids[i] != null) {
                this.setSavedFluid(i, this.storedInformationFluids[i]);
                return this.shadowStoredFluids[i];
            }
            this.setSavedFluid(i, null);
            return null;
        }
        return null;
    }

    public FluidStack getShadowFluidStack(int index) {
        if (index < 0 || index >= this.storedFluids.length) {
            return null;
        }
        return this.shadowStoredFluids[index];
    }

    public int getFluidSlot(FluidStack fluidStack) {
        if (fluidStack == null) {
            return -1;
        }
        for (int i = 0; i < this.storedFluids.length; ++i) {
            if (this.storedFluids[i] == null || !GT_Utility.areFluidsEqual(fluidStack, this.storedFluids[i], false)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public boolean canTankBeEmptied() {
        return false;
    }

    @Override
    public boolean canTankBeFilled() {
        return false;
    }

    @Override
    public boolean doesEmptyContainers() {
        return false;
    }

    @Override
    public boolean isValidSlot(int aIndex) {
        return false;
    }

    @Override
    public void saveNBTData(NBTTagCompound aNBT) {
        super.saveNBTData(aNBT);
        NBTTagList nbtTagList = new NBTTagList();
        for (int i = 0; i < 16; ++i) {
            FluidStack fluidStack = this.storedFluids[i];
            if (fluidStack == null) continue;
            NBTTagCompound fluidTag = fluidStack.writeToNBT(new NBTTagCompound());
            if (this.storedInformationFluids[i] != null) {
                fluidTag.func_74768_a("informationAmount", this.storedInformationFluids[i].amount);
            }
            nbtTagList.func_74742_a((NBTBase)fluidTag);
        }
        aNBT.func_74782_a("storedFluids", (NBTBase)nbtTagList);
        aNBT.func_74757_a("autoPull", this.autoPullFluidList);
        aNBT.func_74768_a("minAmount", this.minAutoPullAmount);
        aNBT.func_74757_a("additionalConnection", this.additionalConnection);
        aNBT.func_74768_a("refreshTime", this.autoPullRefreshTime);
        this.getProxy().writeToNBT(aNBT);
    }

    @Override
    public void loadNBTData(NBTTagCompound aNBT) {
        super.loadNBTData(aNBT);
        if (aNBT.func_74764_b("storedFluids")) {
            NBTTagList nbtTagList = aNBT.func_150295_c("storedFluids", 10);
            int c = Math.min(nbtTagList.func_74745_c(), 16);
            for (int i = 0; i < c; ++i) {
                FluidStack fluidStack;
                NBTTagCompound nbtTagCompound = nbtTagList.func_150305_b(i);
                this.storedFluids[i] = fluidStack = GT_Utility.loadFluid(nbtTagCompound);
                if (!nbtTagCompound.func_74764_b("informationAmount")) continue;
                int informationAmount = nbtTagCompound.func_74762_e("informationAmount");
                this.storedInformationFluids[i] = GT_Utility.copyAmount(informationAmount, fluidStack);
            }
        }
        this.minAutoPullAmount = aNBT.func_74762_e("minAmount");
        this.autoPullFluidList = aNBT.func_74767_n("autoPull");
        this.additionalConnection = aNBT.func_74767_n("additionalConnection");
        if (aNBT.func_74764_b("refreshTime")) {
            this.autoPullRefreshTime = aNBT.func_74762_e("refreshTime");
        }
        this.getProxy().readFromNBT(aNBT);
    }

    @Override
    public void onScrewdriverRightClick(ForgeDirection side, EntityPlayer aPlayer, float aX, float aY, float aZ) {
        if (!this.autoPullAvailable) {
            return;
        }
        this.setAutoPullFluidList(!this.autoPullFluidList);
        aPlayer.func_145747_a((IChatComponent)new ChatComponentTranslation("GT5U.machines.stocking_hatch.auto_pull_toggle." + (this.autoPullFluidList ? "enabled" : "disabled"), new Object[0]));
    }

    @Override
    public boolean onRightclick(IGregTechTileEntity aBaseMetaTileEntity, EntityPlayer aPlayer, ForgeDirection side, float aX, float aY, float aZ) {
        if (!(aPlayer instanceof EntityPlayerMP)) {
            return super.onRightclick(aBaseMetaTileEntity, aPlayer, side, aX, aY, aZ);
        }
        ItemStack dataStick = aPlayer.field_71071_by.func_70448_g();
        if (!ItemList.Tool_DataStick.isStackEqual(dataStick, false, true)) {
            return super.onRightclick(aBaseMetaTileEntity, aPlayer, side, aX, aY, aZ);
        }
        if (!dataStick.func_77942_o() || !"stockingHatch".equals(dataStick.field_77990_d.func_74779_i("type"))) {
            return false;
        }
        NBTTagCompound nbt = dataStick.field_77990_d;
        if (this.autoPullAvailable) {
            this.setAutoPullFluidList(nbt.func_74767_n("autoPull"));
            this.minAutoPullAmount = nbt.func_74762_e("minAmount");
            this.autoPullRefreshTime = nbt.func_74762_e("refreshTime");
        }
        this.additionalConnection = nbt.func_74767_n("additionalConnection");
        if (!this.autoPullFluidList) {
            NBTTagList stockingFluids = nbt.func_150295_c("fluidsToStock", 10);
            for (int i = 0; i < stockingFluids.func_74745_c(); ++i) {
                this.storedFluids[i] = GT_Utility.loadFluid(stockingFluids.func_150305_b(i));
            }
        }
        this.updateValidGridProxySides();
        aPlayer.func_145747_a((IChatComponent)new ChatComponentTranslation("GT5U.machines.stocking_bus.loaded", new Object[0]));
        return true;
    }

    @Override
    public void onLeftclick(IGregTechTileEntity aBaseMetaTileEntity, EntityPlayer aPlayer) {
        if (!(aPlayer instanceof EntityPlayerMP)) {
            return;
        }
        ItemStack dataStick = aPlayer.field_71071_by.func_70448_g();
        if (!ItemList.Tool_DataStick.isStackEqual(dataStick, false, true)) {
            return;
        }
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74778_a("type", "stockingHatch");
        tag.func_74757_a("autoPull", this.autoPullFluidList);
        tag.func_74768_a("minAmount", this.minAutoPullAmount);
        tag.func_74757_a("additionalConnection", this.additionalConnection);
        tag.func_74768_a("refreshTime", this.autoPullRefreshTime);
        NBTTagList stockingFluids = new NBTTagList();
        if (!this.autoPullFluidList) {
            for (int index = 0; index < 16; ++index) {
                FluidStack fluidStack = this.storedFluids[index];
                if (fluidStack == null) continue;
                stockingFluids.func_74742_a((NBTBase)fluidStack.writeToNBT(new NBTTagCompound()));
            }
            tag.func_74782_a("fluidsToStock", (NBTBase)stockingFluids);
        }
        dataStick.field_77990_d = tag;
        dataStick.func_151001_c("Stocking Input Hatch Configuration");
        aPlayer.func_145747_a((IChatComponent)new ChatComponentTranslation("GT5U.machines.stocking_bus.saved", new Object[0]));
    }

    @Override
    public void onExplosion() {
        for (int i = 0; i < 16; ++i) {
            this.mInventory[i] = null;
        }
    }

    public boolean containsSuchStack(FluidStack tStack) {
        for (int i = 0; i < 16; ++i) {
            if (!GT_Utility.areFluidsEqual(this.storedFluids[i], tStack, false)) continue;
            return true;
        }
        return false;
    }

    @Override
    public int getGUIHeight() {
        return 179;
    }

    @Override
    public void addUIWidgets(ModularWindow.Builder builder, UIBuildContext buildContext) {
        if (this.autoPullAvailable) {
            buildContext.addSyncedWindow(10, this::createStackSizeConfigurationWindow);
        }
        builder.widget(SlotGroup.ofFluidTanks(IntStream.range(0, 16).mapToObj(index -> this.createTankForFluidStack(this.storedFluids, index, 1)).collect(Collectors.toList()), (int)4).phantom(true).widgetCreator((slotIndex, h) -> (FluidSlotWidget)new FluidSlotWidget((IFluidTanksHandler)h, (Integer)slotIndex){
            final /* synthetic */ Integer val$slotIndex;
            {
                this.val$slotIndex = n;
                super(singleSlotHandler);
            }

            protected void tryClickPhantom(Widget.ClickData clickData, ItemStack cursorStack) {
                if (clickData.mouseButton != 0 || GT_MetaTileEntity_Hatch_Input_ME.this.autoPullFluidList) {
                    return;
                }
                FluidStack heldFluid = this.getFluidForPhantomItem(cursorStack);
                if (cursorStack == null) {
                    GT_MetaTileEntity_Hatch_Input_ME.this.storedFluids[this.val$slotIndex.intValue()] = null;
                } else {
                    if (GT_MetaTileEntity_Hatch_Input_ME.this.containsSuchStack(heldFluid)) {
                        return;
                    }
                    GT_MetaTileEntity_Hatch_Input_ME.this.storedFluids[this.val$slotIndex.intValue()] = heldFluid;
                }
                if (GT_MetaTileEntity_Hatch_Input_ME.this.getBaseMetaTileEntity().isServerSide()) {
                    GT_MetaTileEntity_Hatch_Input_ME.this.updateInformationSlot(this.val$slotIndex);
                    this.detectAndSendChanges(false);
                }
            }

            protected void tryScrollPhantom(int direction) {
            }

            public IDrawable[] getBackground() {
                AdaptableUITexture slot = GT_MetaTileEntity_Hatch_Input_ME.this.autoPullFluidList ? GT_UITextures.SLOT_DARK_GRAY : ModularUITextures.FLUID_SLOT;
                return new IDrawable[]{slot, GT_UITextures.OVERLAY_SLOT_ARROW_ME};
            }

            public void buildTooltip(List<Text> tooltip) {
                FluidStack fluid = this.getContent();
                if (fluid != null) {
                    this.addFluidNameInfo(tooltip, fluid);
                    if (!GT_MetaTileEntity_Hatch_Input_ME.this.autoPullFluidList) {
                        tooltip.add(Text.localised((String)"modularui.phantom.single.clear", (Object[])new Object[0]));
                    }
                } else {
                    tooltip.add(Text.localised((String)"modularui.fluid.empty", (Object[])new Object[0]).format(EnumChatFormatting.WHITE));
                }
                if (GT_MetaTileEntity_Hatch_Input_ME.this.autoPullFluidList) {
                    tooltip.add(Text.localised((String)"GT5U.machines.stocking_bus.cannot_set_slot", (Object[])new Object[0]));
                }
            }
        }.setUpdateTooltipEveryTick(true)).build().setPos(new Pos2d(7, 9)));
        builder.widget(SlotGroup.ofFluidTanks(IntStream.range(0, 16).mapToObj(index -> this.createTankForFluidStack(this.storedInformationFluids, index, Integer.MAX_VALUE)).collect(Collectors.toList()), (int)4).phantom(true).widgetCreator((slotIndex, h) -> (FluidSlotWidget)new FluidSlotWidget((IFluidTanksHandler)h){

            protected void tryClickPhantom(Widget.ClickData clickData, ItemStack cursorStack) {
            }

            protected void tryScrollPhantom(int direction) {
            }

            public void buildTooltip(List<Text> tooltip) {
                FluidStack fluid = this.getContent();
                if (fluid != null) {
                    this.addFluidNameInfo(tooltip, fluid);
                    tooltip.add(Text.localised((String)"modularui.fluid.phantom.amount", (Object[])new Object[]{fluid.amount}));
                    this.addAdditionalFluidInfo(tooltip, fluid);
                    if (!Interactable.hasShiftDown()) {
                        tooltip.add(Text.EMPTY);
                        tooltip.add(Text.localised((String)"modularui.tooltip.shift", (Object[])new Object[0]));
                    }
                } else {
                    tooltip.add(Text.localised((String)"modularui.fluid.empty", (Object[])new Object[0]).format(EnumChatFormatting.WHITE));
                }
            }
        }.setUpdateTooltipEveryTick(true)).background(new IDrawable[]{GT_UITextures.SLOT_DARK_GRAY}).controlsAmount(true).build().setPos(new Pos2d(97, 9)));
        if (this.autoPullAvailable) {
            ((ModularWindow.Builder)builder.widget(new ButtonWidget().setOnClick((clickData, widget) -> {
                if (clickData.mouseButton == 0) {
                    this.setAutoPullFluidList(!this.autoPullFluidList);
                } else if (clickData.mouseButton == 1 && !widget.isClient()) {
                    widget.getContext().openSyncedWindow(10);
                }
            }).setPlayClickSound(true).setBackground(() -> {
                if (this.autoPullFluidList) {
                    return new IDrawable[]{GT_UITextures.BUTTON_STANDARD_PRESSED, GT_UITextures.OVERLAY_BUTTON_AUTOPULL_ME};
                }
                return new IDrawable[]{GT_UITextures.BUTTON_STANDARD, GT_UITextures.OVERLAY_BUTTON_AUTOPULL_ME_DISABLED};
            }).addTooltips(Arrays.asList(StatCollector.func_74838_a((String)"GT5U.machines.stocking_hatch.auto_pull.tooltip.1"), StatCollector.func_74838_a((String)"GT5U.machines.stocking_hatch.auto_pull.tooltip.2"))).setSize(16, 16).setPos(80, 10))).widget((Widget)new FakeSyncWidget.BooleanSyncer(() -> this.autoPullFluidList, this::setAutoPullFluidList));
        }
        ((ModularWindow.Builder)builder.widget(new DrawableWidget().setDrawable((IDrawable)GT_UITextures.PICTURE_ARROW_DOUBLE).setPos(82, 30).setSize(12, 12))).widget(TextWidget.dynamicString(() -> {
            boolean isActive = this.isActive();
            boolean isPowered = this.isPowered();
            boolean isBooting = this.isBooting();
            EnumChatFormatting color = isActive && isPowered ? EnumChatFormatting.GREEN : EnumChatFormatting.DARK_RED;
            return color + WailaText.getPowerState((boolean)isActive, (boolean)isPowered, (boolean)isBooting);
        }).setTextAlignment(Alignment.Center).setSize(90, 9).setPos(43, 84));
    }

    private FluidStackTank createTankForFluidStack(FluidStack[] fluidStacks, int slotIndex, int capacity) {
        return new FluidStackTank(() -> fluidStacks[slotIndex], stack -> {
            if (this.getBaseMetaTileEntity().isServerSide()) {
                return;
            }
            fluidStacks[slotIndex] = stack;
        }, capacity);
    }

    protected ModularWindow createStackSizeConfigurationWindow(EntityPlayer player) {
        int WIDTH = 78;
        int HEIGHT = 80;
        int PARENT_WIDTH = this.getGUIWidth();
        int PARENT_HEIGHT = this.getGUIHeight();
        ModularWindow.Builder builder = ModularWindow.builder((int)78, (int)80);
        builder.setBackground(new IDrawable[]{GT_UITextures.BACKGROUND_SINGLEBLOCK_DEFAULT});
        builder.setGuiTint(this.getGUIColorization());
        builder.setDraggable(true);
        builder.setPos((size, window) -> Alignment.Center.getAlignedPos(size, new Size(PARENT_WIDTH, PARENT_HEIGHT)).add(Alignment.TopRight.getAlignedPos(new Size(PARENT_WIDTH, PARENT_HEIGHT), new Size(78, 80)).add(75, 0)));
        ((ModularWindow.Builder)builder.widget(TextWidget.localised((String)"GT5U.machines.stocking_hatch.min_amount", (Object[])new Object[0]).setPos(3, 2).setSize(74, 14))).widget(new NumericWidget().setSetter(val -> {
            this.minAutoPullAmount = (int)val;
        }).setGetter(() -> this.minAutoPullAmount).setBounds(1.0, 2.147483647E9).setScrollValues(1.0, 4.0, 64.0).setTextAlignment(Alignment.Center).setTextColor(Color.WHITE.normal).setSize(70, 18).setPos(3, 18).setBackground(new IDrawable[]{GT_UITextures.BACKGROUND_TEXT_FIELD}));
        ((ModularWindow.Builder)builder.widget(TextWidget.localised((String)"GT5U.machines.stocking_bus.refresh_time", (Object[])new Object[0]).setPos(3, 42).setSize(74, 14))).widget(new NumericWidget().setSetter(val -> {
            this.autoPullRefreshTime = (int)val;
        }).setGetter(() -> this.autoPullRefreshTime).setBounds(1.0, 2.147483647E9).setScrollValues(1.0, 4.0, 64.0).setTextAlignment(Alignment.Center).setTextColor(Color.WHITE.normal).setSize(70, 18).setPos(3, 58).setBackground(new IDrawable[]{GT_UITextures.BACKGROUND_TEXT_FIELD}));
        return builder.build();
    }

    @Override
    public void addGregTechLogo(ModularWindow.Builder builder) {
        builder.widget(new DrawableWidget().setDrawable((IDrawable)this.getGUITextureSet().getGregTechLogo()).setSize(17, 17).setPos(80, 63));
    }

    @Override
    public void getWailaBody(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        if (!this.autoPullAvailable) {
            super.getWailaBody(itemStack, currenttip, accessor, config);
            return;
        }
        NBTTagCompound tag = accessor.getNBTData();
        boolean autopull = tag.func_74767_n("autoPull");
        int minSize = tag.func_74762_e("minAmount");
        currenttip.add(StatCollector.func_74838_a((String)("GT5U.waila.stocking_bus.auto_pull." + (autopull ? "enabled" : "disabled"))));
        if (autopull) {
            currenttip.add(StatCollector.func_74837_a((String)"GT5U.waila.stocking_hatch.min_amount", (Object[])new Object[]{GT_Utility.formatNumbers(minSize)}));
        }
        super.getWailaBody(itemStack, currenttip, accessor, config);
    }

    @Override
    public void getWailaNBTData(EntityPlayerMP player, TileEntity tile, NBTTagCompound tag, World world, int x, int y, int z) {
        if (!this.autoPullAvailable) {
            super.getWailaNBTData(player, tile, tag, world, x, y, z);
            return;
        }
        tag.func_74757_a("autoPull", this.autoPullFluidList);
        tag.func_74768_a("minAmount", this.minAutoPullAmount);
        super.getWailaNBTData(player, tile, tag, world, x, y, z);
    }

    private static String[] getDescriptionArray(boolean autoPullAvailable) {
        ArrayList<String> strings = new ArrayList<String>(8);
        strings.add("Advanced fluid input for Multiblocks");
        strings.add("Hatch Tier: " + GT_Values.TIER_COLORS[autoPullAvailable ? 10 : 8] + GT_Values.VN[autoPullAvailable ? 10 : 8]);
        strings.add("Retrieves directly from ME");
        strings.add("Keeps 16 fluid types in stock");
        if (autoPullAvailable) {
            strings.add("Auto-Pull from ME mode will automatically stock the first 16 fluid in the ME system, updated every 5 seconds.");
            strings.add("Toggle by right-clicking with screwdriver, or use the GUI.");
            strings.add("Use the GUI to limit the minimum stack size for Auto-Pulling and adjust the slot refresh timer.");
        }
        strings.add("Change ME connection behavior by right-clicking with wire cutter.");
        strings.add("Configuration data can be copy+pasted using a data stick.");
        return strings.toArray(new String[0]);
    }
}

