/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.objects.overclockdescriber;

import gregtech.api.enums.GT_Values;
import gregtech.api.objects.overclockdescriber.EUOverclockDescriber;
import gregtech.api.util.GT_OverclockCalculator;
import gregtech.api.util.GT_Recipe;
import gregtech.api.util.GT_Utility;
import gregtech.api.util.MethodsReturnNonnullByDefault;
import gregtech.nei.formatter.FusionSpecialValueFormatter;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.util.EnumChatFormatting;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class FusionOverclockDescriber
extends EUOverclockDescriber {
    protected final long capableStartup;

    public FusionOverclockDescriber(byte energyTier, long capableStartup) {
        super(energyTier, 1);
        this.capableStartup = capableStartup;
    }

    @Override
    public GT_OverclockCalculator createCalculator(GT_OverclockCalculator template, GT_Recipe recipe) {
        return super.createCalculator(template, recipe).limitOverclockCount(this.overclock(recipe.mSpecialValue, recipe.mEUt)).setEUtIncreasePerOC(this.getEUtIncreasePerOC()).setDurationDecreasePerOC(this.getDurationDecreasePerOC());
    }

    protected int getEUtIncreasePerOC() {
        return 1;
    }

    protected int getDurationDecreasePerOC() {
        return 1;
    }

    @Override
    public String getTierString() {
        return GT_Values.TIER_COLORS[this.tier] + "MK " + this.getFusionTier() + EnumChatFormatting.RESET;
    }

    @Override
    public boolean canHandle(GT_Recipe recipe) {
        byte tier = GT_Utility.getTier(recipe.mEUt);
        if (this.tier < tier) {
            return false;
        }
        return this.capableStartup >= (long)recipe.mSpecialValue;
    }

    protected int overclock(long startEnergy, long voltage) {
        return Math.max(this.getFusionTier() - FusionSpecialValueFormatter.getFusionTier(startEnergy, voltage), 0);
    }

    protected int getFusionTier() {
        return this.tier - 5;
    }
}

