/*
 * Decompiled with CFR 0.152.
 */
package forge.com.gitlab.cdagaming.craftpresence.utils.gui.widgets;

import com.gitlab.cdagaming.craftpresence.core.config.element.ColorData;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import forge.com.gitlab.cdagaming.craftpresence.utils.gui.RenderUtils;
import forge.com.gitlab.cdagaming.craftpresence.utils.gui.integrations.ExtendedScreen;
import forge.com.gitlab.cdagaming.craftpresence.utils.gui.widgets.DynamicWidget;
import java.util.function.Supplier;

public class TexturedWidget
implements DynamicWidget {
    private final ExtendedScreen parent;
    private int startX;
    private int startY;
    private int width;
    private int height;
    private double offset;
    private Supplier<Float> tintSupplier;
    private Supplier<ColorData> infoSupplier;
    private boolean hasBorder;

    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"})
    public TexturedWidget(ExtendedScreen parent, int startX, int startY, int width, int height, double offset, Supplier<Float> tintSupplier, Supplier<ColorData> infoSupplier, boolean hasBorder) {
        this.parent = parent;
        this.setControlPosX(startX);
        this.setControlPosY(startY);
        this.setControlWidth(width);
        this.setControlHeight(height);
        this.setOffset(offset);
        this.setTintSupplier(tintSupplier);
        this.setInfoSupplier(infoSupplier);
        this.setBorderState(hasBorder);
    }

    @Override
    public void preDraw(ExtendedScreen screen) {
    }

    @Override
    public void draw(ExtendedScreen screen) {
        if (this.hasBorder()) {
            RenderUtils.drawGradientBox(this.getControlPosX() - 1, this.getControlPosY() - 1, this.getControlWidth() + 2, this.getControlHeight() + 2, 300.0, "#000000", "#000000", 1, null, null);
        }
        this.parent.drawBackground(this.getLeft(), this.getRight(), this.getTop(), this.getBottom(), this.getOffset(), this.getTintFactor(), 0.0, 0.0, this.getInfo());
    }

    @Override
    public void postDraw(ExtendedScreen screen) {
    }

    public double getOffset() {
        return this.offset;
    }

    public void setOffset(double offset) {
        this.offset = offset;
    }

    public Supplier<Float> getTintSupplier() {
        return this.tintSupplier;
    }

    public void setTintSupplier(Supplier<Float> tintSupplier) {
        this.tintSupplier = tintSupplier;
    }

    public float getTintFactor() {
        return this.getTintSupplier().get().floatValue();
    }

    public Supplier<ColorData> getInfoSupplier() {
        return this.infoSupplier;
    }

    public void setInfoSupplier(Supplier<ColorData> infoSupplier) {
        this.infoSupplier = infoSupplier;
    }

    public ColorData getInfo() {
        return this.getInfoSupplier().get();
    }

    public boolean hasBorder() {
        return this.hasBorder;
    }

    public void setBorderState(boolean hasBorder) {
        this.hasBorder = hasBorder;
    }

    @Override
    public int getControlPosX() {
        return this.startX;
    }

    @Override
    public void setControlPosX(int posX) {
        this.startX = posX;
    }

    @Override
    public int getControlPosY() {
        return this.startY;
    }

    @Override
    public void setControlPosY(int posY) {
        this.startY = posY;
    }

    @Override
    public int getControlWidth() {
        return this.width - this.startX;
    }

    @Override
    public void setControlWidth(int width) {
        this.width = width;
    }

    @Override
    public int getControlHeight() {
        return this.height;
    }

    @Override
    public void setControlHeight(int height) {
        this.height = height;
    }
}

