/*
 * Decompiled with CFR 0.152.
 */
package forge.com.gitlab.cdagaming.craftpresence.utils.gui.widgets;

import com.gitlab.cdagaming.craftpresence.core.Constants;
import forge.com.gitlab.cdagaming.craftpresence.utils.gui.RenderUtils;
import forge.com.gitlab.cdagaming.craftpresence.utils.gui.controls.ExtendedButtonControl;
import forge.com.gitlab.cdagaming.craftpresence.utils.gui.integrations.ExtendedScreen;
import io.github.cdagaming.unicore.utils.StringUtils;

public class ButtonWidget
extends ExtendedButtonControl {
    private String title;
    private int titleLeft;
    private int titleRight;
    private boolean setDimensions;
    private Runnable titleHoverEvent = null;

    public ButtonWidget(int buttonId, int y, int widthIn, int heightIn, String buttonText, String title, Runnable titleHoverEvent, String ... optionalArgs) {
        super(buttonId, 0, y, widthIn, heightIn, buttonText, optionalArgs);
        this.title = title;
        this.setDimensions = false;
        this.setOnTitleHover(titleHoverEvent);
    }

    public ButtonWidget(int buttonId, int y, int widthIn, int heightIn, String buttonText, Runnable onPushEvent, String title, Runnable titleHoverEvent, String ... optionalArgs) {
        this(buttonId, y, widthIn, heightIn, buttonText, title, titleHoverEvent, optionalArgs);
        this.setOnClick(onPushEvent);
    }

    public ButtonWidget(int buttonId, int y, int widthIn, int heightIn, String buttonText, Runnable onPushEvent, Runnable onHoverEvent, String title, Runnable titleHoverEvent, String ... optionalArgs) {
        this(buttonId, y, widthIn, heightIn, buttonText, onPushEvent, title, titleHoverEvent, optionalArgs);
        this.setOnHover(onHoverEvent);
    }

    public ButtonWidget(int y, int widthIn, int heightIn, String buttonText, String title, Runnable titleHoverEvent, String ... optionalArgs) {
        this(ExtendedScreen.getNextIndex(), y, widthIn, heightIn, buttonText, title, titleHoverEvent, optionalArgs);
    }

    public ButtonWidget(int y, int widthIn, int heightIn, String buttonText, Runnable onPushEvent, String title, Runnable titleHoverEvent, String ... optionalArgs) {
        this(y, widthIn, heightIn, buttonText, title, titleHoverEvent, optionalArgs);
        this.setOnClick(onPushEvent);
    }

    public ButtonWidget(int y, int widthIn, int heightIn, String buttonText, Runnable onPushEvent, Runnable onHoverEvent, String title, Runnable titleHoverEvent, String ... optionalArgs) {
        this(y, widthIn, heightIn, buttonText, onPushEvent, title, titleHoverEvent, optionalArgs);
        this.setOnHover(onHoverEvent);
    }

    public String getTitle() {
        return this.title;
    }

    public ButtonWidget setTitle(String title) {
        this.title = title;
        return this;
    }

    public void setOnTitleHover(Runnable event) {
        this.titleHoverEvent = event;
    }

    public void onTitleHover() {
        if (this.titleHoverEvent != null) {
            this.titleHoverEvent.run();
        }
    }

    @Override
    public void preDraw(ExtendedScreen screen) {
        if (!this.setDimensions) {
            int middle = screen.getScreenWidth() / 2;
            this.setControlPosX(middle + 3);
            this.titleLeft = middle - 180;
            this.titleRight = middle - 6;
            this.setDimensions = true;
        }
        super.preDraw(screen);
    }

    @Override
    public void draw(ExtendedScreen screen) {
        if (!StringUtils.isNullOrEmpty(this.title) && this.setDimensions) {
            String mainTitle = Constants.TRANSLATOR.getLocalizedMessage(this.title);
            screen.renderScrollingString(mainTitle, this.titleLeft + screen.getStringWidth(mainTitle) / 2, this.titleLeft, this.getTop(), this.titleRight, this.getBottom(), 0xFFFFFF);
        }
        super.draw(screen);
    }

    @Override
    public void postDraw(ExtendedScreen screen) {
        if (!StringUtils.isNullOrEmpty(this.title) && this.setDimensions && screen.isOverScreen() && RenderUtils.isMouseOver(screen.getMouseX(), screen.getMouseY(), this.titleLeft, this.getTop(), this.titleRight - this.titleLeft, this.getControlHeight())) {
            this.onTitleHover();
        }
        super.postDraw(screen);
    }
}

