/*
 * Decompiled with CFR 0.152.
 */
package forge.com.gitlab.cdagaming.craftpresence.utils.gui.impl;

import com.gitlab.cdagaming.craftpresence.core.Constants;
import com.gitlab.cdagaming.craftpresence.core.impl.discord.DiscordStatus;
import external.com.jagrosh.discordipc.IPCClient;
import external.org.meteordev.starscript.compiler.Expr;
import external.org.meteordev.starscript.value.Value;
import forge.com.gitlab.cdagaming.craftpresence.CraftPresence;
import forge.com.gitlab.cdagaming.craftpresence.utils.CommandUtils;
import forge.com.gitlab.cdagaming.craftpresence.utils.discord.assets.DiscordAsset;
import forge.com.gitlab.cdagaming.craftpresence.utils.discord.assets.DiscordAssetUtils;
import forge.com.gitlab.cdagaming.craftpresence.utils.gui.controls.ExtendedButtonControl;
import forge.com.gitlab.cdagaming.craftpresence.utils.gui.controls.ExtendedTextControl;
import forge.com.gitlab.cdagaming.craftpresence.utils.gui.controls.ScrollableListControl;
import forge.com.gitlab.cdagaming.craftpresence.utils.gui.impl.SelectorGui;
import forge.com.gitlab.cdagaming.craftpresence.utils.gui.integrations.ExtendedScreen;
import forge.com.gitlab.cdagaming.craftpresence.utils.gui.integrations.ScrollPane;
import forge.com.gitlab.cdagaming.craftpresence.utils.gui.widgets.TextDisplayWidget;
import io.github.cdagaming.unicore.utils.FileUtils;
import io.github.cdagaming.unicore.utils.StringUtils;
import java.io.BufferedWriter;
import java.io.File;
import java.io.OutputStreamWriter;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Collection;
import java.util.List;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.client.gui.GuiScreen;

public class CommandsGui
extends ExtendedScreen {
    public ExtendedButtonControl proceedButton;
    public ExtendedButtonControl copyButton;
    private String[] executionCommandArgs;
    private ExtendedTextControl commandInput;
    private ScrollPane childFrame;
    private TextDisplayWidget previewArea;
    private String executionString;
    private String commandString = "";
    private boolean blockInteractions = false;
    private String[] commandArgs;
    private String[] filteredCommandArgs;
    private List<String> tabCompletions = StringUtils.newArrayList();

    public CommandsGui(GuiScreen parentScreen, String ... commandArgs) {
        super(parentScreen);
        this.executionCommandArgs = commandArgs;
        this.executionString = Constants.TRANSLATOR.translate("craftpresence.command.usage.main", new Object[0]);
    }

    private static List<String> getListOfStringsMatchingLastWord(String[] inputArgs, Collection<?> possibleCompletions) {
        String s = inputArgs[inputArgs.length - 1];
        List<String> list = StringUtils.newArrayList();
        if (!possibleCompletions.isEmpty()) {
            for (Object object : possibleCompletions) {
                String str;
                if (object == null || !CommandsGui.doesStringStartWith(s, str = String.valueOf(object))) continue;
                list.add(str);
            }
        }
        return list;
    }

    private static boolean doesStringStartWith(String original, String region) {
        return region.regionMatches(true, 0, original, 0, original.length());
    }

    public void executeCommand(String ... args) {
        this.executionCommandArgs = args;
    }

    @Override
    public void initializeUi() {
        this.proceedButton = this.addControl(new ExtendedButtonControl(6, this.getScreenHeight() - 26, 95, 20, "gui.config.message.button.back", () -> this.openScreen(this.parentScreen), new String[0]));
        this.copyButton = this.addControl(new ExtendedButtonControl(6, 6, 95, 20, "gui.config.message.button.copy", () -> CommandsGui.copyToClipboard(this.executionString), new String[0]));
        this.commandInput = this.addControl(new ExtendedTextControl(this.getFontRenderer(), this.proceedButton.getRight() + 4, this.getScreenHeight() - 26, this.getScreenWidth() - 112, 20, () -> {
            this.commandString = this.commandInput.getControlMessage();
        }));
        this.commandInput.setControlMessage(this.commandString);
        this.childFrame = this.addControl(new ScrollPane(0, 32, this.getScreenWidth(), this.getScreenHeight() - 32));
        this.previewArea = this.childFrame.addWidget(new TextDisplayWidget((ExtendedScreen)this.childFrame, 0, 0, this.getScreenWidth(), this.executionString));
        super.initializeUi();
    }

    @Override
    public void preRender() {
        this.proceedButton.setControlEnabled(!this.blockInteractions);
        this.copyButton.setControlEnabled(!this.blockInteractions);
        this.commandInput.func_146184_c(!this.blockInteractions);
        if (!this.blockInteractions) {
            this.checkCommands();
        }
        this.previewArea.setMessage(this.executionString);
        super.preRender();
    }

    @Override
    public void renderExtra() {
        String mainTitle = Constants.TRANSLATOR.translate("gui.config.title.commands", new Object[0]);
        this.renderScrollingString(mainTitle, 30, 0, this.getScreenWidth() - 30, 32, 0xFFFFFF);
        super.renderExtra();
    }

    private void checkCommands() {
        if (!StringUtils.isNullOrEmpty(this.commandString) && this.commandString.startsWith("/")) {
            this.commandArgs = this.commandString.replace("/", "").split(" ");
            this.filteredCommandArgs = this.commandString.replace("/", "").replace("cp", "").replace("craftpresence", "").trim().split(" ");
            this.tabCompletions = this.getTabCompletions(this.filteredCommandArgs);
        }
        if (this.executionCommandArgs != null) {
            if (this.executionCommandArgs.length == 0 || this.executionCommandArgs[0].equalsIgnoreCase("help") || this.executionCommandArgs[0].equalsIgnoreCase("?") || this.executionCommandArgs[0].equalsIgnoreCase("")) {
                this.executionString = Constants.TRANSLATOR.translate("craftpresence.command.usage.main", new Object[0]);
            } else if (!StringUtils.isNullOrEmpty(this.executionCommandArgs[0])) {
                if (this.executionCommandArgs[0].equalsIgnoreCase("request")) {
                    if (CraftPresence.CLIENT.isAvailable()) {
                        if (this.executionCommandArgs.length == 1) {
                            this.executionString = CraftPresence.CLIENT.STATUS == DiscordStatus.JoinRequest && CraftPresence.CLIENT.REQUESTER_USER != null ? Constants.TRANSLATOR.translate("craftpresence.command.request.info", CraftPresence.CLIENT.REQUESTER_USER.getEffectiveName(), CraftPresence.SCHEDULER.TIMER) : Constants.TRANSLATOR.translate("craftpresence.command.request.none", new Object[0]);
                        } else if (!StringUtils.isNullOrEmpty(this.executionCommandArgs[1])) {
                            if (CraftPresence.CLIENT.STATUS == DiscordStatus.JoinRequest && CraftPresence.CLIENT.REQUESTER_USER != null) {
                                if (this.executionCommandArgs[1].equalsIgnoreCase("accept")) {
                                    this.executionString = Constants.TRANSLATOR.translate("craftpresence.command.request.accept", CraftPresence.CLIENT.REQUESTER_USER.getEffectiveName());
                                    CraftPresence.CLIENT.respondToJoinRequest(IPCClient.ApprovalMode.ACCEPT);
                                } else if (this.executionCommandArgs[1].equalsIgnoreCase("deny")) {
                                    this.executionString = Constants.TRANSLATOR.translate("craftpresence.command.request.denied", CraftPresence.CLIENT.REQUESTER_USER.getEffectiveName());
                                    CraftPresence.CLIENT.respondToJoinRequest(IPCClient.ApprovalMode.DENY);
                                } else {
                                    this.executionString = Constants.TRANSLATOR.translate("craftpresence.command.unrecognized", new Object[0]);
                                }
                            } else {
                                this.executionString = Constants.TRANSLATOR.translate("craftpresence.command.request.none", new Object[0]);
                            }
                        }
                    } else {
                        this.executionString = Constants.TRANSLATOR.translate("craftpresence.command.offline", new Object[0]);
                    }
                } else if (this.executionCommandArgs[0].equalsIgnoreCase("export")) {
                    String clientId = CraftPresence.CONFIG.generalSettings.clientId;
                    boolean doFullCopy = false;
                    String urlMeta = "";
                    if (this.executionCommandArgs.length == 1) {
                        this.executionString = Constants.TRANSLATOR.translate("craftpresence.command.usage.export", clientId, false);
                    } else if (!StringUtils.isNullOrEmpty(this.executionCommandArgs[1])) {
                        if (this.executionCommandArgs[1].equalsIgnoreCase("assets")) {
                            if (this.executionCommandArgs.length >= 3 && this.executionCommandArgs.length <= 5) {
                                for (int i = 2; i < this.executionCommandArgs.length; ++i) {
                                    if (StringUtils.isValidBoolean(this.executionCommandArgs[i])) {
                                        doFullCopy = Boolean.parseBoolean(this.executionCommandArgs[i]);
                                        continue;
                                    }
                                    if (DiscordAssetUtils.isValidId(this.executionCommandArgs[i])) {
                                        clientId = this.executionCommandArgs[i];
                                        continue;
                                    }
                                    Matcher matcher = Pattern.compile("\"(.*?)\"").matcher(this.commandString);
                                    if (!matcher.find()) continue;
                                    urlMeta = matcher.group(1);
                                }
                            } else {
                                this.executionString = Constants.TRANSLATOR.translate("craftpresence.command.unrecognized", new Object[0]);
                            }
                            this.exportAssets(clientId, doFullCopy, urlMeta);
                        } else {
                            this.executionString = Constants.TRANSLATOR.translate("craftpresence.command.unrecognized", new Object[0]);
                        }
                    }
                } else if (this.executionCommandArgs[0].equalsIgnoreCase("compile")) {
                    if (this.executionCommandArgs.length == 1) {
                        this.executionString = Constants.TRANSLATOR.translate("craftpresence.command.usage.compile", new Object[0]);
                    } else {
                        Matcher matcher = Pattern.compile("\"(.*?)\"").matcher(this.commandString);
                        if (matcher.find()) {
                            String contents = matcher.group(1);
                            StringBuilder out = new StringBuilder();
                            Supplier<Value> data = CraftPresence.CLIENT.getCompileResult(contents, true, out, new Expr.Visitor[0]);
                            String value = data.get().toString();
                            int length = StringUtils.getBytes(value, "UTF-8").length;
                            this.executionString = Constants.TRANSLATOR.translate("craftpresence.command.compile", value, length, out.toString().replace("\n", "\\n"));
                        } else {
                            this.executionString = Constants.TRANSLATOR.translate("craftpresence.command.unrecognized", new Object[0]);
                        }
                    }
                } else if (this.executionCommandArgs[0].equalsIgnoreCase("search")) {
                    if (this.executionCommandArgs.length == 1) {
                        this.executionString = Constants.TRANSLATOR.translate("craftpresence.command.usage.search", new Object[0]);
                    } else if (!StringUtils.isNullOrEmpty(this.executionCommandArgs[1])) {
                        List<String> results = StringUtils.newArrayList(CraftPresence.CLIENT.getArgumentEntries(this.executionCommandArgs[1]));
                        if (!results.isEmpty()) {
                            this.openScreen(new SelectorGui(this.currentScreen, Constants.TRANSLATOR.translate("gui.config.title.selector.view.items", new Object[0]), results, null, null, false, false, ScrollableListControl.RenderType.Placeholder, null, null));
                        } else {
                            this.executionString = Constants.TRANSLATOR.translate("gui.config.message.empty.list", new Object[0]);
                        }
                    }
                } else if (this.executionCommandArgs[0].equalsIgnoreCase("reload")) {
                    this.executionString = Constants.TRANSLATOR.translate("craftpresence.command.reload", new Object[0]);
                    CommandUtils.reloadData(true);
                    this.executionString = Constants.TRANSLATOR.translate("craftpresence.command.reload.complete", new Object[0]);
                } else if (this.executionCommandArgs[0].equalsIgnoreCase("shutdown")) {
                    if (CraftPresence.CLIENT.isAvailable()) {
                        this.executionString = Constants.TRANSLATOR.translate("craftpresence.command.shutdown.pre", new Object[0]);
                        CraftPresence.CLIENT.shutDown();
                        this.executionString = Constants.TRANSLATOR.translate("craftpresence.command.shutdown.post", new Object[0]);
                    } else {
                        this.executionString = Constants.TRANSLATOR.translate("craftpresence.command.offline", new Object[0]);
                    }
                } else if (this.executionCommandArgs[0].equalsIgnoreCase("reboot")) {
                    this.executionString = Constants.TRANSLATOR.translate("craftpresence.command.reboot.pre", new Object[0]);
                    CommandUtils.setupRPC();
                    this.executionString = Constants.TRANSLATOR.translate("craftpresence.command.reboot.post", new Object[0]);
                } else if (this.executionCommandArgs[0].equalsIgnoreCase("view")) {
                    if (this.executionCommandArgs.length == 1) {
                        this.executionString = Constants.TRANSLATOR.translate("craftpresence.command.usage.view", new Object[0]);
                    } else if (!StringUtils.isNullOrEmpty(this.executionCommandArgs[1])) {
                        if (this.executionCommandArgs[1].equalsIgnoreCase("placeholders")) {
                            this.executeCommand("search", "all");
                            return;
                        }
                        if (this.executionCommandArgs[1].equalsIgnoreCase("items")) {
                            if (CraftPresence.TILE_ENTITIES.enabled) {
                                this.openScreen(new SelectorGui(this.currentScreen, Constants.TRANSLATOR.translate("gui.config.title.selector.view.items", new Object[0]), CraftPresence.TILE_ENTITIES.TILE_ENTITY_NAMES, null, null, false, false, ScrollableListControl.RenderType.ItemData, null, null));
                            } else {
                                this.executionString = Constants.TRANSLATOR.translate("gui.config.message.hover.access", Constants.TRANSLATOR.translate("gui.config.name.advanced.enable_per_item", new Object[0]));
                            }
                        } else if (this.executionCommandArgs[1].equalsIgnoreCase("entities")) {
                            if (CraftPresence.ENTITIES.enabled) {
                                this.openScreen(new SelectorGui(this.currentScreen, Constants.TRANSLATOR.translate("gui.config.title.selector.view.entities", new Object[0]), CraftPresence.ENTITIES.ENTITY_NAMES, null, null, false, false, ScrollableListControl.RenderType.EntityData, null, null));
                            } else {
                                this.executionString = Constants.TRANSLATOR.translate("gui.config.message.hover.access", Constants.TRANSLATOR.translate("gui.config.name.advanced.enable_per_entity", new Object[0]));
                            }
                        } else if (this.executionCommandArgs[1].equalsIgnoreCase("servers")) {
                            if (CraftPresence.SERVER.enabled) {
                                this.openScreen(new SelectorGui(this.currentScreen, Constants.TRANSLATOR.translate("gui.config.title.selector.view.servers", new Object[0]), CraftPresence.SERVER.knownAddresses, null, null, false, false, ScrollableListControl.RenderType.ServerData, null, null));
                            } else {
                                this.executionString = Constants.TRANSLATOR.translate("gui.config.message.hover.access", Constants.TRANSLATOR.translate("gui.config.name.general.detect_world_data", new Object[0]));
                            }
                        } else if (this.executionCommandArgs[1].equalsIgnoreCase("screens")) {
                            if (CraftPresence.GUIS.enabled) {
                                this.openScreen(new SelectorGui(this.currentScreen, Constants.TRANSLATOR.translate("gui.config.title.selector.view.guis", new Object[0]), CraftPresence.GUIS.GUI_NAMES, null, null, false, false, null, null, null));
                            } else {
                                this.executionString = Constants.TRANSLATOR.translate("gui.config.message.hover.access", Constants.TRANSLATOR.translate("gui.config.name.advanced.enable_per_gui", new Object[0]));
                            }
                        } else if (this.executionCommandArgs[1].equalsIgnoreCase("biomes")) {
                            if (CraftPresence.BIOMES.enabled) {
                                this.openScreen(new SelectorGui(this.currentScreen, Constants.TRANSLATOR.translate("gui.config.title.selector.view.biomes", new Object[0]), CraftPresence.BIOMES.BIOME_NAMES, null, null, false, false, null, null, null));
                            } else {
                                this.executionString = Constants.TRANSLATOR.translate("gui.config.message.hover.access", Constants.TRANSLATOR.translate("gui.config.name.general.detect_biome_data", new Object[0]));
                            }
                        } else if (this.executionCommandArgs[1].equalsIgnoreCase("dimensions")) {
                            if (CraftPresence.DIMENSIONS.enabled) {
                                this.openScreen(new SelectorGui(this.currentScreen, Constants.TRANSLATOR.translate("gui.config.title.selector.view.dimensions", new Object[0]), CraftPresence.DIMENSIONS.DIMENSION_NAMES, null, null, false, false, null, null, null));
                            } else {
                                this.executionString = Constants.TRANSLATOR.translate("gui.config.message.hover.access", Constants.TRANSLATOR.translate("gui.config.name.general.detect_dimension_data", new Object[0]));
                            }
                        } else if (this.executionCommandArgs[1].equalsIgnoreCase("currentData")) {
                            this.executionString = CraftPresence.CLIENT.isAvailable() ? Constants.TRANSLATOR.translate("craftpresence.command.current_data", CraftPresence.CLIENT.CURRENT_USER.getEffectiveName(), StringUtils.convertString(CraftPresence.CLIENT.DETAILS, "UTF-8", true), StringUtils.convertString(CraftPresence.CLIENT.GAME_STATE, "UTF-8", true), CraftPresence.CLIENT.START_TIMESTAMP, CraftPresence.CLIENT.CLIENT_ID, StringUtils.convertString(CraftPresence.CLIENT.LARGE_IMAGE_KEY, "UTF-8", true), StringUtils.convertString(CraftPresence.CLIENT.LARGE_IMAGE_TEXT, "UTF-8", true), StringUtils.convertString(CraftPresence.CLIENT.SMALL_IMAGE_KEY, "UTF-8", true), StringUtils.convertString(CraftPresence.CLIENT.SMALL_IMAGE_TEXT, "UTF-8", true), CraftPresence.CLIENT.PARTY_ID, CraftPresence.CLIENT.PARTY_SIZE, CraftPresence.CLIENT.PARTY_MAX, CraftPresence.CLIENT.PARTY_PRIVACY.name(), CraftPresence.CLIENT.JOIN_SECRET, CraftPresence.CLIENT.END_TIMESTAMP, CraftPresence.CLIENT.MATCH_SECRET, CraftPresence.CLIENT.SPECTATE_SECRET, CraftPresence.CLIENT.BUTTONS.toString(), CraftPresence.CLIENT.INSTANCE) : Constants.TRANSLATOR.translate("craftpresence.command.offline", new Object[0]);
                        } else if (this.executionCommandArgs[1].equalsIgnoreCase("assets")) {
                            if (this.executionCommandArgs.length == 2) {
                                this.executionString = Constants.TRANSLATOR.translate("craftpresence.command.usage.view.assets", new Object[0]);
                            } else if (!StringUtils.isNullOrEmpty(this.executionCommandArgs[2])) {
                                if (this.executionCommandArgs[2].equalsIgnoreCase("custom")) {
                                    this.openScreen(new SelectorGui(this.currentScreen, Constants.TRANSLATOR.translate("gui.config.title.selector.view.assets.custom", new Object[0]), DiscordAssetUtils.CUSTOM_ASSET_LIST.keySet(), null, null, false, false, ScrollableListControl.RenderType.CustomDiscordAsset, null, null));
                                } else if (this.executionCommandArgs[2].equalsIgnoreCase("all")) {
                                    this.openScreen(new SelectorGui(this.currentScreen, Constants.TRANSLATOR.translate("gui.config.title.selector.view.assets.all", new Object[0]), DiscordAssetUtils.ASSET_LIST.keySet(), null, null, false, false, ScrollableListControl.RenderType.DiscordAsset, null, null));
                                }
                            }
                        } else {
                            this.executionString = Constants.TRANSLATOR.translate("craftpresence.command.unrecognized", new Object[0]);
                        }
                    }
                } else {
                    this.executionString = Constants.TRANSLATOR.translate("craftpresence.command.unrecognized", new Object[0]);
                }
            } else {
                this.executionString = Constants.TRANSLATOR.translate("craftpresence.logger.error.command", new Object[0]);
            }
        }
        this.executionCommandArgs = null;
    }

    @Override
    protected void func_73869_a(char typedChar, int keyCode) {
        if (!this.blockInteractions) {
            if (this.commandInput.isControlFocused()) {
                if (keyCode == 1) {
                    this.commandInput.setControlFocused(false);
                } else if (this.commandString.startsWith("/") && this.commandArgs != null && this.commandArgs.length > 0 && (this.commandArgs[0].equalsIgnoreCase("cp") || this.commandArgs[0].equalsIgnoreCase("craftpresence"))) {
                    if (keyCode == 15 && !this.tabCompletions.isEmpty()) {
                        if (this.commandArgs.length > 1 && (this.filteredCommandArgs[this.filteredCommandArgs.length - 1].length() > 1 || this.filteredCommandArgs[this.filteredCommandArgs.length - 1].equalsIgnoreCase("?"))) {
                            this.commandString = this.commandString.replace(this.filteredCommandArgs[this.filteredCommandArgs.length - 1], this.tabCompletions.get(0));
                            this.commandInput.setControlMessage(this.commandString);
                        }
                    } else if (keyCode == 28 || keyCode == 156) {
                        this.executeCommand(this.filteredCommandArgs);
                        this.childFrame.resetMouseScroll();
                        this.childFrame.setMouseScroll(0);
                    }
                }
            }
            super.func_73869_a(typedChar, keyCode);
        }
    }

    private List<String> getTabCompletions(String[] args) {
        List completions = StringUtils.newArrayList();
        if (args.length == 1) {
            completions.add("?");
            completions.add("help");
            completions.add("compile");
            completions.add("search");
            completions.add("reload");
            completions.add("request");
            completions.add("export");
            completions.add("view");
            completions.add("reboot");
            completions.add("shutdown");
        } else if (args.length == 2) {
            if (args[0].equalsIgnoreCase("export")) {
                completions.add("assets");
            } else if (args[0].equalsIgnoreCase("search")) {
                completions.add("type:");
                completions.add("all");
            } else if (args[0].equalsIgnoreCase("view")) {
                completions.add("placeholders");
                completions.add("currentData");
                completions.add("assets");
                completions.add("dimensions");
                completions.add("biomes");
                completions.add("items");
                completions.add("entities");
                completions.add("servers");
                completions.add("screens");
            } else if (args[0].equalsIgnoreCase("request")) {
                completions.add("accept");
                completions.add("deny");
            }
        } else if (args.length == 3 && args[0].equalsIgnoreCase("view") && args[1].equalsIgnoreCase("assets")) {
            completions.add("all");
            completions.add("custom");
        }
        return CommandsGui.getListOfStringsMatchingLastWord(args, completions);
    }

    private void exportAssets(String clientId, boolean doFullCopy, String urlMeta) {
        Constants.getThreadFactory().newThread(() -> {
            this.blockInteractions = true;
            DiscordAsset[] assetList = DiscordAssetUtils.loadAssets(clientId, false);
            boolean hasError = false;
            if (assetList != null) {
                String filePath = "craftpresence" + File.separator + "export" + File.separator + clientId + File.separator;
                this.executionString = Constants.TRANSLATOR.translate("craftpresence.command.export.pre", assetList.length, clientId, doFullCopy);
                File dataDir = new File(filePath + "downloads.txt");
                String encoding = CraftPresence.CLIENT.isAvailable() ? CraftPresence.CLIENT.ipcInstance.getEncoding() : "UTF-8";
                try {
                    FileUtils.assertFileExists(dataDir);
                }
                catch (Exception ex) {
                    Constants.LOG.debugError(ex);
                    hasError = true;
                }
                try (BufferedWriter bw = new BufferedWriter(new OutputStreamWriter(Files.newOutputStream(dataDir.toPath(), new OpenOption[0]), encoding));){
                    bw.write("## Export Data => " + clientId);
                    bw.newLine();
                    bw.newLine();
                    for (int i = 0; i < assetList.length; ++i) {
                        this.executionString = Constants.TRANSLATOR.translate("craftpresence.command.export.progress", clientId, i + 1, assetList.length);
                        DiscordAsset asset = assetList[i];
                        String assetUrl = DiscordAssetUtils.getDiscordAssetUrl(clientId, asset.getId(), false) + urlMeta;
                        String assetName = asset.getName() + ".png";
                        if (doFullCopy) {
                            FileUtils.downloadFile(assetUrl, new File(filePath + assetName));
                        }
                        bw.write("* " + assetName + " => " + assetUrl);
                        bw.newLine();
                    }
                }
                catch (Throwable ex) {
                    Constants.LOG.debugError(ex);
                    hasError = true;
                }
                this.executionString = !hasError ? Constants.TRANSLATOR.translate("craftpresence.command.export.post", assetList.length, clientId, doFullCopy) : Constants.TRANSLATOR.translate("craftpresence.command.export.exception", clientId);
            } else {
                this.executionString = Constants.TRANSLATOR.translate("craftpresence.command.export.exception", clientId);
            }
            this.blockInteractions = false;
        }).start();
    }
}

