/*
 * Decompiled with CFR 0.152.
 */
package forge.com.gitlab.cdagaming.craftpresence.config.gui;

import com.gitlab.cdagaming.craftpresence.core.Constants;
import com.gitlab.cdagaming.craftpresence.core.config.Module;
import forge.com.gitlab.cdagaming.craftpresence.CraftPresence;
import forge.com.gitlab.cdagaming.craftpresence.config.category.Display;
import forge.com.gitlab.cdagaming.craftpresence.config.gui.PresenceEditorGui;
import forge.com.gitlab.cdagaming.craftpresence.utils.discord.assets.DiscordAsset;
import forge.com.gitlab.cdagaming.craftpresence.utils.discord.assets.DiscordAssetUtils;
import forge.com.gitlab.cdagaming.craftpresence.utils.gui.controls.ExtendedButtonControl;
import forge.com.gitlab.cdagaming.craftpresence.utils.gui.controls.ScrollableListControl;
import forge.com.gitlab.cdagaming.craftpresence.utils.gui.impl.ConfigurationGui;
import forge.com.gitlab.cdagaming.craftpresence.utils.gui.impl.DynamicEditorGui;
import forge.com.gitlab.cdagaming.craftpresence.utils.gui.impl.SelectorGui;
import io.github.cdagaming.unicore.utils.StringUtils;
import net.minecraft.client.gui.GuiScreen;

public class DisplaySettingsGui
extends ConfigurationGui<Display> {
    private final Display INSTANCE;
    private final Display DEFAULTS = this.getCurrentData().getDefaults();

    DisplaySettingsGui(GuiScreen parentScreen) {
        super(parentScreen, "gui.config.title", "gui.config.title.display_settings");
        this.INSTANCE = this.getCurrentData().copy();
    }

    @Override
    protected void appendControls() {
        super.appendControls();
        this.childFrame.addControl(new ExtendedButtonControl(this.getScreenWidth() / 2 - 90, this.getButtonY(0), 180, 20, "gui.config.title.editor.presence", () -> this.openScreen(new PresenceEditorGui(this.currentScreen, this.getInstanceData().presenceData, this.getDefaultData().presenceData, true, output -> this.getInstanceData().presenceData.transferFrom((Module)output))), () -> this.drawMultiLineString(StringUtils.splitTextByNewLine(Constants.TRANSLATOR.translate("gui.config.message.hover.presence_editor", new Object[0]))), new String[0]));
        this.childFrame.addControl(new ExtendedButtonControl(this.getScreenWidth() / 2 - 90, this.getButtonY(1), 180, 20, "gui.config.name.display.dynamic_icons", () -> this.openScreen(new SelectorGui(this.currentScreen, Constants.TRANSLATOR.translate("gui.config.title.selector.icon", new Object[0]), DiscordAssetUtils.CUSTOM_ASSET_LIST.keySet(), null, null, true, true, ScrollableListControl.RenderType.CustomDiscordAsset, null, (currentValue, parentScreen) -> this.openScreen(new DynamicEditorGui((GuiScreen)parentScreen, (String)currentValue, (attributeName, screenInstance) -> {
            screenInstance.primaryText = Constants.TRANSLATOR.translate("gui.config.message.editor.url", new Object[0]);
            screenInstance.maxPrimaryLength = Short.MAX_VALUE;
            screenInstance.secondaryText = Constants.TRANSLATOR.translate("gui.config.message.editor.label", new Object[0]);
            screenInstance.maxSecondaryLength = 32;
            screenInstance.primaryMessage = screenInstance.originalPrimaryMessage = this.getInstanceData().dynamicIcons.getOrDefault("default", "");
        }, (attributeName, screenInstance) -> {
            screenInstance.primaryText = Constants.TRANSLATOR.translate("gui.config.message.editor.url", new Object[0]);
            screenInstance.maxPrimaryLength = Short.MAX_VALUE;
            screenInstance.secondaryText = Constants.TRANSLATOR.translate("gui.config.message.editor.label", new Object[0]);
            screenInstance.maxSecondaryLength = 32;
            screenInstance.mainTitle = Constants.TRANSLATOR.translate("gui.config.title.display.edit_specific_icon", attributeName);
            screenInstance.originalPrimaryMessage = this.getInstanceData().dynamicIcons.getOrDefault("default", "");
            screenInstance.primaryMessage = this.getInstanceData().dynamicIcons.getOrDefault(attributeName, screenInstance.originalPrimaryMessage);
        }, (screenInstance, attributeName, inputText) -> {
            this.getInstanceData().dynamicIcons.put((String)attributeName, (String)inputText);
            DiscordAsset asset = new DiscordAsset().setName((String)attributeName).setUrl((String)inputText).setType(DiscordAsset.AssetType.CUSTOM);
            if (!DiscordAssetUtils.CUSTOM_ASSET_LIST.containsKey(asset.getName())) {
                DiscordAssetUtils.CUSTOM_ASSET_LIST.put(asset.getName(), asset);
            }
            if (!asset.getName().equalsIgnoreCase("default")) {
                DiscordAssetUtils.ASSET_LIST.put(asset.getName(), asset);
            }
        }, (screenInstance, attributeName, inputText) -> {
            this.getInstanceData().dynamicIcons.remove(attributeName);
            if (DiscordAssetUtils.CUSTOM_ASSET_LIST.containsKey(attributeName)) {
                DiscordAssetUtils.CUSTOM_ASSET_LIST.remove(attributeName);
                if (!attributeName.equalsIgnoreCase("default")) {
                    DiscordAssetUtils.ASSET_LIST.remove(attributeName);
                }
            }
        }, null, (attributeName, screenInstance) -> screenInstance.drawMultiLineString(StringUtils.splitTextByNewLine(Constants.TRANSLATOR.translate("gui.config.comment.display.dynamic_icons", new Object[0]))), (attributeName, screenInstance) -> screenInstance.drawMultiLineString(StringUtils.splitTextByNewLine(Constants.TRANSLATOR.translate("gui.config.comment.display.dynamic_icons", new Object[0]))))))), () -> this.drawMultiLineString(StringUtils.splitTextByNewLine(Constants.TRANSLATOR.translate("gui.config.comment.display.dynamic_icons", new Object[0]))), new String[0]));
        this.childFrame.addControl(new ExtendedButtonControl(this.getScreenWidth() / 2 - 90, this.getButtonY(2), 180, 20, "gui.config.name.display.dynamic_variables", () -> this.openScreen(new SelectorGui(this.currentScreen, Constants.TRANSLATOR.translate("gui.config.title.selector.item", new Object[0]), this.getInstanceData().dynamicVariables.keySet(), null, null, true, true, ScrollableListControl.RenderType.None, null, (currentValue, parentScreen) -> this.openScreen(new DynamicEditorGui((GuiScreen)parentScreen, (String)currentValue, (attributeName, screenInstance) -> {
            screenInstance.maxPrimaryLength = Short.MAX_VALUE;
            screenInstance.maxSecondaryLength = 32;
            screenInstance.primaryMessage = screenInstance.originalPrimaryMessage = this.getInstanceData().dynamicVariables.getOrDefault("default", "");
        }, (attributeName, screenInstance) -> {
            screenInstance.maxPrimaryLength = Short.MAX_VALUE;
            screenInstance.maxSecondaryLength = 32;
            screenInstance.mainTitle = Constants.TRANSLATOR.translate("gui.config.title.item.edit_specific_item", attributeName);
            screenInstance.originalPrimaryMessage = this.getInstanceData().dynamicVariables.getOrDefault("default", "");
            screenInstance.primaryMessage = this.getInstanceData().dynamicVariables.getOrDefault(attributeName, screenInstance.originalPrimaryMessage);
        }, (screenInstance, attributeName, inputText) -> this.getInstanceData().dynamicVariables.put((String)attributeName, (String)inputText), (screenInstance, attributeName, inputText) -> this.getInstanceData().dynamicVariables.remove(attributeName), null, (attributeName, screenInstance) -> screenInstance.drawMultiLineString(StringUtils.splitTextByNewLine(Constants.TRANSLATOR.translate("gui.config.comment.display.dynamic_variables", new Object[0]))), (attributeName, screenInstance) -> screenInstance.drawMultiLineString(StringUtils.splitTextByNewLine(Constants.TRANSLATOR.translate("gui.config.comment.display.dynamic_variables", new Object[0]))))))), () -> this.drawMultiLineString(StringUtils.splitTextByNewLine(Constants.TRANSLATOR.translate("gui.config.comment.display.dynamic_variables", new Object[0]))), new String[0]));
    }

    @Override
    protected boolean allowedToReset() {
        return true;
    }

    @Override
    protected Display getInstanceData() {
        return this.INSTANCE;
    }

    @Override
    protected Display getCurrentData() {
        return CraftPresence.CONFIG.displaySettings;
    }

    @Override
    protected Display getDefaultData() {
        this.DEFAULTS.dynamicIcons = this.getCurrentData().dynamicIcons;
        return this.DEFAULTS;
    }
}

