/*
 * Decompiled with CFR 0.152.
 */
package forge.com.gitlab.cdagaming.craftpresence.config.category;

import com.gitlab.cdagaming.craftpresence.core.Constants;
import com.gitlab.cdagaming.craftpresence.core.config.Module;
import forge.com.gitlab.cdagaming.craftpresence.config.category.Entity;
import forge.com.gitlab.cdagaming.craftpresence.config.category.Gui;
import io.github.cdagaming.unicore.impl.HashMapBuilder;
import io.github.cdagaming.unicore.utils.StringUtils;
import java.io.Serializable;
import java.util.Map;

public class Advanced
extends Module
implements Serializable {
    private static final long serialVersionUID = 6035241954568785784L;
    private static final Advanced DEFAULT = new Advanced();
    public boolean enablePerGui = false;
    public boolean enablePerItem = false;
    public boolean enablePerEntity = false;
    public boolean formatWords = true;
    public boolean debugMode = false;
    public boolean verboseMode = false;
    public int refreshRate = 2;
    public boolean allowPlaceholderPreviews = false;
    public Gui guiSettings = new Gui();
    public Map<String, String> itemMessages = new HashMapBuilder<String, String>().put("default", Constants.TRANSLATOR.translate("craftpresence.defaults.advanced.item_messages", new Object[0])).build();
    public Entity entitySettings = new Entity();
    public boolean allowEndpointIcons = true;
    public String serverIconEndpoint = "https://api.mcsrvstat.us/icon/{server.address.short}";
    public String playerSkinEndpoint = "https://mc-heads.net/avatar/{getOrDefault(player.uuid.short, player.name)}";
    public boolean allowDuplicatePackets = false;
    public int maxConnectionAttempts = 10;

    public Advanced(Advanced other) {
        this.transferFrom(other);
    }

    public Advanced() {
    }

    @Override
    public Advanced getDefaults() {
        return new Advanced(DEFAULT);
    }

    @Override
    public Advanced copy() {
        return new Advanced(this);
    }

    @Override
    public void transferFrom(Module target) {
        if (target instanceof Advanced && !this.equals(target)) {
            Advanced data = (Advanced)target;
            this.enablePerGui = data.enablePerGui;
            this.enablePerItem = data.enablePerItem;
            this.enablePerEntity = data.enablePerEntity;
            this.formatWords = data.formatWords;
            this.debugMode = data.debugMode;
            this.verboseMode = data.verboseMode;
            this.refreshRate = data.refreshRate;
            this.allowPlaceholderPreviews = data.allowPlaceholderPreviews;
            this.guiSettings = new Gui(data.guiSettings);
            this.itemMessages.clear();
            this.itemMessages.putAll(data.itemMessages);
            this.entitySettings = new Entity(data.entitySettings);
            this.allowEndpointIcons = data.allowEndpointIcons;
            this.serverIconEndpoint = data.serverIconEndpoint;
            this.playerSkinEndpoint = data.playerSkinEndpoint;
            this.allowDuplicatePackets = data.allowDuplicatePackets;
            this.maxConnectionAttempts = data.maxConnectionAttempts;
        }
    }

    @Override
    public Object getProperty(String name) {
        return StringUtils.getField(Advanced.class, this, name);
    }

    @Override
    public void setProperty(String name, Object value) {
        StringUtils.updateField(Advanced.class, this, value, name);
    }
}

