/*
 * Decompiled with CFR 0.152.
 */
package fabric.com.gitlab.cdagaming.craftpresence.utils.gui.controls;

import com.gitlab.cdagaming.craftpresence.core.Constants;
import external.io.github.classgraph.ClassInfo;
import external.org.meteordev.starscript.value.Value;
import fabric.com.gitlab.cdagaming.craftpresence.CraftPresence;
import fabric.com.gitlab.cdagaming.craftpresence.utils.ImageUtils;
import fabric.com.gitlab.cdagaming.craftpresence.utils.discord.assets.DiscordAssetUtils;
import fabric.com.gitlab.cdagaming.craftpresence.utils.entity.TileEntityUtils;
import fabric.com.gitlab.cdagaming.craftpresence.utils.gui.GuiUtils;
import fabric.com.gitlab.cdagaming.craftpresence.utils.gui.RenderUtils;
import fabric.com.gitlab.cdagaming.craftpresence.utils.gui.integrations.ExtendedScreen;
import io.github.cdagaming.unicore.impl.Pair;
import io.github.cdagaming.unicore.utils.MappingUtils;
import io.github.cdagaming.unicore.utils.StringUtils;
import java.awt.Color;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.class_1071;
import net.minecraft.class_1600;
import net.minecraft.class_1653;
import net.minecraft.class_370;
import net.minecraft.class_390;
import net.minecraft.class_533;

public class ScrollableListControl
extends class_390 {
    public final Map<String, String> entryAliases = StringUtils.newHashMap();
    public final RenderType renderType;
    public String currentValue;
    public List<String> currentHoverText = StringUtils.newArrayList();
    public List<String> itemList;
    public IdentifierType identifierType = IdentifierType.None;
    public ExtendedScreen currentScreen;

    public ScrollableListControl(@Nonnull class_1600 mc, ExtendedScreen currentScreen, int width, int height, int topIn, int bottomIn, int slotHeightIn, List<String> itemList, String currentValue) {
        this(mc, currentScreen, width, height, topIn, bottomIn, slotHeightIn, itemList, currentValue, RenderType.None);
    }

    public ScrollableListControl(@Nonnull class_1600 mc, ExtendedScreen currentScreen, int width, int height, int topIn, int bottomIn, int slotHeightIn, List<String> itemList, String currentValue, RenderType renderType) {
        super(mc, width, height, topIn, bottomIn, slotHeightIn);
        this.currentScreen = currentScreen;
        this.currentValue = currentValue;
        this.renderType = renderType;
        this.setList(itemList);
    }

    public ScrollableListControl(@Nonnull class_1600 mc, ExtendedScreen currentScreen, int width, int height, int topIn, int bottomIn, List<String> itemList, String currentValue, RenderType renderType) {
        this(mc, currentScreen, width, height, topIn, bottomIn, renderType.canRenderImage() ? 45 : 18, itemList, currentValue, renderType);
    }

    public ScrollableListControl setIdentifierType(IdentifierType type) {
        this.identifierType = type;
        return this;
    }

    public boolean isWithinBounds(int mouseX, int mouseY) {
        return RenderUtils.isMouseWithin(mouseX, mouseY, this.field_1242, this.field_1243, this.field_7734, this.field_1249);
    }

    protected int method_1050() {
        return this.itemList.size();
    }

    public void method_1057(int slotIndex, boolean isDoubleClick, int mouseX, int mouseY) {
        this.currentValue = this.getSelectedItem(slotIndex);
    }

    public boolean method_1051(int slotIndex) {
        return this.getSelectedItem(slotIndex).equals(this.currentValue);
    }

    protected void method_1066() {
    }

    protected void method_1055(int slotIndex, int xPos, int yPos, int heightIn, class_533 tessellatorIn, int mouseXIn, int mouseYIn) {
        this.renderSlotItem(this.getSelectedItem(slotIndex), xPos, yPos, this.method_6706(), heightIn, mouseXIn, mouseYIn);
    }

    public String getSelectedItem(int slotIndex) {
        try {
            return this.itemList.get(slotIndex);
        }
        catch (Exception ex) {
            return null;
        }
    }

    public class_370 getFontRenderer() {
        return GuiUtils.getDefaultFontRenderer();
    }

    public int getFontHeight() {
        return RenderUtils.getFontHeight(this.getFontRenderer());
    }

    public void setList(List<String> itemList) {
        if (itemList == null) {
            itemList = StringUtils.newArrayList();
        }
        if (!itemList.equals(this.itemList)) {
            this.itemList = itemList;
            this.method_1063(Integer.MIN_VALUE);
            this.setupAliasData();
        }
    }

    public void setupAliasData() {
        this.entryAliases.clear();
        Iterator<String> iterator = StringUtils.newArrayList(this.itemList).iterator();
        while (iterator.hasNext()) {
            String originalName;
            String displayName = originalName = iterator.next();
            if (this.renderType == RenderType.EntityData && StringUtils.isValidUuid(originalName)) {
                String fullUuid = StringUtils.getFromUuid(originalName, false);
                String trimmedUuid = StringUtils.getFromUuid(originalName, true);
                displayName = CraftPresence.ENTITIES.PLAYER_BINDINGS.getOrDefault(fullUuid, trimmedUuid);
            }
            if (originalName.equals(displayName)) continue;
            this.entryAliases.put(originalName, displayName);
        }
    }

    public void renderSlotItem(String originalName, int xPos, int yPos, int widthIn, int heightIn, int mouseXIn, int mouseYIn) {
        String identifierName;
        Object data;
        List hoverText = StringUtils.newArrayList();
        String displayName = this.entryAliases.getOrDefault(originalName, originalName);
        int xOffset = xPos;
        boolean isOverEntry = RenderUtils.isMouseOver(mouseXIn, mouseYIn, xPos, yPos, widthIn, heightIn);
        boolean isInBounds = this.isWithinBounds(mouseXIn, mouseYIn);
        boolean isHovering = isInBounds && isOverEntry;
        class_1653 texture = new class_1653("");
        if (this.renderType == RenderType.ServerData) {
            data = CraftPresence.SERVER.getDataFromName(originalName);
            if (data != null && !StringUtils.isNullOrEmpty(data.method_6850())) {
                String assetUrl = "data:image/png;base64," + data.method_6850();
                texture = ImageUtils.getTextureFromUrl(originalName, new Pair<ImageUtils.InputType, Object>(ImageUtils.InputType.ByteStream, assetUrl));
            } else if (CraftPresence.CONFIG.advancedSettings.allowEndpointIcons && !StringUtils.isNullOrEmpty(CraftPresence.CONFIG.advancedSettings.serverIconEndpoint)) {
                String formattedIP = originalName.contains(":") ? StringUtils.formatAddress(originalName, false) : originalName;
                String endpointUrl = CraftPresence.CLIENT.compileData(String.format(CraftPresence.CONFIG.advancedSettings.serverIconEndpoint, originalName), new Pair<String, Supplier<String>>("server.address.short", () -> formattedIP), new Pair<String, Supplier<String>>("server.address.full", () -> originalName)).get().toString();
                texture = ImageUtils.getTextureFromUrl(originalName, endpointUrl);
                if (this.currentScreen.isDebugMode() && isHovering) {
                    hoverText.add(Constants.TRANSLATOR.translate("gui.config.message.editor.url", new Object[0]) + " " + endpointUrl);
                }
            }
        } else if (this.renderType == RenderType.DiscordAsset || this.renderType == RenderType.CustomDiscordAsset) {
            String assetUrl = DiscordAssetUtils.getUrl(this.renderType == RenderType.CustomDiscordAsset ? DiscordAssetUtils.CUSTOM_ASSET_LIST : DiscordAssetUtils.ASSET_LIST, originalName);
            if (this.currentScreen.isDebugMode() && isHovering) {
                hoverText.add(Constants.TRANSLATOR.translate("gui.config.message.editor.url", new Object[0]) + " " + assetUrl);
            }
            texture = ImageUtils.getTextureFromUrl(originalName, assetUrl);
        } else if (this.renderType == RenderType.EntityData) {
            boolean isPlayer = CraftPresence.ENTITIES.PLAYER_BINDINGS.containsKey(originalName);
            boolean isValidUuid = StringUtils.isValidUuid(originalName);
            if (isPlayer && CraftPresence.CONFIG.advancedSettings.allowEndpointIcons && !StringUtils.isNullOrEmpty(CraftPresence.CONFIG.advancedSettings.playerSkinEndpoint)) {
                String endpointUrl = CraftPresence.CLIENT.compileData(String.format(CraftPresence.CONFIG.advancedSettings.playerSkinEndpoint, originalName), new Pair<String, Supplier<String>>("player.name", () -> originalName), new Pair<String, Supplier<String>>("player.uuid.full", () -> isValidUuid ? StringUtils.getFromUuid(originalName, false) : ""), new Pair<String, Supplier<String>>("player.uuid.short", () -> isValidUuid ? StringUtils.getFromUuid(originalName, true) : "")).get().toString();
                texture = ImageUtils.getTextureFromUrl(originalName, endpointUrl);
                if (this.currentScreen.isDebugMode() && isHovering) {
                    hoverText.add(Constants.TRANSLATOR.translate("gui.config.message.editor.url", new Object[0]) + " " + endpointUrl);
                }
            }
        } else if (this.renderType == RenderType.ItemData && this.renderType.canRenderImage()) {
            class_1071 stack;
            data = CraftPresence.TILE_ENTITIES.TILE_ENTITY_RESOURCES;
            if (data.containsKey(originalName) && !TileEntityUtils.isEmpty(stack = (class_1071)data.get(originalName))) {
                RenderUtils.drawItemStack(CraftPresence.instance, this.getFontRenderer(), xOffset, yPos + 4, stack, 2.0f);
                xOffset += 35;
            }
        } else if (this.renderType == RenderType.Placeholder && isHovering) {
            Supplier<Value> suppliedInfo;
            boolean addExtraData;
            String placeholderTranslation = String.format("%s.placeholders.%s.description", "craftpresence", originalName);
            String placeholderUsage = String.format("%s.placeholders.%s.usage", "craftpresence", originalName);
            if (Constants.TRANSLATOR.hasTranslation(placeholderTranslation)) {
                hoverText.add(String.format("%s \"%s\"", Constants.TRANSLATOR.translate("gui.config.message.editor.description", new Object[0]), Constants.TRANSLATOR.translate(placeholderTranslation, new Object[0])));
            }
            if (Constants.TRANSLATOR.hasTranslation(placeholderUsage)) {
                hoverText.add(String.format("%s \"%s\"", Constants.TRANSLATOR.translate("gui.config.message.editor.usage", new Object[0]), Constants.TRANSLATOR.translate(placeholderUsage, new Object[0])));
            }
            if ((addExtraData = CraftPresence.CONFIG.advancedSettings.allowPlaceholderPreviews) && CraftPresence.CLIENT.isDefaultPlaceholder(originalName.toLowerCase()) && (suppliedInfo = CraftPresence.CLIENT.getArgument(originalName)) != null) {
                Value rawValue = suppliedInfo.get();
                String tagValue = rawValue.toString();
                if (!(rawValue.isNull() || rawValue.isFunction() || StringUtils.isNullOrEmpty(tagValue))) {
                    hoverText.add(String.format("%s \"%s\"", Constants.TRANSLATOR.translate("gui.config.message.editor.preview", new Object[0]), tagValue.length() >= 128 ? "<...>" : tagValue));
                }
            }
        }
        if (this.renderType.canRenderImage() && !ImageUtils.isTextureNull(texture)) {
            double yOffset = (double)yPos + 4.5;
            double size = 32.0;
            RenderUtils.drawTexture(CraftPresence.instance, xOffset, (double)xOffset + 32.0, yOffset, yOffset + 32.0, 0.0, 0.0, 1.0, 0.0, 1.0, Color.white, Color.white, texture);
            if (this.currentScreen.isDebugMode() && isHovering) {
                hoverText.add(Constants.TRANSLATOR.translate("gui.config.message.editor.texture_path", new Object[0]) + " " + texture);
            }
            xOffset += 35;
        }
        if (!(identifierName = this.identifierType.getIdentifier(originalName)).equals(displayName) && isHovering) {
            hoverText.add(Constants.TRANSLATOR.translate("gui.config.message.editor.original", new Object[0]) + " " + identifierName);
        }
        RenderUtils.renderScrollingString(CraftPresence.instance, this.getFontRenderer(), displayName, xOffset + RenderUtils.getStringWidth(this.getFontRenderer(), displayName) / 2, xOffset, yPos, xPos + widthIn - 4, yPos + heightIn, 0xFFFFFF);
        if (isHovering) {
            this.currentHoverText = hoverText;
        }
    }

    public static enum IdentifierType {
        Gui,
        None;


        public String getIdentifier(String originalName) {
            String identifierName;
            switch (this) {
                case Gui: {
                    ClassInfo target = CraftPresence.GUIS.GUI_CLASSES.get(originalName);
                    identifierName = target != null ? MappingUtils.getCanonicalName(target) : originalName;
                    break;
                }
                default: {
                    identifierName = originalName;
                }
            }
            return identifierName;
        }
    }

    public static enum RenderType {
        DiscordAsset,
        CustomDiscordAsset,
        ServerData,
        EntityData,
        ItemData,
        Placeholder(false),
        None(false);

        private final boolean canRenderImage;

        private RenderType() {
            this.canRenderImage = true;
        }

        private RenderType(boolean canRenderImage) {
            this.canRenderImage = canRenderImage;
        }

        public boolean canRenderImage() {
            return this.canRenderImage && !CraftPresence.CONFIG.accessibilitySettings.stripExtraGuiElements;
        }
    }
}

