/*
 * Decompiled with CFR 0.152.
 */
package fabric.com.gitlab.cdagaming.craftpresence.config.gui;

import com.gitlab.cdagaming.craftpresence.core.Constants;
import com.gitlab.cdagaming.craftpresence.core.config.element.ModuleData;
import com.gitlab.cdagaming.craftpresence.core.config.element.PresenceData;
import fabric.com.gitlab.cdagaming.craftpresence.CraftPresence;
import fabric.com.gitlab.cdagaming.craftpresence.config.Config;
import fabric.com.gitlab.cdagaming.craftpresence.config.category.Server;
import fabric.com.gitlab.cdagaming.craftpresence.config.gui.PresenceEditorGui;
import fabric.com.gitlab.cdagaming.craftpresence.utils.gui.controls.ExtendedButtonControl;
import fabric.com.gitlab.cdagaming.craftpresence.utils.gui.controls.ScrollableListControl;
import fabric.com.gitlab.cdagaming.craftpresence.utils.gui.impl.ConfigurationGui;
import fabric.com.gitlab.cdagaming.craftpresence.utils.gui.impl.DynamicEditorGui;
import fabric.com.gitlab.cdagaming.craftpresence.utils.gui.impl.SelectorGui;
import fabric.com.gitlab.cdagaming.craftpresence.utils.gui.widgets.TextWidget;
import io.github.cdagaming.unicore.utils.StringUtils;
import net.minecraft.class_388;

public class ServerSettingsGui
extends ConfigurationGui<Server> {
    private final Server INSTANCE;
    private final Server DEFAULTS = this.getCurrentData().getDefaults();
    private ExtendedButtonControl serverMessagesButton;
    private TextWidget defaultMOTD;
    private TextWidget defaultName;
    private TextWidget defaultMessage;
    private TextWidget defaultIcon;

    ServerSettingsGui(class_388 parentScreen) {
        super(parentScreen, "gui.config.title", "gui.config.title.server_messages");
        this.INSTANCE = this.getCurrentData().copy();
    }

    @Override
    protected void appendControls() {
        super.appendControls();
        ModuleData defaultData = this.getInstanceData().serverData.get("default");
        String defaultServerMessage = Config.getProperty(defaultData, "textOverride") != null ? defaultData.getTextOverride() : "";
        this.defaultName = this.childFrame.addControl(new TextWidget(this.getFontRenderer(), this.getButtonY(0), 180, 20, () -> {
            this.getInstanceData().fallbackServerName = this.defaultName.getControlMessage();
        }, "gui.config.name.server_messages.server_name", () -> this.drawMultiLineString(StringUtils.splitTextByNewLine(Constants.TRANSLATOR.translate("gui.config.comment.server_messages.server_name", new Object[0])))));
        this.defaultName.setControlMessage(this.getInstanceData().fallbackServerName);
        this.defaultMOTD = this.childFrame.addControl(new TextWidget(this.getFontRenderer(), this.getButtonY(1), 180, 20, () -> {
            this.getInstanceData().fallbackServerMotd = this.defaultMOTD.getControlMessage();
        }, "gui.config.name.server_messages.server_motd", () -> this.drawMultiLineString(StringUtils.splitTextByNewLine(Constants.TRANSLATOR.translate("gui.config.comment.server_messages.server_motd", new Object[0])))));
        this.defaultMOTD.setControlMessage(this.getInstanceData().fallbackServerMotd);
        this.defaultMessage = this.childFrame.addControl(new TextWidget(this.getFontRenderer(), this.getButtonY(2), 180, 20, () -> {
            ModuleData defaultServerData = this.getInstanceData().serverData.getOrDefault("default", new ModuleData());
            defaultServerData.setTextOverride(this.defaultMessage.getControlMessage());
            this.getInstanceData().serverData.put("default", defaultServerData);
        }, "gui.config.message.default.server", () -> this.drawMultiLineString(StringUtils.splitTextByNewLine(Constants.TRANSLATOR.translate("gui.config.comment.server_messages.server_messages", CraftPresence.CLIENT.generateArgumentMessage("server.", "world.", "player."))))));
        this.defaultMessage.setControlMessage(defaultServerMessage);
        this.defaultIcon = this.childFrame.addControl(new TextWidget(this.getFontRenderer(), this.getButtonY(3), 147, 20, () -> {
            this.getInstanceData().fallbackServerIcon = this.defaultIcon.getControlMessage();
        }, "gui.config.name.server_messages.server_icon", () -> this.drawMultiLineString(StringUtils.splitTextByNewLine(Constants.TRANSLATOR.translate("gui.config.comment.server_messages.server_icon", new Object[0])))));
        this.addIconSelector(this.childFrame, () -> this.defaultIcon, (attributeName, currentValue) -> {
            this.getInstanceData().fallbackServerIcon = currentValue;
        });
        this.defaultIcon.setControlMessage(this.getInstanceData().fallbackServerIcon);
        this.serverMessagesButton = this.childFrame.addControl(new ExtendedButtonControl(this.getScreenWidth() / 2 - 90, this.getButtonY(4), 180, 20, "gui.config.name.server_messages.server_messages", () -> this.openScreen(new SelectorGui(this.currentScreen, Constants.TRANSLATOR.translate("gui.config.title.selector.server", new Object[0]), CraftPresence.SERVER.knownAddresses, null, null, true, true, ScrollableListControl.RenderType.ServerData, (attributeName, currentValue) -> {
            ModuleData defaultServerData = this.getInstanceData().serverData.get("default");
            ModuleData currentServerData = this.getInstanceData().serverData.get(attributeName);
            String defaultMessage = Config.getProperty(defaultServerData, "textOverride") != null ? defaultServerData.getTextOverride() : "";
            String currentMessage = Config.getProperty(currentServerData, "textOverride") != null ? currentServerData.getTextOverride() : "";
            ModuleData newData = new ModuleData();
            if (StringUtils.isNullOrEmpty(currentMessage) || currentMessage.equals(defaultMessage)) {
                newData.setTextOverride(defaultMessage);
            }
            newData.setIconOverride((String)currentValue);
            this.getInstanceData().serverData.put((String)attributeName, newData);
        }, (currentValue, parentScreen) -> this.openScreen(new DynamicEditorGui((class_388)parentScreen, (String)currentValue, (attributeName, screenInstance) -> {
            screenInstance.defaultData = this.getInstanceData().serverData.get("default");
            screenInstance.originalPrimaryMessage = Config.getProperty(screenInstance.defaultData, "textOverride") != null ? screenInstance.defaultData.getTextOverride() : "";
            screenInstance.primaryMessage = screenInstance.originalPrimaryMessage;
        }, (attributeName, screenInstance) -> {
            screenInstance.defaultData = this.getInstanceData().serverData.get("default");
            screenInstance.currentData = this.getInstanceData().serverData.get(attributeName);
            screenInstance.isPreliminaryData = screenInstance.currentData == null;
            screenInstance.mainTitle = Constants.TRANSLATOR.translate("gui.config.title.server.edit_specific_server", attributeName);
            screenInstance.originalPrimaryMessage = Config.getProperty(screenInstance.defaultData, "textOverride") != null ? screenInstance.defaultData.getTextOverride() : "";
            screenInstance.primaryMessage = Config.getProperty(screenInstance.currentData, "textOverride") != null ? screenInstance.currentData.getTextOverride() : screenInstance.originalPrimaryMessage;
        }, (screenInstance, attributeName, inputText) -> {
            screenInstance.currentData.setTextOverride((String)inputText);
            this.getInstanceData().serverData.put((String)attributeName, screenInstance.currentData);
            if (!CraftPresence.SERVER.knownAddresses.contains(attributeName)) {
                CraftPresence.SERVER.knownAddresses.add((String)attributeName);
            }
        }, (screenInstance, attributeName, inputText) -> {
            this.getInstanceData().serverData.remove(attributeName);
            if (!CraftPresence.SERVER.defaultAddresses.contains(attributeName)) {
                CraftPresence.SERVER.knownAddresses.remove(attributeName);
            }
        }, (attributeName, screenInstance, isPresenceButton) -> {
            if (isPresenceButton.booleanValue()) {
                PresenceData defaultPresenceData = Config.getProperty(screenInstance.defaultData, "data") != null ? screenInstance.defaultData.getData() : new PresenceData();
                PresenceData currentPresenceData = Config.getProperty(screenInstance.currentData, "data") != null ? screenInstance.currentData.getData() : defaultPresenceData;
                this.openScreen(new PresenceEditorGui((class_388)screenInstance, currentPresenceData, defaultPresenceData, output -> screenInstance.currentData.setData((PresenceData)output)));
            } else {
                screenInstance.currentData.setIconOverride((String)attributeName);
            }
        }, (attributeName, screenInstance) -> screenInstance.drawMultiLineString(StringUtils.splitTextByNewLine(Constants.TRANSLATOR.translate("gui.config.comment.server_messages.server_messages", CraftPresence.CLIENT.generateArgumentMessage("server.", "world.", "player.")))))))), () -> {
            if (!this.serverMessagesButton.isControlEnabled()) {
                this.drawMultiLineString(StringUtils.splitTextByNewLine(Constants.TRANSLATOR.translate("gui.config.message.hover.access", Constants.TRANSLATOR.translate("gui.config.name.server_messages.server_messages", new Object[0]))));
            } else {
                this.drawMultiLineString(StringUtils.splitTextByNewLine(Constants.TRANSLATOR.translate("gui.config.comment.server_messages.server_messages", CraftPresence.CLIENT.generateArgumentMessage("server.", "world.", "player."))));
            }
        }, new String[0]));
        this.proceedButton.setOnHover(() -> {
            if (!this.proceedButton.isControlEnabled()) {
                this.drawMultiLineString(StringUtils.splitTextByNewLine(Constants.TRANSLATOR.translate("gui.config.message.hover.empty.default", new Object[0])));
            }
        });
    }

    @Override
    protected boolean allowedToReset() {
        return true;
    }

    @Override
    protected void syncRenderStates() {
        super.syncRenderStates();
        this.proceedButton.setControlEnabled(!StringUtils.isNullOrEmpty(this.defaultMessage.getControlMessage()) || !StringUtils.isNullOrEmpty(this.defaultName.getControlMessage()) || !StringUtils.isNullOrEmpty(this.defaultMOTD.getControlMessage()));
        this.serverMessagesButton.setControlEnabled(CraftPresence.SERVER.enabled);
    }

    @Override
    protected Server getInstanceData() {
        return this.INSTANCE;
    }

    @Override
    protected Server getCurrentData() {
        return CraftPresence.CONFIG.serverSettings;
    }

    @Override
    protected Server getDefaultData() {
        return this.DEFAULTS;
    }
}

