/*
 * Decompiled with CFR 0.152.
 */
package fabric.com.gitlab.cdagaming.craftpresence.config.gui;

import com.gitlab.cdagaming.craftpresence.core.Constants;
import com.gitlab.cdagaming.craftpresence.core.config.element.Button;
import com.gitlab.cdagaming.craftpresence.core.config.element.PresenceData;
import fabric.com.gitlab.cdagaming.craftpresence.CraftPresence;
import fabric.com.gitlab.cdagaming.craftpresence.config.Config;
import fabric.com.gitlab.cdagaming.craftpresence.utils.gui.controls.CheckBoxControl;
import fabric.com.gitlab.cdagaming.craftpresence.utils.gui.controls.ExtendedButtonControl;
import fabric.com.gitlab.cdagaming.craftpresence.utils.gui.controls.ScrollableListControl;
import fabric.com.gitlab.cdagaming.craftpresence.utils.gui.impl.ConfigurationGui;
import fabric.com.gitlab.cdagaming.craftpresence.utils.gui.impl.DynamicEditorGui;
import fabric.com.gitlab.cdagaming.craftpresence.utils.gui.impl.SelectorGui;
import fabric.com.gitlab.cdagaming.craftpresence.utils.gui.integrations.ExtendedScreen;
import fabric.com.gitlab.cdagaming.craftpresence.utils.gui.widgets.ScrollableTextWidget;
import fabric.com.gitlab.cdagaming.craftpresence.utils.gui.widgets.TextWidget;
import io.github.cdagaming.unicore.utils.StringUtils;
import java.util.function.Consumer;
import net.minecraft.class_388;

public class PresenceEditorGui
extends ConfigurationGui<PresenceData> {
    private final PresenceData DEFAULTS;
    private final PresenceData INSTANCE;
    private final PresenceData CURRENT;
    private final boolean isDefaultModule;
    private final Consumer<PresenceData> onChangedCallback;
    private TextWidget detailsFormat;
    private TextWidget gameStateFormat;
    private TextWidget largeImageFormat;
    private TextWidget smallImageFormat;
    private TextWidget smallImageKeyFormat;
    private TextWidget largeImageKeyFormat;
    private TextWidget startTimeFormat;
    private TextWidget endTimeFormat;
    private CheckBoxControl useAsMainCheckbox;
    private CheckBoxControl enabledCheckbox;

    PresenceEditorGui(class_388 parentScreen, PresenceData moduleData, PresenceData defaultData, boolean isDefault, Consumer<PresenceData> changedCallback) {
        super(parentScreen, "gui.config.title", "gui.config.title.editor.presence");
        this.DEFAULTS = defaultData;
        this.INSTANCE = moduleData.copy();
        this.CURRENT = moduleData;
        this.isDefaultModule = isDefault;
        this.onChangedCallback = changedCallback;
    }

    PresenceEditorGui(class_388 parentScreen, PresenceData moduleData, PresenceData defaultData, Consumer<PresenceData> changedCallback) {
        this(parentScreen, moduleData, defaultData, false, changedCallback);
    }

    @Override
    protected void appendControls() {
        super.appendControls();
        int calc1 = this.getScreenWidth() / 2 - 183;
        int calc2 = this.getScreenWidth() / 2 + 3;
        String generalFieldsTitle = Constants.TRANSLATOR.translate("gui.config.message.editor.presence.general", new Object[0]);
        String largeImageTitle = Constants.TRANSLATOR.translate("gui.config.message.editor.presence.image.large", new Object[0]);
        String smallImageTitle = Constants.TRANSLATOR.translate("gui.config.message.editor.presence.image.small", new Object[0]);
        String extraFieldsTitle = Constants.TRANSLATOR.translate("gui.config.message.editor.presence.extra", new Object[0]);
        int controlIndex = 0;
        this.childFrame.addWidget(new ScrollableTextWidget((ExtendedScreen)this.childFrame, calc1, this.getButtonY(controlIndex++), this.childFrame.getScreenWidth(), generalFieldsTitle));
        if (!this.isDefaultModule) {
            this.enabledCheckbox = this.childFrame.addControl(new CheckBoxControl(calc1, this.getButtonY(controlIndex), "gui.config.message.editor.presence.enabled", this.getInstanceData().enabled, () -> {
                this.getInstanceData().enabled = this.enabledCheckbox.isChecked();
            }, () -> this.drawMultiLineString(StringUtils.splitTextByNewLine(Constants.TRANSLATOR.translate("gui.config.message.hover.presence.enabled", new Object[0])))));
            this.useAsMainCheckbox = this.childFrame.addControl(new CheckBoxControl(calc2, this.getButtonY(controlIndex), "gui.config.message.editor.presence.use_as_main", this.getInstanceData().useAsMain, () -> {
                this.getInstanceData().useAsMain = this.useAsMainCheckbox.isChecked();
            }, () -> this.drawMultiLineString(StringUtils.splitTextByNewLine(Constants.TRANSLATOR.translate("gui.config.message.hover.presence.use_as_main", new Object[0])))));
        }
        int n = ++controlIndex;
        this.detailsFormat = this.childFrame.addControl(new TextWidget(this.getFontRenderer(), this.getButtonY(n), 180, 20, () -> this.getInstanceData().setDetails(this.detailsFormat.getControlMessage()), "gui.config.message.editor.presence.details", () -> this.drawMultiLineString(StringUtils.splitTextByNewLine(Constants.TRANSLATOR.translate("gui.config.message.presence.args.general", CraftPresence.CLIENT.generateArgumentMessage("general."))))));
        int n2 = ++controlIndex;
        this.gameStateFormat = this.childFrame.addControl(new TextWidget(this.getFontRenderer(), this.getButtonY(n2), 180, 20, () -> this.getInstanceData().setGameState(this.gameStateFormat.getControlMessage()), "gui.config.message.editor.presence.game_state", () -> this.drawMultiLineString(StringUtils.splitTextByNewLine(Constants.TRANSLATOR.translate("gui.config.message.presence.args.general", CraftPresence.CLIENT.generateArgumentMessage("general."))))));
        this.detailsFormat.setControlMessage(this.getInstanceData().details);
        this.gameStateFormat.setControlMessage(this.getInstanceData().gameState);
        int n3 = ++controlIndex;
        this.childFrame.addWidget(new ScrollableTextWidget((ExtendedScreen)this.childFrame, calc1, this.getButtonY(n3), this.childFrame.getScreenWidth(), largeImageTitle));
        int n4 = ++controlIndex;
        this.largeImageFormat = this.childFrame.addControl(new TextWidget(this.getFontRenderer(), this.getButtonY(n4), 180, 20, () -> {
            this.getInstanceData().largeImageText = this.largeImageFormat.getControlMessage();
        }, "gui.config.message.editor.message", () -> this.drawMultiLineString(StringUtils.splitTextByNewLine(Constants.TRANSLATOR.translate("gui.config.message.presence.args.general", CraftPresence.CLIENT.generateArgumentMessage("general."))))));
        int n5 = ++controlIndex;
        this.largeImageKeyFormat = this.childFrame.addControl(new TextWidget(this.getFontRenderer(), this.getButtonY(n5), 147, 20, () -> {
            this.getInstanceData().largeImageKey = this.largeImageKeyFormat.getControlMessage();
        }, "gui.config.message.editor.icon.change", () -> this.drawMultiLineString(StringUtils.splitTextByNewLine(Constants.TRANSLATOR.translate("gui.config.message.presence.args.icon", CraftPresence.CLIENT.generateArgumentMessage("general."))))));
        this.addIconSelector(this.childFrame, () -> this.largeImageKeyFormat, (attributeName, currentValue) -> {
            this.getInstanceData().largeImageKey = currentValue;
        });
        this.largeImageFormat.setControlMessage(this.getInstanceData().largeImageText);
        this.largeImageKeyFormat.setControlMessage(this.getInstanceData().largeImageKey);
        int n6 = ++controlIndex;
        this.childFrame.addWidget(new ScrollableTextWidget((ExtendedScreen)this.childFrame, calc1, this.getButtonY(n6), this.childFrame.getScreenWidth(), smallImageTitle));
        int n7 = ++controlIndex;
        this.smallImageFormat = this.childFrame.addControl(new TextWidget(this.getFontRenderer(), this.getButtonY(n7), 180, 20, () -> {
            this.getInstanceData().smallImageText = this.smallImageFormat.getControlMessage();
        }, "gui.config.message.editor.message", () -> this.drawMultiLineString(StringUtils.splitTextByNewLine(Constants.TRANSLATOR.translate("gui.config.message.presence.args.general", CraftPresence.CLIENT.generateArgumentMessage("general."))))));
        int n8 = ++controlIndex;
        this.smallImageKeyFormat = this.childFrame.addControl(new TextWidget(this.getFontRenderer(), this.getButtonY(n8), 147, 20, () -> {
            this.getInstanceData().smallImageKey = this.smallImageKeyFormat.getControlMessage();
        }, "gui.config.message.editor.icon.change", () -> this.drawMultiLineString(StringUtils.splitTextByNewLine(Constants.TRANSLATOR.translate("gui.config.message.presence.args.icon", CraftPresence.CLIENT.generateArgumentMessage("general."))))));
        this.addIconSelector(this.childFrame, () -> this.smallImageKeyFormat, (attributeName, currentValue) -> {
            this.getInstanceData().smallImageKey = currentValue;
        });
        this.smallImageFormat.setControlMessage(this.getInstanceData().smallImageText);
        this.smallImageKeyFormat.setControlMessage(this.getInstanceData().smallImageKey);
        int n9 = ++controlIndex;
        this.childFrame.addWidget(new ScrollableTextWidget((ExtendedScreen)this.childFrame, calc1, this.getButtonY(n9), this.childFrame.getScreenWidth(), extraFieldsTitle));
        int n10 = ++controlIndex;
        this.startTimeFormat = this.childFrame.addControl(new TextWidget(this.getFontRenderer(), this.getButtonY(n10), 180, 20, () -> this.getInstanceData().setStartTime(this.startTimeFormat.getControlMessage()), "gui.config.message.editor.presence.start_timestamp", () -> this.drawMultiLineString(StringUtils.splitTextByNewLine(Constants.TRANSLATOR.translate("gui.config.message.presence.args.general", CraftPresence.CLIENT.generateArgumentMessage("general."))))));
        int n11 = ++controlIndex;
        this.endTimeFormat = this.childFrame.addControl(new TextWidget(this.getFontRenderer(), this.getButtonY(n11), 180, 20, () -> this.getInstanceData().setEndTime(this.endTimeFormat.getControlMessage()), "gui.config.message.editor.presence.end_timestamp", () -> this.drawMultiLineString(StringUtils.splitTextByNewLine(Constants.TRANSLATOR.translate("gui.config.message.presence.args.general", CraftPresence.CLIENT.generateArgumentMessage("general."))))));
        this.startTimeFormat.setControlMessage(this.getInstanceData().startTimestamp);
        this.endTimeFormat.setControlMessage(this.getInstanceData().endTimestamp);
        int n12 = ++controlIndex;
        ++controlIndex;
        this.childFrame.addControl(new ExtendedButtonControl(this.getScreenWidth() / 2 - 90, this.getButtonY(n12), 180, 20, "gui.config.message.editor.presence.button_editor", () -> this.openScreen(new SelectorGui(this.currentScreen, Constants.TRANSLATOR.translate("gui.config.title.selector.button", new Object[0]), CraftPresence.CLIENT.createButtonsList(this.getInstanceData().buttons), null, null, true, true, ScrollableListControl.RenderType.None, null, (currentValue, parentScreen) -> this.openScreen(new DynamicEditorGui((class_388)parentScreen, (String)currentValue, (attributeName, screenInstance) -> {
            screenInstance.attributeName = "button_" + CraftPresence.CLIENT.createButtonsList(this.getInstanceData().buttons).size();
            screenInstance.mainTitle = Constants.TRANSLATOR.translate("gui.config.title.editor.add.new.prefilled", screenInstance.attributeName);
            screenInstance.primaryText = Constants.TRANSLATOR.translate("gui.config.message.editor.label", new Object[0]);
            screenInstance.secondaryText = Constants.TRANSLATOR.translate("gui.config.message.editor.url", new Object[0]);
            Button defaultData = this.getInstanceData().buttons.get("default");
            screenInstance.originalPrimaryMessage = Config.getProperty(defaultData, "label") != null ? defaultData.label : "";
            screenInstance.primaryMessage = screenInstance.originalPrimaryMessage;
            screenInstance.originalSecondaryMessage = Config.getProperty(defaultData, "url") != null ? defaultData.url : "";
            screenInstance.secondaryMessage = screenInstance.originalSecondaryMessage;
        }, (attributeName, screenInstance) -> {
            screenInstance.primaryText = Constants.TRANSLATOR.translate("gui.config.message.editor.label", new Object[0]);
            screenInstance.secondaryText = Constants.TRANSLATOR.translate("gui.config.message.editor.url", new Object[0]);
            screenInstance.overrideSecondaryRender = true;
            screenInstance.mainTitle = Constants.TRANSLATOR.translate("gui.config.title.display.edit_specific_button", attributeName);
            Button defaultData = this.getInstanceData().buttons.get("default");
            Button currentData = this.getInstanceData().buttons.get(attributeName);
            screenInstance.isPreliminaryData = currentData == null;
            screenInstance.originalPrimaryMessage = Config.getProperty(defaultData, "label") != null ? defaultData.label : "";
            screenInstance.originalSecondaryMessage = Config.getProperty(defaultData, "url") != null ? defaultData.url : "";
            screenInstance.primaryMessage = Config.getProperty(currentData, "label") != null ? currentData.label : screenInstance.originalPrimaryMessage;
            screenInstance.secondaryMessage = Config.getProperty(currentData, "url") != null ? currentData.url : screenInstance.originalSecondaryMessage;
        }, (screenInstance, secondaryText, inputText) -> this.getInstanceData().addButton(screenInstance.attributeName, new Button((String)inputText, (String)secondaryText)), (screenInstance, secondaryText, inputText) -> this.getInstanceData().removeButton(screenInstance.attributeName), null, (attributeName, screenInstance) -> screenInstance.drawMultiLineString(StringUtils.splitTextByNewLine(Constants.TRANSLATOR.translate("gui.config.message.hover.presence.button.label", new Object[0]))), (attributeName, screenInstance) -> screenInstance.drawMultiLineString(StringUtils.splitTextByNewLine(Constants.TRANSLATOR.translate("gui.config.message.hover.presence.button.url", new Object[0]))))))), () -> this.drawMultiLineString(StringUtils.splitTextByNewLine(Constants.TRANSLATOR.translate("gui.config.message.hover.presence.button_editor", new Object[0]))), new String[0]));
    }

    @Override
    protected boolean allowedToReset() {
        return this.DEFAULTS != null;
    }

    @Override
    protected PresenceData getInstanceData() {
        return this.INSTANCE;
    }

    @Override
    protected PresenceData getCurrentData() {
        return this.CURRENT;
    }

    @Override
    protected PresenceData getDefaultData() {
        return this.DEFAULTS;
    }

    @Override
    protected boolean setCurrentData(PresenceData data) {
        if (this.onChangedCallback != null && this.hasChangesBetween(this.getCurrentData(), data)) {
            this.onChangedCallback.accept(data);
            return true;
        }
        return false;
    }
}

