/*
 * Decompiled with CFR 0.152.
 */
package fabric.com.gitlab.cdagaming.craftpresence.config.gui;

import com.gitlab.cdagaming.craftpresence.core.Constants;
import com.gitlab.cdagaming.craftpresence.core.config.element.ColorData;
import com.gitlab.cdagaming.craftpresence.core.config.element.ColorSection;
import fabric.com.gitlab.cdagaming.craftpresence.utils.gui.controls.SliderControl;
import fabric.com.gitlab.cdagaming.craftpresence.utils.gui.impl.ConfigurationGui;
import fabric.com.gitlab.cdagaming.craftpresence.utils.gui.integrations.ExtendedScreen;
import fabric.com.gitlab.cdagaming.craftpresence.utils.gui.widgets.ScrollableTextWidget;
import fabric.com.gitlab.cdagaming.craftpresence.utils.gui.widgets.TextWidget;
import fabric.com.gitlab.cdagaming.craftpresence.utils.gui.widgets.TexturedWidget;
import io.github.cdagaming.unicore.impl.Pair;
import io.github.cdagaming.unicore.impl.Tuple;
import io.github.cdagaming.unicore.utils.StringUtils;
import java.awt.Color;
import net.minecraft.class_388;

public class ColorEditorGui
extends ConfigurationGui<ColorData> {
    private final ColorData DEFAULTS;
    private final ColorData INSTANCE;
    private final ColorData CURRENT;
    private ColorData storedStart;
    private ColorData storedEnd;
    private SliderControl startRed;
    private SliderControl startGreen;
    private SliderControl startBlue;
    private SliderControl startAlpha;
    private SliderControl endRed;
    private SliderControl endGreen;
    private SliderControl endBlue;
    private SliderControl endAlpha;
    private TextWidget textureLocationText;
    private TextWidget startColorText;
    private TextWidget endColorText;
    private SliderControl tintFactor;

    ColorEditorGui(class_388 parentScreen, ColorData moduleData, ColorData defaultData) {
        super(parentScreen, "gui.config.title", "gui.config.title.editor.color");
        this.DEFAULTS = defaultData;
        this.INSTANCE = moduleData.copy();
        this.CURRENT = moduleData;
    }

    @Override
    protected void appendControls() {
        super.appendControls();
        this.storedStart = new ColorData(this.getInstanceData().getStart());
        this.storedEnd = new ColorData(this.getInstanceData().getEnd());
        int calc1 = this.getScreenWidth() / 2 - 183;
        int calc2 = this.getScreenWidth() / 2 + 3;
        int calcAlt = calc2 + 180;
        String startColorTitle = Constants.TRANSLATOR.translate("gui.config.message.editor.color.start", new Object[0]);
        String endColorTitle = Constants.TRANSLATOR.translate("gui.config.message.editor.color.end", new Object[0]);
        String previewTitle = Constants.TRANSLATOR.translate("gui.config.message.editor.color.preview", new Object[0]);
        String redTitle = Constants.TRANSLATOR.translate("gui.config.message.editor.color.value.red", new Object[0]);
        String greenTitle = Constants.TRANSLATOR.translate("gui.config.message.editor.color.value.green", new Object[0]);
        String blueTitle = Constants.TRANSLATOR.translate("gui.config.message.editor.color.value.blue", new Object[0]);
        String alphaTitle = Constants.TRANSLATOR.translate("gui.config.message.editor.color.value.alpha", new Object[0]);
        String tintFactorTitle = Constants.TRANSLATOR.translate("gui.config.message.editor.color.tint_factor", new Object[0]);
        this.childFrame.addWidget(new ScrollableTextWidget((ExtendedScreen)this.childFrame, calc1, this.getButtonY(0), this.childFrame.getScreenWidth(), startColorTitle));
        this.startColorText = this.childFrame.addControl(new TextWidget(this.getFontRenderer(), this.getButtonY(1), 180, 20, () -> {
            String newText = this.startColorText.getControlMessage();
            if (StringUtils.isValidColorCode(newText)) {
                Color newColor = StringUtils.findColor(newText);
                this.startRed.setSliderValue(newColor.getRed());
                this.startGreen.setSliderValue(newColor.getGreen());
                this.startBlue.setSliderValue(newColor.getBlue());
                this.startAlpha.setSliderValue(newColor.getAlpha());
            }
        }, "gui.config.message.editor.hex_code"));
        this.startRed = this.childFrame.addControl(new SliderControl(new Pair<Integer, Integer>(calc1, this.getButtonY(2)), new Pair<Integer, Integer>(180, 20), (float)this.getInstanceData().getStart().red, 0.0f, 255.0f, 1.0f, redTitle, new Tuple<Runnable, Object, Runnable>(() -> {
            ColorSection sect = this.getInstanceData().getStart();
            sect.red = (int)this.startRed.getSliderValue();
            this.setStartColor(sect);
        }, null, () -> {
            ColorSection sect = this.getInstanceData().getStart();
            sect.red = (int)this.startRed.getSliderValue();
            this.setStartColor(sect);
        })));
        this.startGreen = this.childFrame.addControl(new SliderControl(new Pair<Integer, Integer>(calc1, this.getButtonY(3)), new Pair<Integer, Integer>(180, 20), (float)this.getInstanceData().getStart().green, 0.0f, 255.0f, 1.0f, greenTitle, new Tuple<Runnable, Object, Runnable>(() -> {
            ColorSection sect = this.getInstanceData().getStart();
            sect.green = (int)this.startGreen.getSliderValue();
            this.setStartColor(sect);
        }, null, () -> {
            ColorSection sect = this.getInstanceData().getStart();
            sect.green = (int)this.startGreen.getSliderValue();
            this.setStartColor(sect);
        })));
        this.startBlue = this.childFrame.addControl(new SliderControl(new Pair<Integer, Integer>(calc1, this.getButtonY(4)), new Pair<Integer, Integer>(180, 20), (float)this.getInstanceData().getStart().blue, 0.0f, 255.0f, 1.0f, blueTitle, new Tuple<Runnable, Object, Runnable>(() -> {
            ColorSection sect = this.getInstanceData().getStart();
            sect.blue = (int)this.startBlue.getSliderValue();
            this.setStartColor(sect);
        }, null, () -> {
            ColorSection sect = this.getInstanceData().getStart();
            sect.blue = (int)this.startBlue.getSliderValue();
            this.setStartColor(sect);
        })));
        this.startAlpha = this.childFrame.addControl(new SliderControl(new Pair<Integer, Integer>(calc1, this.getButtonY(5)), new Pair<Integer, Integer>(180, 20), (float)this.getInstanceData().getStart().alpha, 0.0f, 255.0f, 1.0f, alphaTitle, new Tuple<Runnable, Object, Runnable>(() -> {
            ColorSection sect = this.getInstanceData().getStart();
            sect.alpha = (int)this.startAlpha.getSliderValue();
            this.setStartColor(sect);
        }, null, () -> {
            ColorSection sect = this.getInstanceData().getStart();
            sect.alpha = (int)this.startAlpha.getSliderValue();
            this.setStartColor(sect);
        })));
        this.childFrame.addWidget(new TexturedWidget(this.childFrame, calc2, this.getButtonY(2, 1), calcAlt, 93, 0.0, () -> Float.valueOf(1.0f), () -> this.storedStart, true));
        this.childFrame.addWidget(new ScrollableTextWidget((ExtendedScreen)this.childFrame, calc1, this.getButtonY(6), this.childFrame.getScreenWidth(), endColorTitle));
        this.endColorText = this.childFrame.addControl(new TextWidget(this.getFontRenderer(), this.getButtonY(7), 180, 20, () -> {
            String newText = this.endColorText.getControlMessage();
            if (StringUtils.isValidColorCode(newText)) {
                Color newColor = StringUtils.findColor(newText);
                this.endRed.setSliderValue(newColor.getRed());
                this.endGreen.setSliderValue(newColor.getGreen());
                this.endBlue.setSliderValue(newColor.getBlue());
                this.endAlpha.setSliderValue(newColor.getAlpha());
            }
        }, "gui.config.message.editor.hex_code"));
        this.endRed = this.childFrame.addControl(new SliderControl(new Pair<Integer, Integer>(calc1, this.getButtonY(8)), new Pair<Integer, Integer>(180, 20), (float)this.getInstanceData().getEnd().red, 0.0f, 255.0f, 1.0f, redTitle, new Tuple<Runnable, Object, Runnable>(() -> {
            ColorSection sect = this.getInstanceData().getEnd();
            sect.red = (int)this.endRed.getSliderValue();
            this.setEndColor(sect);
        }, null, () -> {
            ColorSection sect = this.getInstanceData().getEnd();
            sect.red = (int)this.endRed.getSliderValue();
            this.setEndColor(sect);
        })));
        this.endGreen = this.childFrame.addControl(new SliderControl(new Pair<Integer, Integer>(calc1, this.getButtonY(9)), new Pair<Integer, Integer>(180, 20), (float)this.getInstanceData().getEnd().green, 0.0f, 255.0f, 1.0f, greenTitle, new Tuple<Runnable, Object, Runnable>(() -> {
            ColorSection sect = this.getInstanceData().getEnd();
            sect.green = (int)this.endGreen.getSliderValue();
            this.setEndColor(sect);
        }, null, () -> {
            ColorSection sect = this.getInstanceData().getEnd();
            sect.green = (int)this.endGreen.getSliderValue();
            this.setEndColor(sect);
        })));
        this.endBlue = this.childFrame.addControl(new SliderControl(new Pair<Integer, Integer>(calc1, this.getButtonY(10)), new Pair<Integer, Integer>(180, 20), (float)this.getInstanceData().getEnd().blue, 0.0f, 255.0f, 1.0f, blueTitle, new Tuple<Runnable, Object, Runnable>(() -> {
            ColorSection sect = this.getInstanceData().getEnd();
            sect.blue = (int)this.endBlue.getSliderValue();
            this.setEndColor(sect);
        }, null, () -> {
            ColorSection sect = this.getInstanceData().getEnd();
            sect.blue = (int)this.endBlue.getSliderValue();
            this.setEndColor(sect);
        })));
        this.endAlpha = this.childFrame.addControl(new SliderControl(new Pair<Integer, Integer>(calc1, this.getButtonY(11)), new Pair<Integer, Integer>(180, 20), (float)this.getInstanceData().getEnd().alpha, 0.0f, 255.0f, 1.0f, alphaTitle, new Tuple<Runnable, Object, Runnable>(() -> {
            ColorSection sect = this.getInstanceData().getEnd();
            sect.alpha = (int)this.endAlpha.getSliderValue();
            this.setEndColor(sect);
        }, null, () -> {
            ColorSection sect = this.getInstanceData().getEnd();
            sect.alpha = (int)this.endAlpha.getSliderValue();
            this.setEndColor(sect);
        })));
        this.childFrame.addWidget(new TexturedWidget(this.childFrame, calc2, this.getButtonY(8, 1), calcAlt, 93, 0.0, () -> Float.valueOf(1.0f), () -> this.storedEnd, true));
        this.childFrame.addWidget(new ScrollableTextWidget((ExtendedScreen)this.childFrame, calc1, this.getButtonY(12), this.childFrame.getScreenWidth(), previewTitle));
        this.textureLocationText = this.childFrame.addControl(new TextWidget(this.getFontRenderer(), this.getButtonY(13), 180, 20, () -> this.getInstanceData().setTexLocation(this.textureLocationText.getControlMessage()), "gui.config.message.editor.texture_path"));
        this.textureLocationText.setControlMessage(this.getInstanceData().getTexLocation());
        this.tintFactor = this.childFrame.addControl(new SliderControl(new Pair<Integer, Integer>(calc1, this.getButtonY(14)), new Pair<Integer, Integer>(180, 20), 100.0f, 0.0f, 100.0f, 1.0f, tintFactorTitle));
        this.childFrame.addWidget(new TexturedWidget(this.childFrame, calc2, this.getButtonY(14, 1), calcAlt, 93, 0.0, () -> Float.valueOf(this.tintFactor.getSliderValue(true)), this::getInstanceData, true));
    }

    @Override
    protected boolean allowedToReset() {
        return this.DEFAULTS != null;
    }

    @Override
    protected ColorData getInstanceData() {
        return this.INSTANCE;
    }

    @Override
    protected ColorData getCurrentData() {
        return this.CURRENT;
    }

    @Override
    protected ColorData getDefaultData() {
        return this.DEFAULTS;
    }

    @Override
    protected boolean setCurrentData(ColorData data) {
        if (data.getStart() != null && data.getStart().equals(data.getEnd())) {
            data.setEndColor(null);
        }
        if (StringUtils.isNullOrEmpty(data.getTexLocation())) {
            data.setTexLocation(null);
        }
        return super.setCurrentData(data);
    }

    private void setStartColor(ColorSection sect) {
        this.getInstanceData().setStartColor(sect);
        this.storedStart.setStartColor(sect);
    }

    private void setEndColor(ColorSection sect) {
        this.getInstanceData().setEndColor(sect);
        this.storedEnd.setStartColor(sect);
    }
}

