/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.cdagaming.craftpresence.core.config.element;

import com.gitlab.cdagaming.craftpresence.core.Constants;
import com.gitlab.cdagaming.craftpresence.core.config.Module;
import com.gitlab.cdagaming.craftpresence.core.config.element.Button;
import io.github.cdagaming.unicore.impl.HashMapBuilder;
import io.github.cdagaming.unicore.utils.StringUtils;
import java.io.Serializable;
import java.util.Map;
import java.util.Objects;

public class PresenceData
extends Module
implements Serializable {
    private static final long serialVersionUID = -7560029890988753870L;
    private static final PresenceData DEFAULT = new PresenceData();
    public boolean enabled = true;
    public boolean useAsMain = false;
    public String details = "";
    public String gameState = "";
    public String largeImageKey = "";
    public String largeImageText = "";
    public String smallImageKey = "";
    public String smallImageText = "";
    public String startTimestamp = "";
    public String endTimestamp = "";
    public Map<String, Button> buttons = new HashMapBuilder<String, Button>().put("default", new Button(Constants.TRANSLATOR.translate("craftpresence.defaults.display.button.label", new Object[0]), Constants.TRANSLATOR.translate("craftpresence.defaults.display.button.url", new Object[0]))).build();

    public PresenceData(PresenceData other) {
        this.transferFrom(other);
    }

    public PresenceData() {
    }

    @Override
    public PresenceData getDefaults() {
        return new PresenceData(DEFAULT);
    }

    @Override
    public void transferFrom(Module target) {
        if (target instanceof PresenceData && !this.equals(target)) {
            PresenceData data = (PresenceData)target;
            this.enabled = data.enabled;
            this.useAsMain = data.useAsMain;
            this.setDetails(data.details);
            this.setGameState(data.gameState);
            this.setLargeImage(data.largeImageKey, data.largeImageText);
            this.setSmallImage(data.smallImageKey, data.smallImageText);
            this.setTimes(data.startTimestamp, data.endTimestamp);
            this.buttons.clear();
            for (Map.Entry<String, Button> entry : data.buttons.entrySet()) {
                this.addButton(entry.getKey(), entry.getValue());
            }
        }
    }

    @Override
    public PresenceData copy() {
        return new PresenceData(this);
    }

    public PresenceData setDetails(String details) {
        this.details = details;
        return this;
    }

    public PresenceData setGameState(String gameState) {
        this.gameState = gameState;
        return this;
    }

    public PresenceData setLargeImage(String imageKey, String imageText) {
        this.largeImageKey = imageKey;
        this.largeImageText = imageText;
        return this;
    }

    public PresenceData setSmallImage(String imageKey, String imageText) {
        this.smallImageKey = imageKey;
        this.smallImageText = imageText;
        return this;
    }

    public PresenceData setTimes(String startTimestamp, String endTimestamp) {
        this.startTimestamp = startTimestamp;
        this.endTimestamp = endTimestamp;
        return this;
    }

    public PresenceData setStartTime(String timestamp) {
        return this.setTimes(timestamp, this.endTimestamp);
    }

    public PresenceData setEndTime(String timestamp) {
        return this.setTimes(this.startTimestamp, timestamp);
    }

    public PresenceData addButton(String name, Button button) {
        this.buttons.put(name, new Button(button));
        return this;
    }

    public PresenceData removeButton(String name) {
        this.buttons.remove(name);
        return this;
    }

    @Override
    public Object getProperty(String name) {
        return StringUtils.getField(PresenceData.class, this, name);
    }

    @Override
    public void setProperty(String name, Object value) {
        StringUtils.updateField(PresenceData.class, this, value, name);
    }

    @Override
    public boolean equals(Object obj) {
        boolean areButtonsEqual;
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof PresenceData)) {
            return false;
        }
        PresenceData p = (PresenceData)obj;
        boolean bl = areButtonsEqual = this.buttons.size() == p.buttons.size();
        if (areButtonsEqual) {
            for (Map.Entry<String, Button> entry : this.buttons.entrySet()) {
                String key = entry.getKey();
                if (p.buttons.containsKey(key) && p.buttons.get(key).equals(entry.getValue())) continue;
                areButtonsEqual = false;
                break;
            }
        }
        return Objects.equals(p.details, this.details) && Objects.equals(p.gameState, this.gameState) && Objects.equals(p.largeImageKey, this.largeImageKey) && Objects.equals(p.largeImageText, this.largeImageText) && Objects.equals(p.smallImageKey, this.smallImageKey) && Objects.equals(p.startTimestamp, this.startTimestamp) && Objects.equals(p.endTimestamp, this.endTimestamp) && areButtonsEqual;
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.details != null ? this.details.hashCode() : 0);
        result = 31 * result + (this.gameState != null ? this.gameState.hashCode() : 0);
        result = 31 * result + (this.largeImageKey != null ? this.largeImageKey.hashCode() : 0);
        result = 31 * result + (this.largeImageText != null ? this.largeImageText.hashCode() : 0);
        result = 31 * result + (this.smallImageKey != null ? this.smallImageKey.hashCode() : 0);
        result = 31 * result + (this.startTimestamp != null ? this.startTimestamp.hashCode() : 0);
        result = 31 * result + (this.endTimestamp != null ? this.endTimestamp.hashCode() : 0);
        result = 31 * result + (this.buttons != null ? this.buttons.hashCode() : 0);
        return result;
    }
}

