/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizon.gtnhlib.util.parsing;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParsePosition;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.function.BiFunction;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;

public class MathExpressionParser {
    public static final Pattern EXPRESSION_PATTERN = Pattern.compile("[0-9., \u202f_\u2019+\\-*/^()eEkKmMgGbBtTsSiI%]*");
    private static final Context defaultContext = new Context();

    public static double parse(String expr) {
        return MathExpressionParser.parse(expr, defaultContext);
    }

    public static double parse(String expr, Context ctx) {
        if (expr == null) {
            ctx.success = true;
            ctx.errorMessage = "Success";
            return ctx.emptyValue;
        }
        if ((expr = expr.replace(" ", "").replace("_", "")).isEmpty()) {
            ctx.success = true;
            ctx.errorMessage = "Success";
            return ctx.emptyValue;
        }
        ParsePosition parsePos = new ParsePosition(0);
        Number value = ctx.numberFormat.parse(expr, parsePos);
        if (ctx.plainOnly) {
            if (value == null || parsePos.getIndex() == 0) {
                ctx.success = false;
                ctx.errorMessage = "Error: No number found";
                return ctx.errorValue;
            }
            ctx.success = true;
            ctx.errorMessage = "Success";
            return value.doubleValue();
        }
        if (value != null && parsePos.getIndex() == expr.length()) {
            ctx.success = true;
            ctx.errorMessage = "Success";
            return value.doubleValue();
        }
        ArrayList<StackElement> stack = new ArrayList<StackElement>();
        ctx.success = true;
        if (value != null) {
            double d = value.doubleValue();
            if (d < 0.0) {
                MathExpressionParser.handleMinus(stack, ctx);
                MathExpressionParser.handleNumber(stack, -d, ctx);
            } else {
                MathExpressionParser.handleNumber(stack, d, ctx);
            }
        }
        for (int i = parsePos.getIndex(); i < expr.length(); ++i) {
            char c = expr.charAt(i);
            switch (c) {
                case '+': {
                    MathExpressionParser.handlePlus(stack, ctx);
                    break;
                }
                case '-': {
                    MathExpressionParser.handleMinus(stack, ctx);
                    break;
                }
                case '*': {
                    MathExpressionParser.handleOperator(stack, Operator.MULTIPLY, ctx);
                    break;
                }
                case '/': {
                    MathExpressionParser.handleOperator(stack, Operator.DIVIDE, ctx);
                    break;
                }
                case '^': {
                    MathExpressionParser.handleOperator(stack, Operator.POWER, ctx);
                    break;
                }
                case 'E': 
                case 'e': {
                    MathExpressionParser.handleOperator(stack, Operator.SCIENTIFIC, ctx);
                    break;
                }
                case 'K': 
                case 'k': {
                    MathExpressionParser.handleSuffix(stack, Suffix.THOUSAND, c, ctx);
                    break;
                }
                case 'M': 
                case 'm': {
                    MathExpressionParser.handleSuffix(stack, Suffix.MILLION, c, ctx);
                    break;
                }
                case 'B': 
                case 'G': 
                case 'b': 
                case 'g': {
                    MathExpressionParser.handleSuffix(stack, Suffix.BILLION, c, ctx);
                    break;
                }
                case 'T': 
                case 't': {
                    MathExpressionParser.handleSuffix(stack, Suffix.TRILLION, c, ctx);
                    break;
                }
                case 'S': 
                case 's': {
                    MathExpressionParser.handleSuffix(stack, Suffix.STACK, c, ctx);
                    break;
                }
                case 'I': 
                case 'i': {
                    MathExpressionParser.handleSuffix(stack, Suffix.INGOT, c, ctx);
                    break;
                }
                case '%': {
                    MathExpressionParser.handleSuffix(stack, Suffix.PERCENT, c, ctx);
                    break;
                }
                case '(': {
                    MathExpressionParser.handleOpenBracket(stack, ctx);
                    break;
                }
                case ')': {
                    MathExpressionParser.handleClosedBracket(stack, ctx);
                    break;
                }
                default: {
                    parsePos.setIndex(i);
                    value = ctx.numberFormat.parse(expr, parsePos);
                    if (value == null || parsePos.getIndex() == i) {
                        ctx.success = false;
                        ctx.errorMessage = "Error: Number expected";
                        return ctx.errorValue;
                    }
                    MathExpressionParser.handleNumber(stack, value.doubleValue(), ctx);
                    i = parsePos.getIndex() - 1;
                }
            }
            if (ctx.success) continue;
            return ctx.errorValue;
        }
        MathExpressionParser.handleExpressionEnd(stack, ctx);
        if (!ctx.success) {
            return ctx.errorValue;
        }
        ctx.errorMessage = "Success";
        return ((StackElement)stack.get((int)0)).value;
    }

    private static boolean handleOperator(@NotNull List<StackElement> stack, Operator op, Context ctx) {
        if (stack.isEmpty()) {
            ctx.success = false;
            ctx.errorMessage = "Syntax error: no left-hand value for operator " + (Object)((Object)op);
            return false;
        }
        if (stack.get((int)(stack.size() - 1)).isOperator) {
            ctx.success = false;
            ctx.errorMessage = "Syntax error: two operators in a row: " + (Object)((Object)stack.get((int)(stack.size() - 1)).operator) + ", " + (Object)((Object)op);
            return false;
        }
        MathExpressionParser.evaluateStack(stack, op == Operator.POWER ? op.priority + 1 : op.priority);
        stack.add(new StackElement(op));
        return true;
    }

    private static boolean handlePlus(@NotNull List<StackElement> stack, Context ctx) {
        if (stack.isEmpty() || stack.get((int)(stack.size() - 1)).isOperator) {
            stack.add(new StackElement(0.0));
            stack.add(new StackElement(Operator.UNARY_PLUS));
        } else if (!MathExpressionParser.handleOperator(stack, Operator.PLUS, ctx)) {
            return false;
        }
        return true;
    }

    private static boolean handleMinus(@NotNull List<StackElement> stack, Context ctx) {
        if (stack.isEmpty() || stack.get((int)(stack.size() - 1)).isOperator) {
            stack.add(new StackElement(0.0));
            stack.add(new StackElement(Operator.UNARY_MINUS));
        } else if (!MathExpressionParser.handleOperator(stack, Operator.MINUS, ctx)) {
            return false;
        }
        return true;
    }

    private static boolean handleSuffix(@NotNull List<StackElement> stack, Suffix suf, char chr, Context ctx) {
        if (stack.isEmpty()) {
            ctx.success = false;
            ctx.errorMessage = "Syntax error: no value for suffix " + chr;
            return false;
        }
        StackElement a = stack.get(stack.size() - 1);
        if (!a.isValue) {
            ctx.success = false;
            ctx.errorMessage = "Syntax error: suffix " + chr + " follows operator " + (Object)((Object)a.operator);
            return false;
        }
        stack.remove(stack.size() - 1);
        if (suf == Suffix.PERCENT) {
            stack.add(new StackElement(a.value * 0.01 * ctx.hundredPercent));
        } else {
            stack.add(new StackElement(a.value * suf.multiplier));
        }
        return true;
    }

    private static boolean handleNumber(@NotNull List<StackElement> stack, double value, Context ctx) {
        if (!stack.isEmpty() && stack.get((int)(stack.size() - 1)).isValue) {
            ctx.success = false;
            ctx.errorMessage = "Syntax error: Number " + stack.get((int)(stack.size() - 1)).value + " followed by number " + value;
            return false;
        }
        stack.add(new StackElement(value));
        return true;
    }

    private static boolean handleOpenBracket(@NotNull List<StackElement> stack, Context ctx) {
        if (!stack.isEmpty() && stack.get((int)(stack.size() - 1)).isValue && !MathExpressionParser.handleOperator(stack, Operator.MULTIPLY, ctx)) {
            return false;
        }
        stack.add(new StackElement(0.0));
        stack.add(new StackElement(Operator.OPEN_BRACKET));
        return true;
    }

    private static boolean handleClosedBracket(@NotNull List<StackElement> stack, Context ctx) {
        if (stack.isEmpty()) {
            ctx.success = false;
            ctx.errorMessage = "Syntax error: Mismatched closed bracket";
            return false;
        }
        if (stack.get((int)(stack.size() - 1)).isOperator) {
            ctx.success = false;
            ctx.errorMessage = "Syntax error: Closed bracket immediately after operator " + (Object)((Object)stack.get((int)(stack.size() - 1)).operator);
            return false;
        }
        MathExpressionParser.evaluateStack(stack, Operator.OPEN_BRACKET.priority + 1);
        if (stack.size() < 2 || !stack.get((int)(stack.size() - 2)).isOperator || stack.get((int)(stack.size() - 2)).operator != Operator.OPEN_BRACKET) {
            ctx.success = false;
            ctx.errorMessage = "Syntax error: Mismatched closed bracket";
            return false;
        }
        stack.remove(stack.size() - 2);
        stack.remove(stack.size() - 2);
        return true;
    }

    private static boolean handleExpressionEnd(@NotNull List<StackElement> stack, Context ctx) {
        if (stack.isEmpty()) {
            ctx.success = false;
            ctx.errorMessage = "Internal error: Evaluating empty expression";
            return false;
        }
        if (stack.get((int)(stack.size() - 1)).isOperator) {
            ctx.success = false;
            ctx.errorMessage = "Syntax error: no right-hand value for operator " + (Object)((Object)stack.get((int)(stack.size() - 1)).operator);
            return false;
        }
        MathExpressionParser.evaluateStack(stack, -1);
        if (stack.size() > 1) {
            ctx.success = false;
            ctx.errorMessage = "Internal error: operators remaining after evaluating expression";
            return false;
        }
        return true;
    }

    private static void evaluateStack(@NotNull List<StackElement> stack, int minPriority) {
        while (stack.size() >= 3) {
            StackElement op = stack.get(stack.size() - 2);
            if (op.operator.priority < minPriority) break;
            StackElement right = stack.remove(stack.size() - 1);
            stack.remove(stack.size() - 1);
            StackElement left = stack.remove(stack.size() - 1);
            stack.add(new StackElement(op.operator.evaluate(left.value, right.value)));
        }
    }

    public static class Context {
        private double emptyValue = 0.0;
        private double errorValue = 0.0;
        private double hundredPercent = 100.0;
        private NumberFormat numberFormat = DecimalFormat.getNumberInstance(Locale.US);
        private boolean plainOnly = false;
        private boolean success = false;
        private String errorMessage = "";

        public Context setEmptyValue(double emptyValue) {
            this.emptyValue = emptyValue;
            return this;
        }

        public Context setErrorValue(double errorValue) {
            this.errorValue = errorValue;
            return this;
        }

        public Context setDefaultValue(double defaultValue) {
            this.emptyValue = defaultValue;
            this.errorValue = defaultValue;
            return this;
        }

        public Context setHundredPercent(double hundredPercent) {
            this.hundredPercent = hundredPercent;
            return this;
        }

        public Context setNumberFormat(NumberFormat numberFormat) {
            this.numberFormat = numberFormat;
            return this;
        }

        public Context setPlainOnly(boolean plainOnly) {
            this.plainOnly = plainOnly;
            return this;
        }

        public boolean wasSuccessful() {
            return this.success;
        }

        public String getErrorMessage() {
            return this.errorMessage;
        }
    }

    private static enum Suffix {
        THOUSAND(1000.0),
        MILLION(1000000.0),
        BILLION(1.0E9),
        TRILLION(1.0E12),
        STACK(64.0),
        INGOT(144.0),
        PERCENT(0.0);

        public final double multiplier;

        private Suffix(double multiplier) {
            this.multiplier = multiplier;
        }
    }

    private static enum Operator {
        PLUS('+', 10, (a, b) -> a + b),
        MINUS('-', 10, (a, b) -> a - b),
        MULTIPLY('*', 20, (a, b) -> a * b),
        DIVIDE('/', 20, (a, b) -> a / b),
        UNARY_PLUS('+', 30, (a, b) -> b),
        UNARY_MINUS('-', 30, (a, b) -> -b.doubleValue()),
        POWER('^', 40, (a, b) -> Math.pow(a, b)),
        SCIENTIFIC('e', 50, (a, b) -> a * Math.pow(10.0, b)),
        OPEN_BRACKET('(', 1, (a, b) -> b);

        public final char name;
        public final int priority;
        private final BiFunction<Double, Double, Double> evaluator;

        public double evaluate(double left, double right) {
            return this.evaluator.apply(left, right);
        }

        private Operator(char name, int priority, BiFunction<Double, Double, Double> evaluator) {
            this.name = name;
            this.priority = priority;
            this.evaluator = evaluator;
        }

        public String toString() {
            return String.valueOf(this.name);
        }
    }

    private static class StackElement {
        public Operator operator;
        public double value;
        public boolean isValue;
        public boolean isOperator;

        public StackElement(Operator operator) {
            this.operator = operator;
            this.isValue = false;
            this.isOperator = true;
        }

        public StackElement(double value) {
            this.value = value;
            this.isValue = true;
            this.isOperator = false;
        }

        public String toString() {
            if (this.isValue && this.isOperator) {
                return "Error! Stack element incorrectly set to both value and operator.";
            }
            if (this.isValue) {
                return "Value: " + this.value;
            }
            if (this.isOperator) {
                return "Operator: " + (Object)((Object)this.operator);
            }
            return "Error! Stack element incorrectly set to neither value nor operator.";
        }
    }
}

