/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.alchemicalWizardry.common.items;

import WayofTime.alchemicalWizardry.AlchemicalWizardry;
import WayofTime.alchemicalWizardry.common.entity.projectile.EntityEnergyBazookaMainProjectile;
import WayofTime.alchemicalWizardry.common.items.EnergyItems;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.IIcon;
import net.minecraft.util.StatCollector;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;

public class EnergyBazooka
extends EnergyItems {
    @SideOnly(value=Side.CLIENT)
    private IIcon activeIcon;
    @SideOnly(value=Side.CLIENT)
    private IIcon activeIconTier2;
    @SideOnly(value=Side.CLIENT)
    private IIcon activeIconTier3;
    @SideOnly(value=Side.CLIENT)
    private IIcon passiveIcon;
    private int tier;
    private int damage;

    public EnergyBazooka(int tier) {
        this.func_77625_d(1);
        this.func_77637_a(AlchemicalWizardry.tabBloodMagic);
        this.func_77664_n();
        this.func_77656_e(250);
        this.tier = tier;
        switch (this.tier) {
            case 1: {
                this.setEnergyUsed(AlchemicalWizardry.energyBazookaLPPerShot);
                this.damage = AlchemicalWizardry.energyBazookaDamage;
                break;
            }
            case 2: {
                this.setEnergyUsed(AlchemicalWizardry.energyBazookaSecondTierLPPerShot);
                this.damage = AlchemicalWizardry.energyBazookaSecondTierDamage;
                break;
            }
            case 3: {
                this.setEnergyUsed(AlchemicalWizardry.energyBazookaThirdTierLPPerShot);
                this.damage = AlchemicalWizardry.energyBazookaThirdTierDamage;
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister iconRegister) {
        this.field_77791_bV = iconRegister.func_94245_a("AlchemicalWizardry:EnergyBazooka_activated");
        this.activeIcon = iconRegister.func_94245_a("AlchemicalWizardry:EnergyBazooka_activated");
        this.activeIconTier2 = iconRegister.func_94245_a("AlchemicalWizardry:EnergyBazooka2_activated");
        this.activeIconTier3 = iconRegister.func_94245_a("AlchemicalWizardry:EnergyBazooka3_activated");
        this.passiveIcon = iconRegister.func_94245_a("AlchemicalWizardry:SheathedItem");
    }

    public IIcon getIcon(ItemStack stack, int renderPass, EntityPlayer player, ItemStack usingItem, int useRemaining) {
        NBTTagCompound tag;
        if (stack.func_77978_p() == null) {
            stack.func_77982_d(new NBTTagCompound());
        }
        if ((tag = stack.func_77978_p()).func_74767_n("isActive")) {
            switch (this.tier) {
                case 1: {
                    return this.activeIcon;
                }
                case 2: {
                    return this.activeIconTier2;
                }
                case 3: {
                    return this.activeIconTier3;
                }
            }
            return this.activeIcon;
        }
        return this.passiveIcon;
    }

    public ItemStack func_77659_a(ItemStack par1ItemStack, World par2World, EntityPlayer par3EntityPlayer) {
        int maxDelay = 1;
        int maxDelayAfterActivation = 1;
        switch (this.tier) {
            case 1: {
                maxDelay = AlchemicalWizardry.energyBazookaMaxDelay;
                maxDelayAfterActivation = AlchemicalWizardry.energyBazookaMaxDelayAfterActivation + 1;
                break;
            }
            case 2: {
                maxDelay = AlchemicalWizardry.energyBazookaSecondTierMaxDelay;
                maxDelayAfterActivation = AlchemicalWizardry.energyBazookaSecondTierMaxDelayAfterActivation + 1;
                break;
            }
            case 3: {
                maxDelay = AlchemicalWizardry.energyBazookaThirdTierMaxDelay;
                maxDelayAfterActivation = AlchemicalWizardry.energyBazookaThirdTierMaxDelayAfterActivation + 1;
            }
        }
        if (!EnergyItems.checkAndSetItemOwner(par1ItemStack, par3EntityPlayer) || par3EntityPlayer.func_70093_af()) {
            this.setActivated(par1ItemStack, !this.getActivated(par1ItemStack));
            par1ItemStack.func_77978_p().func_74768_a("worldTimeDelay", (int)(par2World.func_72820_D() - 1L) % maxDelayAfterActivation);
            return par1ItemStack;
        }
        if (!this.getActivated(par1ItemStack)) {
            return par1ItemStack;
        }
        if (this.getDelay(par1ItemStack) > 0) {
            return par1ItemStack;
        }
        if (!par3EntityPlayer.field_71075_bZ.field_75098_d && !EnergyBazooka.syphonBatteries(par1ItemStack, par3EntityPlayer, this.getEnergyUsed())) {
            return par1ItemStack;
        }
        par2World.func_72956_a((Entity)par3EntityPlayer, "random.bow", 0.5f, 0.4f / (field_77697_d.nextFloat() * 0.4f + 0.8f));
        if (!par2World.field_72995_K) {
            par2World.func_72838_d((Entity)new EntityEnergyBazookaMainProjectile(par2World, (EntityLivingBase)par3EntityPlayer, this.damage));
            this.setDelay(par1ItemStack, maxDelay);
        }
        Vec3 vec = par3EntityPlayer.func_70040_Z();
        double wantedVelocity = (double)this.tier * 2.0;
        par3EntityPlayer.field_70159_w = -vec.field_72450_a * wantedVelocity;
        par3EntityPlayer.field_70181_x = -vec.field_72448_b * wantedVelocity;
        par3EntityPlayer.field_70179_y = -vec.field_72449_c * wantedVelocity;
        par2World.func_72908_a((double)((float)par3EntityPlayer.field_70165_t + 0.5f), (double)((float)par3EntityPlayer.field_70163_u + 0.5f), (double)((float)par3EntityPlayer.field_70161_v + 0.5f), "random.fizz", 0.5f, 2.6f + (par2World.field_73012_v.nextFloat() - par2World.field_73012_v.nextFloat()) * 0.8f);
        par3EntityPlayer.field_70143_R = 0.0f;
        return par1ItemStack;
    }

    public void func_77663_a(ItemStack par1ItemStack, World par2World, Entity par3Entity, int par4, boolean par5) {
        if (!(par3Entity instanceof EntityPlayer)) {
            return;
        }
        EntityPlayer par3EntityPlayer = (EntityPlayer)par3Entity;
        if (par1ItemStack.func_77978_p() == null) {
            par1ItemStack.func_77982_d(new NBTTagCompound());
        }
        int delay = this.getDelay(par1ItemStack);
        if (!par2World.field_72995_K && delay > 0) {
            this.setDelay(par1ItemStack, delay - 1);
        }
        int lpPerActivation = 0;
        int maxDelayAfterActivation = 1;
        switch (this.tier) {
            case 1: {
                lpPerActivation = AlchemicalWizardry.energyBazookaLPPerActivation;
                maxDelayAfterActivation = AlchemicalWizardry.energyBazookaMaxDelayAfterActivation + 1;
                break;
            }
            case 2: {
                lpPerActivation = AlchemicalWizardry.energyBazookaSecondTierLPPerActivation;
                maxDelayAfterActivation = AlchemicalWizardry.energyBazookaSecondTierMaxDelayAfterActivation + 1;
                break;
            }
            case 3: {
                lpPerActivation = AlchemicalWizardry.energyBazookaThirdTierLPPerActivation;
                maxDelayAfterActivation = AlchemicalWizardry.energyBazookaThirdTierMaxDelayAfterActivation + 1;
            }
        }
        if (par2World.func_72820_D() % (long)maxDelayAfterActivation == (long)par1ItemStack.func_77978_p().func_74762_e("worldTimeDelay") && par1ItemStack.func_77978_p().func_74767_n("isActive") && !par3EntityPlayer.field_71075_bZ.field_75098_d && !EnergyItems.syphonBatteries(par1ItemStack, par3EntityPlayer, lpPerActivation)) {
            this.setActivated(par1ItemStack, false);
        }
        par1ItemStack.func_77964_b(0);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack par1ItemStack, EntityPlayer par2EntityPlayer, List par3List, boolean par4) {
        par3List.add(StatCollector.func_74838_a((String)"tooltip.energybazooka.desc"));
        par3List.add(StatCollector.func_74838_a((String)"tooltip.alchemy.damage") + " " + this.damage);
        if (par1ItemStack.func_77978_p() != null) {
            if (par1ItemStack.func_77978_p().func_74767_n("isActive")) {
                par3List.add(StatCollector.func_74838_a((String)"tooltip.sigil.state.activated"));
            } else {
                par3List.add(StatCollector.func_74838_a((String)"tooltip.sigil.state.deactivated"));
            }
            if (!par1ItemStack.func_77978_p().func_74779_i("ownerName").equals("")) {
                par3List.add(StatCollector.func_74838_a((String)"tooltip.owner.currentowner") + " " + par1ItemStack.func_77978_p().func_74779_i("ownerName"));
            }
        }
    }

    public void setActivated(ItemStack par1ItemStack, boolean newActivated) {
        if (par1ItemStack.func_77978_p() == null) {
            par1ItemStack.func_77982_d(new NBTTagCompound());
        }
        par1ItemStack.func_77978_p().func_74757_a("isActive", newActivated);
    }

    public boolean getActivated(ItemStack par1ItemStack) {
        if (par1ItemStack.func_77978_p() == null) {
            par1ItemStack.func_77982_d(new NBTTagCompound());
        }
        return par1ItemStack.func_77978_p().func_74767_n("isActive");
    }

    public void setDelay(ItemStack par1ItemStack, int newDelay) {
        if (par1ItemStack.func_77978_p() == null) {
            par1ItemStack.func_77982_d(new NBTTagCompound());
        }
        par1ItemStack.func_77978_p().func_74768_a("delay", newDelay);
    }

    public int getDelay(ItemStack par1ItemStack) {
        if (par1ItemStack.func_77978_p() == null) {
            par1ItemStack.func_77982_d(new NBTTagCompound());
        }
        return par1ItemStack.func_77978_p().func_74762_e("delay");
    }
}

