/*
 * Decompiled with CFR 0.152.
 */
package binnie.genetics.nei;

import binnie.botany.Botany;
import binnie.core.BinnieCore;
import binnie.core.Mods;
import binnie.core.nei.NEIUtils;
import binnie.core.nei.PositionedFluidTank;
import binnie.core.nei.RecipeHandlerBase;
import binnie.genetics.Genetics;
import binnie.genetics.api.IItemSerum;
import binnie.genetics.item.GeneticLiquid;
import codechicken.lib.gui.GuiDraw;
import codechicken.nei.ItemList;
import codechicken.nei.NEIServerUtils;
import codechicken.nei.PositionedStack;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.ISpeciesRoot;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.StatCollector;
import net.minecraftforge.fluids.FluidStack;

public class SplicerRecipeHandler
extends RecipeHandlerBase {
    private static final List<SplicerRecipe> recipes = new ArrayList<SplicerRecipe>();

    private void createInoculatorRecipeForNEI(ItemStack dnaManipulable) {
        recipes.add(new SplicerRecipe(dnaManipulable, new ItemStack(Genetics.itemSerum, 1, Short.MAX_VALUE)));
        recipes.add(new SplicerRecipe(dnaManipulable, new ItemStack((Item)Genetics.itemSerumArray, 1, Short.MAX_VALUE)));
    }

    @Override
    public void prepare() {
        if (BinnieCore.isApicultureActive()) {
            this.createInoculatorRecipeForNEI(Mods.forestry.stack("beeLarvaeGE", 1, Short.MAX_VALUE));
        }
        if (BinnieCore.isArboricultureActive()) {
            this.createInoculatorRecipeForNEI(Mods.forestry.stack("pollenFertile", 1, Short.MAX_VALUE));
        }
        if (BinnieCore.isLepidopteryActive()) {
            this.createInoculatorRecipeForNEI(Mods.forestry.stack("serumGE", 1, Short.MAX_VALUE));
        }
        if (BinnieCore.isBotanyActive()) {
            this.createInoculatorRecipeForNEI(new ItemStack(Botany.pollen, 1, Short.MAX_VALUE));
        }
    }

    public String getOverlayIdentifier() {
        return "genetics.splicer";
    }

    public String getGuiTexture() {
        return "genetics:textures/gui/nei/splicer.png";
    }

    public String getRecipeName() {
        return StatCollector.func_74838_a((String)"genetics.machine.advMachine.splicer");
    }

    public void loadTransferRects() {
        this.addTransferRect(75, 27, 24, 17);
    }

    public void drawBackground(int recipe) {
        this.changeToGuiTexture();
        GuiDraw.drawTexturedModalRect((int)0, (int)0, (int)5, (int)11, (int)166, (int)74);
    }

    public void drawExtras(int recipe) {
        this.drawProgressBar(75, 27, 176, 0, 24, 17, 40, 0);
    }

    @Override
    public void loadAllRecipes() {
        for (SplicerRecipe recipe : recipes) {
            this.arecipes.add(new CachedSplicer(recipe));
        }
    }

    @Override
    public void loadCraftingRecipes(ItemStack result) {
        for (SplicerRecipe recipe : recipes) {
            if (!NEIServerUtils.areStacksSameTypeCrafting((ItemStack)recipe.getDnaManipulable(), (ItemStack)result)) continue;
            this.arecipes.add(new CachedSplicer(recipe));
        }
    }

    @Override
    public void loadUsageRecipes(FluidStack ingredient) {
        if (NEIUtils.areFluidsSameType(GeneticLiquid.BacteriaVector.get(0), ingredient)) {
            this.loadAllRecipes();
        }
    }

    @Override
    public void loadUsageRecipes(ItemStack ingredient) {
        for (SplicerRecipe recipe : recipes) {
            if (!NEIServerUtils.areStacksSameTypeCrafting((ItemStack)recipe.getDnaManipulable(), (ItemStack)ingredient) && !NEIServerUtils.areStacksSameTypeCrafting((ItemStack)recipe.getSerum(), (ItemStack)ingredient)) continue;
            this.arecipes.add(new CachedSplicer(recipe));
        }
    }

    public class CachedSplicer
    extends RecipeHandlerBase.CachedBaseRecipe {
        public PositionedFluidTank bacteriaTank;
        public PositionedStack serum;
        public PositionedStack input;
        public PositionedStack output;
        public List<PositionedStack> ingredients = new ArrayList<PositionedStack>();

        public CachedSplicer(SplicerRecipe recipe) {
            if (recipe.getSerum() != null && recipe.getDnaManipulable() != null) {
                ISpeciesRoot root1 = AlleleManager.alleleRegistry.getSpeciesRoot(recipe.getDnaManipulable());
                ArrayList<ItemStack> serums = new ArrayList<ItemStack>();
                for (ItemStack serumStack : ItemList.itemMap.get((Object)recipe.getSerum().func_77973_b())) {
                    IItemSerum itemSerum;
                    ISpeciesRoot root2;
                    if (serumStack.func_77978_p() == null || root1 != (root2 = (itemSerum = (IItemSerum)serumStack.func_77973_b()).getSpeciesRoot(serumStack))) continue;
                    serums.add(serumStack.func_77946_l());
                }
                this.serum = new PositionedStack(serums, 53, 40);
                this.input = new PositionedStack((Object)recipe.getDnaManipulable(), 53, 14);
                this.output = new PositionedStack((Object)recipe.getDnaManipulable(), 105, 27);
                this.ingredients.add(this.serum);
                this.ingredients.add(this.input);
            }
        }

        public List<PositionedStack> getIngredients() {
            this.input.setPermutationToRender(SplicerRecipeHandler.this.cycleticks / 40 % this.input.items.length);
            this.serum.setPermutationToRender(SplicerRecipeHandler.this.cycleticks / 40 % this.serum.items.length);
            return this.ingredients;
        }

        public PositionedStack getResult() {
            this.output.setPermutationToRender(SplicerRecipeHandler.this.cycleticks / 40 % this.output.items.length);
            return this.output;
        }

        @Override
        public PositionedFluidTank getFluidTank() {
            return this.bacteriaTank;
        }
    }

    private static class SplicerRecipe {
        private final ItemStack dnaManipulable;
        private final ItemStack serum;

        public SplicerRecipe(ItemStack dnaManipulable, ItemStack serum) {
            this.dnaManipulable = dnaManipulable;
            this.serum = serum;
        }

        public ItemStack getDnaManipulable() {
            return this.dnaManipulable;
        }

        public ItemStack getSerum() {
            return this.serum;
        }
    }
}

