/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.gtnhintergalactic.recipe.maps;

import com.gtnewhorizons.gtnhintergalactic.recipe.IG_Recipe;
import com.gtnewhorizons.modularui.api.math.Pos2d;
import gregtech.api.recipe.BasicUIPropertiesBuilder;
import gregtech.api.recipe.NEIRecipePropertiesBuilder;
import gregtech.api.recipe.RecipeMapFrontend;
import gregtech.api.util.GT_Recipe;
import gregtech.api.util.GT_Utility;
import gregtech.api.util.MethodsReturnNonnullByDefault;
import gregtech.common.gui.modularui.UIHelper;
import gregtech.nei.RecipeDisplayInfo;
import gregtech.nei.formatter.INEISpecialInfoFormatter;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class SpaceMiningFrontend
extends RecipeMapFrontend {
    public SpaceMiningFrontend(BasicUIPropertiesBuilder uiPropertiesBuilder, NEIRecipePropertiesBuilder neiPropertiesBuilder) {
        super(uiPropertiesBuilder, neiPropertiesBuilder.neiSpecialInfoFormatter((INEISpecialInfoFormatter)new SpaceMiningSpecialValueFormatter()));
    }

    public List<Pos2d> getItemInputPositions(int itemInputCount) {
        ArrayList<Pos2d> results = new ArrayList<Pos2d>();
        results.add(new Pos2d(143, 15));
        results.addAll(UIHelper.getGridPositions((int)(itemInputCount - 1), (int)10, (int)6, (int)2));
        return results;
    }

    public List<Pos2d> getItemOutputPositions(int itemOutputCount) {
        return UIHelper.getGridPositions((int)itemOutputCount, (int)69, (int)6, (int)4);
    }

    public List<Pos2d> getFluidInputPositions(int fluidInputCount) {
        return UIHelper.getGridPositions((int)fluidInputCount, (int)10, (int)51, (int)fluidInputCount);
    }

    private static class SpaceMiningSpecialValueFormatter
    implements INEISpecialInfoFormatter {
        private SpaceMiningSpecialValueFormatter() {
        }

        public List<String> format(RecipeDisplayInfo recipeInfo) {
            ArrayList<String> result = new ArrayList<String>();
            result.add(GCCoreUtil.translateWithFormat((String)"ig.nei.module", (Object[])new Object[]{recipeInfo.recipe.mSpecialValue}));
            GT_Recipe gT_Recipe = recipeInfo.recipe;
            if (gT_Recipe instanceof IG_Recipe.IG_SpaceMiningRecipe) {
                IG_Recipe.IG_SpaceMiningRecipe miningRecipe = (IG_Recipe.IG_SpaceMiningRecipe)gT_Recipe;
                result.add(GCCoreUtil.translate((String)"ig.nei.spacemining.distance") + " " + miningRecipe.minDistance + "-" + miningRecipe.maxDistance);
                result.add(GCCoreUtil.translate((String)"ig.nei.spacemining.size") + " " + miningRecipe.minSize + "-" + miningRecipe.maxSize);
                result.add(GCCoreUtil.translateWithFormat((String)"tt.nei.research.min_computation", (Object[])new Object[]{GT_Utility.formatNumbers((long)miningRecipe.computation)}));
                result.add(GCCoreUtil.translate((String)"ig.nei.spacemining.weight") + " " + miningRecipe.recipeWeight);
            }
            return result;
        }
    }
}

