/*
 * Decompiled with CFR 0.152.
 */
package blockrenderer6343.client.utils;

import blockrenderer6343.BlockRenderer6343;
import net.minecraft.util.StatCollector;

public enum GuiText {
    Tier,
    Layer,
    FontColor(0x333333),
    BgColor(0xC6C6C6),
    ButtonEnabledColor(0x202020),
    ButtonDisabledColor(0xA0A0A0),
    ButtonHoveredColor(0xFFFFA0);

    private final String root;
    private final int color;

    private GuiText() {
        this.root = "gui.blockrenderer6343";
        this.color = 0;
    }

    private GuiText(int hex) {
        this.root = "gui.blockrenderer6343";
        this.color = hex;
    }

    public int getColor() {
        String hex = StatCollector.func_74838_a((String)this.getUnlocalized());
        int color = this.color;
        if (hex.length() <= 6) {
            try {
                color = Integer.parseUnsignedInt(hex, 16);
            }
            catch (NumberFormatException e) {
                BlockRenderer6343.warn("Couldn't format color correctly for: " + this.root + " -> " + hex);
            }
        }
        return color;
    }

    public String getLocal() {
        return StatCollector.func_74838_a((String)this.getUnlocalized());
    }

    public String getUnlocalized() {
        return this.root + '.' + this.toString();
    }
}

