/*
 * Decompiled with CFR 0.152.
 */
package remoteio.client.render;

public class TessellatorCapture {
    private static boolean capture = false;
    public static double rotationAngle = 0.0;
    public static double offsetX = 0.0;
    public static double offsetZ = 0.0;
    private static final ThreadLocal<double[]> rotationPoint = ThreadLocal.withInitial(() -> new double[3]);
    private static final ThreadLocal<double[]> rotationPointOffset = ThreadLocal.withInitial(() -> new double[3]);

    public static void startCapturing() {
        TessellatorCapture.reset();
        capture = true;
    }

    public static void reset() {
        capture = false;
        rotationAngle = 0.0;
        offsetX = 0.0;
        offsetZ = 0.0;
    }

    public static double[] rotatePoint(double x, double y, double z) {
        if (capture) {
            double radians = Math.toRadians(rotationAngle);
            double sin = Math.sin(radians);
            double cos = Math.cos(radians);
            double nx = x * cos - z * sin;
            double nz = x * sin + z * cos;
            x = nx;
            z = nz;
        }
        double[] doubles = rotationPoint.get();
        doubles[0] = x;
        doubles[1] = y;
        doubles[2] = z;
        return doubles;
    }

    public static double[] rotatePointWithOffset(double x, double y, double z) {
        return TessellatorCapture.rotatePointWithOffset(x, y, z, offsetX, 0.0, offsetZ);
    }

    public static double[] rotatePointWithOffset(double x, double y, double z, double offsetX, double offsetY, double offsetZ) {
        if (capture) {
            double radians = Math.toRadians(rotationAngle);
            double sin = Math.sin(radians);
            double cos = Math.cos(radians);
            x += offsetX;
            z += offsetZ;
            double nx = (x += 0.5) * cos - (z += 0.5) * sin;
            double nz = x * sin + z * cos;
            x = nx;
            z = nz;
            x -= offsetX;
            z -= offsetZ;
            x -= 0.5;
            z -= 0.5;
        }
        double[] doubles = rotationPointOffset.get();
        doubles[0] = x;
        doubles[1] = y;
        doubles[2] = z;
        return doubles;
    }
}

