/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.hypercube;

import crazypants.enderio.machine.hypercube.Channel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ClientChannelRegister {
    static final ClientChannelRegister instance = new ClientChannelRegister();
    private final List<Channel> publicChannels = new ArrayList<Channel>();
    private final List<Channel> publicChannelsRO = Collections.unmodifiableList(this.publicChannels);
    private final List<Channel> privateChannels = new ArrayList<Channel>();
    private final List<Channel> privateChannelsRO = Collections.unmodifiableList(this.privateChannels);

    void setPublicChannels(List<Channel> channels) {
        this.publicChannels.clear();
        this.publicChannels.addAll(channels);
    }

    void setPrivateChannels(List<Channel> channels) {
        this.privateChannels.clear();
        this.privateChannels.addAll(channels);
    }

    public List<Channel> getPublicChannels() {
        return this.publicChannelsRO;
    }

    public List<Channel> getPrivateChannels() {
        return this.privateChannelsRO;
    }

    void addChannel(Channel channel) {
        if (channel == null) {
            return;
        }
        if (channel.isPublic()) {
            if (!this.publicChannels.contains(channel)) {
                this.publicChannels.add(channel);
            }
        } else if (!this.privateChannels.contains(channel)) {
            this.privateChannels.add(channel);
        }
    }

    public void channelAdded(Channel channel) {
        if (channel.isPublic() && !this.publicChannels.contains(channel)) {
            this.publicChannels.add(channel);
        }
    }

    public void reset() {
        this.publicChannels.clear();
        this.privateChannels.clear();
    }

    public void channelRemoved(Channel c) {
        if (c.isPublic()) {
            this.publicChannels.remove(c);
        } else {
            this.privateChannels.remove(c);
        }
    }
}

