/*
 * Decompiled with CFR 0.152.
 */
package com.dreammaster.recipes;

import gregtech.api.util.GT_Utility;
import java.util.HashMap;
import java.util.function.Function;
import net.minecraft.block.Block;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentData;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemEnchantedBook;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTException;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public interface CustomItem {
    public boolean matches(ItemStack var1);

    public ItemStack getStack();

    public static CustomItem createCustomItem(final Function<ItemStack, Boolean> matcher, final ItemStack stack) {
        return new CustomItem(){

            @Override
            public boolean matches(ItemStack stack2) {
                return (Boolean)matcher.apply(stack2);
            }

            @Override
            public ItemStack getStack() {
                return stack;
            }
        };
    }

    public static class EnchantedBookMatcher
    implements CustomItem {
        final ItemStack book = new ItemStack((Item)Items.field_151134_bR);
        final HashMap<Short, Short> enchantments = new HashMap();

        public EnchantedBookMatcher addEnchantment(EnchantmentData enchantment) {
            short id = (short)enchantment.field_76302_b.field_77352_x;
            if (this.enchantments.get(id) != null && this.enchantments.get(id) >= enchantment.field_76303_c) {
                return this;
            }
            Items.field_151134_bR.func_92115_a(this.book, enchantment);
            this.enchantments.put(id, (short)enchantment.field_76303_c);
            return this;
        }

        public EnchantedBookMatcher addEnchantment(Enchantment enchantment, int lvl) {
            return this.addEnchantment(new EnchantmentData(enchantment, lvl));
        }

        public EnchantedBookMatcher addEnchantment(int enchantment, int lvl) {
            return this.addEnchantment(new EnchantmentData(enchantment, lvl));
        }

        @Override
        public boolean matches(ItemStack stack) {
            if (stack == null) {
                return false;
            }
            if (!(stack.func_77973_b() instanceof ItemEnchantedBook)) {
                return false;
            }
            HashMap toFind = (HashMap)this.enchantments.clone();
            NBTTagList stackEnchantments = Items.field_151134_bR.func_92110_g(stack);
            for (int i = 0; i < stackEnchantments.func_74745_c(); ++i) {
                NBTTagCompound tag = stackEnchantments.func_150305_b(i);
                short id = tag.func_74765_d("id");
                short lvl = tag.func_74765_d("lvl");
                Short found = (Short)toFind.get(id);
                if (found == null || lvl < found) continue;
                toFind.remove(id);
            }
            return toFind.isEmpty();
        }

        @Override
        public ItemStack getStack() {
            return this.book;
        }
    }

    public static class NBTItem
    implements CustomItem {
        private ItemStack stack;
        private NBTTagCompound nbt;
        private boolean exact = false;
        private boolean noValues = false;

        public NBTItem() {
        }

        public NBTItem(ItemStack stack) {
            this.item(stack);
        }

        @Override
        public boolean matches(ItemStack stack) {
            if (!GT_Utility.areStacksEqual((ItemStack)this.stack, (ItemStack)stack, (boolean)true)) {
                return false;
            }
            if (this.nbt == null && stack.field_77990_d != null) {
                return !this.exact;
            }
            if (this.nbt == null) {
                return true;
            }
            if (this.exact) {
                return this.nbt.equals((Object)stack.field_77990_d);
            }
            if (this.nbt.func_82582_d()) {
                return true;
            }
            if (stack.field_77990_d == null) {
                return false;
            }
            for (String key : this.nbt.func_150296_c()) {
                NBTBase v;
                if (!stack.field_77990_d.func_150297_b(key, (int)(v = this.nbt.func_74781_a(key)).func_74732_a())) {
                    return false;
                }
                if (this.noValues || stack.field_77990_d.func_74781_a(key).equals((Object)v)) continue;
                return false;
            }
            return true;
        }

        public NBTItem item(ItemStack stack) {
            this.stack = stack;
            if (this.stack.field_77990_d != null) {
                this.nbt = this.stack.field_77990_d;
                this.stack.field_77990_d = null;
            }
            return this;
        }

        public NBTItem item(Item item) {
            this.stack = new ItemStack(item);
            return this;
        }

        public NBTItem item(Block block) {
            this.stack = new ItemStack(block);
            return this;
        }

        public NBTItem setNBT(NBTTagCompound nbt) {
            this.nbt = nbt;
            return this;
        }

        public NBTItem setNBT(String nbt) {
            try {
                this.nbt = (NBTTagCompound)JsonToNBT.func_150315_a((String)nbt);
            }
            catch (NBTException e) {
                throw new RuntimeException(e);
            }
            return this;
        }

        public NBTItem addNBT(String tagName, NBTBase nbt) {
            if (this.nbt == null) {
                this.nbt = new NBTTagCompound();
            }
            this.nbt.func_74782_a(tagName, nbt);
            return this;
        }

        public NBTItem matchExact() {
            this.exact = true;
            return this;
        }

        public NBTItem noValues() {
            this.noValues = true;
            return this;
        }

        @Override
        public ItemStack getStack() {
            ItemStack stack = this.stack.func_77946_l();
            if (this.nbt != null && !this.nbt.func_82582_d()) {
                stack.field_77990_d = (NBTTagCompound)this.nbt.func_74737_b();
            }
            return stack;
        }
    }
}

