/*
 * Decompiled with CFR 0.152.
 */
package com.sinthoras.visualprospecting.integration.xaeroworldmap.rendersteps;

import com.sinthoras.visualprospecting.integration.DrawUtils;
import com.sinthoras.visualprospecting.integration.model.locations.UndergroundFluidLocation;
import com.sinthoras.visualprospecting.integration.xaeroworldmap.rendersteps.RenderStep;
import javax.annotation.Nullable;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;
import org.lwjgl.opengl.GL11;

public class UndergroundFluidRenderStep
implements RenderStep {
    private final UndergroundFluidLocation undergroundFluidLocation;

    public UndergroundFluidRenderStep(UndergroundFluidLocation undergroundFluid) {
        this.undergroundFluidLocation = undergroundFluid;
    }

    @Override
    public void draw(@Nullable GuiScreen gui, double cameraX, double cameraZ, double scale) {
        int maxAmountInField = this.undergroundFluidLocation.getMaxProduction();
        if (scale >= 0.5) {
            GL11.glPushMatrix();
            GL11.glTranslated((double)(this.undergroundFluidLocation.getBlockX() - 0.5 - cameraX), (double)(this.undergroundFluidLocation.getBlockZ() - 0.5 - cameraZ), (double)0.0);
            int borderColor = this.undergroundFluidLocation.getFluid().getColor() | 0xCC000000;
            double lenX = 128.0;
            double lenZ = 128.0;
            DrawUtils.drawGradientRect(0.0, 0.0, 128.0, 2.0, 0.0, borderColor, borderColor);
            DrawUtils.drawGradientRect(128.0, 0.0, 130.0, 128.0, 0.0, borderColor, borderColor);
            DrawUtils.drawGradientRect(2.0, 128.0, 130.0, 130.0, 0.0, borderColor, borderColor);
            DrawUtils.drawGradientRect(0.0, 2.0, 2.0, 130.0, 0.0, borderColor, borderColor);
            if (scale >= 1.0 && gui != null) {
                GL11.glScaled((double)(1.0 / scale), (double)(1.0 / scale), (double)1.0);
                String label = I18n.func_135052_a((String)"visualprospecting.empty", (Object[])new Object[0]);
                if (maxAmountInField > 0) {
                    label = this.undergroundFluidLocation.getMinProduction() + "L - " + maxAmountInField + "L  " + this.undergroundFluidLocation.getFluid().getLocalizedName();
                }
                DrawUtils.drawSimpleLabel(gui, label, 16.0 * scale, 0.0, -1, -1275068416, false);
            }
            GL11.glPopMatrix();
        }
    }
}

