/*
 * Decompiled with CFR 0.152.
 */
package gcewing.architecture;

import gcewing.architecture.BaseBlockUtils;
import gcewing.architecture.BaseModClient;
import gcewing.architecture.BaseTexture;
import gcewing.architecture.BlockPos;
import gcewing.architecture.EnumWorldBlockLayer;
import gcewing.architecture.IBlockState;
import gcewing.architecture.ShapeTE;
import gcewing.architecture.Trans3;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;

public class ShapeRenderDispatch
implements BaseModClient.ICustomRenderer {
    @Override
    public void renderBlock(IBlockAccess world, BlockPos pos, IBlockState state, BaseModClient.IRenderTarget target, EnumWorldBlockLayer layer, Trans3 t) {
        ShapeTE te = ShapeTE.get(world, pos);
        if (te != null) {
            Trans3 t2 = t.t(te.localToGlobalRotation());
            boolean renderBase = te.baseBlockState != null && BaseBlockUtils.blockCanRenderInLayer(te.baseBlockState.getBlock(), layer);
            boolean renderSecondary = te.secondaryBlockState != null && BaseBlockUtils.blockCanRenderInLayer(te.secondaryBlockState.getBlock(), layer);
            this.renderShapeTE(te, target, t2, renderBase, renderSecondary);
        }
    }

    @Override
    public void renderItemStack(ItemStack stack, BaseModClient.IRenderTarget target, Trans3 t) {
        ShapeTE te = new ShapeTE();
        te.readFromItemStack(stack);
        this.renderShapeTE(te, target, t.t(Trans3.sideTurn(0, 3)), te.baseBlockState != null, te.secondaryBlockState != null);
    }

    protected void renderShapeTE(ShapeTE te, BaseModClient.IRenderTarget target, Trans3 t, boolean renderBase, boolean renderSecondary) {
        IBlockState base;
        if (te.shape != null && (renderBase || renderSecondary) && (base = te.baseBlockState) != null) {
            IIcon icon = BaseBlockUtils.getSpriteForBlockState(base);
            IIcon icon2 = BaseBlockUtils.getSpriteForBlockState(te.secondaryBlockState);
            if (icon != null) {
                BaseModClient.ITexture[] textures = new BaseModClient.ITexture[4];
                if (renderBase) {
                    textures[0] = BaseTexture.fromSprite(icon);
                    textures[1] = textures[0].projected();
                }
                if (renderSecondary) {
                    if (icon2 != null) {
                        textures[2] = BaseTexture.fromSprite(icon2);
                        textures[3] = textures[2].projected();
                    } else {
                        renderSecondary = false;
                    }
                }
                if (renderBase && te.shape.kind.secondaryDefaultsToBase() && (icon2 == null || te.secondaryBlockState != null && te.secondaryBlockState.getBlock().func_149701_w() != 0)) {
                    textures[2] = textures[0];
                    textures[3] = textures[1];
                    renderSecondary = renderBase;
                }
                te.shape.kind.renderShape(te, textures, target, t, renderBase, renderSecondary);
            }
        }
    }
}

