/*
 * Decompiled with CFR 0.152.
 */
package com.github.bartimaeusnek.cropspp.items;

import com.github.bartimaeusnek.cropspp.ConfigValues;
import com.github.bartimaeusnek.cropspp.items.CreativeTab;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2.core.crop.TileEntityCrop;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidContainerItem;

public class ItemBppWateringCan
extends Item
implements IFluidContainerItem {
    private int content = 0;
    private boolean nutrient = false;

    public ItemBppWateringCan() {
        this.func_77655_b("WateringCan");
        this.func_77625_d(1);
        this.func_77637_a(CreativeTab.cpp);
        this.func_111206_d("bpp:itemWateringCan");
        this.func_77656_e(0);
    }

    public void writeToNBT(ItemStack stack) {
        if (stack == null) {
            return;
        }
        if (stack.func_77978_p() == null) {
            stack.func_77982_d(new NBTTagCompound());
        }
        this.writeToNBT(stack.func_77978_p());
    }

    public void writeToNBT(NBTTagCompound tag) {
        NBTTagCompound subtag = new NBTTagCompound();
        subtag.func_74768_a("content", this.content);
        subtag.func_74757_a("nutrient", this.nutrient);
        tag.func_74782_a("Stats", (NBTBase)subtag);
    }

    public void readFromToNBT(ItemStack stack) {
        if (stack == null || stack.func_77978_p() == null) {
            return;
        }
        this.readFromToNBT(stack.func_77978_p());
    }

    public void readFromToNBT(NBTTagCompound tag) {
        if (tag == null) {
            return;
        }
        NBTTagCompound subtag = tag.func_74775_l("Stats");
        this.content = subtag.func_74762_e("content");
        this.nutrient = subtag.func_74767_n("nutrient");
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean par4) {
        list.add("Max Capacity:");
        list.add(Integer.toString(this.getCapacity(null)));
        list.add("Contains:");
        list.add(Integer.toString(this.content));
        list.add("IsNutrient:");
        list.add(String.valueOf(this.nutrient));
    }

    public boolean onItemUseFirst(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        if (world.field_72995_K) {
            return false;
        }
        this.readFromToNBT(stack);
        if (this.content < 144) {
            return false;
        }
        TileEntity te = world.func_147438_o(x, y, z);
        if (!(te instanceof TileEntityCrop)) {
            return false;
        }
        TileEntityCrop crop = (TileEntityCrop)te;
        if (crop.getCrop() == null) {
            return false;
        }
        if (ConfigValues.debug && crop.getSize() < crop.getCrop().maxSize()) {
            ++crop.size;
        }
        if (this.nutrient) {
            crop.applyFertilizer(true);
        }
        crop.waterStorage += 144;
        this.content -= 144;
        crop.updateState();
        this.writeToNBT(stack);
        return true;
    }

    public FluidStack getFluid(ItemStack container) {
        if (this.content == 0) {
            return null;
        }
        if (this.nutrient) {
            return FluidRegistry.getFluidStack((String)"fluid.fertiliser", (int)this.content);
        }
        return new FluidStack(FluidRegistry.WATER, this.content);
    }

    public int getCapacity(ItemStack container) {
        return 1440;
    }

    public int fill(ItemStack stack, FluidStack resource, boolean doFill) {
        if (resource == null || resource.getFluid() == null) {
            return 0;
        }
        if (this.nutrient && this.content != 0) {
            return 0;
        }
        if (resource.getFluid().equals(FluidRegistry.WATER) || resource.getFluid().equals(FluidRegistry.getFluidStack((String)"fluid.fertiliser", (int)this.content).getFluid())) {
            boolean fert = FluidRegistry.getFluidStack((String)"fluid.fertiliser", (int)this.content) != null && resource.getFluid().equals(FluidRegistry.getFluidStack((String)"fluid.fertiliser", (int)this.content).getFluid());
            int toFill = Math.min(resource.amount, this.getCapacity(null) - this.content);
            if (doFill) {
                this.nutrient = fert;
                this.content = toFill;
                this.writeToNBT(stack);
            }
            return toFill;
        }
        return 0;
    }

    public FluidStack drain(ItemStack container, int maxDrain, boolean doDrain) {
        return null;
    }
}

