/*
 * Decompiled with CFR 0.152.
 */
package com.github.bartimaeusnek.cropspp.crops.TC;

import com.github.bartimaeusnek.croploadcore.BlockGetterTC;
import com.github.bartimaeusnek.cropspp.ConfigValues;
import com.github.bartimaeusnek.cropspp.abstracts.BasicThaumcraftCrop;
import ic2.api.crops.CropCard;
import ic2.api.crops.Crops;
import ic2.api.crops.ICropTile;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.world.World;
import thaumcraft.api.ItemApi;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.common.items.ItemManaBean;

public class BasicManaBeanCrop
extends BasicThaumcraftCrop {
    private static ItemStack manaBean = null;
    private static ArrayList<Aspect> aspects = null;
    private static Block blockCrystal = null;

    public BasicManaBeanCrop() {
        Crops.instance.registerBaseSeed(ItemApi.getItem((String)"itemManaBean", (int)0), (CropCard)this, 1, 1, 1, 1);
    }

    public String name() {
        return "Mana Bean";
    }

    @Override
    public String discoveredBy() {
        return "kuba6000";
    }

    public String[] attributes() {
        return new String[]{"Berry", "Bean", "Magic", "Colorful"};
    }

    @Override
    public int stat(int n) {
        switch (n) {
            case 0: {
                return 0;
            }
            case 1: {
                return 4;
            }
            case 2: {
                return 0;
            }
            case 3: {
                return 4;
            }
            case 4: {
                return 0;
            }
        }
        return 0;
    }

    public int weightInfluences(ICropTile crop, float humidity, float nutrients, float air) {
        return (int)((double)humidity / 1.3 + (double)nutrients + (double)air / 0.7);
    }

    @Override
    public boolean canGrow(ICropTile crop) {
        if (crop.getSize() >= this.maxSize()) {
            return false;
        }
        if (blockCrystal == null && (blockCrystal = BlockGetterTC.getBlock_asBlock((String)"blockCrystal", (int)0)) == null) {
            return false;
        }
        if (crop.getSize() > 1) {
            return crop.isBlockBelow(blockCrystal);
        }
        return true;
    }

    @Override
    public int growthDuration(ICropTile crop) {
        if (ConfigValues.debug) {
            return 1;
        }
        return crop.getSize() >= this.maxSize() - 1 ? 1200 : 800;
    }

    public ItemStack getGain(ICropTile crop) {
        ItemStack bean = this.getDisplayItem().func_77946_l();
        if (blockCrystal == null && (blockCrystal = BlockGetterTC.getBlock_asBlock((String)"blockCrystal", (int)0)) == null) {
            return null;
        }
        World w = crop.getWorld();
        ChunkCoordinates location = crop.getLocation();
        int option = 0;
        for (int i = 1; i < this.getrootslength(crop) && !w.func_147437_c(location.field_71574_a, location.field_71572_b - i, location.field_71573_c); ++i) {
            Block b = w.func_147439_a(location.field_71574_a, location.field_71572_b - i, location.field_71573_c);
            if (b != blockCrystal) continue;
            option = w.func_72805_g(location.field_71574_a, location.field_71572_b - i, location.field_71573_c);
            break;
        }
        ((ItemManaBean)bean.func_77973_b()).setAspects(bean, new AspectList().add(aspects.get(option > 5 ? w.field_73012_v.nextInt(aspects.size()) : option), 1));
        return bean;
    }

    @Override
    public List<String> getCropInformation() {
        return Arrays.asList("Needs a Crystal Cluster below to fully mature.", "Has increased humidity requirements (x1.3)", "Has decreased air requirements (x0.7)");
    }

    @Override
    public ItemStack getDisplayItem() {
        if (manaBean == null) {
            aspects = new ArrayList(5);
            aspects.add(Aspect.AIR);
            aspects.add(Aspect.FIRE);
            aspects.add(Aspect.WATER);
            aspects.add(Aspect.EARTH);
            aspects.add(Aspect.ORDER);
            aspects.add(Aspect.ENTROPY);
            manaBean = ItemApi.getItem((String)"itemManaBean", (int)0);
        }
        return manaBean;
    }
}

