/*
 * Decompiled with CFR 0.152.
 */
package com.github.bartimaeusnek.cropspp.GTHandler.machines;

import com.github.bartimaeusnek.cropspp.GTHandler.CPP_UITextures;
import com.gtnewhorizons.modularui.api.drawable.FallbackableUITexture;
import com.gtnewhorizons.modularui.api.drawable.IDrawable;
import com.gtnewhorizons.modularui.api.drawable.UITexture;
import com.gtnewhorizons.modularui.api.math.Pos2d;
import com.gtnewhorizons.modularui.common.widget.SlotWidget;
import gregtech.api.enums.GT_Values;
import gregtech.api.enums.ItemList;
import gregtech.api.enums.SoundResource;
import gregtech.api.enums.Textures;
import gregtech.api.gui.modularui.GT_UITextures;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_BasicMachine;
import gregtech.api.recipe.BasicUIProperties;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GT_Utility;
import gregtech.common.items.behaviors.Behaviour_DataOrb;
import ic2.api.crops.CropCard;
import ic2.api.crops.Crops;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;

public class CropGeneExtractor
extends GT_MetaTileEntity_BasicMachine {
    private static final FallbackableUITexture progressBarTexture = GT_UITextures.fallbackableProgressbar((String)"crop_gene_extractor", (UITexture)GT_UITextures.PROGRESSBAR_ARROW);

    public CropGeneExtractor(int aID, String aName, String aNameRegional, int aTier) {
        super(aID, aName, aNameRegional, aTier, 1, new String[]{"It can extract CropGenes", "Use a circuit to determine the genes you want to extract,", "1 for Specimen, 2 for Growth, 3 for Gain, 4 for Resistance", "Takes in 1A", "Needs crop's (tier+2)/2 as Voltage level, round down (Tier 5 crop needs 7/2=~3=HV)", "Can process crops up to tier " + CropGeneExtractor.getMaxCropTier(aTier)}, 1, 1, new ITexture[]{TextureFactory.of((ITexture[])new ITexture[]{TextureFactory.of((IIconContainer)Textures.BlockIcons.OVERLAY_SIDE_SCANNER_ACTIVE), TextureFactory.builder().addIcon(new IIconContainer[]{Textures.BlockIcons.OVERLAY_SIDE_SCANNER_ACTIVE_GLOW}).glow().build()}), TextureFactory.of((ITexture[])new ITexture[]{TextureFactory.of((IIconContainer)Textures.BlockIcons.OVERLAY_SIDE_SCANNER), TextureFactory.builder().addIcon(new IIconContainer[]{Textures.BlockIcons.OVERLAY_SIDE_SCANNER_GLOW}).glow().build()}), TextureFactory.of((ITexture[])new ITexture[]{TextureFactory.of((IIconContainer)Textures.BlockIcons.OVERLAY_FRONT_SCANNER_ACTIVE), TextureFactory.builder().addIcon(new IIconContainer[]{Textures.BlockIcons.OVERLAY_FRONT_SCANNER_ACTIVE_GLOW}).glow().build()}), TextureFactory.of((ITexture[])new ITexture[]{TextureFactory.of((IIconContainer)Textures.BlockIcons.OVERLAY_FRONT_SCANNER), TextureFactory.builder().addIcon(new IIconContainer[]{Textures.BlockIcons.OVERLAY_FRONT_SCANNER_GLOW}).glow().build()}), TextureFactory.of((ITexture[])new ITexture[]{TextureFactory.of((IIconContainer)Textures.BlockIcons.OVERLAY_TOP_SCANNER_ACTIVE), TextureFactory.builder().addIcon(new IIconContainer[]{Textures.BlockIcons.OVERLAY_TOP_SCANNER_ACTIVE_GLOW}).glow().build()}), TextureFactory.of((ITexture[])new ITexture[]{TextureFactory.of((IIconContainer)Textures.BlockIcons.OVERLAY_TOP_SCANNER), TextureFactory.builder().addIcon(new IIconContainer[]{Textures.BlockIcons.OVERLAY_TOP_SCANNER_GLOW}).glow().build()}), TextureFactory.of((ITexture[])new ITexture[]{TextureFactory.of((IIconContainer)Textures.BlockIcons.OVERLAY_BOTTOM_SCANNER_ACTIVE), TextureFactory.builder().addIcon(new IIconContainer[]{Textures.BlockIcons.OVERLAY_BOTTOM_SCANNER_ACTIVE_GLOW}).glow().build()}), TextureFactory.of((ITexture[])new ITexture[]{TextureFactory.of((IIconContainer)Textures.BlockIcons.OVERLAY_BOTTOM_SCANNER), TextureFactory.builder().addIcon(new IIconContainer[]{Textures.BlockIcons.OVERLAY_BOTTOM_SCANNER_GLOW}).glow().build()})});
    }

    public CropGeneExtractor(String mName, byte mTier, String[] mDescriptionArray, ITexture[][][] mTextures) {
        super(mName, (int)mTier, 1, mDescriptionArray, mTextures, 1, 1);
    }

    public IMetaTileEntity newMetaEntity(IGregTechTileEntity arg0) {
        return new CropGeneExtractor(this.mName, this.mTier, this.mDescriptionArray, this.mTextures);
    }

    public static int getMaxCropTier(int mTier) {
        return mTier * 2 - 1;
    }

    public int checkRecipe(boolean skipOC) {
        ItemStack aStack = this.getInputAt(0);
        ItemStack bStack = this.func_70301_a(this.getCircuitSlot());
        ItemStack tosave = this.getSpecialSlot();
        if (ItemList.IC2_Crop_Seeds.isStackEqual((Object)aStack, true, true) && ItemList.Tool_DataOrb.isStackEqual((Object)tosave, false, true) && bStack != null) {
            NBTTagCompound tNBT = aStack.func_77978_p();
            if (tNBT == null || tNBT.func_74779_i("name").isEmpty()) {
                return 0;
            }
            if (this.getOutputAt(0) != null) {
                return 0;
            }
            CropCard card = Crops.instance.getCropCard(tNBT.func_74779_i("owner"), tNBT.func_74779_i("name"));
            if (card.tier() > CropGeneExtractor.getMaxCropTier(this.mTier)) {
                return 0;
            }
            if (bStack.func_77960_j() < 1 || bStack.func_77960_j() > 4) {
                return 0;
            }
            byte[] GrGaRe = new byte[]{tNBT.func_74771_c("growth"), tNBT.func_74771_c("gain"), tNBT.func_74771_c("resistance")};
            this.mOutputItems[0] = ItemList.Tool_DataOrb.get(1L, new Object[0]);
            --aStack.field_77994_a;
            --tosave.field_77994_a;
            switch (bStack.func_77960_j()) {
                case 1: {
                    Behaviour_DataOrb.setDataTitle((ItemStack)this.mOutputItems[0], (String)"Crop-Specimen-Scan");
                    Behaviour_DataOrb.setDataName((ItemStack)this.mOutputItems[0], (String)(tNBT.func_74779_i("owner") + ":" + tNBT.func_74779_i("name")));
                    break;
                }
                case 2: {
                    Behaviour_DataOrb.setDataTitle((ItemStack)this.mOutputItems[0], (String)"Crop-Growth-Scan");
                    Behaviour_DataOrb.setDataName((ItemStack)this.mOutputItems[0], (String)Byte.toString(GrGaRe[0]));
                    break;
                }
                case 3: {
                    Behaviour_DataOrb.setDataTitle((ItemStack)this.mOutputItems[0], (String)"Crop-Gain-Scan");
                    Behaviour_DataOrb.setDataName((ItemStack)this.mOutputItems[0], (String)Byte.toString(GrGaRe[1]));
                    break;
                }
                case 4: {
                    Behaviour_DataOrb.setDataTitle((ItemStack)this.mOutputItems[0], (String)"Crop-Resistance-Scan");
                    Behaviour_DataOrb.setDataName((ItemStack)this.mOutputItems[0], (String)Byte.toString(GrGaRe[2]));
                    break;
                }
            }
            long power = GT_Values.V[(card.tier() + 2) / 2];
            this.calculateOverclockedNess((int)(power - power / 10L), 6000);
            if (this.mMaxProgresstime == 0x7FFFFFFE && this.mEUt == 0x7FFFFFFE) {
                return 1;
            }
            return 2;
        }
        return 0;
    }

    public void startSoundLoop(byte aIndex, double aX, double aY, double aZ) {
        super.startSoundLoop(aIndex, aX, aY, aZ);
        if (aIndex == 1) {
            GT_Utility.doSoundAtClient((SoundResource)SoundResource.IC2_MACHINES_MAGNETIZER_LOOP, (int)10, (float)1.0f, (double)aX, (double)aY, (double)aZ);
        }
    }

    public void startProcess() {
        this.sendLoopStart((byte)1);
    }

    public boolean func_102007_a(int aIndex, ItemStack aStack, int ordinalSide) {
        if (ItemList.IC2_Crop_Seeds.isStackEqual((Object)aStack, true, true)) {
            return this.isValidSlot(aIndex) && aStack != null && aIndex < this.mInventory.length && (this.mInventory[aIndex] == null || GT_Utility.areStacksEqual((ItemStack)aStack, (ItemStack)this.mInventory[aIndex])) && this.allowPutStack(this.getBaseMetaTileEntity(), aIndex, ForgeDirection.getOrientation((int)ordinalSide), aStack);
        }
        return false;
    }

    public boolean useModularUI() {
        return true;
    }

    public boolean allowSelectCircuit() {
        return true;
    }

    protected BasicUIProperties getUIProperties() {
        return super.getUIProperties().toBuilder().progressBarTexture(progressBarTexture).build();
    }

    protected SlotWidget createItemInputSlot(int index, IDrawable[] backgrounds, Pos2d pos) {
        return (SlotWidget)super.createItemInputSlot(index, backgrounds, pos).setBackground(new IDrawable[]{this.getGUITextureSet().getItemSlot(), CPP_UITextures.OVERLAY_SLOT_SEED});
    }

    protected SlotWidget createSpecialSlot(IDrawable[] backgrounds, Pos2d pos, BasicUIProperties uiProperties) {
        return (SlotWidget)super.createSpecialSlot(backgrounds, pos, uiProperties).setGTTooltip(() -> this.mTooltipCache.getData("bpp.machines.special_slot.tooltip", new Object[0])).setBackground(new IDrawable[]{this.getGUITextureSet().getItemSlot(), GT_UITextures.OVERLAY_SLOT_DATA_ORB});
    }
}

