/*
 * Decompiled with CFR 0.152.
 */
package galaxyspace.core.item.electric;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import cpw.mods.fml.common.Optional;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import galaxyspace.GalaxySpace;
import ic2.api.item.IElectricItemManager;
import ic2.api.item.ISpecialElectricItem;
import java.util.List;
import mekanism.api.energy.IEnergizedItem;
import micdoodle8.mods.galacticraft.api.item.ElectricItemHelper;
import micdoodle8.mods.galacticraft.api.item.IItemElectric;
import micdoodle8.mods.galacticraft.core.energy.EnergyConfigHandler;
import micdoodle8.mods.galacticraft.core.energy.EnergyDisplayHelper;
import micdoodle8.mods.galacticraft.core.energy.item.ElectricItemManagerIC2_1710;
import micdoodle8.mods.galacticraft.core.items.ItemBatteryInfinite;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemAxe;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagDouble;
import net.minecraft.nbt.NBTTagFloat;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;

@Optional.InterfaceList(value={@Optional.Interface(iface="mekanism.api.energy.IEnergizedItem", modid="Mekanism"), @Optional.Interface(iface="ic2.api.item.ISpecialElectricItem", modid="IC2")})
public class ItemElectricAxe
extends ItemAxe
implements IItemElectric,
IEnergizedItem,
ISpecialElectricItem {
    private static IElectricItemManager itemManagerIC2;
    public float transferMax;
    private float maxPower;
    public static IIcon[] icons;

    public ItemElectricAxe(String name, Item.ToolMaterial material, float maxPower) {
        super(material);
        this.func_77656_e(100);
        this.setNoRepair();
        this.setMaxTransfer();
        this.func_77655_b(name);
        this.maxPower = maxPower;
        if (EnergyConfigHandler.isIndustrialCraft2Loaded()) {
            itemManagerIC2 = new ElectricItemManagerIC2_1710();
        }
    }

    public void func_94581_a(IIconRegister iconRegister) {
        for (int i = 0; i < icons.length; ++i) {
            ItemElectricAxe.icons[i] = iconRegister.func_94245_a("galaxyspace:tools/" + this.func_77658_a() + "_" + i);
        }
    }

    public IIcon func_77617_a(int par1) {
        return par1 == 100 ? icons[1] : icons[0];
    }

    protected void setMaxTransfer() {
        this.transferMax = 200.0f;
    }

    public float getMaxElectricityStored(ItemStack itemStack) {
        return this.maxPower;
    }

    public boolean func_77644_a(ItemStack itemStack, EntityLivingBase living, EntityLivingBase holder) {
        if (this.getElectricityStored(itemStack) != 0.0f) {
            this.setElectricity(itemStack, this.getElectricityStored(itemStack) - 10.5f);
            return true;
        }
        return false;
    }

    public float getDigSpeed(ItemStack itemStack, Block block, int meta) {
        if (this.getElectricityStored(itemStack) == 0.0f) {
            return 0.1f;
        }
        if (ForgeHooks.isToolEffective((ItemStack)itemStack, (Block)block, (int)meta)) {
            return this.field_77864_a;
        }
        return super.getDigSpeed(itemStack, block, meta);
    }

    public boolean func_150894_a(ItemStack itemStack, World world, Block block, int x, int y, int z, EntityLivingBase entity) {
        if ((double)block.func_149712_f(world, x, y, z) != 0.0 && this.getElectricityStored(itemStack) != 0.0f) {
            this.setElectricity(itemStack, this.getElectricityStored(itemStack) - 10.0f);
        }
        return false;
    }

    public EnumAction func_77661_b(ItemStack itemStack) {
        if (this.getElectricityStored(itemStack) != 0.0f) {
            return EnumAction.block;
        }
        return EnumAction.none;
    }

    public int func_77626_a(ItemStack itemStack) {
        if (this.getElectricityStored(itemStack) != 0.0f) {
            return 72000;
        }
        return 0;
    }

    public Multimap getAttributeModifiers(ItemStack itemStack) {
        if (this.getElectricityStored(itemStack) != 0.0f) {
            return super.getAttributeModifiers(itemStack);
        }
        return HashMultimap.create();
    }

    public CreativeTabs func_77640_w() {
        return GalaxySpace.tabArmor;
    }

    public boolean func_82789_a(ItemStack itemStack, ItemStack itemStack2) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item item, CreativeTabs creativeTabs, List list) {
        list.add(ElectricItemHelper.getWithCharge((ItemStack)new ItemStack((Item)this), (float)this.getMaxElectricityStored(new ItemStack((Item)this))));
    }

    public double getEnergy(ItemStack itemStack) {
        return this.getElectricityStored(itemStack) * EnergyConfigHandler.TO_MEKANISM_RATIO;
    }

    public void setEnergy(ItemStack itemStack, double amount) {
        this.setElectricity(itemStack, (float)amount * EnergyConfigHandler.MEKANISM_RATIO);
    }

    public double getMaxEnergy(ItemStack itemStack) {
        return this.getMaxElectricityStored(itemStack) * EnergyConfigHandler.TO_MEKANISM_RATIO;
    }

    public double getMaxTransfer(ItemStack itemStack) {
        return this.transferMax * EnergyConfigHandler.TO_MEKANISM_RATIO;
    }

    public boolean canReceive(ItemStack itemStack) {
        return itemStack != null && !(itemStack.func_77973_b() instanceof ItemBatteryInfinite);
    }

    public boolean canProvideEnergy(ItemStack itemStack) {
        return true;
    }

    public Item getChargedItem(ItemStack itemStack) {
        return itemStack.func_77973_b();
    }

    public Item getEmptyItem(ItemStack itemStack) {
        return itemStack.func_77973_b();
    }

    public int getTier(ItemStack itemStack) {
        return 1;
    }

    public double getMaxCharge(ItemStack itemStack) {
        return this.getMaxElectricityStored(itemStack) / EnergyConfigHandler.IC2_RATIO;
    }

    public double getTransferLimit(ItemStack itemStack) {
        return this.transferMax * EnergyConfigHandler.TO_IC2_RATIO;
    }

    public float recharge(ItemStack itemStack, float energy, boolean doRecharge) {
        float rejectedElectricity = Math.max(this.getElectricityStored(itemStack) + energy - this.getMaxElectricityStored(itemStack), 0.0f);
        float energyToReceive = energy - rejectedElectricity;
        if (energyToReceive > this.transferMax) {
            rejectedElectricity += energyToReceive - this.transferMax;
            energyToReceive = this.transferMax;
        }
        if (doRecharge) {
            this.setElectricity(itemStack, this.getElectricityStored(itemStack) + energyToReceive);
        }
        return energyToReceive;
    }

    public float discharge(ItemStack itemStack, float energy, boolean doDischarge) {
        float energyToTransfer = Math.min(Math.min(this.getElectricityStored(itemStack), energy), this.transferMax);
        if (doDischarge) {
            this.setElectricity(itemStack, this.getElectricityStored(itemStack) - energyToTransfer);
        }
        return energyToTransfer;
    }

    public float getElectricityStored(ItemStack itemStack) {
        if (itemStack.func_77978_p() == null) {
            itemStack.func_77982_d(new NBTTagCompound());
        }
        float energyStored = 0.0f;
        if (itemStack.func_77978_p().func_74764_b("electricity")) {
            NBTBase obj = itemStack.func_77978_p().func_74781_a("electricity");
            if (obj instanceof NBTTagDouble) {
                energyStored = ((NBTTagDouble)obj).func_150288_h();
            } else if (obj instanceof NBTTagFloat) {
                energyStored = ((NBTTagFloat)obj).func_150288_h();
            }
        }
        itemStack.func_77964_b((int)(100.0f - energyStored / this.getMaxElectricityStored(itemStack) * 100.0f));
        return energyStored;
    }

    public void setElectricity(ItemStack itemStack, float joules) {
        if (itemStack.func_77978_p() == null) {
            itemStack.func_77982_d(new NBTTagCompound());
        }
        float electricityStored = Math.max(Math.min(joules, this.getMaxElectricityStored(itemStack)), 0.0f);
        itemStack.func_77978_p().func_74776_a("electricity", electricityStored);
        itemStack.func_77964_b((int)(100.0f - electricityStored / this.getMaxElectricityStored(itemStack) * 100.0f));
    }

    public float getTransfer(ItemStack itemStack) {
        return Math.min(this.transferMax, this.getMaxElectricityStored(itemStack) - this.getElectricityStored(itemStack));
    }

    public int getTierGC(ItemStack itemStack) {
        return 1;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack itemStack, EntityPlayer player, List list, boolean advanced) {
        EnumChatFormatting color = null;
        float joules = this.getElectricityStored(itemStack);
        color = joules <= this.getMaxElectricityStored(itemStack) / 3.0f ? EnumChatFormatting.DARK_RED : (joules > this.getMaxElectricityStored(itemStack) * 2.0f / 3.0f ? EnumChatFormatting.DARK_GREEN : EnumChatFormatting.GOLD);
        list.add(color + EnergyDisplayHelper.getEnergyDisplayS((float)joules) + "/" + EnergyDisplayHelper.getEnergyDisplayS((float)this.getMaxElectricityStored(itemStack)));
    }

    public void func_77622_d(ItemStack itemStack, World world, EntityPlayer player) {
        this.setElectricity(itemStack, 0.0f);
    }

    public IElectricItemManager getManager(ItemStack itemStack) {
        return itemManagerIC2;
    }

    public boolean canSend(ItemStack arg0) {
        return true;
    }

    static {
        icons = new IIcon[2];
    }
}

