/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.xmod.gregtech.loaders;

import gregtech.api.enums.GT_Values;
import gregtech.api.enums.ItemList;
import gregtech.api.util.GT_ModHandler;
import gregtech.api.util.GT_Utility;
import gtPlusPlus.api.interfaces.RunnableWithInfo;
import gtPlusPlus.api.objects.Logger;
import gtPlusPlus.api.objects.data.AutoMap;
import gtPlusPlus.core.lib.CORE;
import gtPlusPlus.core.material.Material;
import gtPlusPlus.core.material.MaterialGenerator;
import gtPlusPlus.core.material.MaterialStack;
import gtPlusPlus.core.material.state.MaterialState;
import gtPlusPlus.core.recipe.common.CI;
import gtPlusPlus.core.util.math.MathUtils;
import gtPlusPlus.core.util.minecraft.ItemUtils;
import gtPlusPlus.core.util.minecraft.RecipeUtils;
import gtPlusPlus.xmod.gregtech.loaders.RecipeGen_Base;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class RecipeGen_DustGeneration
extends RecipeGen_Base {
    public static final Set<RunnableWithInfo<Material>> mRecipeGenMap = new HashSet<RunnableWithInfo<Material>>();

    public RecipeGen_DustGeneration(Material M) {
        this(M, false);
    }

    public RecipeGen_DustGeneration(Material M, boolean O) {
        this.toGenerate = M;
        this.disableOptional = O;
        mRecipeGenMap.add(this);
        ItemStack normalDust = M.getDust(1);
        ItemStack smallDust = M.getSmallDust(1);
        ItemStack tinyDust = M.getTinyDust(1);
        if (tinyDust != null && normalDust != null) {
            if (RecipeUtils.addShapedRecipe(tinyDust, tinyDust, tinyDust, tinyDust, tinyDust, tinyDust, tinyDust, tinyDust, tinyDust, normalDust)) {
                Logger.INFO("9 Tiny dust to 1 Dust Recipe: " + M.getLocalizedName() + " - Success");
            } else {
                Logger.INFO("9 Tiny dust to 1 Dust Recipe: " + M.getLocalizedName() + " - Failed");
            }
            if (RecipeUtils.addShapedRecipe(normalDust, null, null, null, null, null, null, null, null, M.getTinyDust(9))) {
                Logger.INFO("9 Tiny dust from 1 Recipe: " + M.getLocalizedName() + " - Success");
            } else {
                Logger.INFO("9 Tiny dust from 1 Recipe: " + M.getLocalizedName() + " - Failed");
            }
        }
        if (smallDust != null && normalDust != null) {
            if (RecipeUtils.addShapedRecipe(smallDust, smallDust, null, smallDust, smallDust, null, null, null, null, normalDust)) {
                Logger.INFO("4 Small dust to 1 Dust Recipe: " + M.getLocalizedName() + " - Success");
            } else {
                Logger.INFO("4 Small dust to 1 Dust Recipe: " + M.getLocalizedName() + " - Failed");
            }
            if (RecipeUtils.addShapedRecipe(null, normalDust, null, null, null, null, null, null, null, M.getSmallDust(4))) {
                Logger.INFO("4 Small dust from 1 Dust Recipe: " + M.getLocalizedName() + " - Success");
            } else {
                Logger.INFO("4 Small dust from 1 Dust Recipe: " + M.getLocalizedName() + " - Failed");
            }
        }
    }

    @Override
    public void run() {
        this.generateRecipes(this.toGenerate, this.disableOptional);
    }

    private void generateRecipes(Material material, boolean disableOptional) {
        Logger.INFO("Generating Shaped Crafting recipes for " + material.getLocalizedName());
        ItemStack normalDust = material.getDust(1);
        ItemStack smallDust = material.getSmallDust(1);
        ItemStack tinyDust = material.getTinyDust(1);
        ItemStack[] inputStacks = material.getMaterialComposites();
        ItemStack outputStacks = material.getDust(material.smallestStackSizeWhenProcessing);
        ItemStack materialBlock = material.getBlock(1);
        ItemStack materialFrameBox = material.getFrameBox(1);
        if (ItemUtils.checkForInvalidItems(materialBlock)) {
            GT_ModHandler.addPulverisationRecipe((ItemStack)materialBlock, (ItemStack)material.getDust(9));
        }
        if (ItemUtils.checkForInvalidItems(materialFrameBox)) {
            GT_ModHandler.addPulverisationRecipe((ItemStack)materialFrameBox, (ItemStack)material.getDust(2));
        }
        if (ItemUtils.checkForInvalidItems(smallDust) && ItemUtils.checkForInvalidItems(tinyDust)) {
            RecipeGen_DustGeneration.generatePackagerRecipes(material);
        }
        ItemStack ingot = material.getIngot(1);
        if (ItemUtils.checkForInvalidItems(normalDust) && ItemUtils.checkForInvalidItems(ingot)) {
            this.addFurnaceRecipe(material);
            this.addMacerationRecipe(material);
        }
        if (inputStacks != null && !disableOptional) {
            Logger.WARNING("mixer length: " + inputStacks.length);
            if (inputStacks.length != 0 && inputStacks.length <= 4) {
                Logger.WARNING(ItemUtils.getArrayStackNames(inputStacks));
                long[] inputStackSize = material.vSmallestRatio;
                Logger.WARNING("mixer is stacksizeVar null? " + (inputStackSize != null));
                if (inputStackSize != null) {
                    for (int x = 0; x < inputStacks.length; x = (int)((short)(x + 1))) {
                        if (inputStacks[x] == null || inputStackSize[x] == 0L) continue;
                        inputStacks[x].field_77994_a = (int)inputStackSize[x];
                    }
                    Logger.WARNING(ItemUtils.getArrayStackNames(inputStacks));
                    ItemStack[] input = new ItemStack[4];
                    ItemStack itemStack = inputStacks.length >= 1 ? (inputStacks[0] == null ? null : inputStacks[0]) : (input[0] = null);
                    ItemStack itemStack2 = inputStacks.length >= 2 ? (inputStacks[1] == null ? null : inputStacks[1]) : (input[1] = null);
                    ItemStack itemStack3 = inputStacks.length >= 3 ? (inputStacks[2] == null ? null : inputStacks[2]) : (input[2] = null);
                    ItemStack itemStack4 = inputStacks.length >= 4 ? (inputStacks[3] == null ? null : inputStacks[3]) : (input[3] = null);
                    if (inputStacks.length == 1) {
                        input[1] = input[0];
                        input[0] = CI.getNumberedCircuit(inputStacks.length + 10);
                    } else if (inputStacks.length == 2) {
                        input[2] = input[1];
                        input[1] = input[0];
                        input[0] = CI.getNumberedCircuit(inputStacks.length + 10);
                    } else if (inputStacks.length == 3) {
                        input[3] = input[2];
                        input[2] = input[1];
                        input[1] = input[0];
                        input[0] = CI.getNumberedCircuit(inputStacks.length + 10);
                    }
                    FluidStack oxygen = GT_Values.NF;
                    if (material.getComposites() != null) {
                        for (MaterialStack x : material.getComposites()) {
                            if (material.getComposites().isEmpty() || x == null || x.getStackMaterial() == null || x.getStackMaterial().getDust(1) != null || x.getStackMaterial().getState() == MaterialState.SOLID || x.getStackMaterial().getState() == MaterialState.ORE || x.getStackMaterial().getState() == MaterialState.PLASMA) continue;
                            oxygen = x.getStackMaterial().getFluidStack(1000);
                            break;
                        }
                    }
                    if (GT_Values.RA.addMixerRecipe((input = ItemUtils.cleanItemStackArray(input))[0], input[1], input[2], input[3], oxygen, null, outputStacks, (int)Math.max(material.getMass() * 2L * 1L, 1L), material.vVoltageMultiplier)) {
                        Logger.WARNING("Dust Mixer Recipe: " + material.getLocalizedName() + " - Success");
                    } else {
                        Logger.WARNING("Dust Mixer Recipe: " + material.getLocalizedName() + " - Failed");
                    }
                }
            }
        }
    }

    public static boolean addMixerRecipe_Standalone(Material material) {
        ItemStack[] inputStacks = material.getMaterialComposites();
        ItemStack outputStacks = material.getDust(material.smallestStackSizeWhenProcessing);
        if (inputStacks != null) {
            Logger.WARNING("mixer length: " + inputStacks.length);
            if (inputStacks.length >= 1 && inputStacks.length <= 4) {
                Logger.WARNING(ItemUtils.getArrayStackNames(inputStacks));
                long[] inputStackSize = material.vSmallestRatio;
                Logger.WARNING("mixer is stacksizeVar not null? " + (inputStackSize != null));
                if (inputStackSize != null) {
                    ItemStack input4;
                    ItemStack input3;
                    ItemStack input2;
                    for (int x = 0; x < inputStacks.length; x = (int)((short)(x + 1))) {
                        if (inputStacks[x] == null || inputStackSize[x] == 0L) continue;
                        inputStacks[x].field_77994_a = (int)inputStackSize[x];
                    }
                    Logger.WARNING(ItemUtils.getArrayStackNames(inputStacks));
                    ItemStack input1 = inputStacks[0];
                    ItemStack itemStack = inputStacks.length >= 2 ? (input2 = inputStacks[1] == null ? null : inputStacks[1]) : (input2 = null);
                    ItemStack itemStack2 = inputStacks.length >= 3 ? (input3 = inputStacks[2] == null ? null : inputStacks[2]) : (input3 = null);
                    ItemStack itemStack3 = inputStacks.length >= 4 ? (input4 = inputStacks[3] == null ? null : inputStacks[3]) : (input4 = null);
                    if (inputStacks.length == 1) {
                        input2 = input1;
                        input1 = CI.getNumberedCircuit(20);
                    } else if (inputStacks.length == 2) {
                        input3 = input2;
                        input2 = input1;
                        input1 = CI.getNumberedCircuit(20);
                    } else if (inputStacks.length == 3) {
                        input4 = input3;
                        input3 = input2;
                        input2 = input1;
                        input1 = CI.getNumberedCircuit(20);
                    }
                    FluidStack oxygen = GT_Values.NF;
                    if (material.getComposites() != null) {
                        int compSlot = 0;
                        for (MaterialStack x : material.getComposites()) {
                            MaterialState f;
                            if (!(material.getComposites().isEmpty() || x == null || x.getStackMaterial() == null || x.getStackMaterial().getDust(1) != null || (f = x.getStackMaterial().getState()) != MaterialState.GAS && f != MaterialState.LIQUID && f != MaterialState.PURE_LIQUID && f != MaterialState.PURE_GAS)) {
                                oxygen = x.getStackMaterial().getFluidStack((int)(material.vSmallestRatio[compSlot] * 1000L));
                            }
                            ++compSlot;
                        }
                    }
                    try {
                        if (GT_Values.RA.addMixerRecipe(input1, input2, input3, input4, oxygen, null, outputStacks, (int)Math.max(material.getMass() * 2L * 1L, 1L), material.vVoltageMultiplier)) {
                            Logger.WARNING("Dust Mixer Recipe: " + material.getLocalizedName() + " - Success");
                            return true;
                        }
                        Logger.WARNING("Dust Mixer Recipe: " + material.getLocalizedName() + " - Failed");
                        return false;
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                    }
                } else {
                    Logger.WARNING("inputStackSize == NUll - " + material.getLocalizedName());
                }
            } else {
                Logger.WARNING("InputStacks is out range 1-4 - " + material.getLocalizedName());
            }
        } else {
            Logger.WARNING("InputStacks == NUll - " + material.getLocalizedName());
        }
        return false;
    }

    public static boolean generatePackagerRecipes(Material aMatInfo) {
        AutoMap<Boolean> aResults = new AutoMap<Boolean>();
        aResults.put(GT_Values.RA.addBoxingRecipe(GT_Utility.copyAmount((long)4L, (Object[])new Object[]{aMatInfo.getSmallDust(4)}), ItemList.Schematic_Dust.get(0L, new Object[0]), aMatInfo.getDust(1), 100, 4));
        aResults.put(GT_Values.RA.addBoxingRecipe(GT_Utility.copyAmount((long)9L, (Object[])new Object[]{aMatInfo.getTinyDust(9)}), ItemList.Schematic_Dust.get(0L, new Object[0]), aMatInfo.getDust(1), 100, 4));
        Iterator iterator = aResults.iterator();
        while (iterator.hasNext()) {
            boolean b = (Boolean)iterator.next();
            if (b) continue;
            return false;
        }
        return true;
    }

    private void addMacerationRecipe(Material aMatInfo) {
        try {
            Logger.MATERIALS("Adding Maceration recipe for " + aMatInfo.getLocalizedName() + " Ingot -> Dusts");
            int chance = aMatInfo.vTier * 10 / MathUtils.randInt(10, 20);
            GT_ModHandler.addPulverisationRecipe((ItemStack)aMatInfo.getIngot(1), (ItemStack)aMatInfo.getDust(1), null, (int)chance);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    private void addFurnaceRecipe(Material aMatInfo) {
        ItemStack aDust = aMatInfo.getDust(1);
        try {
            if (aMatInfo.requiresBlastFurnace()) {
                ItemStack aOutput = aMatInfo.getHotIngot(1);
                if (ItemUtils.checkForInvalidItems(aOutput)) {
                    if (this.addBlastFurnaceRecipe(aMatInfo, aDust, null, aOutput, null, aMatInfo.getMeltingPointK())) {
                        Logger.MATERIALS("Successfully added a blast furnace recipe for " + aMatInfo.getLocalizedName());
                    } else {
                        Logger.MATERIALS("Failed to add a blast furnace recipe for " + aMatInfo.getLocalizedName());
                    }
                } else {
                    Logger.MATERIALS("Failed to add a blast furnace recipe for " + aMatInfo.getLocalizedName());
                }
            } else {
                ItemStack aOutput = aMatInfo.getIngot(1);
                if (ItemUtils.checkForInvalidItems(aOutput)) {
                    if (CORE.RA.addSmeltingAndAlloySmeltingRecipe(aDust, aOutput)) {
                        Logger.MATERIALS("Successfully added a furnace recipe for " + aMatInfo.getLocalizedName());
                    } else {
                        Logger.MATERIALS("Failed to add a furnace recipe for " + aMatInfo.getLocalizedName());
                    }
                }
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    private boolean addBlastFurnaceRecipe(Material aMatInfo, ItemStack input1, ItemStack input2, ItemStack output1, ItemStack output2, int tempRequired) {
        try {
            int aSlot;
            int timeTaken = 125 * aMatInfo.vTier * 10;
            if (aMatInfo.vTier <= 4) {
                timeTaken = 25 * aMatInfo.vTier * 10;
            }
            if ((aSlot = aMatInfo.vTier) < 2) {
                aSlot = 2;
            }
            long aVoltage = aMatInfo.vVoltageMultiplier;
            return GT_Values.RA.addBlastRecipe(input1, input2, GT_Values.NF, GT_Values.NF, output1, output2, timeTaken, (int)aVoltage, tempRequired);
        }
        catch (Throwable t) {
            t.printStackTrace();
            return false;
        }
    }

    static {
        MaterialGenerator.mRecipeMapsToGenerate.put(mRecipeGenMap);
    }
}

