/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.xmod.gregtech.api.metatileentity.implementations.base;

import com.gtnewhorizon.structurelib.StructureLibAPI;
import com.gtnewhorizon.structurelib.structure.AutoPlaceEnvironment;
import com.gtnewhorizon.structurelib.structure.IItemSource;
import com.gtnewhorizon.structurelib.structure.IStructureElement;
import com.gtnewhorizon.structurelib.structure.StructureUtility;
import com.gtnewhorizons.modularui.api.drawable.IDrawable;
import com.gtnewhorizons.modularui.api.drawable.ItemDrawable;
import com.gtnewhorizons.modularui.api.screen.ModularWindow;
import com.gtnewhorizons.modularui.api.screen.UIBuildContext;
import com.gtnewhorizons.modularui.api.widget.Widget;
import com.gtnewhorizons.modularui.common.widget.Column;
import com.gtnewhorizons.modularui.common.widget.DrawableWidget;
import com.gtnewhorizons.modularui.common.widget.DynamicPositionedColumn;
import com.gtnewhorizons.modularui.common.widget.FakeSyncWidget;
import com.gtnewhorizons.modularui.common.widget.TextWidget;
import gregtech.api.enums.GT_Values;
import gregtech.api.enums.Materials;
import gregtech.api.enums.Mods;
import gregtech.api.enums.Textures;
import gregtech.api.enums.VoidingMode;
import gregtech.api.gui.modularui.GT_UITextures;
import gregtech.api.interfaces.IHatchElement;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.items.GT_MetaGenerated_Tool;
import gregtech.api.logic.ProcessingLogic;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_ExtendedPowerMultiBlockBase;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_Dynamo;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_Energy;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_Input;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_InputBus;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_Maintenance;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_Muffler;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_Output;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_OutputBus;
import gregtech.api.recipe.RecipeMap;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GT_Recipe;
import gregtech.api.util.GT_Utility;
import gregtech.api.util.IGT_HatchAdder;
import gregtech.common.items.GT_MetaGenerated_Tool_01;
import gtPlusPlus.GTplusplus;
import gtPlusPlus.api.objects.Logger;
import gtPlusPlus.api.objects.minecraft.BlockPos;
import gtPlusPlus.core.util.minecraft.ItemUtils;
import gtPlusPlus.core.util.minecraft.PlayerUtils;
import gtPlusPlus.core.util.reflect.ReflectionUtils;
import gtPlusPlus.preloader.CORE_Preloader;
import gtPlusPlus.preloader.asm.AsmConfig;
import gtPlusPlus.xmod.gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_AirIntake;
import gtPlusPlus.xmod.gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_InputBattery;
import gtPlusPlus.xmod.gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_OutputBattery;
import gtPlusPlus.xmod.gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_Steam_BusInput;
import gtPlusPlus.xmod.gregtech.api.metatileentity.implementations.base.GT_MetaTileEntity_Hatch_CustomFluidBase;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.oredict.OreDictionary;

public abstract class GregtechMeta_MultiBlockBase<T extends GT_MetaTileEntity_ExtendedPowerMultiBlockBase<T>>
extends GT_MetaTileEntity_ExtendedPowerMultiBlockBase<T> {
    public static final boolean DEBUG_DISABLE_CORES_TEMPORARILY = true;
    public GT_Recipe mLastRecipe;
    protected long mTotalRunTime = 0L;
    public ArrayList<GT_MetaTileEntity_Hatch_AirIntake> mAirIntakes = new ArrayList();
    public ArrayList<GT_MetaTileEntity_Hatch_InputBattery> mChargeHatches = new ArrayList();
    public ArrayList<GT_MetaTileEntity_Hatch_OutputBattery> mDischargeHatches = new ArrayList();
    public ArrayList<GT_MetaTileEntity_Hatch> mAllEnergyHatches = new ArrayList();
    public ArrayList<GT_MetaTileEntity_Hatch> mAllDynamoHatches = new ArrayList();
    private String[] aCachedToolTip;
    public static final String TAG_HIDE_HATCHES = "TAG_HIDE_HATCHES";
    public static final String TAG_HIDE_MAINT = "TAG_HIDE_MAINT";
    public static final String TAG_HIDE_POLLUTION = "TAG_HIDE_POLLUTION";
    public static final String TAG_HIDE_MACHINE_TYPE = "TAG_HIDE_MACHINE_TYPE";
    public static Method aLogger = null;
    public ArrayList<GT_MetaTileEntity_Hatch> mTecTechDynamoHatches = new ArrayList();
    public ArrayList<GT_MetaTileEntity_Hatch> mTecTechEnergyHatches = new ArrayList();
    private static final Materials GOOD = Materials.Uranium;
    private static final Materials BAD = Materials.Plutonium;
    private static final ConcurrentHashMap<String, ItemStack> mToolStacks = new ConcurrentHashMap();

    public GregtechMeta_MultiBlockBase(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    public GregtechMeta_MultiBlockBase(String aName) {
        super(aName);
    }

    private static int toStackCount(Map.Entry<ItemStack, Integer> e) {
        int tMaxStackSize = e.getKey().func_77976_d();
        int tStackSize = e.getValue();
        return (tStackSize + tMaxStackSize - 1) / tMaxStackSize;
    }

    public long getTotalRuntimeInTicks() {
        return this.mTotalRunTime;
    }

    public abstract String getMachineType();

    public String getMachineTooltip() {
        return "Machine Type: " + EnumChatFormatting.YELLOW + this.getMachineType() + EnumChatFormatting.RESET;
    }

    public String[] getExtraInfoData() {
        return new String[0];
    }

    public String[] getInfoData() {
        long maxEnergy;
        long storedEnergy;
        String[] extra;
        ArrayList<String> mInfo = new ArrayList<String>();
        if (!this.getMetaName().equals("")) {
            mInfo.add(this.getMetaName());
        }
        if ((extra = this.getExtraInfoData()) == null) {
            extra = new String[]{};
        }
        if (extra.length > 0) {
            for (String s : extra) {
                mInfo.add(s);
            }
        }
        long seconds = this.mTotalRunTime / 20L;
        int weeks = (int)(TimeUnit.SECONDS.toDays(seconds) / 7L);
        int days = (int)(TimeUnit.SECONDS.toDays(seconds) - (long)(7 * weeks));
        long hours = TimeUnit.SECONDS.toHours(seconds) - TimeUnit.DAYS.toHours(days) - TimeUnit.DAYS.toHours(7L * (long)weeks);
        long minutes = TimeUnit.SECONDS.toMinutes(seconds) - TimeUnit.SECONDS.toHours(seconds) * 60L;
        long second = TimeUnit.SECONDS.toSeconds(seconds) - TimeUnit.SECONDS.toMinutes(seconds) * 60L;
        mInfo.add(this.getMachineTooltip());
        mInfo.add(StatCollector.func_74838_a((String)"GTPP.multiblock.progress") + ": " + EnumChatFormatting.GREEN + this.mProgresstime / 20 + EnumChatFormatting.RESET + " s / " + EnumChatFormatting.YELLOW + this.mMaxProgresstime / 20 + EnumChatFormatting.RESET + " s");
        if (!this.mAllEnergyHatches.isEmpty()) {
            storedEnergy = this.getStoredEnergyInAllEnergyHatches();
            maxEnergy = this.getMaxEnergyStorageOfAllEnergyHatches();
            mInfo.add(StatCollector.func_74838_a((String)"GTPP.multiblock.energy") + ":");
            mInfo.add(StatCollector.func_74838_a((String)("" + EnumChatFormatting.GREEN + Long.toString(storedEnergy) + EnumChatFormatting.RESET + " EU / " + EnumChatFormatting.YELLOW + Long.toString(maxEnergy) + EnumChatFormatting.RESET + " EU")));
            mInfo.add(StatCollector.func_74838_a((String)"GTPP.multiblock.mei") + ":");
            mInfo.add(StatCollector.func_74838_a((String)("" + EnumChatFormatting.YELLOW + Long.toString(this.getMaxInputVoltage()) + EnumChatFormatting.RESET + " EU/t(*2A) " + StatCollector.func_74838_a((String)"GTPP.machines.tier") + ": " + EnumChatFormatting.YELLOW + GT_Values.VN[GT_Utility.getTier((long)this.getMaxInputVoltage())] + EnumChatFormatting.RESET)));
        }
        if (!this.mAllDynamoHatches.isEmpty()) {
            storedEnergy = this.getStoredEnergyInAllDynamoHatches();
            maxEnergy = this.getMaxEnergyStorageOfAllDynamoHatches();
            mInfo.add(StatCollector.func_74838_a((String)"GTPP.multiblock.energy") + " In Dynamos:");
            mInfo.add(StatCollector.func_74838_a((String)("" + EnumChatFormatting.GREEN + Long.toString(storedEnergy) + EnumChatFormatting.RESET + " EU / " + EnumChatFormatting.YELLOW + Long.toString(maxEnergy) + EnumChatFormatting.RESET + " EU")));
        }
        if (-this.lEUt > 0L) {
            mInfo.add(StatCollector.func_74838_a((String)"GTPP.multiblock.usage") + ":");
            mInfo.add(StatCollector.func_74838_a((String)("" + EnumChatFormatting.RED + -this.lEUt + EnumChatFormatting.RESET + " EU/t")));
        } else {
            mInfo.add(StatCollector.func_74838_a((String)"GTPP.multiblock.generation") + ":");
            mInfo.add(StatCollector.func_74838_a((String)("" + EnumChatFormatting.GREEN + this.lEUt + EnumChatFormatting.RESET + " EU/t")));
        }
        mInfo.add(StatCollector.func_74838_a((String)"GTPP.multiblock.problems") + ": " + EnumChatFormatting.RED + (this.getIdealStatus() - this.getRepairStatus()) + EnumChatFormatting.RESET + " " + StatCollector.func_74838_a((String)"GTPP.multiblock.efficiency") + ": " + EnumChatFormatting.YELLOW + Float.toString((float)this.mEfficiency / 100.0f) + EnumChatFormatting.RESET + " %");
        if (this.getPollutionPerSecond(null) > 0) {
            int mPollutionReduction = this.getPollutionReductionForAllMufflers();
            mInfo.add(StatCollector.func_74838_a((String)"GTPP.multiblock.pollution") + ": " + EnumChatFormatting.RED + this.getPollutionPerSecond(null) + EnumChatFormatting.RESET + "/sec");
            mInfo.add(StatCollector.func_74838_a((String)"GTPP.multiblock.pollutionreduced") + ": " + EnumChatFormatting.GREEN + mPollutionReduction + EnumChatFormatting.RESET + " %");
        }
        mInfo.add(StatCollector.func_74838_a((String)"GTPP.CC.parallel") + ": " + EnumChatFormatting.GREEN + this.getMaxParallelRecipes() + EnumChatFormatting.RESET);
        mInfo.add("Total Time Since Built: " + EnumChatFormatting.DARK_GREEN + Integer.toString(weeks) + EnumChatFormatting.RESET + " Weeks, " + EnumChatFormatting.DARK_GREEN + Integer.toString(days) + EnumChatFormatting.RESET + " Days, ");
        mInfo.add(EnumChatFormatting.DARK_GREEN + Long.toString(hours) + EnumChatFormatting.RESET + " Hours, " + EnumChatFormatting.DARK_GREEN + Long.toString(minutes) + EnumChatFormatting.RESET + " Minutes, " + EnumChatFormatting.DARK_GREEN + Long.toString(second) + EnumChatFormatting.RESET + " Seconds.");
        mInfo.add("Total Time in ticks: " + EnumChatFormatting.DARK_GREEN + Long.toString(this.mTotalRunTime));
        String[] mInfo2 = mInfo.toArray(new String[mInfo.size()]);
        return mInfo2;
    }

    public int getPollutionReductionForAllMufflers() {
        int mPollutionReduction = 0;
        for (GT_MetaTileEntity_Hatch_Muffler tHatch : (ArrayList)GT_Utility.filterValidMTEs((Collection)this.mMufflerHatches)) {
            mPollutionReduction = Math.max(this.calculatePollutionReductionForHatch(tHatch, 100), mPollutionReduction);
        }
        return mPollutionReduction;
    }

    public long getStoredEnergyInAllEnergyHatches() {
        long storedEnergy = 0L;
        for (GT_MetaTileEntity_Hatch tHatch : (ArrayList)GT_Utility.filterValidMTEs(this.mAllEnergyHatches)) {
            storedEnergy += tHatch.getBaseMetaTileEntity().getStoredEU();
        }
        return storedEnergy;
    }

    public long getMaxEnergyStorageOfAllEnergyHatches() {
        long maxEnergy = 0L;
        for (GT_MetaTileEntity_Hatch tHatch : (ArrayList)GT_Utility.filterValidMTEs(this.mAllEnergyHatches)) {
            maxEnergy += tHatch.getBaseMetaTileEntity().getEUCapacity();
        }
        return maxEnergy;
    }

    public long getStoredEnergyInAllDynamoHatches() {
        long storedEnergy = 0L;
        for (GT_MetaTileEntity_Hatch tHatch : (ArrayList)GT_Utility.filterValidMTEs(this.mAllDynamoHatches)) {
            storedEnergy += tHatch.getBaseMetaTileEntity().getStoredEU();
        }
        return storedEnergy;
    }

    public long getMaxEnergyStorageOfAllDynamoHatches() {
        long maxEnergy = 0L;
        for (GT_MetaTileEntity_Hatch tHatch : (ArrayList)GT_Utility.filterValidMTEs(this.mAllDynamoHatches)) {
            maxEnergy += tHatch.getBaseMetaTileEntity().getEUCapacity();
        }
        return maxEnergy;
    }

    public boolean isGivingInformation() {
        return true;
    }

    public abstract int getMaxParallelRecipes();

    public boolean isCorrectMachinePart(ItemStack paramItemStack) {
        return true;
    }

    public int getDamageToComponent(ItemStack paramItemStack) {
        return 0;
    }

    public boolean explodesOnComponentBreak(ItemStack p0) {
        return false;
    }

    public void log(String s) {
        if (!AsmConfig.disableAllLogging) {
            if (CORE_Preloader.DEBUG_MODE) {
                Logger.INFO(s);
            } else {
                Logger.MACHINE_INFO(s, new Object[0]);
            }
        }
    }

    protected void setProcessingLogicPower(ProcessingLogic logic) {
        logic.setAvailableVoltage(GT_Utility.roundUpVoltage((long)this.getMaxInputVoltage()));
        logic.setAvailableAmperage(1L);
    }

    public long getMaxInputEnergy() {
        long rEnergy = 0L;
        if (this.mEnergyHatches.size() == 1) {
            return ((GT_MetaTileEntity_Hatch_Energy)this.mEnergyHatches.get(0)).getBaseMetaTileEntity().getInputVoltage();
        }
        for (GT_MetaTileEntity_Hatch_Energy tHatch : (ArrayList)GT_Utility.filterValidMTEs((Collection)this.mEnergyHatches)) {
            rEnergy += tHatch.getBaseMetaTileEntity().getInputVoltage() * tHatch.getBaseMetaTileEntity().getInputAmperage();
        }
        return rEnergy;
    }

    public boolean isMachineRunning() {
        boolean aRunning = this.getBaseMetaTileEntity().isActive();
        return aRunning;
    }

    public void onPostTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        if (aBaseMetaTileEntity.isServerSide()) {
            ++this.mTotalRunTime;
        }
        if (aBaseMetaTileEntity.isServerSide() && (this.mUpdate == 1 || this.mStartUpCheck == 1)) {
            this.mChargeHatches.clear();
            this.mDischargeHatches.clear();
            this.mAirIntakes.clear();
            this.mTecTechEnergyHatches.clear();
            this.mTecTechDynamoHatches.clear();
            this.mAllEnergyHatches.clear();
            this.mAllDynamoHatches.clear();
        }
        super.onPostTick(aBaseMetaTileEntity, aTick);
    }

    public void explodeMultiblock() {
        for (MetaTileEntity metaTileEntity : this.mChargeHatches) {
            metaTileEntity.getBaseMetaTileEntity().doExplosion(GT_Values.V[8]);
        }
        Object var1_3 = null;
        for (MetaTileEntity metaTileEntity : this.mDischargeHatches) {
            metaTileEntity.getBaseMetaTileEntity().doExplosion(GT_Values.V[8]);
        }
        Object var1_6 = null;
        for (MetaTileEntity metaTileEntity : this.mTecTechDynamoHatches) {
            metaTileEntity.getBaseMetaTileEntity().doExplosion(GT_Values.V[8]);
        }
        Object var1_9 = null;
        for (MetaTileEntity metaTileEntity : this.mTecTechEnergyHatches) {
            metaTileEntity.getBaseMetaTileEntity().doExplosion(GT_Values.V[8]);
        }
        super.explodeMultiblock();
    }

    protected boolean setGUIItemStack(ItemStack aNewGuiSlotContents) {
        boolean result = false;
        if (this.mInventory[1] == null) {
            this.mInventory[1] = aNewGuiSlotContents != null ? aNewGuiSlotContents.func_77946_l() : null;
            this.depleteInput(aNewGuiSlotContents);
            this.updateSlots();
            result = true;
        }
        return result;
    }

    public ItemStack findItemInInventory(Item aSearchStack) {
        return this.findItemInInventory(aSearchStack, 0);
    }

    public ItemStack findItemInInventory(Item aSearchStack, int aMeta) {
        return this.findItemInInventory(ItemUtils.simpleMetaStack(aSearchStack, aMeta, 1));
    }

    public ItemStack findItemInInventory(ItemStack aSearchStack) {
        if (aSearchStack != null && this.mInputBusses.size() > 0) {
            for (GT_MetaTileEntity_Hatch_InputBus bus : this.mInputBusses) {
                if (bus == null) continue;
                for (ItemStack uStack : bus.mInventory) {
                    if (uStack == null || !aSearchStack.getClass().isInstance(uStack.func_77973_b())) continue;
                    return uStack;
                }
            }
        }
        return null;
    }

    protected boolean depleteInputFromRestrictedHatches(Collection<GT_MetaTileEntity_Hatch_CustomFluidBase> aHatches, int aAmount) {
        for (GT_MetaTileEntity_Hatch_CustomFluidBase tHatch : GT_Utility.filterValidMTEs(aHatches)) {
            FluidStack tLiquid = tHatch.getFluid();
            if (tLiquid == null || tLiquid.amount < aAmount || (tLiquid = tHatch.drain(aAmount, false)) == null || tLiquid.amount < aAmount) continue;
            tLiquid = tHatch.drain(aAmount, true);
            return tLiquid != null && tLiquid.amount >= aAmount;
        }
        return false;
    }

    public void updateSlots() {
        for (GT_MetaTileEntity_Hatch tHatch : (ArrayList)GT_Utility.filterValidMTEs(this.mChargeHatches)) {
            tHatch.updateSlots();
        }
        for (GT_MetaTileEntity_Hatch tHatch : (ArrayList)GT_Utility.filterValidMTEs(this.mDischargeHatches)) {
            tHatch.updateSlots();
        }
        super.updateSlots();
    }

    public boolean causeMaintenanceIssue() {
        boolean b = false;
        switch (this.getBaseMetaTileEntity().getRandomNumber(6)) {
            case 0: {
                this.mWrench = false;
                b = true;
                break;
            }
            case 1: {
                this.mScrewdriver = false;
                b = true;
                break;
            }
            case 2: {
                this.mSoftHammer = false;
                b = true;
                break;
            }
            case 3: {
                this.mHardHammer = false;
                b = true;
                break;
            }
            case 4: {
                this.mSolderingTool = false;
                b = true;
                break;
            }
            case 5: {
                this.mCrowbar = false;
                b = true;
            }
        }
        return b;
    }

    public void fixAllMaintenanceIssue() {
        this.mCrowbar = true;
        this.mWrench = true;
        this.mHardHammer = true;
        this.mSoftHammer = true;
        this.mSolderingTool = true;
        this.mScrewdriver = true;
    }

    public boolean checkHatch() {
        return this.mMaintenanceHatches.size() <= 1 && (this.getPollutionPerSecond(null) <= 0 || !this.mMufflerHatches.isEmpty());
    }

    public void clearHatches() {
        super.clearHatches();
        this.mChargeHatches.clear();
        this.mDischargeHatches.clear();
        this.mAirIntakes.clear();
        this.mTecTechEnergyHatches.clear();
        this.mTecTechDynamoHatches.clear();
        this.mAllEnergyHatches.clear();
        this.mAllDynamoHatches.clear();
    }

    public <E> boolean addToMachineListInternal(ArrayList<E> aList, IGregTechTileEntity aTileEntity, int aBaseCasingIndex) {
        return this.addToMachineListInternal(aList, this.getMetaTileEntity(aTileEntity), aBaseCasingIndex);
    }

    public <E> boolean addToMachineListInternal(ArrayList<E> aList, IMetaTileEntity aTileEntity, int aBaseCasingIndex) {
        if (aTileEntity == null) {
            return false;
        }
        try {
            if (aTileEntity instanceof GT_MetaTileEntity_Hatch_Input) {
                this.resetRecipeMapForHatch((GT_MetaTileEntity_Hatch)aTileEntity, this.getRecipeMap());
            }
            if (aTileEntity instanceof GT_MetaTileEntity_Hatch_InputBus) {
                this.resetRecipeMapForHatch((GT_MetaTileEntity_Hatch)aTileEntity, this.getRecipeMap());
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        if (aList.isEmpty()) {
            if (aTileEntity instanceof GT_MetaTileEntity_Hatch) {
                if (GTplusplus.CURRENT_LOAD_PHASE == GTplusplus.INIT_PHASE.STARTED) {
                    this.log("Adding " + aTileEntity.func_145825_b() + " at " + new BlockPos(aTileEntity.getBaseMetaTileEntity()).getLocationString());
                }
                this.updateTexture(aTileEntity, aBaseCasingIndex);
                return aList.add(aTileEntity);
            }
        } else {
            IGregTechTileEntity aCur = aTileEntity.getBaseMetaTileEntity();
            if (aList.contains(aTileEntity)) {
                this.log("Found Duplicate " + aTileEntity.func_145825_b() + " @ " + new BlockPos(aCur).getLocationString());
                return false;
            }
            BlockPos aCurPos = new BlockPos(aCur);
            boolean aExists = false;
            for (IMetaTileEntity iMetaTileEntity : aList) {
                BlockPos aPos;
                IGregTechTileEntity b = iMetaTileEntity.getBaseMetaTileEntity();
                if (b == null || (aPos = new BlockPos(b)) == null || !aCurPos.equals(aPos)) continue;
                if (GTplusplus.CURRENT_LOAD_PHASE == GTplusplus.INIT_PHASE.STARTED) {
                    this.log("Found Duplicate " + b.func_145825_b() + " at " + aPos.getLocationString());
                }
                return false;
            }
            if (aTileEntity instanceof GT_MetaTileEntity_Hatch) {
                if (GTplusplus.CURRENT_LOAD_PHASE == GTplusplus.INIT_PHASE.STARTED) {
                    this.log("Adding " + aCur.func_145825_b() + " at " + aCurPos.getLocationString());
                }
                this.updateTexture(aTileEntity, aBaseCasingIndex);
                return aList.add(aTileEntity);
            }
        }
        return false;
    }

    private IMetaTileEntity getMetaTileEntity(IGregTechTileEntity aTileEntity) {
        if (aTileEntity == null) {
            return null;
        }
        IMetaTileEntity aMetaTileEntity = aTileEntity.getMetaTileEntity();
        return aMetaTileEntity;
    }

    public boolean addToMachineList(IGregTechTileEntity aTileEntity, int aBaseCasingIndex) {
        return this.addToMachineList(this.getMetaTileEntity(aTileEntity), aBaseCasingIndex);
    }

    public boolean addToMachineList(IMetaTileEntity aMetaTileEntity, int aBaseCasingIndex) {
        if (aMetaTileEntity == null) {
            return false;
        }
        boolean aDidAdd = false;
        if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_InputBattery) {
            this.log("Found GT_MetaTileEntity_Hatch_InputBattery");
            aDidAdd = this.addToMachineListInternal(this.mChargeHatches, aMetaTileEntity, aBaseCasingIndex);
        } else if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_OutputBattery) {
            this.log("Found GT_MetaTileEntity_Hatch_OutputBattery");
            aDidAdd = this.addToMachineListInternal(this.mDischargeHatches, aMetaTileEntity, aBaseCasingIndex);
        } else if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_AirIntake) {
            aDidAdd = this.addToMachineListInternal(this.mAirIntakes, aMetaTileEntity, aBaseCasingIndex) && this.addToMachineListInternal(this.mInputHatches, aMetaTileEntity, aBaseCasingIndex);
        } else if (Mods.TecTech.isModLoaded() && this.isThisHatchMultiEnergy(aMetaTileEntity)) {
            this.log("Found isThisHatchMultiEnergy");
            aDidAdd = this.addToMachineListInternal(this.mTecTechEnergyHatches, aMetaTileEntity, aBaseCasingIndex);
            this.updateMasterEnergyHatchList(aMetaTileEntity);
        } else if (Mods.TecTech.isModLoaded() && this.isThisHatchMultiDynamo(aMetaTileEntity)) {
            this.log("Found isThisHatchMultiDynamo");
            aDidAdd = this.addToMachineListInternal(this.mTecTechDynamoHatches, aMetaTileEntity, aBaseCasingIndex);
            this.updateMasterDynamoHatchList(aMetaTileEntity);
        } else if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_Input) {
            aDidAdd = this.addToMachineListInternal(this.mInputHatches, aMetaTileEntity, aBaseCasingIndex);
        } else if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_Output) {
            aDidAdd = this.addToMachineListInternal(this.mOutputHatches, aMetaTileEntity, aBaseCasingIndex);
        } else if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_InputBus) {
            aDidAdd = this.addToMachineListInternal(this.mInputBusses, aMetaTileEntity, aBaseCasingIndex);
        } else if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_OutputBus) {
            aDidAdd = this.addToMachineListInternal(this.mOutputBusses, aMetaTileEntity, aBaseCasingIndex);
        } else if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_Energy) {
            aDidAdd = this.addToMachineListInternal(this.mEnergyHatches, aMetaTileEntity, aBaseCasingIndex);
            this.updateMasterEnergyHatchList(aMetaTileEntity);
        } else if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_Dynamo) {
            aDidAdd = this.addToMachineListInternal(this.mDynamoHatches, aMetaTileEntity, aBaseCasingIndex);
            this.updateMasterDynamoHatchList(aMetaTileEntity);
        } else if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_Maintenance) {
            aDidAdd = this.addToMachineListInternal(this.mMaintenanceHatches, aMetaTileEntity, aBaseCasingIndex);
        } else if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_Muffler) {
            aDidAdd = this.addToMachineListInternal(this.mMufflerHatches, aMetaTileEntity, aBaseCasingIndex);
        }
        return aDidAdd;
    }

    public boolean addMaintenanceToMachineList(IGregTechTileEntity aTileEntity, int aBaseCasingIndex) {
        IMetaTileEntity aMetaTileEntity = this.getMetaTileEntity(aTileEntity);
        if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_Maintenance) {
            return this.addToMachineList(aMetaTileEntity, aBaseCasingIndex);
        }
        return false;
    }

    public boolean addMufflerToMachineList(IGregTechTileEntity aTileEntity, int aBaseCasingIndex) {
        IMetaTileEntity aMetaTileEntity = this.getMetaTileEntity(aTileEntity);
        if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_Muffler) {
            return this.addToMachineList(aMetaTileEntity, aBaseCasingIndex);
        }
        return false;
    }

    public boolean addInputToMachineList(IGregTechTileEntity aTileEntity, int aBaseCasingIndex) {
        IMetaTileEntity aMetaTileEntity = this.getMetaTileEntity(aTileEntity);
        if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_Input || aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_InputBus) {
            return this.addToMachineList(aMetaTileEntity, aBaseCasingIndex);
        }
        return false;
    }

    public boolean addOutputToMachineList(IGregTechTileEntity aTileEntity, int aBaseCasingIndex) {
        IMetaTileEntity aMetaTileEntity = this.getMetaTileEntity(aTileEntity);
        if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_Output || aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_OutputBus) {
            return this.addToMachineList(aMetaTileEntity, aBaseCasingIndex);
        }
        return false;
    }

    public boolean addAirIntakeToMachineList(IGregTechTileEntity aTileEntity, int aBaseCasingIndex) {
        IMetaTileEntity aMetaTileEntity = this.getMetaTileEntity(aTileEntity);
        if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_AirIntake) {
            return this.addToMachineList(aMetaTileEntity, aBaseCasingIndex);
        }
        return false;
    }

    public boolean addFluidInputToMachineList(IGregTechTileEntity aTileEntity, int aBaseCasingIndex) {
        return this.addFluidInputToMachineList(this.getMetaTileEntity(aTileEntity), aBaseCasingIndex);
    }

    public boolean addFluidInputToMachineList(IMetaTileEntity aMetaTileEntity, int aBaseCasingIndex) {
        if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_Input) {
            return this.addToMachineList(aMetaTileEntity, aBaseCasingIndex);
        }
        return false;
    }

    public boolean clearRecipeMapForAllInputHatches() {
        return this.resetRecipeMapForAllInputHatches(null);
    }

    public boolean resetRecipeMapForAllInputHatches() {
        return this.resetRecipeMapForAllInputHatches(this.getRecipeMap());
    }

    public boolean resetRecipeMapForAllInputHatches(RecipeMap<?> aMap) {
        int cleared = 0;
        for (GT_MetaTileEntity_Hatch_Input g : this.mInputHatches) {
            if (!this.resetRecipeMapForHatch((GT_MetaTileEntity_Hatch)g, aMap)) continue;
            ++cleared;
        }
        for (GT_MetaTileEntity_Hatch_Input g : this.mInputBusses) {
            if (!this.resetRecipeMapForHatch((GT_MetaTileEntity_Hatch)g, aMap)) continue;
            ++cleared;
        }
        return cleared > 0;
    }

    public boolean resetRecipeMapForHatch(IGregTechTileEntity aTileEntity, RecipeMap<?> aMap) {
        try {
            IMetaTileEntity aMetaTileEntity = this.getMetaTileEntity(aTileEntity);
            if (aMetaTileEntity == null) {
                return false;
            }
            if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_Input || aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_InputBus || aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_Steam_BusInput) {
                return this.resetRecipeMapForHatch((GT_MetaTileEntity_Hatch)aMetaTileEntity, aMap);
            }
            return false;
        }
        catch (Throwable t) {
            t.printStackTrace();
            return false;
        }
    }

    public boolean resetRecipeMapForHatch(GT_MetaTileEntity_Hatch aTileEntity, RecipeMap<?> aMap) {
        if (aTileEntity == null) {
            return false;
        }
        GT_MetaTileEntity_Hatch aMetaTileEntity = aTileEntity;
        if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_Input || aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_InputBus || aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_Steam_BusInput) {
            if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_Input) {
                ((GT_MetaTileEntity_Hatch_Input)aMetaTileEntity).mRecipeMap = null;
                ((GT_MetaTileEntity_Hatch_Input)aMetaTileEntity).mRecipeMap = aMap;
                if (aMap != null) {
                    this.log("Remapped Input Hatch to " + aMap.unlocalizedName + ".");
                } else {
                    this.log("Cleared Input Hatch.");
                }
            } else if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_InputBus) {
                ((GT_MetaTileEntity_Hatch_InputBus)aMetaTileEntity).mRecipeMap = null;
                ((GT_MetaTileEntity_Hatch_InputBus)aMetaTileEntity).mRecipeMap = aMap;
                if (aMap != null) {
                    this.log("Remapped Input Bus to " + aMap.unlocalizedName + ".");
                } else {
                    this.log("Cleared Input Bus.");
                }
            } else {
                ((GT_MetaTileEntity_Hatch_Steam_BusInput)aMetaTileEntity).mRecipeMap = null;
                ((GT_MetaTileEntity_Hatch_Steam_BusInput)aMetaTileEntity).mRecipeMap = aMap;
                if (aMap != null) {
                    this.log("Remapped Input Bus to " + aMap.unlocalizedName + ".");
                } else {
                    this.log("Cleared Input Bus.");
                }
            }
            return true;
        }
        return false;
    }

    public final void onScrewdriverRightClick(ForgeDirection side, EntityPlayer aPlayer, float aX, float aY, float aZ) {
        super.onScrewdriverRightClick(side, aPlayer, aX, aY, aZ);
        this.clearRecipeMapForAllInputHatches();
        this.onModeChangeByScrewdriver(side, aPlayer, aX, aY, aZ);
        this.resetRecipeMapForAllInputHatches();
    }

    public void onModeChangeByScrewdriver(ForgeDirection side, EntityPlayer aPlayer, float aX, float aY, float aZ) {
    }

    public boolean updateTexture(IGregTechTileEntity aTileEntity, int aCasingID) {
        return this.updateTexture(this.getMetaTileEntity(aTileEntity), aCasingID);
    }

    public boolean updateTexture(IMetaTileEntity aTileEntity, int aCasingID) {
        try {
            IMetaTileEntity aMetaTileEntity = aTileEntity;
            if (aMetaTileEntity == null) {
                return false;
            }
            Method mProper = ReflectionUtils.getMethod(GT_MetaTileEntity_Hatch.class, "updateTexture", Integer.TYPE);
            if (mProper != null) {
                if (GT_MetaTileEntity_Hatch.class.isInstance(aMetaTileEntity)) {
                    mProper.setAccessible(true);
                    mProper.invoke((Object)aMetaTileEntity, aCasingID);
                    return true;
                }
            } else {
                this.log("Bad Method Call for updateTexture.");
                if (GT_MetaTileEntity_Hatch.class.isInstance(aMetaTileEntity)) {
                    if (aCasingID <= 127) {
                        ((GT_MetaTileEntity_Hatch)aTileEntity).updateTexture(aCasingID);
                        this.log("Good Method Call for updateTexture. Used fallback method of setting mMachineBlock as casing id was <= 128.");
                        return true;
                    }
                    this.log("updateTexture returning false. 1.2");
                } else {
                    this.log("updateTexture returning false. 1.3");
                }
            }
            this.log("updateTexture returning false. 1");
            return false;
        }
        catch (IllegalAccessException | IllegalArgumentException | SecurityException | InvocationTargetException e) {
            this.log("updateTexture returning false.");
            this.log("updateTexture returning false. 2");
            e.printStackTrace();
            return false;
        }
    }

    public boolean addMultiAmpDynamoToMachineList(IGregTechTileEntity aTileEntity, int aBaseCasingIndex) {
        IMetaTileEntity aMetaTileEntity = this.getMetaTileEntity(aTileEntity);
        if (aMetaTileEntity == null) {
            return false;
        }
        if (this.isThisHatchMultiDynamo(aTileEntity)) {
            return this.addToMachineListInternal(this.mTecTechDynamoHatches, aMetaTileEntity, aBaseCasingIndex);
        }
        return false;
    }

    public boolean isThisHatchMultiDynamo(IGregTechTileEntity aTileEntity) {
        return this.isThisHatchMultiDynamo(this.getMetaTileEntity(aTileEntity));
    }

    public boolean isThisHatchMultiDynamo(IMetaTileEntity aMetaTileEntity) {
        Class<?> mDynamoClass = ReflectionUtils.getClass("com.github.technus.tectech.thing.metaTileEntity.hatch.GT_MetaTileEntity_Hatch_DynamoMulti");
        return mDynamoClass != null && mDynamoClass.isInstance(aMetaTileEntity);
    }

    public boolean addDynamoToMachineList(IGregTechTileEntity aTileEntity, int aBaseCasingIndex) {
        IMetaTileEntity aMetaTileEntity = this.getMetaTileEntity(aTileEntity);
        if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_Dynamo || this.isThisHatchMultiDynamo(aMetaTileEntity)) {
            return this.addToMachineList(aMetaTileEntity, aBaseCasingIndex);
        }
        return false;
    }

    private boolean updateMasterDynamoHatchList(IMetaTileEntity aMetaTileEntity) {
        if (aMetaTileEntity == null) {
            return false;
        }
        if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch) {
            GT_MetaTileEntity_Hatch aHatch = (GT_MetaTileEntity_Hatch)aMetaTileEntity;
            return this.mAllDynamoHatches.add(aHatch);
        }
        return false;
    }

    public boolean addMultiAmpEnergyToMachineList(IGregTechTileEntity aTileEntity, int aBaseCasingIndex) {
        IMetaTileEntity aMetaTileEntity = this.getMetaTileEntity(aTileEntity);
        if (aMetaTileEntity == null) {
            return false;
        }
        if (this.isThisHatchMultiEnergy(aMetaTileEntity)) {
            return this.addToMachineListInternal(this.mTecTechEnergyHatches, aMetaTileEntity, aBaseCasingIndex);
        }
        return false;
    }

    public boolean isThisHatchMultiEnergy(IGregTechTileEntity aTileEntity) {
        return this.isThisHatchMultiEnergy(this.getMetaTileEntity(aTileEntity));
    }

    public boolean isThisHatchMultiEnergy(IMetaTileEntity aMetaTileEntity) {
        Class<?> mDynamoClass = ReflectionUtils.getClass("com.github.technus.tectech.thing.metaTileEntity.hatch.GT_MetaTileEntity_Hatch_EnergyMulti");
        return mDynamoClass != null && mDynamoClass.isInstance(aMetaTileEntity);
    }

    public boolean addEnergyInputToMachineList(IGregTechTileEntity aTileEntity, int aBaseCasingIndex) {
        IMetaTileEntity aMetaTileEntity = this.getMetaTileEntity(aTileEntity);
        if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_Energy || this.isThisHatchMultiEnergy(aMetaTileEntity)) {
            return this.addToMachineList(aMetaTileEntity, aBaseCasingIndex);
        }
        return false;
    }

    private boolean updateMasterEnergyHatchList(IMetaTileEntity aMetaTileEntity) {
        if (aMetaTileEntity == null) {
            return false;
        }
        if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch) {
            GT_MetaTileEntity_Hatch aHatch = (GT_MetaTileEntity_Hatch)aMetaTileEntity;
            return this.mAllEnergyHatches.add(aHatch);
        }
        return false;
    }

    public int calculatePollutionReductionForHatch(GT_MetaTileEntity_Hatch_Muffler hatch, int poll) {
        return hatch.calculatePollutionReduction(poll);
    }

    public void saveNBTData(NBTTagCompound aNBT) {
        aNBT.func_74772_a("mTotalRunTime", this.mTotalRunTime);
        super.saveNBTData(aNBT);
    }

    public void loadNBTData(NBTTagCompound aNBT) {
        super.loadNBTData(aNBT);
        this.mTotalRunTime = aNBT.func_74763_f("mTotalRunTime");
        if (aNBT.func_74764_b("mVoidExcess")) {
            VoidingMode voidingMode = this.voidingMode = aNBT.func_74767_n("mVoidExcess") ? VoidingMode.VOID_ALL : VoidingMode.VOID_NONE;
        }
        if (aNBT.func_74764_b("mUseMultiparallelMode")) {
            this.batchMode = aNBT.func_74767_n("mUseMultiparallelMode");
        }
    }

    public boolean onRightclick(IGregTechTileEntity aBaseMetaTileEntity, EntityPlayer aPlayer, ForgeDirection side, float aX, float aY, float aZ) {
        ItemStack tCurrentItem;
        if (this.getBaseMetaTileEntity().isServerSide() && (tCurrentItem = aPlayer.field_71071_by.func_70448_g()) != null && tCurrentItem.func_77973_b() instanceof GT_MetaGenerated_Tool) {
            int[] aOreID;
            for (int id : aOreID = OreDictionary.getOreIDs((ItemStack)tCurrentItem)) {
                if (!OreDictionary.getOreName((int)id).equals("craftingToolPlunger")) continue;
                return this.onPlungerRightClick(aPlayer, side, aX, aY, aZ);
            }
        }
        boolean aSuper = super.onRightclick(aBaseMetaTileEntity, aPlayer, side, aX, aY, aZ);
        return aSuper;
    }

    public boolean onPlungerRightClick(EntityPlayer aPlayer, ForgeDirection side, float aX, float aY, float aZ) {
        int aHatchIndex = 0;
        PlayerUtils.messagePlayer(aPlayer, "Trying to clear " + this.mOutputHatches.size() + " output hatches.");
        for (GT_MetaTileEntity_Hatch_Output hatch : this.mOutputHatches) {
            if (hatch.mFluid != null) {
                PlayerUtils.messagePlayer(aPlayer, "Clearing " + hatch.mFluid.amount + "L of " + hatch.mFluid.getLocalizedName() + " from hatch " + aHatchIndex + ".");
                hatch.mFluid = null;
            }
            ++aHatchIndex;
        }
        return aHatchIndex > 0;
    }

    public boolean onWireCutterRightClick(ForgeDirection side, ForgeDirection wrenchingSide, EntityPlayer aPlayer, float aX, float aY, float aZ) {
        if (aPlayer.func_70093_af()) {
            boolean bl = this.batchMode = !this.batchMode;
            if (this.batchMode) {
                GT_Utility.sendChatToPlayer((EntityPlayer)aPlayer, (String)StatCollector.func_74838_a((String)"misc.BatchModeTextOn"));
            } else {
                GT_Utility.sendChatToPlayer((EntityPlayer)aPlayer, (String)StatCollector.func_74838_a((String)"misc.BatchModeTextOff"));
            }
            return true;
        }
        return false;
    }

    public boolean onSolderingToolRightClick(ForgeDirection side, ForgeDirection wrenchingSide, EntityPlayer aPlayer, float aX, float aY, float aZ) {
        if (this.supportsVoidProtection()) {
            Set allowed = this.getAllowedVoidingModes();
            this.setVoidingMode(this.getVoidingMode().nextInCollection((Collection)allowed));
            GT_Utility.sendChatToPlayer((EntityPlayer)aPlayer, (String)(StatCollector.func_74838_a((String)"GT5U.gui.button.voiding_mode") + " " + StatCollector.func_74838_a((String)this.getVoidingMode().getTransKey())));
            return true;
        }
        return super.onSolderingToolRightClick(side, wrenchingSide, aPlayer, aX, aY, aZ);
    }

    public void onServerStart() {
        super.onServerStart();
        this.tryTickWaitTimerDown();
    }

    public void onFirstTick(IGregTechTileEntity aBaseMetaTileEntity) {
        super.onFirstTick(aBaseMetaTileEntity);
        this.tryTickWaitTimerDown();
    }

    public void onPreTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        super.onPreTick(aBaseMetaTileEntity, aTick);
        this.tryTickWaitTimerDown();
    }

    public void onCreated(ItemStack aStack, World aWorld, EntityPlayer aPlayer) {
        super.onCreated(aStack, aWorld, aPlayer);
        this.tryTickWaitTimerDown();
    }

    private void tryTickWaitTimerDown() {
    }

    public static <T> IStructureElement<T> addTieredBlock(Block aBlock, BiConsumer<T, Integer> aSetTheMeta, Function<T, Integer> aGetTheMeta, int maxMeta) {
        return GregtechMeta_MultiBlockBase.addTieredBlock(aBlock, (T t, Integer i) -> {
            aSetTheMeta.accept((Object)t, (Integer)i);
            return true;
        }, aGetTheMeta, 0, maxMeta);
    }

    public static <T> IStructureElement<T> addTieredBlock(Block aBlock, BiConsumer<T, Integer> aSetTheMeta, Function<T, Integer> aGetTheMeta, int minMeta, int maxMeta) {
        return GregtechMeta_MultiBlockBase.addTieredBlock(aBlock, (T t, Integer i) -> {
            aSetTheMeta.accept((Object)t, (Integer)i);
            return true;
        }, aGetTheMeta, minMeta, maxMeta);
    }

    public static <T> IStructureElement<T> addTieredBlock(final Block aBlock, final BiPredicate<T, Integer> aSetTheMeta, final Function<T, Integer> aGetTheMeta, final int minMeta, final int maxMeta) {
        return new IStructureElement<T>(){

            public boolean check(T t, World world, int x, int y, int z) {
                Block tBlock = world.func_147439_a(x, y, z);
                if (aBlock == tBlock) {
                    Integer currentMeta = (Integer)aGetTheMeta.apply(t);
                    int newMeta = tBlock.func_149643_k(world, x, y, z) + 1;
                    if (newMeta > maxMeta || newMeta < minMeta + 1) {
                        return false;
                    }
                    if (currentMeta == 0) {
                        return aSetTheMeta.test(t, newMeta);
                    }
                    return currentMeta == newMeta;
                }
                return false;
            }

            public boolean spawnHint(T t, World world, int x, int y, int z, ItemStack trigger) {
                StructureLibAPI.hintParticle((World)world, (int)x, (int)y, (int)z, (Block)aBlock, (int)this.getMeta(trigger));
                return true;
            }

            public boolean placeBlock(T t, World world, int x, int y, int z, ItemStack trigger) {
                return world.func_147465_d(x, y, z, aBlock, this.getMeta(trigger), 3);
            }

            private int getMeta(ItemStack trigger) {
                int meta = trigger.field_77994_a;
                if (meta <= 0) {
                    meta = minMeta;
                }
                if (meta + minMeta >= maxMeta) {
                    meta = maxMeta - 1 - minMeta;
                }
                return meta + minMeta;
            }

            @Nullable
            public IStructureElement.BlocksToPlace getBlocksToPlace(T t, World world, int x, int y, int z, ItemStack trigger, AutoPlaceEnvironment env) {
                return IStructureElement.BlocksToPlace.create((Block)aBlock, (int)this.getMeta(trigger));
            }

            public IStructureElement.PlaceResult survivalPlaceBlock(T t, World world, int x, int y, int z, ItemStack trigger, AutoPlaceEnvironment env) {
                if (world.func_147439_a(x, y, z) == aBlock) {
                    if (world.func_72805_g(x, y, z) == this.getMeta(trigger)) {
                        return IStructureElement.PlaceResult.SKIP;
                    }
                    return IStructureElement.PlaceResult.REJECT;
                }
                return StructureUtility.survivalPlaceBlock((Block)aBlock, (int)this.getMeta(trigger), (World)world, (int)x, (int)y, (int)z, (IItemSource)env.getSource(), (EntityPlayer)env.getActor(), (Consumer)env.getChatter());
            }
        };
    }

    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, ForgeDirection side, ForgeDirection facing, int aColorIndex, boolean aActive, boolean aRedstone) {
        if (side == facing) {
            if (aActive) {
                return new ITexture[]{this.getCasingTexture(), TextureFactory.builder().addIcon(new IIconContainer[]{this.getActiveOverlay()}).extFacing().build()};
            }
            return new ITexture[]{this.getCasingTexture(), TextureFactory.builder().addIcon(new IIconContainer[]{this.getInactiveOverlay()}).extFacing().build()};
        }
        return new ITexture[]{this.getCasingTexture()};
    }

    protected IIconContainer getActiveOverlay() {
        return null;
    }

    protected IIconContainer getInactiveOverlay() {
        return null;
    }

    protected ITexture getCasingTexture() {
        return Textures.BlockIcons.getCasingTextureForId((int)this.getCasingTextureId());
    }

    protected int getCasingTextureId() {
        return 0;
    }

    public void addUIWidgets(ModularWindow.Builder builder, UIBuildContext buildContext) {
        if (this.doesBindPlayerInventory()) {
            super.addUIWidgets(builder, buildContext);
        } else {
            this.addNoPlayerInventoryUI(builder, buildContext);
        }
    }

    public boolean supportsVoidProtection() {
        return true;
    }

    public boolean supportsBatchMode() {
        return true;
    }

    protected void addNoPlayerInventoryUI(ModularWindow.Builder builder, UIBuildContext buildContext) {
        builder.widget(new DrawableWidget().setDrawable((IDrawable)GT_UITextures.PICTURE_SCREEN_BLACK).setPos(3, 4).setSize(152, 159));
        for (int i = 0; i < 9; ++i) {
            builder.widget(new DrawableWidget().setDrawable((IDrawable)GT_UITextures.BUTTON_STANDARD).setPos(155, 3 + i * 18).setSize(18, 18));
        }
        DynamicPositionedColumn screenElements = new DynamicPositionedColumn();
        this.drawTextsNoPlayerInventory(screenElements);
        builder.widget((Widget)screenElements);
        this.setupToolDisplay();
        ((ModularWindow.Builder)builder.widget(new ItemDrawable(() -> mToolStacks.get(this.mWrench + "WRENCH")).asWidget().setPos(156, 58))).widget((Widget)new FakeSyncWidget.BooleanSyncer(() -> this.mWrench, val -> {
            this.mWrench = val;
        }));
        ((ModularWindow.Builder)builder.widget(new ItemDrawable(() -> mToolStacks.get(this.mCrowbar + "CROWBAR")).asWidget().setPos(156, 76))).widget((Widget)new FakeSyncWidget.BooleanSyncer(() -> this.mCrowbar, val -> {
            this.mCrowbar = val;
        }));
        ((ModularWindow.Builder)((ModularWindow.Builder)builder.widget(new ItemDrawable(() -> mToolStacks.get(this.mHardHammer + "HARDHAMMER")).asWidget().setPos(156, 94))).widget(new TextWidget("H").setDefaultColor(((Integer)this.COLOR_TEXT_WHITE.get()).intValue()).setPos(167, 103))).widget((Widget)new FakeSyncWidget.BooleanSyncer(() -> this.mHardHammer, val -> {
            this.mHardHammer = val;
        }));
        ((ModularWindow.Builder)((ModularWindow.Builder)builder.widget(new ItemDrawable(() -> mToolStacks.get(this.mSoftHammer + "SOFTHAMMER")).asWidget().setPos(156, 112))).widget(new TextWidget("M").setDefaultColor(((Integer)this.COLOR_TEXT_WHITE.get()).intValue()).setPos(167, 121))).widget((Widget)new FakeSyncWidget.BooleanSyncer(() -> this.mSoftHammer, val -> {
            this.mSoftHammer = val;
        }));
        ((ModularWindow.Builder)builder.widget(new ItemDrawable(() -> mToolStacks.get(this.mScrewdriver + "SCREWDRIVER")).asWidget().setPos(156, 130))).widget((Widget)new FakeSyncWidget.BooleanSyncer(() -> this.mScrewdriver, val -> {
            this.mScrewdriver = val;
        }));
        ((ModularWindow.Builder)builder.widget(new ItemDrawable(() -> mToolStacks.get(this.mSolderingTool + "SOLDERING_IRON_LV")).asWidget().setPos(156, 148))).widget((Widget)new FakeSyncWidget.BooleanSyncer(() -> this.mSolderingTool, val -> {
            this.mSolderingTool = val;
        }));
        ((ModularWindow.Builder)((ModularWindow.Builder)builder.widget(new ItemDrawable(() -> mToolStacks.get(this.getBaseMetaTileEntity().isActive() + "GLASS")).asWidget().setPos(156, 22))).widget(TextWidget.dynamicString(() -> this.getBaseMetaTileEntity().isActive() ? "On" : "Off").setSynced(false).setDefaultColor(((Integer)this.COLOR_TEXT_WHITE.get()).intValue()).setPos(157, 31))).widget((Widget)new FakeSyncWidget.BooleanSyncer(() -> this.getBaseMetaTileEntity().isActive(), val -> this.getBaseMetaTileEntity().setActive(val.booleanValue())));
    }

    protected void drawTextsNoPlayerInventory(DynamicPositionedColumn screenElements) {
        screenElements.setSynced(false).setSpace(0).setPos(6, 7);
        ((Column)((Column)((Column)((Column)((Column)((Column)((Column)((Column)((Column)((Column)((Column)((Column)((Column)((Column)((Column)((Column)((Column)((Column)((Column)((Column)((Column)((Column)((Column)screenElements.widget(new TextWidget(GT_Utility.trans((String)"138", (String)"Incomplete Structure.")).setDefaultColor(((Integer)this.COLOR_TEXT_WHITE.get()).intValue()).setEnabled(widget -> !this.mMachine))).widget((Widget)new FakeSyncWidget.BooleanSyncer(() -> this.mMachine, val -> {
            this.mMachine = val;
        }))).widget(TextWidget.dynamicString(() -> StatCollector.func_74838_a((String)"GTPP.machines.input") + " " + StatCollector.func_74838_a((String)"GTPP.machines.tier") + ": " + EnumChatFormatting.GREEN + GT_Values.VOLTAGE_NAMES[(int)this.getInputTier()]).setDefaultColor(((Integer)this.COLOR_TEXT_WHITE.get()).intValue()).setEnabled(widget -> this.mMachine && this.getInputTier() > 0L))).widget(TextWidget.dynamicString(() -> StatCollector.func_74838_a((String)"GTPP.machines.output") + " " + StatCollector.func_74838_a((String)"GTPP.machines.tier") + ": " + EnumChatFormatting.GREEN + GT_Values.VOLTAGE_NAMES[(int)this.getOutputTier()]).setDefaultColor(((Integer)this.COLOR_TEXT_WHITE.get()).intValue()).setEnabled(widget -> this.mMachine && this.getOutputTier() > 0L))).widget(TextWidget.dynamicString(() -> StatCollector.func_74838_a((String)"GTPP.multiblock.progress") + ": " + EnumChatFormatting.GREEN + this.getBaseMetaTileEntity().getProgress() / 20 + EnumChatFormatting.RESET + " s / " + EnumChatFormatting.YELLOW + this.getBaseMetaTileEntity().getMaxProgress() / 20 + EnumChatFormatting.RESET + " s").setDefaultColor(((Integer)this.COLOR_TEXT_WHITE.get()).intValue()).setEnabled(widget -> this.mMachine))).widget(new TextWidget(StatCollector.func_74838_a((String)"GTPP.multiblock.energy") + ":").setDefaultColor(((Integer)this.COLOR_TEXT_WHITE.get()).intValue()).setEnabled(widget -> this.mMachine))).widget(TextWidget.dynamicString(() -> StatCollector.func_74838_a((String)("" + EnumChatFormatting.GREEN + this.getStoredEnergyInAllEnergyHatches() + EnumChatFormatting.RESET + " EU / " + EnumChatFormatting.YELLOW + this.getMaxEnergyStorageOfAllEnergyHatches() + EnumChatFormatting.RESET + " EU"))).setDefaultColor(((Integer)this.COLOR_TEXT_WHITE.get()).intValue()).setEnabled(widget -> this.mMachine))).widget(new TextWidget(StatCollector.func_74838_a((String)"GTPP.multiblock.usage") + ":").setDefaultColor(((Integer)this.COLOR_TEXT_WHITE.get()).intValue()).setEnabled(widget -> this.mMachine && this.getLastRecipeEU() > 0 && this.getLastRecipeDuration() > 0))).widget(TextWidget.dynamicString(() -> StatCollector.func_74838_a((String)("" + EnumChatFormatting.RED + -this.getLastRecipeEU() + EnumChatFormatting.RESET + " EU/t/parallel"))).setDefaultColor(((Integer)this.COLOR_TEXT_WHITE.get()).intValue()).setEnabled(widget -> this.mMachine && this.getLastRecipeEU() > 0 && this.getLastRecipeDuration() > 0))).widget(TextWidget.dynamicString(() -> StatCollector.func_74838_a((String)"GTPP.multiblock.generation") + ":").setDefaultColor(((Integer)this.COLOR_TEXT_WHITE.get()).intValue()).setEnabled(widget -> this.mMachine && this.getLastRecipeEU() < 0 && this.getLastRecipeDuration() > 0))).widget(TextWidget.dynamicString(() -> StatCollector.func_74838_a((String)("" + EnumChatFormatting.GREEN + this.getLastRecipeEU() + EnumChatFormatting.RESET + " EU/t/parallel"))).setDefaultColor(((Integer)this.COLOR_TEXT_WHITE.get()).intValue()).setEnabled(widget -> this.mMachine && this.getLastRecipeEU() < 0 && this.getLastRecipeDuration() > 0))).widget(TextWidget.dynamicString(() -> StatCollector.func_74838_a((String)"GTPP.multiblock.duration") + ": " + EnumChatFormatting.RED + this.getLastRecipeDuration() + EnumChatFormatting.RESET + " ticks").setDefaultColor(((Integer)this.COLOR_TEXT_WHITE.get()).intValue()).setEnabled(widget -> this.mMachine && this.getLastRecipeEU() != 0 && this.getLastRecipeDuration() > 0))).widget(TextWidget.dynamicString(() -> StatCollector.func_74838_a((String)"GTPP.multiblock.specialvalue") + ": " + EnumChatFormatting.RED + this.getLastRecipeEU() + EnumChatFormatting.RESET + "").setDefaultColor(((Integer)this.COLOR_TEXT_WHITE.get()).intValue()).setEnabled(widget -> this.mMachine && this.getLastRecipeEU() != 0 && this.getLastRecipeDuration() > 0 && (this.mLastRecipe != null ? this.mLastRecipe.mSpecialValue : 0) > 0))).widget(new TextWidget(StatCollector.func_74838_a((String)"GTPP.multiblock.mei") + ":").setDefaultColor(((Integer)this.COLOR_TEXT_WHITE.get()).intValue()).setEnabled(widget -> this.mMachine))).widget(TextWidget.dynamicString(() -> StatCollector.func_74838_a((String)("" + EnumChatFormatting.YELLOW + this.getMaxInputVoltage() + EnumChatFormatting.RESET + " EU/t(*2A) " + StatCollector.func_74838_a((String)"GTPP.machines.tier") + ": " + EnumChatFormatting.YELLOW + GT_Values.VN[GT_Utility.getTier((long)this.getMaxInputVoltage())] + EnumChatFormatting.RESET))).setDefaultColor(((Integer)this.COLOR_TEXT_WHITE.get()).intValue()).setEnabled(widget -> this.mMachine))).widget(TextWidget.dynamicString(() -> StatCollector.func_74838_a((String)"GTPP.multiblock.efficiency") + ": " + EnumChatFormatting.YELLOW + (float)this.mEfficiency / 100.0f + EnumChatFormatting.RESET + " %").setDefaultColor(((Integer)this.COLOR_TEXT_WHITE.get()).intValue()).setEnabled(widget -> this.mMachine))).widget(TextWidget.dynamicString(() -> StatCollector.func_74838_a((String)"GTPP.multiblock.pollution") + ": " + EnumChatFormatting.RED + this.getPollutionPerTick(null) * 20 + EnumChatFormatting.RESET + "/sec").setDefaultColor(((Integer)this.COLOR_TEXT_WHITE.get()).intValue()).setEnabled(widget -> this.mMachine))).widget(TextWidget.dynamicString(() -> StatCollector.func_74838_a((String)"GTPP.multiblock.pollutionreduced") + ": " + EnumChatFormatting.GREEN + this.getPollutionReductionForAllMufflers() + EnumChatFormatting.RESET + " %").setDefaultColor(((Integer)this.COLOR_TEXT_WHITE.get()).intValue()).setEnabled(widget -> this.mMachine))).widget(new TextWidget("Total Time Since Built: ").setDefaultColor(((Integer)this.COLOR_TEXT_WHITE.get()).intValue()).setEnabled(widget -> this.mMachine))).widget(TextWidget.dynamicString(() -> "" + EnumChatFormatting.DARK_GREEN + this.getRuntimeWeeksDisplay() + EnumChatFormatting.RESET + " Weeks,").setDefaultColor(((Integer)this.COLOR_TEXT_WHITE.get()).intValue()).setEnabled(widget -> this.mMachine))).widget(TextWidget.dynamicString(() -> "" + EnumChatFormatting.DARK_GREEN + this.getRuntimeDaysDisplay() + EnumChatFormatting.RESET + " Days,").setDefaultColor(((Integer)this.COLOR_TEXT_WHITE.get()).intValue()).setEnabled(widget -> this.mMachine))).widget(TextWidget.dynamicString(() -> "" + EnumChatFormatting.DARK_GREEN + this.getRuntimeHoursDisplay() + EnumChatFormatting.RESET + " Hours,").setDefaultColor(((Integer)this.COLOR_TEXT_WHITE.get()).intValue()).setEnabled(widget -> this.mMachine))).widget(TextWidget.dynamicString(() -> "" + EnumChatFormatting.DARK_GREEN + this.getRuntimeMinutesDisplay() + EnumChatFormatting.RESET + " Minutes,").setDefaultColor(((Integer)this.COLOR_TEXT_WHITE.get()).intValue()).setEnabled(widget -> this.mMachine))).widget(TextWidget.dynamicString(() -> "" + EnumChatFormatting.DARK_GREEN + this.getRuntimeSecondsDisplay() + EnumChatFormatting.RESET + " Seconds").setDefaultColor(((Integer)this.COLOR_TEXT_WHITE.get()).intValue()).setEnabled(widget -> this.mMachine));
    }

    protected int getLastRecipeEU() {
        return this.mLastRecipe != null ? this.mLastRecipe.mEUt : 0;
    }

    protected int getLastRecipeDuration() {
        return this.mLastRecipe != null ? this.mLastRecipe.mDuration : 0;
    }

    protected long getRuntimeSeconds() {
        return this.getTotalRuntimeInTicks() / 20L;
    }

    protected long getRuntimeWeeksDisplay() {
        return TimeUnit.SECONDS.toDays(this.getRuntimeSeconds()) / 7L;
    }

    protected long getRuntimeDaysDisplay() {
        return TimeUnit.SECONDS.toDays(this.getRuntimeSeconds()) - 7L * this.getRuntimeWeeksDisplay();
    }

    protected long getRuntimeHoursDisplay() {
        return TimeUnit.SECONDS.toHours(this.getRuntimeSeconds()) - TimeUnit.DAYS.toHours(this.getRuntimeDaysDisplay()) - TimeUnit.DAYS.toHours(7L * this.getRuntimeWeeksDisplay());
    }

    protected long getRuntimeMinutesDisplay() {
        return TimeUnit.SECONDS.toMinutes(this.getRuntimeSeconds()) - TimeUnit.SECONDS.toHours(this.getRuntimeSeconds()) * 60L;
    }

    protected long getRuntimeSecondsDisplay() {
        return TimeUnit.SECONDS.toSeconds(this.getRuntimeSeconds()) - TimeUnit.SECONDS.toMinutes(this.getRuntimeSeconds()) * 60L;
    }

    protected void setupToolDisplay() {
        if (!mToolStacks.isEmpty()) {
            return;
        }
        mToolStacks.put("trueWRENCH", GT_MetaGenerated_Tool_01.INSTANCE.getToolWithStats(16, 1, GOOD, Materials.Tungsten, null));
        mToolStacks.put("trueCROWBAR", GT_MetaGenerated_Tool_01.INSTANCE.getToolWithStats(20, 1, GOOD, Materials.Tungsten, null));
        mToolStacks.put("trueHARDHAMMER", GT_MetaGenerated_Tool_01.INSTANCE.getToolWithStats(12, 1, GOOD, Materials.Tungsten, null));
        mToolStacks.put("trueSOFTHAMMER", GT_MetaGenerated_Tool_01.INSTANCE.getToolWithStats(14, 1, GOOD, Materials.Tungsten, null));
        mToolStacks.put("trueSCREWDRIVER", GT_MetaGenerated_Tool_01.INSTANCE.getToolWithStats(22, 1, GOOD, Materials.Tungsten, null));
        mToolStacks.put("trueSOLDERING_IRON_LV", GT_MetaGenerated_Tool_01.INSTANCE.getToolWithStats(160, 1, GOOD, Materials.Tungsten, null));
        mToolStacks.put("falseWRENCH", GT_MetaGenerated_Tool_01.INSTANCE.getToolWithStats(16, 1, BAD, Materials.Tungsten, null));
        mToolStacks.put("falseCROWBAR", GT_MetaGenerated_Tool_01.INSTANCE.getToolWithStats(20, 1, BAD, Materials.Tungsten, null));
        mToolStacks.put("falseHARDHAMMER", GT_MetaGenerated_Tool_01.INSTANCE.getToolWithStats(12, 1, BAD, Materials.Tungsten, null));
        mToolStacks.put("falseSOFTHAMMER", GT_MetaGenerated_Tool_01.INSTANCE.getToolWithStats(14, 1, BAD, Materials.Tungsten, null));
        mToolStacks.put("falseSCREWDRIVER", GT_MetaGenerated_Tool_01.INSTANCE.getToolWithStats(22, 1, BAD, Materials.Tungsten, null));
        mToolStacks.put("falseSOLDERING_IRON_LV", GT_MetaGenerated_Tool_01.INSTANCE.getToolWithStats(160, 1, BAD, Materials.Tungsten, null));
        ItemStack aGlassPane1 = ItemUtils.getItemStackOfAmountFromOreDict("paneGlassRed", 1);
        ItemStack aGlassPane2 = ItemUtils.getItemStackOfAmountFromOreDict("paneGlassLime", 1);
        mToolStacks.put("falseGLASS", aGlassPane1);
        mToolStacks.put("trueGLASS", aGlassPane2);
    }

    public static enum GTPPHatchElement implements IHatchElement<GregtechMeta_MultiBlockBase<?>>
    {
        AirIntake(GregtechMeta_MultiBlockBase::addAirIntakeToMachineList, new Class[]{GT_MetaTileEntity_Hatch_AirIntake.class}){

            public long count(GregtechMeta_MultiBlockBase<?> t) {
                return t.mAirIntakes.size();
            }
        }
        ,
        TTDynamo(GregtechMeta_MultiBlockBase::addMultiAmpDynamoToMachineList, new String[]{"com.github.technus.tectech.thing.metaTileEntity.hatch.GT_MetaTileEntity_Hatch_DynamoMulti"}){

            public long count(GregtechMeta_MultiBlockBase<?> t) {
                return t.mTecTechDynamoHatches.size();
            }
        }
        ,
        TTEnergy(GregtechMeta_MultiBlockBase::addMultiAmpEnergyToMachineList, new String[]{"com.github.technus.tectech.thing.metaTileEntity.hatch.GT_MetaTileEntity_Hatch_EnergyMulti"}){

            public long count(GregtechMeta_MultiBlockBase<?> t) {
                return t.mTecTechEnergyHatches.size();
            }
        };

        private final List<? extends Class<? extends IMetaTileEntity>> mMteClasses;
        private final IGT_HatchAdder<? super GregtechMeta_MultiBlockBase<?>> mAdder;

        private static <T> Class<T> retype(Class<?> clazz) {
            return clazz;
        }

        @SafeVarargs
        private GTPPHatchElement(IGT_HatchAdder<? super GregtechMeta_MultiBlockBase<?>> aAdder, Class<? extends IMetaTileEntity> ... aMteClasses) {
            this.mMteClasses = Arrays.asList(aMteClasses);
            this.mAdder = aAdder;
        }

        private GTPPHatchElement(IGT_HatchAdder<? super GregtechMeta_MultiBlockBase<?>> aAdder, String ... aClassNames) {
            this.mMteClasses = Arrays.stream(aClassNames).map(ReflectionUtils::getClass).filter(Objects::nonNull).map(GTPPHatchElement::retype).collect(Collectors.toList());
            this.mAdder = aAdder;
        }

        public List<? extends Class<? extends IMetaTileEntity>> mteClasses() {
            return this.mMteClasses;
        }

        public IGT_HatchAdder<? super GregtechMeta_MultiBlockBase<?>> adder() {
            return this.mAdder;
        }
    }
}

