/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.renderer.element;

import net.malisis.core.util.Point;
import net.minecraft.util.AxisAlignedBB;
import net.minecraftforge.common.util.ForgeDirection;
import org.lwjgl.util.vector.Matrix4f;
import org.lwjgl.util.vector.Vector4f;

public class Vertex {
    public static final int BRIGHTNESS_MAX = 0xF000F0;
    private String baseName;
    private double x = 0.0;
    private double y = 0.0;
    private double z = 0.0;
    private int brightness = 0;
    private int color = 0xFFFFFF;
    private int alpha = 255;
    private double u = 0.0;
    private double v = 0.0;
    private Vertex initialState;

    public Vertex(double x, double y, double z, int rgba, int brightness, double u, double v, boolean isInitialState) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.color = rgba >>> 8 & 0xFFFFFF;
        this.alpha = rgba & 0xFF;
        this.brightness = brightness;
        this.u = u;
        this.v = v;
        this.baseName();
        if (!isInitialState) {
            this.initialState = new Vertex(x, y, z, rgba, brightness, u, v, true);
        }
    }

    public Vertex(double x, double y, double z, int rgba, int brightness) {
        this(x, y, z, rgba, brightness, 0.0, 0.0, false);
    }

    public Vertex(double x, double y, double z) {
        this(x, y, z, -1, 0xF000F0, 0.0, 0.0, false);
    }

    public Vertex(Vertex vertex) {
        this(vertex.x, vertex.y, vertex.z, vertex.color << 8 | vertex.alpha, vertex.brightness, vertex.u, vertex.v, false);
        this.baseName = vertex.baseName;
    }

    public Vertex(Vertex vertex, int rgba, int brightness) {
        this(vertex.x, vertex.y, vertex.z, rgba, brightness);
    }

    public Vertex(Vertex vertex, int rgba, int brightness, float u, float v) {
        this(vertex.x, vertex.y, vertex.z, rgba, brightness, u, v, false);
    }

    public double getX() {
        return this.x;
    }

    public int getIntX() {
        return (int)Math.round(this.x);
    }

    public Vertex setX(double x) {
        this.x = x;
        return this;
    }

    public double getY() {
        return this.y;
    }

    public int getIntY() {
        return (int)Math.round(this.y);
    }

    public Vertex setY(double y) {
        this.y = y;
        return this;
    }

    public double getZ() {
        return this.z;
    }

    public int getIntZ() {
        return (int)Math.round(this.z);
    }

    public Vertex setZ(double z) {
        this.z = z;
        return this;
    }

    public void set(double x, double y, double z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public void limit(double min, double max) {
        this.x = Vertex.clamp(this.x, min, max);
        this.y = Vertex.clamp(this.y, min, max);
        this.z = Vertex.clamp(this.z, min, max);
    }

    public void interpolateCoord(AxisAlignedBB bounds) {
        if (bounds == null) {
            return;
        }
        double fx = bounds.field_72336_d - bounds.field_72340_a;
        double fy = bounds.field_72337_e - bounds.field_72338_b;
        double fz = bounds.field_72334_f - bounds.field_72339_c;
        this.x = this.x * fx + bounds.field_72340_a;
        this.y = this.y * fy + bounds.field_72338_b;
        this.z = this.z * fz + bounds.field_72339_c;
    }

    public Vertex add(double x, double y, double z) {
        this.x += x;
        this.y += y;
        this.z += z;
        return this;
    }

    public Vertex factorX(float f) {
        this.x *= (double)f;
        return this;
    }

    public Vertex factorY(float f) {
        this.y *= (double)f;
        return this;
    }

    public Vertex factorZ(float f) {
        this.z *= (double)f;
        return this;
    }

    public Vertex factor(float f) {
        this.factorX(f);
        this.factorY(f);
        this.factorZ(f);
        return this;
    }

    public Vertex scale(float f) {
        return this.scale(f, 0.5, 0.5, 0.5);
    }

    public Vertex scale(float f, double centerX, double centerY, double centerZ) {
        this.x = (this.x - centerX) * (double)f + centerX;
        this.y = (this.y - centerY) * (double)f + centerY;
        this.z = (this.z - centerZ) * (double)f + centerZ;
        return this;
    }

    public Vertex rotateAroundX(double angle) {
        return this.rotateAroundX(angle, 0.5, 0.5, 0.5);
    }

    public Vertex rotateAroundX(double angle, double centerX, double centerY, double centerZ) {
        angle = Math.toRadians(angle);
        double ty = this.y - centerY;
        double tz = this.z - centerZ;
        this.y = ty * Math.cos(angle) - tz * Math.sin(angle);
        this.z = ty * Math.sin(angle) + tz * Math.cos(angle);
        this.y += centerY;
        this.z += centerZ;
        return this;
    }

    public Vertex rotateAroundY(double angle) {
        return this.rotateAroundY(angle, 0.5, 0.5, 0.5);
    }

    public Vertex rotateAroundY(double angle, double centerX, double centerY, double centerZ) {
        angle = Math.toRadians(angle);
        double tx = this.x - centerX;
        double tz = this.z - centerZ;
        this.x = tx * Math.cos(angle) + tz * Math.sin(angle);
        this.z = -tx * Math.sin(angle) + tz * Math.cos(angle);
        this.x += centerX;
        this.z += centerZ;
        return this;
    }

    public Vertex rotateAroundZ(double angle) {
        return this.rotateAroundZ(angle, 0.5, 0.5, 0.5);
    }

    public Vertex rotateAroundZ(double angle, double centerX, double centerY, double centerZ) {
        angle = Math.toRadians(angle);
        double tx = this.x - centerX;
        double ty = this.y - centerY;
        this.x = tx * Math.cos(angle) - ty * Math.sin(angle);
        this.y = tx * Math.sin(angle) + ty * Math.cos(angle);
        this.x += centerX;
        this.y += centerY;
        return this;
    }

    public Vertex setColor(int color) {
        this.color = color;
        return this;
    }

    public int getColor() {
        return this.color;
    }

    public Vertex setAlpha(int alpha) {
        this.alpha = alpha;
        return this;
    }

    public int getAlpha() {
        return this.alpha;
    }

    public Vertex setBrightness(int brightness) {
        this.brightness = brightness;
        return this;
    }

    public int getBrightness() {
        return this.brightness;
    }

    public void setUV(float u, float v) {
        this.u = u;
        this.v = v;
    }

    public double getU() {
        return this.u;
    }

    public double getV() {
        return this.v;
    }

    public void limitU(float min, float max) {
        this.u = Math.max(Math.min(this.u, (double)max), (double)min);
    }

    public void limitV(float min, float max) {
        this.v = Math.max(Math.min(this.v, (double)max), (double)min);
    }

    public boolean isCorner() {
        return !(this.x != 1.0 && this.x != 0.0 || this.y != 1.0 && this.y != 0.0 || this.z != 1.0 && this.z != 0.0);
    }

    public Vertex setBaseName(String name) {
        this.baseName = name;
        return this;
    }

    public String baseName() {
        if (this.baseName == null) {
            this.baseName = "";
            if (this.isCorner()) {
                this.baseName = (this.y == 1.0 ? "Top" : "Bottom") + (this.z == 1.0 ? "South" : "North") + (this.x == 1.0 ? "East" : "West");
            }
        }
        return this.baseName;
    }

    public String name() {
        return this.baseName() + " [" + this.x + ", " + this.y + ", " + this.z + "|" + this.u + ", " + this.v + "]";
    }

    public String toString() {
        return this.name() + " 0x" + Integer.toHexString(this.color) + " (a:" + this.alpha + ", b:" + this.brightness + ")";
    }

    public Point toPoint() {
        return new Point(this.x, this.y, this.z);
    }

    public static double clamp(double value) {
        return Vertex.clamp(value, 0.0, 1.0);
    }

    public static double clamp(double value, double min, double max) {
        if (value < min) {
            return min;
        }
        if (value > max) {
            return max;
        }
        return value;
    }

    public void applyMatrix(Matrix4f transformMatrix) {
        Vector4f vec = new Vector4f((float)this.x, (float)this.y, (float)this.z, 1.0f);
        Matrix4f.transform((Matrix4f)transformMatrix, (Vector4f)vec, (Vector4f)vec);
        this.x = vec.x;
        this.y = vec.y;
        this.z = vec.z;
    }

    private void setState(Vertex vertex) {
        this.x = vertex.x;
        this.y = vertex.y;
        this.z = vertex.z;
        this.brightness = vertex.alpha;
        this.color = vertex.color;
        this.alpha = vertex.alpha;
        this.u = vertex.u;
        this.v = vertex.v;
    }

    public void setInitialState() {
        this.initialState.setState(this);
    }

    public void resetState() {
        this.setState(this.initialState);
    }

    public int[][] getAoMatrix(ForgeDirection offset) {
        int[][] a = new int[3][3];
        if (offset == ForgeDirection.WEST || offset == ForgeDirection.EAST) {
            int n = offset.offsetX;
            a[2][0] = n;
            a[1][0] = n;
            a[0][0] = n;
            int[] nArray = a[1];
            nArray[1] = (int)((long)nArray[1] + Math.round(this.y * 2.0 - 1.0));
            int[] nArray2 = a[2];
            nArray2[1] = (int)((long)nArray2[1] + Math.round(this.y * 2.0 - 1.0));
            int[] nArray3 = a[0];
            nArray3[2] = (int)((long)nArray3[2] + Math.round(this.z * 2.0 - 1.0));
            int[] nArray4 = a[1];
            nArray4[2] = (int)((long)nArray4[2] + Math.round(this.z * 2.0 - 1.0));
        } else if (offset == ForgeDirection.UP || offset == ForgeDirection.DOWN) {
            int n = offset.offsetY;
            a[2][1] = n;
            a[1][1] = n;
            a[0][1] = n;
            int[] nArray = a[1];
            nArray[0] = (int)((long)nArray[0] + Math.round(this.x * 2.0 - 1.0));
            int[] nArray5 = a[2];
            nArray5[0] = (int)((long)nArray5[0] + Math.round(this.x * 2.0 - 1.0));
            int[] nArray6 = a[0];
            nArray6[2] = (int)((long)nArray6[2] + Math.round(this.z * 2.0 - 1.0));
            int[] nArray7 = a[1];
            nArray7[2] = (int)((long)nArray7[2] + Math.round(this.z * 2.0 - 1.0));
        } else if (offset == ForgeDirection.NORTH || offset == ForgeDirection.SOUTH) {
            int n = offset.offsetZ;
            a[2][2] = n;
            a[1][2] = n;
            a[0][2] = n;
            int[] nArray = a[1];
            nArray[0] = (int)((long)nArray[0] + Math.round(this.x * 2.0 - 1.0));
            int[] nArray8 = a[2];
            nArray8[0] = (int)((long)nArray8[0] + Math.round(this.x * 2.0 - 1.0));
            int[] nArray9 = a[0];
            nArray9[1] = (int)((long)nArray9[1] + Math.round(this.y * 2.0 - 1.0));
            int[] nArray10 = a[1];
            nArray10[1] = (int)((long)nArray10[1] + Math.round(this.y * 2.0 - 1.0));
        }
        return a;
    }

    public static class BottomSouthEast
    extends Vertex {
        public BottomSouthEast() {
            super(1.0, 0.0, 1.0);
        }
    }

    public static class BottomSouthWest
    extends Vertex {
        public BottomSouthWest() {
            super(0.0, 0.0, 1.0);
        }
    }

    public static class BottomNorthEast
    extends Vertex {
        public BottomNorthEast() {
            super(1.0, 0.0, 0.0);
        }
    }

    public static class BottomNorthWest
    extends Vertex {
        public BottomNorthWest() {
            super(0.0, 0.0, 0.0);
        }
    }

    public static class TopSouthEast
    extends Vertex {
        public TopSouthEast() {
            super(1.0, 1.0, 1.0);
        }
    }

    public static class TopSouthWest
    extends Vertex {
        public TopSouthWest() {
            super(0.0, 1.0, 1.0);
        }
    }

    public static class TopNorthEast
    extends Vertex {
        public TopNorthEast() {
            super(1.0, 1.0, 0.0);
        }
    }

    public static class TopNorthWest
    extends Vertex {
        public TopNorthWest() {
            super(0.0, 1.0, 0.0);
        }
    }
}

