/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.gtnhintergalactic.nei;

import codechicken.lib.gui.GuiDraw;
import codechicken.nei.PositionedStack;
import codechicken.nei.recipe.TemplateRecipeHandler;
import com.gtnewhorizons.gtnhintergalactic.gui.IG_UITextures;
import com.gtnewhorizons.gtnhintergalactic.recipe.SpacePumpingRecipes;
import com.gtnewhorizons.modularui.api.GlStateManager;
import com.gtnewhorizons.modularui.api.UIInfos;
import com.gtnewhorizons.modularui.api.drawable.IDrawable;
import com.gtnewhorizons.modularui.api.math.Pos2d;
import com.gtnewhorizons.modularui.api.screen.ModularWindow;
import com.gtnewhorizons.modularui.api.widget.Widget;
import com.gtnewhorizons.modularui.common.widget.DrawableWidget;
import gregtech.api.gui.modularui.GT_UITextures;
import gregtech.api.util.GT_Utility;
import java.awt.Rectangle;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import org.apache.commons.lang3.tuple.Pair;

public class SpacePumpModuleRecipeHandler
extends TemplateRecipeHandler {
    private static final String SEE_ALL = "ig.nei.elevatorpump.see_all";
    protected final ModularWindow modularWindow = ((ModularWindow.Builder)ModularWindow.builder((int)170, (int)82).setBackground(new IDrawable[]{GT_UITextures.BACKGROUND_NEI_SINGLE_RECIPE}).widget(new DrawableWidget().setDrawable((IDrawable)IG_UITextures.PICTURE_ELEVATOR_LOGO).setSize(17, 17).setPos(new Pos2d(147, 52)))).build();
    private static final Pos2d WINDOW_OFFSET = new Pos2d(-2, -8);
    private static final int CATEGORY_TITLE_X = 30;
    private static final int CATEGORY_VALUE_X = 85;
    private static final int PLANET_TYPE_Y = 0;
    private static final int GAS_TYPE_Y = 15;
    private static final int OUT_AMOUNT_Y = 30;
    private static final int TEXT_COLOR = 0x404040;

    public SpacePumpModuleRecipeHandler() {
        UIInfos.initializeWindow((EntityPlayer)Minecraft.func_71410_x().field_71439_g, (ModularWindow)this.modularWindow);
    }

    public int recipiesPerPage() {
        return 3;
    }

    public String getGuiTexture() {
        return "galaxyspace:textures/gui/guiBase.png";
    }

    public void loadTransferRects() {
        int stringLength = GuiDraw.getStringWidth((String)I18n.func_135052_a((String)SEE_ALL, (Object[])new Object[0]));
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(this.getGuiWidth() - stringLength - 3, 26, stringLength, 9), this.getOutputId(), new Object[0]));
    }

    public int getGuiWidth() {
        return 166;
    }

    public void loadCraftingRecipes(String outputId, Object ... results) {
        if (outputId.equals(this.getOutputId())) {
            for (Map.Entry<Pair<Integer, Integer>, FluidStack> entry : SpacePumpingRecipes.RECIPES.entrySet()) {
                this.arecipes.add(new CachedPumpRecipe((Integer)entry.getKey().getLeft(), (Integer)entry.getKey().getRight(), entry.getValue().getFluid(), entry.getValue().amount));
            }
        } else {
            super.loadCraftingRecipes(outputId, results);
        }
    }

    public void drawBackground(int recipe) {
        for (IDrawable background : this.modularWindow.getBackground()) {
            GlStateManager.pushMatrix();
            GlStateManager.translate((float)SpacePumpModuleRecipeHandler.WINDOW_OFFSET.x, (float)SpacePumpModuleRecipeHandler.WINDOW_OFFSET.y, (float)0.0f);
            GlStateManager.color((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            background.draw(Pos2d.ZERO, this.modularWindow.getSize(), 0.0f);
            GlStateManager.popMatrix();
        }
        for (Widget widget : this.modularWindow.getChildren()) {
            GlStateManager.pushMatrix();
            GlStateManager.translate((float)widget.getPos().x, (float)widget.getPos().y, (float)0.0f);
            GlStateManager.color((float)1.0f, (float)1.0f, (float)1.0f, (float)this.modularWindow.getAlpha());
            GlStateManager.enableBlend();
            widget.drawBackground(0.0f);
            widget.draw(0.0f);
            GlStateManager.popMatrix();
        }
    }

    public void loadCraftingRecipes(ItemStack result) {
        FluidStack displayFluid;
        Fluid fluid = null;
        FluidStack containerFluid = GT_Utility.getFluidForFilledItem((ItemStack)result, (boolean)true);
        if (containerFluid != null) {
            fluid = containerFluid.getFluid();
        }
        if (fluid == null && (displayFluid = GT_Utility.getFluidFromDisplayStack((ItemStack)result)) != null) {
            fluid = displayFluid.getFluid();
        }
        if (fluid == null) {
            return;
        }
        for (Map.Entry<Pair<Integer, Integer>, FluidStack> entry : SpacePumpingRecipes.RECIPES.entrySet()) {
            if (!entry.getValue().isFluidEqual(new FluidStack(fluid, 0))) continue;
            this.arecipes.add(new CachedPumpRecipe((Integer)entry.getKey().getLeft(), (Integer)entry.getKey().getRight(), fluid, entry.getValue().amount));
        }
    }

    public void drawExtras(int recipeIndex) {
        GuiDraw.drawStringC((String)(I18n.func_135052_a((String)"ig.nei.elevatorpump.planettype", (Object[])new Object[0]) + ":"), (int)30, (int)0, (int)0x404040, (boolean)false);
        GuiDraw.drawStringC((String)(I18n.func_135052_a((String)"ig.nei.elevatorpump.gastype", (Object[])new Object[0]) + ":"), (int)30, (int)15, (int)0x404040, (boolean)false);
        GuiDraw.drawStringC((String)(I18n.func_135052_a((String)"ig.nei.elevatorpump.amount", (Object[])new Object[0]) + ":"), (int)30, (int)30, (int)0x404040, (boolean)false);
        CachedPumpRecipe recipe = (CachedPumpRecipe)((Object)this.arecipes.get(recipeIndex));
        GuiDraw.drawStringC((String)Integer.toString(recipe.planetType), (int)85, (int)0, (int)0x404040, (boolean)false);
        GuiDraw.drawStringC((String)Integer.toString(recipe.gasType), (int)85, (int)15, (int)0x404040, (boolean)false);
        GuiDraw.drawStringC((String)GT_Utility.formatNumbers((long)recipe.amount), (int)85, (int)30, (int)0x404040, (boolean)false);
        GuiDraw.drawStringR((String)(EnumChatFormatting.BOLD + I18n.func_135052_a((String)SEE_ALL, (Object[])new Object[0])), (int)(this.getGuiWidth() - 3), (int)30, (int)0x404040, (boolean)false);
    }

    public String getOutputId() {
        return "galacticraft.elevatorPump";
    }

    public String getRecipeName() {
        return I18n.func_135052_a((String)"ig.nei.elevatorpump.name", (Object[])new Object[0]);
    }

    private class CachedPumpRecipe
    extends TemplateRecipeHandler.CachedRecipe {
        private final PositionedStack targetFluidDisplay;
        private final int planetType;
        private final int gasType;
        private final int amount;

        private CachedPumpRecipe(int planetType, int gasType, Fluid output, int outputAmount) {
            super((TemplateRecipeHandler)SpacePumpModuleRecipeHandler.this);
            this.targetFluidDisplay = new PositionedStack((Object)GT_Utility.getFluidDisplayStack((Fluid)output), SpacePumpModuleRecipeHandler.this.getGuiWidth() - 19, 0);
            this.planetType = planetType;
            this.gasType = gasType;
            this.amount = outputAmount;
        }

        public PositionedStack getResult() {
            return this.targetFluidDisplay;
        }
    }
}

