/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.teleport.telepad;

import com.enderio.core.common.network.MessageTileEntity;
import com.enderio.core.common.util.BlockCoord;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import crazypants.enderio.EnderIO;
import crazypants.enderio.teleport.telepad.TileTelePad;
import io.netty.buffer.ByteBuf;
import net.minecraft.tileentity.TileEntity;

public class PacketUpdateCoords
extends MessageTileEntity<TileTelePad>
implements IMessageHandler<PacketUpdateCoords, IMessage> {
    private int targetX;
    private int targetY;
    private int targetZ;
    private int targetDim;

    public PacketUpdateCoords() {
    }

    public PacketUpdateCoords(TileTelePad te, int x, int y, int z, int targetDim) {
        super((TileEntity)te);
        this.targetX = x;
        this.targetY = y;
        this.targetZ = z;
        this.targetDim = targetDim;
    }

    public PacketUpdateCoords(TileTelePad te, BlockCoord bc, int targetDim) {
        this(te, bc.x, bc.y, bc.z, targetDim);
    }

    public void toBytes(ByteBuf buf) {
        super.toBytes(buf);
        buf.writeInt(this.targetX);
        buf.writeInt(this.targetY);
        buf.writeInt(this.targetZ);
        buf.writeInt(this.targetDim);
    }

    public void fromBytes(ByteBuf buf) {
        super.fromBytes(buf);
        this.targetX = buf.readInt();
        this.targetY = buf.readInt();
        this.targetZ = buf.readInt();
        this.targetDim = buf.readInt();
    }

    public IMessage onMessage(PacketUpdateCoords message, MessageContext ctx) {
        TileTelePad te = (TileTelePad)message.getTileEntity(ctx.side.isClient() ? EnderIO.proxy.getClientWorld() : message.getWorld(ctx));
        if (te != null) {
            te.setX(message.targetX);
            te.setY(message.targetY);
            te.setZ(message.targetZ);
            te.setTargetDim(message.targetDim);
        }
        return null;
    }
}

