/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.ticks;

import cpw.mods.fml.common.gameevent.TickEvent;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import logisticspipes.network.LPDataInputStream;
import logisticspipes.network.LPDataOutputStream;
import logisticspipes.network.PacketHandler;
import logisticspipes.network.abstractpackets.ModernPacket;
import logisticspipes.network.packets.BufferTransfer;
import logisticspipes.proxy.MainProxy;
import logisticspipes.utils.tuples.Pair;
import net.minecraft.entity.player.EntityPlayer;

public class ServerPacketBufferHandlerThread {
    private final ServerCompressorThread serverCompressorThread = new ServerCompressorThread();
    private final ServerDecompressorThread serverDecompressorThread = new ServerDecompressorThread();

    public void serverTick(TickEvent.ServerTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        this.serverDecompressorThread.serverTickEnd();
    }

    public void setPause(boolean flag) {
        this.serverCompressorThread.setPause(flag);
    }

    public void addPacketToCompressor(ModernPacket packet, EntityPlayer player) {
        this.serverCompressorThread.addPacketToCompressor(packet, player);
    }

    public void handlePacket(byte[] content, EntityPlayer player) {
        this.serverDecompressorThread.handlePacket(content, player);
    }

    private static byte[] compress(byte[] content) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            GZIPOutputStream gzipOutputStream = new GZIPOutputStream(byteArrayOutputStream);
            gzipOutputStream.write(content);
            gzipOutputStream.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return byteArrayOutputStream.toByteArray();
    }

    private static byte[] decompress(byte[] contentBytes) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            int buffer;
            GZIPInputStream gzip = new GZIPInputStream(new ByteArrayInputStream(contentBytes));
            while ((buffer = gzip.read()) != -1) {
                out.write(buffer);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return out.toByteArray();
    }

    public void clear(EntityPlayer player) {
        new Thread(() -> {
            this.serverCompressorThread.clear(player);
            this.serverDecompressorThread.clear(player);
        }).start();
    }

    private static class ServerDecompressorThread
    extends Thread {
        private final HashMap<EntityPlayer, LinkedList<byte[]>> queue = new HashMap();
        private final HashMap<EntityPlayer, byte[]> ByteBuffer = new HashMap();
        private final LinkedList<Pair<EntityPlayer, byte[]>> PacketBuffer = new LinkedList();
        private final Queue<EntityPlayer> playersToClear = new LinkedList<EntityPlayer>();

        public ServerDecompressorThread() {
            super("LogisticsPipes Packet Decompressor Server");
            this.setDaemon(true);
            this.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void serverTickEnd() {
            boolean flag;
            do {
                flag = false;
                Pair<EntityPlayer, byte[]> part = null;
                LinkedList<Pair<EntityPlayer, byte[]>> linkedList = this.PacketBuffer;
                synchronized (linkedList) {
                    if (this.PacketBuffer.size() > 0) {
                        flag = true;
                        part = this.PacketBuffer.pop();
                    }
                }
                if (!flag) continue;
                try {
                    PacketHandler.onPacketData(new LPDataInputStream(part.getValue2()), part.getValue1());
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            } while (flag);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        @Override
        public void run() {
            while (true) {
                void var3_6;
                boolean flag = false;
                byte[] buffer = null;
                Object var3_4 = null;
                HashMap<EntityPlayer, LinkedList<byte[]>> hashMap = this.queue;
                synchronized (hashMap) {
                    if (this.queue.size() > 0) {
                        Iterator<Map.Entry<EntityPlayer, LinkedList<byte[]>>> it = this.queue.entrySet().iterator();
                        while (it.hasNext()) {
                            Map.Entry<EntityPlayer, LinkedList<byte[]>> lPlayer = it.next();
                            if (lPlayer.getValue().size() > 0) {
                                flag = true;
                                buffer = lPlayer.getValue().getFirst();
                                EntityPlayer entityPlayer = lPlayer.getKey();
                                if (lPlayer.getValue().size() > 1) {
                                    lPlayer.getValue().removeFirst();
                                    break;
                                }
                                it.remove();
                                break;
                            }
                            it.remove();
                        }
                    }
                }
                if (flag && buffer != null && var3_6 != null) {
                    byte[] ByteBufferForPlayer2 = this.ByteBuffer.computeIfAbsent((EntityPlayer)var3_6, k -> new byte[0]);
                    byte[] packetbytes = ServerPacketBufferHandlerThread.decompress(buffer);
                    byte[] newBuffer = new byte[packetbytes.length + ByteBufferForPlayer2.length];
                    System.arraycopy(ByteBufferForPlayer2, 0, newBuffer, 0, ByteBufferForPlayer2.length);
                    System.arraycopy(packetbytes, 0, newBuffer, ByteBufferForPlayer2.length, packetbytes.length);
                    this.ByteBuffer.put((EntityPlayer)var3_6, newBuffer);
                }
                if (flag) continue;
                for (Map.Entry<EntityPlayer, byte[]> entry : this.ByteBuffer.entrySet()) {
                    byte[] ByteBufferForPlayer2;
                    int size;
                    while (entry.getValue().length >= 4 && (size = (((ByteBufferForPlayer2 = entry.getValue())[0] & 0xFF) << 24) + ((ByteBufferForPlayer2[1] & 0xFF) << 16) + ((ByteBufferForPlayer2[2] & 0xFF) << 8) + ((ByteBufferForPlayer2[3] & 0xFF) << 0)) + 4 <= ByteBufferForPlayer2.length) {
                        byte[] packet = Arrays.copyOfRange(ByteBufferForPlayer2, 4, size + 4);
                        ByteBufferForPlayer2 = Arrays.copyOfRange(ByteBufferForPlayer2, size + 4, ByteBufferForPlayer2.length);
                        entry.setValue(ByteBufferForPlayer2);
                        LinkedList<Pair<EntityPlayer, byte[]>> linkedList = this.PacketBuffer;
                        synchronized (linkedList) {
                            this.PacketBuffer.add(new Pair<EntityPlayer, byte[]>(entry.getKey(), packet));
                        }
                    }
                }
                this.ByteBuffer.values().removeIf(ByteBufferForPlayer -> ((byte[])ByteBufferForPlayer).length == 0);
                Queue<EntityPlayer> queue = this.queue;
                synchronized (queue) {
                    while (this.queue.size() == 0) {
                        try {
                            this.queue.wait();
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                }
                queue = this.playersToClear;
                synchronized (queue) {
                    EntityPlayer entityPlayer;
                    do {
                        if ((entityPlayer = this.playersToClear.poll()) == null) continue;
                        this.ByteBuffer.remove(entityPlayer);
                    } while (entityPlayer != null);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handlePacket(byte[] content, EntityPlayer player) {
            HashMap<EntityPlayer, LinkedList<byte[]>> hashMap = this.queue;
            synchronized (hashMap) {
                LinkedList list = this.queue.computeIfAbsent(player, k -> new LinkedList());
                list.addLast(content);
                this.queue.notify();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void clear(EntityPlayer player) {
            Object object = this.queue;
            synchronized (object) {
                this.queue.remove(player);
            }
            object = this.playersToClear;
            synchronized (object) {
                this.playersToClear.add(player);
            }
        }
    }

    private static class ServerCompressorThread
    extends Thread {
        private final HashMap<EntityPlayer, LinkedList<ModernPacket>> serverList = new HashMap();
        private final HashMap<EntityPlayer, byte[]> serverBuffer = new HashMap();
        private boolean pause = false;
        private final Queue<EntityPlayer> playersToClear = new LinkedList<EntityPlayer>();

        public ServerCompressorThread() {
            super("LogisticsPipes Packet Compressor Server");
            this.setDaemon(true);
            this.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (true) {
                Queue<EntityPlayer> queue;
                try {
                    queue = this.serverList;
                    synchronized (queue) {
                        if (!this.pause) {
                            for (Map.Entry<EntityPlayer, LinkedList<ModernPacket>> player : this.serverList.entrySet()) {
                                ByteArrayOutputStream out = new ByteArrayOutputStream();
                                DataOutputStream data = new DataOutputStream(out);
                                byte[] towrite = this.serverBuffer.get(player.getKey());
                                if (towrite != null) {
                                    data.write(towrite);
                                }
                                LinkedList<ModernPacket> packets = player.getValue();
                                for (ModernPacket packet : packets) {
                                    LPDataOutputStream t = new LPDataOutputStream();
                                    t.writeShort(packet.getId());
                                    t.writeInt(packet.getDebugId());
                                    try {
                                        packet.writeData(t);
                                    }
                                    catch (ConcurrentModificationException e) {
                                        throw new RuntimeException("LogisticsPipes error (please report): Method writeData is not thread-safe in packet " + packet.getClass().getSimpleName(), e);
                                    }
                                    data.writeInt(t.size());
                                    data.write(t.toByteArray());
                                }
                                this.serverBuffer.put(player.getKey(), out.toByteArray());
                            }
                            this.serverList.clear();
                        }
                    }
                    for (Map.Entry entry : this.serverBuffer.entrySet()) {
                        byte[] sendbuffer;
                        while (((byte[])entry.getValue()).length > 32768) {
                            sendbuffer = Arrays.copyOf((byte[])entry.getValue(), 32768);
                            byte[] newbuffer = Arrays.copyOfRange((byte[])entry.getValue(), 32768, ((byte[])entry.getValue()).length);
                            entry.setValue(newbuffer);
                            byte[] compressed = ServerPacketBufferHandlerThread.compress(sendbuffer);
                            MainProxy.sendPacketToPlayer(PacketHandler.getPacket(BufferTransfer.class).setContent(compressed), (EntityPlayer)entry.getKey());
                        }
                        sendbuffer = (byte[])entry.getValue();
                        byte[] compressed = ServerPacketBufferHandlerThread.compress(sendbuffer);
                        MainProxy.sendPacketToPlayer(PacketHandler.getPacket(BufferTransfer.class).setContent(compressed), (EntityPlayer)entry.getKey());
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                this.serverBuffer.clear();
                queue = this.serverList;
                synchronized (queue) {
                    while (this.pause || this.serverList.size() == 0) {
                        try {
                            this.serverList.wait();
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                }
                queue = this.playersToClear;
                synchronized (queue) {
                    EntityPlayer entityPlayer;
                    do {
                        if ((entityPlayer = this.playersToClear.poll()) == null) continue;
                        this.serverBuffer.remove(entityPlayer);
                    } while (entityPlayer != null);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addPacketToCompressor(ModernPacket packet, EntityPlayer player) {
            HashMap<EntityPlayer, LinkedList<ModernPacket>> hashMap = this.serverList;
            synchronized (hashMap) {
                LinkedList packetList = this.serverList.computeIfAbsent(player, k -> new LinkedList());
                packetList.add(packet);
                if (!this.pause) {
                    this.serverList.notify();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setPause(boolean flag) {
            HashMap<EntityPlayer, LinkedList<ModernPacket>> hashMap = this.serverList;
            synchronized (hashMap) {
                this.pause = flag;
                if (!this.pause) {
                    this.serverList.notify();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void clear(EntityPlayer player) {
            Object object = this.serverList;
            synchronized (object) {
                this.serverList.remove(player);
            }
            object = this.playersToClear;
            synchronized (object) {
                this.playersToClear.add(player);
            }
        }
    }
}

