/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.nei.recipes.extractor;

import codechicken.nei.PositionedStack;
import codechicken.nei.recipe.IRecipeHandler;
import codechicken.nei.recipe.TemplateRecipeHandler;
import com.glodblock.github.nei.object.IRecipeExtractorLegacy;
import com.glodblock.github.nei.object.OrderStack;
import com.glodblock.github.nei.recipes.extractor.ExtractorUtil;
import forestry.core.recipes.nei.PositionedFluidTank;
import forestry.core.recipes.nei.RecipeHandlerBase;
import forestry.factory.recipes.nei.NEIHandlerFabricator;
import forestry.factory.recipes.nei.NEIHandlerSqueezer;
import java.util.ArrayList;
import java.util.List;
import net.minecraftforge.fluids.FluidStack;

public class ForestryRecipeExtractor
implements IRecipeExtractorLegacy {
    private final IRecipeHandler handler;

    public ForestryRecipeExtractor(IRecipeHandler recipes) {
        this.handler = recipes;
    }

    @Override
    public String getClassName() {
        return this.handler.getClass().getName();
    }

    @Override
    public List<OrderStack<?>> getInputIngredients(List<PositionedStack> rawInputs) {
        return ExtractorUtil.packItemStack(rawInputs);
    }

    @Override
    public List<OrderStack<?>> getOutputIngredients(List<PositionedStack> rawOutputs) {
        return ExtractorUtil.packItemStack(rawOutputs);
    }

    @Override
    public List<OrderStack<?>> getInputIngredients(List<PositionedStack> rawInputs, IRecipeHandler recipe, int index) {
        TemplateRecipeHandler tRecipe = (TemplateRecipeHandler)recipe;
        List<OrderStack<?>> tmp = new ArrayList();
        if (tRecipe.arecipes.get(index) instanceof RecipeHandlerBase.CachedBaseRecipe) {
            FluidStack fluid;
            tmp = this.getInputIngredients(rawInputs);
            List tanks = ((RecipeHandlerBase.CachedBaseRecipe)tRecipe.arecipes.get(index)).getFluidTanks();
            if (tanks.size() > 0 && !(this.handler instanceof NEIHandlerSqueezer) && (fluid = ((PositionedFluidTank)tanks.get((int)0)).tank.getFluid()) != null) {
                tmp.add(new OrderStack<FluidStack>(fluid, rawInputs.size()));
            }
        }
        return tmp;
    }

    @Override
    public List<OrderStack<?>> getOutputIngredients(List<PositionedStack> rawOutputs, IRecipeHandler recipe, int index) {
        TemplateRecipeHandler tRecipe = (TemplateRecipeHandler)recipe;
        this.removeGlass(rawOutputs);
        List<OrderStack<?>> tmp = new ArrayList();
        if (tRecipe.arecipes.get(index) instanceof RecipeHandlerBase.CachedBaseRecipe) {
            FluidStack fluid;
            tmp = this.getOutputIngredients(rawOutputs);
            List tanks = ((RecipeHandlerBase.CachedBaseRecipe)tRecipe.arecipes.get(index)).getFluidTanks();
            if (tanks.size() > 0 && this.handler instanceof NEIHandlerSqueezer) {
                FluidStack fluid2 = ((PositionedFluidTank)tanks.get((int)0)).tank.getFluid();
                if (fluid2 != null) {
                    tmp.add(new OrderStack<FluidStack>(fluid2, rawOutputs.size()));
                }
            } else if (tanks.size() > 1 && (fluid = ((PositionedFluidTank)tanks.get((int)1)).tank.getFluid()) != null) {
                tmp.add(new OrderStack<FluidStack>(fluid, rawOutputs.size()));
            }
        }
        return tmp;
    }

    private void removeGlass(List<PositionedStack> list) {
        if (this.handler instanceof NEIHandlerFabricator) {
            list.remove(list.size() - 1);
        }
    }
}

