/*
 * Decompiled with CFR 0.152.
 */
package tconstruct.modifiers.armor;

import java.util.EnumSet;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import tconstruct.armor.TinkerArmor;
import tconstruct.library.armor.ArmorMod;
import tconstruct.library.armor.ArmorPart;
import tconstruct.modifiers.armor.AModBoolean;

public class AModThaumicVision
extends ArmorMod {
    private final AModBoolean thaumicSensesMod;
    private final AModBoolean thaumicVisionMod;
    private final Item thaumometer;

    public AModThaumicVision(ItemStack thaumometer) {
        super(-1, "", EnumSet.of(ArmorPart.Head), new ItemStack[]{thaumometer});
        this.thaumometer = thaumometer.func_77973_b();
        this.thaumicSensesMod = new AModBoolean(1, "Thaumic Senses", EnumSet.of(ArmorPart.Head), new ItemStack[0], EnumChatFormatting.DARK_PURPLE.toString(), "Thaumic Senses");
        this.thaumicVisionMod = new AModBoolean(2, "Thaumic Vision", EnumSet.of(ArmorPart.Head), new ItemStack[0], EnumChatFormatting.DARK_PURPLE.toString(), "Thaumic Vision");
    }

    @Override
    protected boolean canModify(ItemStack armor, ItemStack[] recipe) {
        return this.thaumicSensesMod.canModify(armor, recipe) || this.thaumicVisionMod.canModify(armor, recipe);
    }

    @Override
    public void modify(ItemStack[] recipe, ItemStack input) {
        int effect = -1;
        int count = this.countThaumometers(recipe);
        if (this.thaumicSensesMod.canModify(input, recipe)) {
            if (count > 1) {
                this.thaumicSensesMod.addMatchingEffect(input);
            }
            this.thaumicSensesMod.modify(recipe, input);
            --count;
            effect = this.thaumicSensesMod.effectIndex;
        }
        if (count > 0) {
            int tipNum = this.addToolTip(input, this.thaumicSensesMod.color + this.thaumicSensesMod.tooltipName, this.thaumicSensesMod.color + this.thaumicSensesMod.key);
            NBTTagCompound tipTags = input.func_77978_p().func_74775_l(this.getTagName(input));
            tipTags.func_82580_o("Tooltip" + tipNum);
            tipTags.func_82580_o("ModifierTip" + tipNum);
            NBTTagCompound tags = this.getModifierTag(input);
            tags.func_74768_a("Modifiers", tags.func_74762_e("Modifiers") + 1);
            this.thaumicVisionMod.modify(recipe, input);
            effect = this.thaumicVisionMod.effectIndex;
        }
        NBTTagCompound tags = input.func_77978_p().func_74775_l(this.getTagName(input));
        for (int i = 1; i <= 6; ++i) {
            if (tags.func_74762_e("Effect" + i) != -1) continue;
            tags.func_74768_a("Effect" + i, effect);
            break;
        }
    }

    private boolean hasThaumicSenses(ItemStack stack) {
        return stack != null && stack.func_77942_o() && stack.func_77978_p().func_74775_l(TinkerArmor.travelGoggles.getBaseTagName()).func_74767_n(this.thaumicSensesMod.key);
    }

    @Override
    public boolean matches(ItemStack[] recipe, ItemStack input) {
        if (!this.canModify(input, recipe)) {
            return false;
        }
        int count = this.countThaumometers(recipe);
        if (count == 0 || count > 2) {
            return false;
        }
        if (count == 1) {
            return true;
        }
        return !this.hasThaumicSenses(input);
    }

    private int countThaumometers(ItemStack[] recipe) {
        int count = 0;
        for (ItemStack stack : recipe) {
            if (stack == null || stack.func_77973_b() != this.thaumometer) continue;
            ++count;
        }
        return count;
    }
}

