/*
 * Decompiled with CFR 0.152.
 */
package com.github.bartimaeusnek.bartworks.util;

import gregtech.api.enums.Dyes;
import gregtech.api.enums.GT_Values;
import java.util.Arrays;

public class BW_ColorUtil {
    private BW_ColorUtil() {
    }

    public static byte getDarknessFromColor(short[] rgba, int index) {
        short g = rgba[index];
        if (g >= 0 && g < 64) {
            return 0;
        }
        if (g >= 64 && g < 160) {
            return 1;
        }
        if (g >= 160 && g < 223) {
            return 2;
        }
        if (g >= 233 && g <= 255) {
            return 3;
        }
        return 4;
    }

    public static Dyes getDyeFromColor(short[] rgba) {
        if (BW_ColorUtil.isGrayScale(rgba = BW_ColorUtil.correctCorlorArray(rgba), 2)) {
            switch (BW_ColorUtil.getDarknessFromColor(rgba, 0)) {
                case 0: {
                    return Dyes.dyeBlack;
                }
                case 1: {
                    return Dyes.dyeGray;
                }
                case 2: {
                    return Dyes.dyeLightGray;
                }
                case 3: {
                    return Dyes.dyeWhite;
                }
            }
        } else {
            short[] tmp = BW_ColorUtil.roundColor(rgba, 2);
            if (BW_ColorUtil.isRedScale(tmp)) {
                if (BW_ColorUtil.isPurpleScale(tmp)) {
                    switch (BW_ColorUtil.getDarknessFromColor(rgba, 0)) {
                        case 0: 
                        case 1: {
                            if (rgba[3] - 50 > rgba[0]) {
                                return Dyes.dyePurple;
                            }
                            return Dyes.dyeRed;
                        }
                        case 2: 
                        case 3: {
                            if (rgba[3] - 50 > rgba[0]) {
                                return Dyes.dyeMagenta;
                            }
                            if (rgba[0] > 200 && rgba[2] > 140) {
                                return Dyes.dyePink;
                            }
                            if (rgba[0] > rgba[1] + rgba[1] / 10 && rgba[0] > rgba[2] + rgba[2] / 10 && rgba[1] >> 4 == rgba[2] >> 4 && rgba[1] + 50 > rgba[0]) {
                                return Dyes.dyeBrown;
                            }
                            return Dyes.dyeRed;
                        }
                        case 4: {
                            return Dyes._NULL;
                        }
                    }
                }
                if (BW_ColorUtil.isYellowScale(tmp)) {
                    switch (BW_ColorUtil.getDarknessFromColor(rgba, 0)) {
                        case 0: 
                        case 1: {
                            return Dyes.dyeBrown;
                        }
                        case 2: 
                        case 3: {
                            if (rgba[0] >> 5 > rgba[1] >> 5) {
                                return Dyes.dyeOrange;
                            }
                            return Dyes.dyeYellow;
                        }
                        case 4: {
                            return Dyes._NULL;
                        }
                    }
                }
                return Dyes.dyePink;
            }
            if (BW_ColorUtil.isGrenScale(tmp)) {
                if (BW_ColorUtil.isCyanScale(tmp)) {
                    if (rgba[2] + 40 < rgba[1]) {
                        switch (BW_ColorUtil.getDarknessFromColor(rgba, 0)) {
                            case 0: 
                            case 1: {
                                return Dyes.dyeGreen;
                            }
                            case 2: 
                            case 3: {
                                return Dyes.dyeLime;
                            }
                        }
                    }
                    return Dyes.dyeCyan;
                }
                if (BW_ColorUtil.isYellowScale(tmp)) {
                    switch (BW_ColorUtil.getDarknessFromColor(rgba, 0)) {
                        case 0: 
                        case 1: {
                            return Dyes.dyeBrown;
                        }
                        case 2: 
                        case 3: {
                            if (rgba[0] >> 5 > rgba[1] >> 5) {
                                return Dyes.dyeOrange;
                            }
                            return Dyes.dyeYellow;
                        }
                    }
                }
                switch (BW_ColorUtil.getDarknessFromColor(rgba, 0)) {
                    case 0: 
                    case 1: {
                        return Dyes.dyeGreen;
                    }
                    case 2: 
                    case 3: {
                        return Dyes.dyeLime;
                    }
                }
            } else if (BW_ColorUtil.isBlueScale(tmp)) {
                if (BW_ColorUtil.isPurpleScale(tmp)) {
                    switch (BW_ColorUtil.getDarknessFromColor(rgba, 0)) {
                        case 0: 
                        case 1: {
                            return Dyes.dyePurple;
                        }
                        case 2: 
                        case 3: {
                            return Dyes.dyeMagenta;
                        }
                    }
                } else if (BW_ColorUtil.isCyanScale(tmp)) {
                    return Dyes.dyeCyan;
                }
                switch (BW_ColorUtil.getDarknessFromColor(rgba, 0)) {
                    case 0: 
                    case 1: {
                        return Dyes.dyeBlue;
                    }
                    case 2: 
                    case 3: {
                        return Dyes.dyeLightBlue;
                    }
                }
            }
        }
        return Dyes._NULL;
    }

    public static boolean isCyanScale(short[] rgba) {
        return !BW_ColorUtil.isRedScale(rgba);
    }

    public static boolean isPurpleScale(short[] rgba) {
        return !BW_ColorUtil.isGrenScale(rgba);
    }

    public static boolean isYellowScale(short[] rgba) {
        return !BW_ColorUtil.isBlueScale(rgba);
    }

    public static boolean isBlueScale(short[] rgba) {
        return (rgba = BW_ColorUtil.correctCorlorArray(rgba))[2] * 2 >= rgba[1] + rgba[0];
    }

    public static boolean isGrenScale(short[] rgba) {
        return (rgba = BW_ColorUtil.correctCorlorArray(rgba))[1] * 2 >= rgba[0] + rgba[2];
    }

    public static boolean isRedScale(short[] rgba) {
        return (rgba = BW_ColorUtil.correctCorlorArray(rgba))[0] * 2 >= rgba[1] + rgba[2];
    }

    public static boolean isGrayScale(short[] rgba, int magin) {
        return (rgba = BW_ColorUtil.correctCorlorArray(rgba))[0] >> magin == rgba[1] >> magin && rgba[1] >> magin == rgba[2] >> magin;
    }

    public static short[] roundColor(short[] rgba, int magin) {
        short[] tmp = Arrays.copyOf(rgba, 4);
        tmp[0] = (short)(rgba[0] >> magin);
        tmp[1] = (short)(rgba[1] >> magin);
        tmp[2] = (short)(rgba[2] >> magin);
        return tmp;
    }

    public static boolean isGrayScale(short[] rgba) {
        return (rgba = BW_ColorUtil.correctCorlorArray(rgba))[0] == rgba[1] && rgba[1] == rgba[2];
    }

    public static short[] correctCorlorArray(short[] rgba) {
        if (rgba.length > 4) {
            rgba = Arrays.copyOfRange(rgba, 0, 4);
        }
        if (rgba.length < 4) {
            short[] tmp = Arrays.copyOf(rgba, 4);
            Arrays.fill(tmp, rgba.length, 4, (short)0);
            rgba = tmp;
        }
        if (rgba[0] > 255) {
            rgba[0] = 255;
        }
        if (rgba[1] > 255) {
            rgba[1] = 255;
        }
        if (rgba[2] > 255) {
            rgba[2] = 255;
        }
        if (rgba[3] > 255) {
            rgba[3] = 255;
        }
        if (rgba[0] < 0) {
            rgba[0] = 0;
        }
        if (rgba[1] < 0) {
            rgba[1] = 0;
        }
        if (rgba[2] < 0) {
            rgba[2] = 0;
        }
        if (rgba[3] < 0) {
            rgba[3] = 0;
        }
        return rgba;
    }

    public static short[] splitColorToRBGArray(int rgb) {
        return new short[]{(short)(rgb >> 16 & 0xFF), (short)(rgb >> 8 & 0xFF), (short)(rgb & 0xFF)};
    }

    public static int getColorFromRGBArray(short[] color) {
        return (color[0] & 0xFF) << 16 | (color[1] & 0xFF) << 8 | color[2] & 0xFF;
    }

    public static int getColorFromRGBArray(int[] color) {
        return (color[0] & 0xFF) << 16 | (color[1] & 0xFF) << 8 | color[2] & 0xFF;
    }

    public static String getColorForTier(int tier) {
        return GT_Values.TIER_COLORS[tier];
    }
}

