/*
 * Decompiled with CFR 0.152.
 */
package com.github.bartimaeusnek.bartworks.system.material.GT_Enhancement;

import com.github.bartimaeusnek.bartworks.system.material.BW_MetaGenerated_Items;
import com.github.bartimaeusnek.bartworks.system.material.Werkstoff;
import com.github.bartimaeusnek.bartworks.system.material.WerkstoffLoader;
import com.github.bartimaeusnek.bartworks.util.BW_Util;
import com.github.bartimaeusnek.bartworks.util.CachedReflectionUtils;
import cpw.mods.fml.common.registry.GameRegistry;
import gregtech.api.enums.GT_Values;
import gregtech.api.enums.ItemList;
import gregtech.api.enums.Materials;
import gregtech.api.enums.Mods;
import gregtech.api.enums.OrePrefixes;
import gregtech.api.enums.TierEU;
import gregtech.api.interfaces.IRecipeMap;
import gregtech.api.interfaces.ISubTagContainer;
import gregtech.api.items.GT_Generic_Block;
import gregtech.api.items.GT_Generic_Item;
import gregtech.api.objects.ItemData;
import gregtech.api.objects.MaterialStack;
import gregtech.api.recipe.RecipeMap;
import gregtech.api.recipe.RecipeMaps;
import gregtech.api.util.GT_ModHandler;
import gregtech.api.util.GT_OreDictUnificator;
import gregtech.api.util.GT_Recipe;
import gregtech.api.util.GT_RecipeConstants;
import gregtech.api.util.GT_Utility;
import gregtech.common.blocks.GT_Block_Ores_Abstract;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.ShapedRecipes;
import net.minecraft.item.crafting.ShapelessRecipes;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;
import org.apache.commons.lang3.reflect.FieldUtils;

public class PlatinumSludgeOverHaul {
    private static final Materials[] BLACKLIST = new Materials[]{Materials.HSSS, Materials.EnderiumBase, Materials.Osmiridium, Materials.TPV, Materials.get((String)"Uraniumtriplatinid"), Materials.get((String)"Tetranaquadahdiindiumhexaplatiumosminid"), Materials.get((String)"Longasssuperconductornameforuvwire")};
    private static final OrePrefixes[] OPBLACKLIST = new OrePrefixes[]{OrePrefixes.crushedCentrifuged, OrePrefixes.crushed, OrePrefixes.crushedPurified, OrePrefixes.dustPure, OrePrefixes.dustImpure, OrePrefixes.dustRefined, OrePrefixes.dust, OrePrefixes.dustTiny, OrePrefixes.dustSmall};

    private PlatinumSludgeOverHaul() {
    }

    private static void runHelperrecipes() {
        GT_Values.RA.stdBuilder().itemInputs(new ItemStack[]{Materials.SulfuricAcid.getCells(2), Materials.Water.getCells(1), GT_Utility.getIntegratedCircuit((int)1)}).itemOutputs(new ItemStack[]{Materials.DilutedSulfuricAcid.getCells(3)}).duration(30).eut(TierEU.RECIPE_LV).addTo((IRecipeMap)RecipeMaps.mixerRecipes);
        GT_Values.RA.stdBuilder().itemInputs(new ItemStack[]{Materials.Water.getCells(1), GT_Utility.getIntegratedCircuit((int)1)}).itemOutputs(new ItemStack[]{Materials.Empty.getCells(1)}).fluidInputs(new FluidStack[]{Materials.SulfuricAcid.getFluid(2000L)}).fluidOutputs(new FluidStack[]{Materials.DilutedSulfuricAcid.getFluid(3000L)}).duration(30).eut(TierEU.RECIPE_LV).addTo((IRecipeMap)RecipeMaps.mixerRecipes);
        GT_Values.RA.stdBuilder().itemInputs(new ItemStack[]{Materials.SulfuricAcid.getCells(2), GT_Utility.getIntegratedCircuit((int)1)}).itemOutputs(new ItemStack[]{Materials.Empty.getCells(2)}).fluidInputs(new FluidStack[]{Materials.Water.getFluid(1000L)}).fluidOutputs(new FluidStack[]{Materials.DilutedSulfuricAcid.getFluid(3000L)}).duration(30).eut(TierEU.RECIPE_LV).addTo((IRecipeMap)RecipeMaps.mixerRecipes);
        GT_Values.RA.stdBuilder().itemInputs(new ItemStack[]{Materials.CarbonMonoxide.getCells(1), Materials.SodiumHydroxide.getDust(3)}).itemOutputs(new ItemStack[]{WerkstoffLoader.Sodiumformate.get(OrePrefixes.cell)}).duration(15).eut(TierEU.RECIPE_LV).addTo(GT_RecipeConstants.UniversalChemical);
        GT_Values.RA.stdBuilder().itemInputs(new ItemStack[]{WerkstoffLoader.Sodiumformate.get(OrePrefixes.cell, 2), GT_Utility.getIntegratedCircuit((int)1)}).itemOutputs(new ItemStack[]{WerkstoffLoader.FormicAcid.get(OrePrefixes.cell, 2), WerkstoffLoader.Sodiumsulfate.get(OrePrefixes.dust, 7)}).fluidInputs(new FluidStack[]{Materials.SulfuricAcid.getFluid(1000L)}).duration(15).eut(TierEU.RECIPE_LV).addTo(GT_RecipeConstants.UniversalChemical);
        GT_Values.RA.stdBuilder().itemInputs(new ItemStack[]{Materials.SulfuricAcid.getCells(1), GT_Utility.getIntegratedCircuit((int)1)}).itemOutputs(new ItemStack[]{Materials.Empty.getCells(1), WerkstoffLoader.Sodiumsulfate.get(OrePrefixes.dust, 7)}).fluidInputs(new FluidStack[]{WerkstoffLoader.Sodiumformate.getFluidOrGas(2000)}).fluidOutputs(new FluidStack[]{WerkstoffLoader.FormicAcid.getFluidOrGas(2000)}).duration(15).eut(TierEU.RECIPE_LV).addTo(GT_RecipeConstants.UniversalChemical);
        GT_Values.RA.stdBuilder().itemInputs(new ItemStack[]{Materials.DilutedSulfuricAcid.getCells(1), Materials.NitricAcid.getCells(1), GT_Utility.getIntegratedCircuit((int)1)}).itemOutputs(new ItemStack[]{WerkstoffLoader.AquaRegia.get(OrePrefixes.cell, 2)}).duration(30).eut(TierEU.RECIPE_LV).addTo((IRecipeMap)RecipeMaps.mixerRecipes);
        GT_Values.RA.stdBuilder().itemInputs(new ItemStack[]{Materials.DilutedSulfuricAcid.getCells(1), Materials.NitricAcid.getCells(1), GT_Utility.getIntegratedCircuit((int)2)}).itemOutputs(new ItemStack[]{Materials.Empty.getCells(2)}).fluidOutputs(new FluidStack[]{WerkstoffLoader.AquaRegia.getFluidOrGas(2000)}).duration(30).eut(TierEU.RECIPE_LV).addTo((IRecipeMap)RecipeMaps.mixerRecipes);
        GT_Values.RA.stdBuilder().itemInputs(new ItemStack[]{Materials.NitricAcid.getCells(1), GT_Utility.getIntegratedCircuit((int)3)}).itemOutputs(new ItemStack[]{Materials.Empty.getCells(1)}).fluidInputs(new FluidStack[]{Materials.DilutedSulfuricAcid.getFluid(1000L)}).fluidOutputs(new FluidStack[]{WerkstoffLoader.AquaRegia.getFluidOrGas(2000)}).duration(30).eut(TierEU.RECIPE_LV).addTo((IRecipeMap)RecipeMaps.mixerRecipes);
        GT_Values.RA.stdBuilder().itemInputs(new ItemStack[]{Materials.DilutedSulfuricAcid.getCells(1), GT_Utility.getIntegratedCircuit((int)4)}).itemOutputs(new ItemStack[]{Materials.Empty.getCells(1)}).fluidInputs(new FluidStack[]{Materials.NitricAcid.getFluid(1000L)}).fluidOutputs(new FluidStack[]{WerkstoffLoader.AquaRegia.getFluidOrGas(2000)}).duration(30).eut(TierEU.RECIPE_LV).addTo((IRecipeMap)RecipeMaps.mixerRecipes);
        GT_Values.RA.stdBuilder().itemInputs(new ItemStack[]{Materials.Ammonia.getCells(1), GT_Utility.getIntegratedCircuit((int)1)}).itemOutputs(new ItemStack[]{WerkstoffLoader.AmmoniumChloride.get(OrePrefixes.cell, 1)}).fluidInputs(new FluidStack[]{Materials.HydrochloricAcid.getFluid(1000L)}).duration(15).eut(TierEU.RECIPE_LV).addTo(GT_RecipeConstants.UniversalChemical);
        GT_Values.RA.stdBuilder().itemInputs(new ItemStack[]{Materials.HydrochloricAcid.getCells(1), GT_Utility.getIntegratedCircuit((int)1)}).itemOutputs(new ItemStack[]{Materials.Empty.getCells(1)}).fluidInputs(new FluidStack[]{Materials.Ammonia.getGas(1000L)}).fluidOutputs(new FluidStack[]{WerkstoffLoader.AmmoniumChloride.getFluidOrGas(1000)}).duration(15).eut(TierEU.RECIPE_LV).addTo(GT_RecipeConstants.UniversalChemical);
        GT_Values.RA.addMultiblockChemicalRecipe(new ItemStack[]{GT_Utility.getIntegratedCircuit((int)9)}, new FluidStack[]{Materials.Ammonia.getGas(64000L), Materials.HydrochloricAcid.getFluid(64000L)}, new FluidStack[]{WerkstoffLoader.AmmoniumChloride.getFluidOrGas(64000)}, null, 60, 480);
        for (Werkstoff w : Werkstoff.werkstoffHashSet) {
            if (!w.containsStuff((ISubTagContainer)Materials.Sulfur) || !w.containsStuff((ISubTagContainer)Materials.Copper) && !w.containsStuff((ISubTagContainer)Materials.Nickel)) continue;
            GT_Values.RA.stdBuilder().itemInputs(new ItemStack[]{w.get(OrePrefixes.crushedPurified), GT_Utility.getIntegratedCircuit((int)1)}).fluidInputs(new FluidStack[]{WerkstoffLoader.AquaRegia.getFluidOrGas(150)}).fluidOutputs(new FluidStack[]{WerkstoffLoader.PTConcentrate.getFluidOrGas(150)}).duration(250).eut(TierEU.RECIPE_LV).addTo(GT_RecipeConstants.UniversalChemical);
            GT_Values.RA.stdBuilder().itemInputs(new ItemStack[]{w.get(OrePrefixes.crushedPurified, 9), GT_Utility.getIntegratedCircuit((int)9)}).fluidInputs(new FluidStack[]{WerkstoffLoader.AquaRegia.getFluidOrGas(1350)}).fluidOutputs(new FluidStack[]{WerkstoffLoader.PTConcentrate.getFluidOrGas(1350)}).duration(225).eut(TierEU.RECIPE_LV).addTo(GT_RecipeConstants.UniversalChemical);
            GT_Values.RA.stdBuilder().itemInputs(new ItemStack[]{w.get(OrePrefixes.crushedPurified, 9), WerkstoffLoader.PTMetallicPowder.get(OrePrefixes.dust, 9)}).itemOutputs(new ItemStack[]{WerkstoffLoader.PTResidue.get(OrePrefixes.dust)}).fluidInputs(new FluidStack[]{WerkstoffLoader.AquaRegia.getFluidOrGas(10350)}).fluidOutputs(new FluidStack[]{WerkstoffLoader.PTConcentrate.getFluidOrGas(10350)}).duration(2250).eut(TierEU.RECIPE_LV).addTo(GT_RecipeConstants.UniversalChemical);
        }
        for (Materials m : Materials.values()) {
            if (!PlatinumSludgeOverHaul.materialsContains(m, (ISubTagContainer)Materials.Sulfur) || !PlatinumSludgeOverHaul.materialsContains(m, (ISubTagContainer)Materials.Copper) && !PlatinumSludgeOverHaul.materialsContains(m, (ISubTagContainer)Materials.Nickel)) continue;
            GT_Values.RA.stdBuilder().itemInputs(new ItemStack[]{GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.crushedPurified, (Object)m, (long)1L), GT_Utility.getIntegratedCircuit((int)1)}).fluidInputs(new FluidStack[]{WerkstoffLoader.AquaRegia.getFluidOrGas(150)}).fluidOutputs(new FluidStack[]{WerkstoffLoader.PTConcentrate.getFluidOrGas(150)}).duration(250).eut(TierEU.RECIPE_LV).addTo(GT_RecipeConstants.UniversalChemical);
            GT_Values.RA.stdBuilder().itemInputs(new ItemStack[]{GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.crushedPurified, (Object)m, (long)9L), GT_Utility.getIntegratedCircuit((int)9)}).fluidInputs(new FluidStack[]{WerkstoffLoader.AquaRegia.getFluidOrGas(1350)}).fluidOutputs(new FluidStack[]{WerkstoffLoader.PTConcentrate.getFluidOrGas(1350)}).duration(2250).eut(TierEU.RECIPE_LV).addTo(GT_RecipeConstants.UniversalChemical);
            GT_Values.RA.stdBuilder().itemInputs(new ItemStack[]{GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.crushedPurified, (Object)m, (long)9L), WerkstoffLoader.PTMetallicPowder.get(OrePrefixes.dust, 9)}).itemOutputs(new ItemStack[]{WerkstoffLoader.PTResidue.get(OrePrefixes.dust)}).fluidInputs(new FluidStack[]{WerkstoffLoader.AquaRegia.getFluidOrGas(10350)}).fluidOutputs(new FluidStack[]{WerkstoffLoader.PTConcentrate.getFluidOrGas(10350)}).duration(2250).eut(TierEU.RECIPE_LV).addTo(GT_RecipeConstants.UniversalChemical);
        }
        GT_Values.RA.stdBuilder().itemInputs(new ItemStack[]{WerkstoffLoader.PTMetallicPowder.get(OrePrefixes.dust, 3), GT_Utility.getIntegratedCircuit((int)1)}).itemOutputs(new ItemStack[]{Materials.Platinum.getNuggets(2)}).duration(600).eut(TierEU.RECIPE_MV).metadata(GT_RecipeConstants.COIL_HEAT, (Object)Materials.Platinum.mMeltingPoint).addTo((IRecipeMap)RecipeMaps.blastFurnaceRecipes);
        GT_Values.RA.stdBuilder().itemInputs(new ItemStack[]{WerkstoffLoader.PTMetallicPowder.get(OrePrefixes.dust), GT_Utility.getIntegratedCircuit((int)1)}).itemOutputs(new ItemStack[]{WerkstoffLoader.PTResidue.get(OrePrefixes.dustTiny)}).fluidInputs(new FluidStack[]{WerkstoffLoader.AquaRegia.getFluidOrGas(1000)}).fluidOutputs(new FluidStack[]{WerkstoffLoader.PTConcentrate.getFluidOrGas(1000)}).duration(250).eut(TierEU.RECIPE_LV).addTo(GT_RecipeConstants.UniversalChemical);
        GT_Values.RA.stdBuilder().itemInputs(new ItemStack[]{WerkstoffLoader.PTMetallicPowder.get(OrePrefixes.dust, 9), GT_Utility.getIntegratedCircuit((int)9)}).itemOutputs(new ItemStack[]{WerkstoffLoader.PTResidue.get(OrePrefixes.dust)}).fluidInputs(new FluidStack[]{WerkstoffLoader.AquaRegia.getFluidOrGas(9000)}).fluidOutputs(new FluidStack[]{WerkstoffLoader.PTConcentrate.getFluidOrGas(9000)}).duration(2250).eut(TierEU.RECIPE_LV).addTo(GT_RecipeConstants.UniversalChemical);
        GT_Values.RA.stdBuilder().itemInputs(new ItemStack[]{WerkstoffLoader.PTConcentrate.get(OrePrefixes.cell, 2)}).itemOutputs(new ItemStack[]{WerkstoffLoader.PTSaltCrude.get(OrePrefixes.dustTiny, 16), WerkstoffLoader.PTRawPowder.get(OrePrefixes.dustTiny, 4), Materials.NitrogenDioxide.getCells(1), Materials.DilutedSulfuricAcid.getCells(1)}).fluidInputs(new FluidStack[]{WerkstoffLoader.AmmoniumChloride.getFluidOrGas(400)}).fluidOutputs(new FluidStack[]{WerkstoffLoader.PDAmmonia.getFluidOrGas(400)}).duration(1200).eut(TierEU.RECIPE_LV).addTo((IRecipeMap)RecipeMaps.centrifugeRecipes);
        GT_Values.RA.addMultiblockChemicalRecipe(new ItemStack[]{GT_Utility.getIntegratedCircuit((int)1)}, new FluidStack[]{WerkstoffLoader.PTConcentrate.getFluidOrGas(2000), WerkstoffLoader.AmmoniumChloride.getFluidOrGas(400)}, new FluidStack[]{WerkstoffLoader.PDAmmonia.getFluidOrGas(400), Materials.NitrogenDioxide.getGas(1000L), Materials.DilutedSulfuricAcid.getFluid(1000L)}, new ItemStack[]{WerkstoffLoader.PTSaltCrude.get(OrePrefixes.dustTiny, 16), WerkstoffLoader.PTRawPowder.get(OrePrefixes.dustTiny, 4)}, 1200, 30);
        GT_Values.RA.addMultiblockChemicalRecipe(new ItemStack[]{GT_Utility.getIntegratedCircuit((int)2)}, new FluidStack[]{WerkstoffLoader.PTConcentrate.getFluidOrGas(18000), WerkstoffLoader.AmmoniumChloride.getFluidOrGas(3600)}, new FluidStack[]{WerkstoffLoader.PDAmmonia.getFluidOrGas(3600), Materials.NitrogenDioxide.getGas(9000L), Materials.DilutedSulfuricAcid.getFluid(9000L)}, new ItemStack[]{WerkstoffLoader.PTSaltCrude.get(OrePrefixes.dust, 16), WerkstoffLoader.PTRawPowder.get(OrePrefixes.dust, 4)}, 1400, 240);
        GT_Values.RA.stdBuilder().itemInputs(new ItemStack[]{WerkstoffLoader.PTSaltCrude.get(OrePrefixes.dust)}).itemOutputs(new ItemStack[]{WerkstoffLoader.PTSaltRefined.get(OrePrefixes.dust), WerkstoffLoader.PTSaltRefined.get(OrePrefixes.dust), WerkstoffLoader.PTSaltRefined.get(OrePrefixes.dust), WerkstoffLoader.PTSaltRefined.get(OrePrefixes.dust), WerkstoffLoader.PTSaltRefined.get(OrePrefixes.dust), WerkstoffLoader.PTSaltRefined.get(OrePrefixes.dust), WerkstoffLoader.PTSaltRefined.get(OrePrefixes.dust), WerkstoffLoader.PTSaltRefined.get(OrePrefixes.dust), WerkstoffLoader.PTSaltRefined.get(OrePrefixes.dust)}).outputChances(new int[]{1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1500}).duration(600).eut(TierEU.RECIPE_LV).addTo((IRecipeMap)RecipeMaps.sifterRecipes);
        GT_Values.RA.stdBuilder().itemInputs(new ItemStack[]{WerkstoffLoader.PTSaltRefined.get(OrePrefixes.dust), GT_Utility.getIntegratedCircuit((int)1)}).itemOutputs(new ItemStack[]{WerkstoffLoader.PTMetallicPowder.get(OrePrefixes.dust)}).fluidOutputs(new FluidStack[]{Materials.Chlorine.getGas(87L)}).duration(200).eut(TierEU.RECIPE_MV).metadata(GT_RecipeConstants.COIL_HEAT, (Object)900).addTo((IRecipeMap)RecipeMaps.blastFurnaceRecipes);
        GT_Values.RA.stdBuilder().itemInputs(new ItemStack[]{WerkstoffLoader.PTRawPowder.get(OrePrefixes.dust, 4), Materials.Calcium.getDust(1)}).itemOutputs(new ItemStack[]{Materials.Platinum.getDust(2), WerkstoffLoader.CalciumChloride.get(OrePrefixes.dust, 3)}).duration(30).eut(TierEU.RECIPE_LV).addTo(GT_RecipeConstants.UniversalChemical);
        GT_Values.RA.stdBuilder().itemInputs(new ItemStack[]{WerkstoffLoader.PDMetallicPowder.get(OrePrefixes.dust), GT_Utility.getIntegratedCircuit((int)1)}).fluidInputs(new FluidStack[]{Materials.Ammonia.getGas(1000L)}).fluidOutputs(new FluidStack[]{WerkstoffLoader.PDAmmonia.getFluidOrGas(1000)}).duration(250).eut(TierEU.RECIPE_LV).addTo(GT_RecipeConstants.UniversalChemical);
        GT_Values.RA.stdBuilder().itemInputs(new ItemStack[]{WerkstoffLoader.PDMetallicPowder.get(OrePrefixes.dust), GT_Utility.getIntegratedCircuit((int)1)}).itemOutputs(new ItemStack[]{WerkstoffLoader.PDSalt.get(OrePrefixes.dustTiny, 16), WerkstoffLoader.PDRawPowder.get(OrePrefixes.dustTiny, 2)}).fluidInputs(new FluidStack[]{WerkstoffLoader.PDAmmonia.getFluidOrGas(1000)}).duration(250).eut(TierEU.RECIPE_LV).addTo(GT_RecipeConstants.UniversalChemical);
        GT_Values.RA.stdBuilder().itemInputs(new ItemStack[]{WerkstoffLoader.PDMetallicPowder.get(OrePrefixes.dust, 9), GT_Utility.getIntegratedCircuit((int)9)}).itemOutputs(new ItemStack[]{WerkstoffLoader.PDSalt.get(OrePrefixes.dust, 16), WerkstoffLoader.PDRawPowder.get(OrePrefixes.dust, 2)}).fluidInputs(new FluidStack[]{WerkstoffLoader.PDAmmonia.getFluidOrGas(9000)}).duration(2250).eut(TierEU.RECIPE_LV).addTo(GT_RecipeConstants.UniversalChemical);
        GT_Values.RA.stdBuilder().itemInputs(new ItemStack[]{GT_Utility.getIntegratedCircuit((int)2)}).itemOutputs(new ItemStack[]{WerkstoffLoader.PDSalt.get(OrePrefixes.dust)}).fluidInputs(new FluidStack[]{WerkstoffLoader.PDAmmonia.getFluidOrGas(1000)}).duration(250).eut(TierEU.RECIPE_LV).addTo(GT_RecipeConstants.UniversalChemical);
        GT_Values.RA.stdBuilder().itemInputs(new ItemStack[]{WerkstoffLoader.PDSalt.get(OrePrefixes.dust)}).itemOutputs(new ItemStack[]{WerkstoffLoader.PDMetallicPowder.get(OrePrefixes.dust), WerkstoffLoader.PDMetallicPowder.get(OrePrefixes.dust), WerkstoffLoader.PDMetallicPowder.get(OrePrefixes.dust), WerkstoffLoader.PDMetallicPowder.get(OrePrefixes.dust), WerkstoffLoader.PDMetallicPowder.get(OrePrefixes.dust), WerkstoffLoader.PDMetallicPowder.get(OrePrefixes.dust), WerkstoffLoader.PDMetallicPowder.get(OrePrefixes.dust), WerkstoffLoader.PDMetallicPowder.get(OrePrefixes.dust), WerkstoffLoader.PDMetallicPowder.get(OrePrefixes.dust)}).outputChances(new int[]{1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1500}).duration(600).eut(TierEU.RECIPE_LV).addTo((IRecipeMap)RecipeMaps.sifterRecipes);
        GT_Values.RA.addChemicalRecipeForBasicMachineOnly(WerkstoffLoader.PDRawPowder.get(OrePrefixes.dust, 4), Materials.Empty.getCells(1), WerkstoffLoader.FormicAcid.getFluidOrGas(4000), Materials.Ammonia.getGas(4000L), Materials.Palladium.getDust(2), Materials.Ethylene.getCells(1), 250, 30);
        GT_Values.RA.addMultiblockChemicalRecipe(new ItemStack[]{WerkstoffLoader.PDRawPowder.get(OrePrefixes.dust, 4)}, new FluidStack[]{WerkstoffLoader.FormicAcid.getFluidOrGas(4000)}, new FluidStack[]{Materials.Ammonia.getGas(4000L), Materials.Ethylene.getGas(1000L), Materials.Water.getFluid(1000L)}, new ItemStack[]{Materials.Palladium.getDust(2)}, 250, 30);
        GT_Values.RA.stdBuilder().itemInputs(new ItemStack[]{WerkstoffLoader.Sodiumsulfate.get(OrePrefixes.dust, 7), Materials.Hydrogen.getCells(2)}).itemOutputs(new ItemStack[]{Materials.Sodium.getDust(2), Materials.Empty.getCells(2)}).fluidOutputs(new FluidStack[]{Materials.SulfuricAcid.getFluid(1000L)}).duration(30).eut(TierEU.RECIPE_LV).addTo(GT_RecipeConstants.UniversalChemical);
        GT_Values.RA.stdBuilder().itemInputs(new ItemStack[]{WerkstoffLoader.PTResidue.get(OrePrefixes.dust), GT_Utility.getIntegratedCircuit((int)11)}).itemOutputs(new ItemStack[]{WerkstoffLoader.LeachResidue.get(OrePrefixes.dust)}).fluidInputs(new FluidStack[]{WerkstoffLoader.PotassiumDisulfate.getMolten(360)}).fluidOutputs(new FluidStack[]{WerkstoffLoader.RHSulfate.getFluidOrGas(360)}).duration(200).eut(TierEU.RECIPE_MV).metadata(GT_RecipeConstants.COIL_HEAT, (Object)775).addTo((IRecipeMap)RecipeMaps.blastFurnaceRecipes);
        GT_Values.RA.stdBuilder().itemInputs(new ItemStack[]{WerkstoffLoader.LeachResidue.get(OrePrefixes.dust, 10), Materials.Saltpeter.getDust(10)}).itemOutputs(new ItemStack[]{WerkstoffLoader.SodiumRuthenate.get(OrePrefixes.dust, 3), WerkstoffLoader.IrOsLeachResidue.get(OrePrefixes.dust, 6)}).fluidInputs(new FluidStack[]{Materials.SaltWater.getFluid(1000L)}).fluidOutputs(new FluidStack[]{GT_ModHandler.getSteam((long)1000L)}).duration(200).eut(TierEU.RECIPE_MV).metadata(GT_RecipeConstants.COIL_HEAT, (Object)775).addTo((IRecipeMap)RecipeMaps.blastFurnaceRecipes);
        GT_Values.RA.stdBuilder().itemInputs(new ItemStack[]{WerkstoffLoader.SodiumRuthenate.get(OrePrefixes.dust, 6), Materials.Chlorine.getCells(3)}).itemOutputs(new ItemStack[]{Materials.Empty.getCells(3)}).fluidOutputs(new FluidStack[]{WerkstoffLoader.RutheniumTetroxideSollution.getFluidOrGas(9000)}).duration(300).eut(TierEU.RECIPE_LV).addTo(GT_RecipeConstants.UniversalChemical);
        GT_Values.RA.stdBuilder().itemInputs(new ItemStack[]{GT_Utility.getIntegratedCircuit((int)1)}).fluidInputs(new FluidStack[]{WerkstoffLoader.RutheniumTetroxideSollution.getFluidOrGas(800)}).fluidOutputs(new FluidStack[]{WerkstoffLoader.HotRutheniumTetroxideSollution.getFluidOrGas(800)}).duration(300).eut(TierEU.RECIPE_HV).addTo((IRecipeMap)RecipeMaps.fluidHeaterRecipes);
        GT_Values.RA.addCrackingRecipe(17, WerkstoffLoader.RutheniumTetroxideSollution.getFluidOrGas(1000), GT_ModHandler.getSteam((long)1000L), WerkstoffLoader.HotRutheniumTetroxideSollution.getFluidOrGas(2000), 150, 480);
        GT_Values.RA.addDistillationTowerRecipe(WerkstoffLoader.HotRutheniumTetroxideSollution.getFluidOrGas(9000), new FluidStack[]{Materials.Water.getFluid(1800L), WerkstoffLoader.RutheniumTetroxide.getFluidOrGas(7200)}, Materials.Salt.getDust(6), 1500, 480);
        GT_Values.RA.stdBuilder().itemInputs(new ItemStack[]{WerkstoffLoader.RutheniumTetroxide.get(OrePrefixes.dust, 1), Materials.HydrochloricAcid.getCells(6)}).itemOutputs(new ItemStack[]{WerkstoffLoader.Ruthenium.get(OrePrefixes.dust), Materials.Chlorine.getCells(6)}).fluidOutputs(new FluidStack[]{Materials.Water.getFluid(2000L)}).duration(300).eut(TierEU.RECIPE_LV).addTo(GT_RecipeConstants.UniversalChemical);
        GT_Values.RA.stdBuilder().itemInputs(new ItemStack[]{WerkstoffLoader.IrOsLeachResidue.get(OrePrefixes.dust, 4), GT_Utility.getIntegratedCircuit((int)11)}).itemOutputs(new ItemStack[]{WerkstoffLoader.IrLeachResidue.get(OrePrefixes.dust, 2)}).fluidInputs(new FluidStack[]{Materials.HydrochloricAcid.getFluid(1000L)}).fluidOutputs(new FluidStack[]{WerkstoffLoader.AcidicOsmiumSolution.getFluidOrGas(2000)}).duration(200).eut(TierEU.RECIPE_MV).metadata(GT_RecipeConstants.COIL_HEAT, (Object)775).addTo((IRecipeMap)RecipeMaps.blastFurnaceRecipes);
        GT_Values.RA.addDistillationTowerRecipe(WerkstoffLoader.AcidicOsmiumSolution.getFluidOrGas(1000), new FluidStack[]{WerkstoffLoader.OsmiumSolution.getFluidOrGas(100), Materials.Water.getFluid(900L)}, null, 150, (int)TierEU.RECIPE_IV);
        GT_Values.RA.stdBuilder().itemInputs(new ItemStack[]{WerkstoffLoader.OsmiumSolution.get(OrePrefixes.cell), Materials.HydrochloricAcid.getCells(6)}).itemOutputs(new ItemStack[]{Materials.Osmium.getDust(1), Materials.Chlorine.getCells(7)}).fluidOutputs(new FluidStack[]{Materials.Water.getFluid(2000L)}).duration(300).eut(TierEU.RECIPE_LV).addTo(GT_RecipeConstants.UniversalChemical);
        GT_Values.RA.stdBuilder().itemInputs(new ItemStack[]{WerkstoffLoader.IrLeachResidue.get(OrePrefixes.dust), GT_Utility.getIntegratedCircuit((int)1)}).itemOutputs(new ItemStack[]{WerkstoffLoader.PGSDResidue.get(OrePrefixes.dust), WerkstoffLoader.IridiumDioxide.get(OrePrefixes.dust)}).duration(200).eut(TierEU.RECIPE_MV).metadata(GT_RecipeConstants.COIL_HEAT, (Object)775).addTo((IRecipeMap)RecipeMaps.blastFurnaceRecipes);
        GT_Values.RA.stdBuilder().itemInputs(new ItemStack[]{WerkstoffLoader.IridiumDioxide.get(OrePrefixes.dust), Materials.HydrochloricAcid.getCells(1)}).itemOutputs(new ItemStack[]{Materials.Empty.getCells(1)}).fluidOutputs(new FluidStack[]{WerkstoffLoader.AcidicIridiumSolution.getFluidOrGas(1000)}).duration(300).eut(TierEU.RECIPE_LV).addTo(GT_RecipeConstants.UniversalChemical);
        GT_Values.RA.stdBuilder().itemInputs(new ItemStack[]{WerkstoffLoader.AcidicIridiumSolution.get(OrePrefixes.cell), WerkstoffLoader.AmmoniumChloride.get(OrePrefixes.cell, 3)}).itemOutputs(new ItemStack[]{Materials.Empty.getCells(4), WerkstoffLoader.IridiumChloride.get(OrePrefixes.dust)}).fluidOutputs(new FluidStack[]{Materials.Ammonia.getGas(3000L)}).duration(300).eut(TierEU.RECIPE_LV).addTo(GT_RecipeConstants.UniversalChemical);
        GT_Values.RA.stdBuilder().itemInputs(new ItemStack[]{WerkstoffLoader.IridiumChloride.get(OrePrefixes.dust), Materials.Calcium.getDust(1)}).itemOutputs(new ItemStack[]{WerkstoffLoader.PGSDResidue2.get(OrePrefixes.dust), Materials.Iridium.getDust(1)}).fluidOutputs(new FluidStack[]{WerkstoffLoader.CalciumChloride.getFluidOrGas(3000)}).duration(300).eut(TierEU.RECIPE_EV).addTo(GT_RecipeConstants.UniversalChemical);
        GT_Values.RA.stdBuilder().itemInputs(new ItemStack[]{WerkstoffLoader.RHSulfate.get(OrePrefixes.cell, 11), GT_Utility.getIntegratedCircuit((int)1)}).itemOutputs(new ItemStack[]{WerkstoffLoader.RHSulfateSolution.get(OrePrefixes.cell, 11), WerkstoffLoader.LeachResidue.get(OrePrefixes.dustTiny, 10)}).fluidInputs(new FluidStack[]{Materials.Water.getFluid(10000L)}).fluidOutputs(new FluidStack[]{Materials.Potassium.getMolten(2000L)}).duration(300).eut(TierEU.RECIPE_LV).addTo(GT_RecipeConstants.UniversalChemical);
        GT_Values.RA.addMultiblockChemicalRecipe(new ItemStack[]{GT_Utility.getIntegratedCircuit((int)3)}, new FluidStack[]{Materials.Water.getFluid(36000L), WerkstoffLoader.RHSulfate.getFluidOrGas(39600)}, new FluidStack[]{Materials.Potassium.getMolten(7200L), WerkstoffLoader.RHSulfateSolution.getFluidOrGas(39600)}, new ItemStack[]{WerkstoffLoader.LeachResidue.get(OrePrefixes.dust, 4)}, 1200, 30);
        GT_Values.RA.stdBuilder().itemInputs(new ItemStack[]{Materials.Zinc.getDust(1)}).itemOutputs(new ItemStack[]{WerkstoffLoader.ZincSulfate.get(OrePrefixes.dust, 6), WerkstoffLoader.CrudeRhMetall.get(OrePrefixes.dust)}).fluidInputs(new FluidStack[]{WerkstoffLoader.RHSulfateSolution.getFluidOrGas(1000)}).duration(300).eut(TierEU.RECIPE_LV).addTo(GT_RecipeConstants.UniversalChemical);
        GT_Values.RA.stdBuilder().itemInputs(new ItemStack[]{WerkstoffLoader.CrudeRhMetall.get(OrePrefixes.dust), Materials.Salt.getDust(1)}).itemOutputs(new ItemStack[]{WerkstoffLoader.RHSalt.get(OrePrefixes.dust, 3)}).fluidInputs(new FluidStack[]{Materials.Chlorine.getGas(1000L)}).duration(300).eut(TierEU.RECIPE_MV).metadata(GT_RecipeConstants.COIL_HEAT, (Object)600).addTo((IRecipeMap)RecipeMaps.blastFurnaceRecipes);
        GT_Values.RA.stdBuilder().itemInputs(new ItemStack[]{WerkstoffLoader.RHSalt.get(OrePrefixes.dust, 10)}).fluidInputs(new FluidStack[]{Materials.Water.getFluid(2000L)}).fluidOutputs(new FluidStack[]{WerkstoffLoader.RHSaltSolution.getFluidOrGas(2000)}).duration(300).eut(TierEU.RECIPE_LV).addTo((IRecipeMap)RecipeMaps.mixerRecipes);
        GT_Values.RA.stdBuilder().itemInputs(new ItemStack[]{WerkstoffLoader.SodiumNitrate.get(OrePrefixes.dust, 5), GT_Utility.getIntegratedCircuit((int)1)}).itemOutputs(new ItemStack[]{WerkstoffLoader.RHNitrate.get(OrePrefixes.dust), Materials.Salt.getDust(2)}).fluidInputs(new FluidStack[]{WerkstoffLoader.RHSaltSolution.getFluidOrGas(1000)}).duration(300).eut(TierEU.RECIPE_LV).addTo(GT_RecipeConstants.UniversalChemical);
        GT_Values.RA.stdBuilder().itemInputs(new ItemStack[]{Materials.Sodium.getDust(1)}).itemOutputs(new ItemStack[]{WerkstoffLoader.SodiumNitrate.get(OrePrefixes.dust, 5)}).fluidInputs(new FluidStack[]{Materials.NitricAcid.getFluid(1000L)}).fluidOutputs(new FluidStack[]{Materials.Hydrogen.getGas(1000L)}).duration(8).eut(60).addTo(GT_RecipeConstants.UniversalChemical);
        GT_Values.RA.stdBuilder().itemInputs(new ItemStack[]{WerkstoffLoader.RHNitrate.get(OrePrefixes.dust)}).itemOutputs(new ItemStack[]{WerkstoffLoader.RhFilterCake.get(OrePrefixes.dust), WerkstoffLoader.RhFilterCake.get(OrePrefixes.dust), WerkstoffLoader.RhFilterCake.get(OrePrefixes.dust), WerkstoffLoader.RhFilterCake.get(OrePrefixes.dust), WerkstoffLoader.RhFilterCake.get(OrePrefixes.dust), WerkstoffLoader.RhFilterCake.get(OrePrefixes.dust), WerkstoffLoader.RhFilterCake.get(OrePrefixes.dust), WerkstoffLoader.RhFilterCake.get(OrePrefixes.dust), WerkstoffLoader.RhFilterCake.get(OrePrefixes.dust)}).outputChances(new int[]{1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1500}).duration(600).eut(TierEU.RECIPE_LV).addTo((IRecipeMap)RecipeMaps.sifterRecipes);
        GT_Values.RA.stdBuilder().itemInputs(new ItemStack[]{WerkstoffLoader.RhFilterCake.get(OrePrefixes.dust)}).fluidInputs(new FluidStack[]{Materials.Water.getFluid(1000L)}).fluidOutputs(new FluidStack[]{WerkstoffLoader.RHFilterCakeSolution.getFluidOrGas(1000)}).duration(300).eut(TierEU.RECIPE_LV).addTo((IRecipeMap)RecipeMaps.mixerRecipes);
        GT_Values.RA.stdBuilder().itemInputs(new ItemStack[]{GT_Utility.getIntegratedCircuit((int)2)}).itemOutputs(new ItemStack[]{WerkstoffLoader.ReRh.get(OrePrefixes.dust)}).fluidInputs(new FluidStack[]{WerkstoffLoader.RHFilterCakeSolution.getFluidOrGas(1000)}).duration(300).eut(TierEU.RECIPE_LV).addTo(GT_RecipeConstants.UniversalChemical);
        GT_Values.RA.stdBuilder().itemInputs(new ItemStack[]{WerkstoffLoader.ReRh.get(OrePrefixes.dust), Materials.Empty.getCells(1)}).itemOutputs(new ItemStack[]{WerkstoffLoader.Rhodium.get(OrePrefixes.dust), Materials.Ammonia.getCells(1)}).fluidInputs(new FluidStack[]{Materials.HydrochloricAcid.getFluid(1000L)}).fluidOutputs(new FluidStack[]{Materials.Chlorine.getGas(1000L)}).duration(300).eut(TierEU.RECIPE_LV).addTo(GT_RecipeConstants.UniversalChemical);
    }

    private static boolean materialsContains(Materials one, ISubTagContainer other) {
        if (one == null || one.mMaterialList == null || one.mMaterialList.isEmpty()) {
            return false;
        }
        for (MaterialStack stack : one.mMaterialList) {
            if (!stack.mMaterial.equals(other)) continue;
            return true;
        }
        return false;
    }

    public static void replacePureElements() {
        for (Map.Entry entry : FurnaceRecipes.func_77602_a().func_77599_b().entrySet()) {
            Map.Entry realEntry = entry;
            if (!GT_Utility.isStackValid(realEntry.getKey()) || !BW_Util.checkStackAndPrefix((ItemStack)realEntry.getKey())) continue;
            ItemData association = GT_OreDictUnificator.getAssociation((ItemStack)((ItemStack)realEntry.getKey()));
            if ((OrePrefixes.dust.equals((Object)association.mPrefix) || OrePrefixes.dustTiny.equals((Object)association.mPrefix)) && association.mMaterial.mMaterial.equals(Materials.Platinum) || !GT_Utility.isStackValid(realEntry.getValue()) || !BW_Util.checkStackAndPrefix((ItemStack)realEntry.getValue())) continue;
            ItemData ass = GT_OreDictUnificator.getAssociation((ItemStack)((ItemStack)realEntry.getValue()));
            if (!ass.mMaterial.mMaterial.equals(Materials.Platinum)) continue;
            if (!PlatinumSludgeOverHaul.isInBlackList((ItemStack)realEntry.getKey())) {
                realEntry.setValue(WerkstoffLoader.PTMetallicPowder.get(ass.mPrefix == OrePrefixes.nugget ? OrePrefixes.dustTiny : OrePrefixes.dust, ((ItemStack)realEntry.getValue()).field_77994_a * 2));
                continue;
            }
            if (!ass.mMaterial.mMaterial.equals(Materials.Palladium) || PlatinumSludgeOverHaul.isInBlackList((ItemStack)realEntry.getKey())) continue;
            realEntry.setValue(WerkstoffLoader.PDMetallicPowder.get(ass.mPrefix == OrePrefixes.nugget ? OrePrefixes.dustTiny : OrePrefixes.dust, ((ItemStack)realEntry.getValue()).field_77994_a * 2));
        }
        CraftingManager.func_77594_a().func_77592_b().forEach(PlatinumSludgeOverHaul::setnewMaterialInRecipe);
        try {
            ((List)FieldUtils.getDeclaredField(GT_ModHandler.class, (String)"sBufferRecipeList", (boolean)true).get(null)).forEach(PlatinumSludgeOverHaul::setnewMaterialInRecipe);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        block3: for (RecipeMap recipeMap : RecipeMap.ALL_RECIPE_MAPS.values()) {
            if (recipeMap == RecipeMaps.fusionRecipes || recipeMap == RecipeMaps.unpackagerRecipes || recipeMap == RecipeMaps.packagerRecipes || recipeMap == RecipeMaps.replicatorRecipes || "gt.recipe.eyeofharmony".equals(recipeMap.unlocalizedName) || "gtpp.recipe.quantumforcesmelter".equals(recipeMap.unlocalizedName)) continue;
            HashSet<GT_Recipe> toDel = new HashSet<GT_Recipe>();
            block4: for (GT_Recipe recipe : recipeMap.getAllRecipes()) {
                int i;
                if (recipe.mFakeRecipe) continue block3;
                for (i = 0; i < recipe.mFluidOutputs.length; ++i) {
                    if (recipeMap.equals(RecipeMaps.fluidExtractionRecipes) || "gtpp.recipe.alloyblastsmelter".equals(recipeMap.unlocalizedName)) continue block3;
                    if (recipeMap.equals(RecipeMaps.multiblockChemicalReactorRecipes) || recipeMap.equals(RecipeMaps.chemicalReactorRecipes)) {
                        if (GT_Utility.areFluidsEqual((FluidStack)WerkstoffLoader.Ruthenium.getMolten(1), (FluidStack)recipe.mFluidOutputs[i]) || GT_Utility.areFluidsEqual((FluidStack)WerkstoffLoader.Rhodium.getMolten(1), (FluidStack)recipe.mFluidOutputs[i])) {
                            toDel.add(recipe);
                            continue;
                        }
                        if (GT_Utility.areFluidsEqual((FluidStack)Materials.Iridium.getMolten(1L), (FluidStack)recipe.mFluidOutputs[i])) {
                            recipe.mFluidOutputs[i] = WerkstoffLoader.AcidicIridiumSolution.getFluidOrGas(1000);
                            recipe.reloadOwner();
                            continue;
                        }
                        if (GT_Utility.areFluidsEqual((FluidStack)Materials.Platinum.getMolten(1L), (FluidStack)recipe.mFluidOutputs[i])) {
                            recipe.mFluidOutputs[i] = WerkstoffLoader.PTConcentrate.getFluidOrGas(1000);
                            recipe.reloadOwner();
                            continue;
                        }
                        if (!GT_Utility.areFluidsEqual((FluidStack)Materials.Osmium.getMolten(1L), (FluidStack)recipe.mFluidOutputs[i])) continue;
                        recipe.mFluidOutputs[i] = WerkstoffLoader.AcidicOsmiumSolution.getFluidOrGas(1000);
                        recipe.reloadOwner();
                        continue;
                    }
                    if (GT_Utility.areFluidsEqual((FluidStack)WerkstoffLoader.Ruthenium.getMolten(1), (FluidStack)recipe.mFluidOutputs[i]) || GT_Utility.areFluidsEqual((FluidStack)WerkstoffLoader.Rhodium.getMolten(1), (FluidStack)recipe.mFluidOutputs[i]) || GT_Utility.areFluidsEqual((FluidStack)Materials.Iridium.getMolten(1L), (FluidStack)recipe.mFluidOutputs[i]) || GT_Utility.areFluidsEqual((FluidStack)Materials.Platinum.getMolten(1L), (FluidStack)recipe.mFluidOutputs[i])) {
                        toDel.add(recipe);
                        continue;
                    }
                    if (!GT_Utility.areFluidsEqual((FluidStack)Materials.Osmium.getMolten(1L), (FluidStack)recipe.mFluidOutputs[i])) continue;
                    toDel.add(recipe);
                }
                for (i = 0; i < recipe.mOutputs.length; ++i) {
                    if (!GT_Utility.isStackValid((ItemStack)recipe.mOutputs[i])) continue;
                    if ((BW_Util.areStacksEqualOrNull(WerkstoffLoader.Ruthenium.get(OrePrefixes.dust), recipe.mOutputs[i]) || BW_Util.areStacksEqualOrNull(WerkstoffLoader.Ruthenium.get(OrePrefixes.dustImpure), recipe.mOutputs[i]) || BW_Util.areStacksEqualOrNull(WerkstoffLoader.Ruthenium.get(OrePrefixes.dustPure), recipe.mOutputs[i])) && !BW_Util.areStacksEqualOrNull(WerkstoffLoader.Ruthenium.get(OrePrefixes.ingot), recipe.mInputs[0])) {
                        for (ItemStack mInput : recipe.mInputs) {
                            if (PlatinumSludgeOverHaul.isInBlackList(mInput)) continue block4;
                        }
                        int amount = recipe.mOutputs[i].field_77994_a * 2;
                        recipe.mOutputs[i] = WerkstoffLoader.LeachResidue.get(OrePrefixes.dust, amount);
                        recipe.reloadOwner();
                    }
                    if ((BW_Util.areStacksEqualOrNull(WerkstoffLoader.Rhodium.get(OrePrefixes.dust), recipe.mOutputs[i]) || BW_Util.areStacksEqualOrNull(WerkstoffLoader.Rhodium.get(OrePrefixes.dustImpure), recipe.mOutputs[i]) || BW_Util.areStacksEqualOrNull(WerkstoffLoader.Rhodium.get(OrePrefixes.dustPure), recipe.mOutputs[i])) && !BW_Util.areStacksEqualOrNull(WerkstoffLoader.Rhodium.get(OrePrefixes.ingot), recipe.mInputs[0])) {
                        for (ItemStack mInput : recipe.mInputs) {
                            if (PlatinumSludgeOverHaul.isInBlackList(mInput)) continue block4;
                        }
                        int amount = recipe.mOutputs[i].field_77994_a * 2;
                        recipe.mOutputs[i] = WerkstoffLoader.CrudeRhMetall.get(OrePrefixes.dust, amount);
                        recipe.reloadOwner();
                    }
                    if (!BW_Util.checkStackAndPrefix(recipe.mOutputs[i])) continue;
                    if (GT_OreDictUnificator.getAssociation((ItemStack)recipe.mOutputs[i]).mMaterial.mMaterial.equals(Materials.Platinum)) {
                        for (ItemStack mInput : recipe.mInputs) {
                            if (PlatinumSludgeOverHaul.isInBlackList(mInput)) continue block4;
                        }
                        if (OrePrefixes.dust.equals((Object)GT_OreDictUnificator.getAssociation((ItemStack)recipe.mOutputs[i]).mPrefix) || OrePrefixes.dustImpure.equals((Object)GT_OreDictUnificator.getAssociation((ItemStack)recipe.mOutputs[i]).mPrefix) || OrePrefixes.dustPure.equals((Object)GT_OreDictUnificator.getAssociation((ItemStack)recipe.mOutputs[i]).mPrefix)) {
                            int amount = recipe.mOutputs[i].field_77994_a;
                            recipe.mOutputs[i] = BW_Util.setStackSize(WerkstoffLoader.PTMetallicPowder.get(OrePrefixes.dust), amount * 2);
                            recipe.reloadOwner();
                            continue;
                        }
                        if (OrePrefixes.dustSmall.equals((Object)GT_OreDictUnificator.getAssociation((ItemStack)recipe.mOutputs[i]).mPrefix)) {
                            int amount = recipe.mOutputs[i].field_77994_a;
                            recipe.mOutputs[i] = BW_Util.setStackSize(WerkstoffLoader.PTMetallicPowder.get(OrePrefixes.dustSmall), amount * 2);
                            recipe.reloadOwner();
                            continue;
                        }
                        if (!OrePrefixes.dustTiny.equals((Object)GT_OreDictUnificator.getAssociation((ItemStack)recipe.mOutputs[i]).mPrefix)) continue;
                        int amount = recipe.mOutputs[i].field_77994_a;
                        recipe.mOutputs[i] = BW_Util.setStackSize(WerkstoffLoader.PTMetallicPowder.get(OrePrefixes.dustTiny), amount * 2);
                        recipe.reloadOwner();
                        continue;
                    }
                    if (GT_OreDictUnificator.getAssociation((ItemStack)recipe.mOutputs[i]).mMaterial.mMaterial.equals(Materials.Palladium)) {
                        for (ItemStack mInput : recipe.mInputs) {
                            if (PlatinumSludgeOverHaul.isInBlackList(mInput)) continue block4;
                        }
                        if (OrePrefixes.dust.equals((Object)GT_OreDictUnificator.getAssociation((ItemStack)recipe.mOutputs[i]).mPrefix) || OrePrefixes.dustImpure.equals((Object)GT_OreDictUnificator.getAssociation((ItemStack)recipe.mOutputs[i]).mPrefix) || OrePrefixes.dustPure.equals((Object)GT_OreDictUnificator.getAssociation((ItemStack)recipe.mOutputs[i]).mPrefix)) {
                            int amount = recipe.mOutputs[i].field_77994_a;
                            recipe.mOutputs[i] = BW_Util.setStackSize(WerkstoffLoader.PDMetallicPowder.get(OrePrefixes.dust), amount * 4);
                            recipe.reloadOwner();
                            continue;
                        }
                        if (OrePrefixes.dustSmall.equals((Object)GT_OreDictUnificator.getAssociation((ItemStack)recipe.mOutputs[i]).mPrefix)) {
                            int amount = recipe.mOutputs[i].field_77994_a;
                            recipe.mOutputs[i] = BW_Util.setStackSize(WerkstoffLoader.PDMetallicPowder.get(OrePrefixes.dustSmall), amount * 4);
                            recipe.reloadOwner();
                            continue;
                        }
                        if (!OrePrefixes.dustTiny.equals((Object)GT_OreDictUnificator.getAssociation((ItemStack)recipe.mOutputs[i]).mPrefix)) continue;
                        int amount = recipe.mOutputs[i].field_77994_a;
                        recipe.mOutputs[i] = BW_Util.setStackSize(WerkstoffLoader.PDMetallicPowder.get(OrePrefixes.dustTiny), amount * 4);
                        recipe.reloadOwner();
                        continue;
                    }
                    if (GT_OreDictUnificator.getAssociation((ItemStack)recipe.mOutputs[i]).mMaterial.mMaterial.equals(Materials.Osmium)) {
                        for (ItemStack mInput : recipe.mInputs) {
                            if (PlatinumSludgeOverHaul.isInBlackList(mInput)) continue block4;
                        }
                        if (OrePrefixes.dust.equals((Object)GT_OreDictUnificator.getAssociation((ItemStack)recipe.mOutputs[i]).mPrefix) || OrePrefixes.dustImpure.equals((Object)GT_OreDictUnificator.getAssociation((ItemStack)recipe.mOutputs[i]).mPrefix) || OrePrefixes.dustPure.equals((Object)GT_OreDictUnificator.getAssociation((ItemStack)recipe.mOutputs[i]).mPrefix)) {
                            int amount = recipe.mOutputs[i].field_77994_a;
                            recipe.mOutputs[i] = BW_Util.setStackSize(WerkstoffLoader.IrOsLeachResidue.get(OrePrefixes.dust), amount);
                            recipe.reloadOwner();
                            continue;
                        }
                        if (OrePrefixes.dustSmall.equals((Object)GT_OreDictUnificator.getAssociation((ItemStack)recipe.mOutputs[i]).mPrefix)) {
                            int amount = recipe.mOutputs[i].field_77994_a;
                            recipe.mOutputs[i] = BW_Util.setStackSize(WerkstoffLoader.IrOsLeachResidue.get(OrePrefixes.dustSmall), amount);
                            recipe.reloadOwner();
                            continue;
                        }
                        if (!OrePrefixes.dustTiny.equals((Object)GT_OreDictUnificator.getAssociation((ItemStack)recipe.mOutputs[i]).mPrefix)) continue;
                        int amount = recipe.mOutputs[i].field_77994_a;
                        recipe.mOutputs[i] = BW_Util.setStackSize(WerkstoffLoader.IrOsLeachResidue.get(OrePrefixes.dustTiny), amount);
                        recipe.reloadOwner();
                        continue;
                    }
                    if (!GT_OreDictUnificator.getAssociation((ItemStack)recipe.mOutputs[i]).mMaterial.mMaterial.equals(Materials.Iridium)) continue;
                    for (ItemStack mInput : recipe.mInputs) {
                        if (PlatinumSludgeOverHaul.isInBlackList(mInput)) continue block4;
                    }
                    if (OrePrefixes.dust.equals((Object)GT_OreDictUnificator.getAssociation((ItemStack)recipe.mOutputs[i]).mPrefix) || OrePrefixes.dustImpure.equals((Object)GT_OreDictUnificator.getAssociation((ItemStack)recipe.mOutputs[i]).mPrefix) || OrePrefixes.dustPure.equals((Object)GT_OreDictUnificator.getAssociation((ItemStack)recipe.mOutputs[i]).mPrefix)) {
                        int amount = recipe.mOutputs[i].field_77994_a;
                        recipe.mOutputs[i] = BW_Util.setStackSize(WerkstoffLoader.IrLeachResidue.get(OrePrefixes.dust), amount);
                        recipe.reloadOwner();
                        continue;
                    }
                    if (OrePrefixes.dustSmall.equals((Object)GT_OreDictUnificator.getAssociation((ItemStack)recipe.mOutputs[i]).mPrefix)) {
                        int amount = recipe.mOutputs[i].field_77994_a;
                        recipe.mOutputs[i] = BW_Util.setStackSize(WerkstoffLoader.IrLeachResidue.get(OrePrefixes.dustSmall), amount);
                        recipe.reloadOwner();
                        continue;
                    }
                    if (!OrePrefixes.dustTiny.equals((Object)GT_OreDictUnificator.getAssociation((ItemStack)recipe.mOutputs[i]).mPrefix)) continue;
                    int amount = recipe.mOutputs[i].field_77994_a;
                    recipe.mOutputs[i] = BW_Util.setStackSize(WerkstoffLoader.IrLeachResidue.get(OrePrefixes.dustTiny), amount);
                    recipe.reloadOwner();
                }
            }
            recipeMap.getBackend().removeRecipes(toDel);
        }
        PlatinumSludgeOverHaul.replaceHVCircuitMaterials();
        PlatinumSludgeOverHaul.runHelperrecipes();
    }

    private static void replaceHVCircuitMaterials() {
        GT_Values.RA.addMixerRecipe(Materials.Redstone.getDust(1), Materials.Electrum.getDust(1), GT_Utility.getIntegratedCircuit((int)1), null, null, null, Materials.Nikolite.getDust(8), 1800, 120);
        for (GT_Recipe recipe : RecipeMaps.circuitAssemblerRecipes.getAllRecipes()) {
            if (recipe.mEUt > 512 || !BW_Util.checkStackAndPrefix(recipe.mOutputs[0])) continue;
            for (int i = 0; i < recipe.mInputs.length; ++i) {
                ItemStack stack = recipe.mInputs[i];
                ItemData ass = GT_OreDictUnificator.getAssociation((ItemStack)stack);
                if (!BW_Util.checkStackAndPrefix(stack) || !ass.mMaterial.mMaterial.equals(Materials.Platinum)) continue;
                recipe.mInputs[i] = GT_OreDictUnificator.get((OrePrefixes)ass.mPrefix, (Object)Materials.BlueAlloy, (long)stack.field_77994_a);
                recipe.reloadOwner();
            }
        }
    }

    private static void setnewMaterialInRecipe(Object obj) {
        Object input;
        Field in;
        String inputName = "output";
        String inputItemName = "input";
        if (!(obj instanceof ShapedOreRecipe) && !(obj instanceof ShapelessOreRecipe)) {
            if (obj instanceof ShapedRecipes || obj instanceof ShapelessRecipes) {
                inputName = "recipeOutput";
                inputItemName = "recipeItems";
            } else if (Mods.GTPlusPlus.isModLoaded()) {
                try {
                    if (Class.forName("gtPlusPlus.api.objects.minecraft.ShapedRecipe").isAssignableFrom(obj.getClass())) {
                        obj = CachedReflectionUtils.getField(obj.getClass(), "mRecipe").get(obj);
                    }
                }
                catch (ClassNotFoundException | IllegalAccessException e) {
                    e.printStackTrace();
                }
            }
        }
        IRecipe recipe = (IRecipe)obj;
        ItemStack otpt = recipe.func_77571_b();
        Field out = CachedReflectionUtils.getDeclaredField(recipe.getClass(), inputName);
        if (out == null) {
            out = CachedReflectionUtils.getField(recipe.getClass(), inputName);
        }
        if ((in = CachedReflectionUtils.getDeclaredField(recipe.getClass(), inputItemName)) == null) {
            in = CachedReflectionUtils.getField(recipe.getClass(), inputItemName);
        }
        if (in == null) {
            return;
        }
        try {
            input = in.get(obj);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            return;
        }
        if (out != null && GT_Utility.areStacksEqual((ItemStack)otpt, (ItemStack)Materials.Platinum.getDust(1), (boolean)true)) {
            if (PlatinumSludgeOverHaul.checkRecipe(input, Materials.Platinum)) {
                return;
            }
            try {
                out.set(recipe, WerkstoffLoader.PTMetallicPowder.get(OrePrefixes.dust, otpt.field_77994_a * 2));
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        } else if (out != null && GT_Utility.areStacksEqual((ItemStack)otpt, (ItemStack)Materials.Palladium.getDust(1), (boolean)true)) {
            if (PlatinumSludgeOverHaul.checkRecipe(input, Materials.Palladium)) {
                return;
            }
            try {
                out.set(recipe, WerkstoffLoader.PDMetallicPowder.get(OrePrefixes.dust, otpt.field_77994_a * 2));
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        } else if (out != null && GT_Utility.areStacksEqual((ItemStack)otpt, (ItemStack)Materials.Iridium.getDust(1), (boolean)true)) {
            if (PlatinumSludgeOverHaul.checkRecipe(input, Materials.Iridium)) {
                return;
            }
            try {
                out.set(recipe, WerkstoffLoader.IrLeachResidue.get(OrePrefixes.dust, otpt.field_77994_a));
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        } else if (out != null && GT_Utility.areStacksEqual((ItemStack)otpt, (ItemStack)Materials.Osmium.getDust(1), (boolean)true)) {
            if (PlatinumSludgeOverHaul.checkRecipe(input, Materials.Osmium)) {
                return;
            }
            try {
                out.set(recipe, WerkstoffLoader.IrOsLeachResidue.get(OrePrefixes.dust, otpt.field_77994_a));
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private static boolean checkRecipe(Object input, Materials mat) {
        if (input instanceof List || input instanceof Object[]) {
            void var8_14;
            HashSet<Object> lists = new HashSet<Object>();
            HashSet<Object> stacks = new HashSet<Object>();
            List ip = input instanceof List ? (List)input : new ArrayList();
            Object[] ip2 = input instanceof Object[] ? (Object[])input : new Object[]{};
            for (Object e : ip) {
                if (e instanceof List) {
                    lists.add(e);
                    continue;
                }
                if (!(e instanceof ItemStack)) continue;
                stacks.add(e);
            }
            Object[] objectArray = ip2;
            int n = objectArray.length;
            boolean bl = false;
            while (var8_14 < n) {
                Object o = objectArray[var8_14];
                if (o instanceof List) {
                    lists.add(o);
                } else if (o instanceof ItemStack) {
                    stacks.add(o);
                }
                ++var8_14;
            }
            for (Object e : lists) {
                if (((List)e).isEmpty()) continue;
                stacks.add(((List)e).get(0));
            }
            for (Object e : stacks) {
                if (!(e instanceof ItemStack) || !GT_Utility.areStacksEqual((ItemStack)GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.crateGtDust, (Object)mat, (long)1L), (ItemStack)((ItemStack)e))) continue;
                return true;
            }
            boolean allSame = false;
            for (Object e : stacks) {
                if (!(e instanceof ItemStack)) {
                    allSame = false;
                    break;
                }
                allSame = BW_Util.checkStackAndPrefix((ItemStack)e) && GT_OreDictUnificator.getAssociation((ItemStack)((ItemStack)e)).mMaterial.mMaterial.equals(mat);
                if (allSame) continue;
                break;
            }
            return allSame;
        }
        return false;
    }

    private static boolean isInBlackList(ItemStack stack) {
        if (stack == null || stack.func_77973_b() instanceof BW_MetaGenerated_Items || "bartworks".equals(GameRegistry.findUniqueIdentifierFor((Item)stack.func_77973_b()).modId) || "bartworkscrossmod".equals(GameRegistry.findUniqueIdentifierFor((Item)stack.func_77973_b()).modId)) {
            return true;
        }
        if (GameRegistry.findUniqueIdentifierFor((Item)stack.func_77973_b()).modId.equals(Mods.NewHorizonsCoreMod.ID) && !stack.func_77977_a().contains("dust") && !stack.func_77977_a().contains("Dust")) {
            return true;
        }
        if (Block.func_149634_a((Item)stack.func_77973_b()) instanceof GT_Generic_Block && !(Block.func_149634_a((Item)stack.func_77973_b()) instanceof GT_Block_Ores_Abstract)) {
            return true;
        }
        if (Arrays.stream(ItemList.values()).filter(ItemList::hasBeenSet).anyMatch(e -> !BW_Util.checkStackAndPrefix(stack) && GT_Utility.areStacksEqual((ItemStack)e.get(1L, new Object[0]), (ItemStack)stack, (boolean)true))) {
            return true;
        }
        if (stack.func_77973_b() instanceof GT_Generic_Item) {
            if (!BW_Util.checkStackAndPrefix(stack)) {
                return false;
            }
            return !Arrays.asList(OPBLACKLIST).contains(GT_OreDictUnificator.getAssociation((ItemStack)stack).mPrefix) || Arrays.asList(BLACKLIST).contains(GT_OreDictUnificator.getAssociation((ItemStack)stack).mMaterial.mMaterial);
        }
        if (Mods.GTPlusPlus.isModLoaded()) {
            try {
                if (Class.forName("gtPlusPlus.core.item.base.BaseItemComponent").isAssignableFrom(stack.func_77973_b().getClass()) && !stack.func_77977_a().contains("dust") && !stack.func_77977_a().contains("Dust")) {
                    return true;
                }
                if (Class.forName("gtPlusPlus.core.block.base.BlockBaseModular").isAssignableFrom(Block.func_149634_a((Item)stack.func_77973_b()).getClass())) {
                    return true;
                }
            }
            catch (ClassNotFoundException e2) {
                e2.printStackTrace();
            }
        }
        if (!BW_Util.checkStackAndPrefix(stack)) {
            return false;
        }
        return Arrays.asList(BLACKLIST).contains(GT_OreDictUnificator.getAssociation((ItemStack)stack).mMaterial.mMaterial);
    }
}

