/*
 * Decompiled with CFR 0.152.
 */
package gcewing.sg;

import gcewing.sg.BaseTileEntity;
import gcewing.sg.ISGEnergySource;
import gcewing.sg.SGCraft;
import net.minecraft.nbt.NBTTagCompound;

public abstract class PowerTE
extends BaseTileEntity
implements ISGEnergySource {
    boolean debugOutput = false;
    public double energyBuffer = 0.0;
    public double energyMax;
    double energyPerSGEnergyUnit;

    public PowerTE(double energyMax, double energyPerSGEnergyUnit) {
        this.energyMax = energyMax;
        this.energyPerSGEnergyUnit = energyPerSGEnergyUnit;
    }

    public abstract String getScreenTitle();

    public abstract String getUnitName();

    @Override
    public void readContentsFromNBT(NBTTagCompound nbt) {
        super.readContentsFromNBT(nbt);
        this.energyBuffer = nbt.func_74769_h("energyBuffer");
    }

    @Override
    public void writeContentsToNBT(NBTTagCompound nbt) {
        super.writeContentsToNBT(nbt);
        nbt.func_74780_a("energyBuffer", this.energyBuffer);
    }

    @Override
    public double availableEnergy() {
        double available = this.energyBuffer / this.energyPerSGEnergyUnit;
        if (this.debugOutput) {
            SGCraft.log.debug(String.format("SGCraft: PowerTE: %s SGU available", available));
        }
        return available;
    }

    @Override
    public double drawEnergy(double request) {
        double available = this.energyBuffer / this.energyPerSGEnergyUnit;
        double supply = Math.min(request, available);
        this.energyBuffer -= supply * this.energyPerSGEnergyUnit;
        this.markChanged();
        if (this.debugOutput) {
            SGCraft.log.debug(String.format("SGCraft: PowerTE: Supplying %s SGU of %s requested", supply, request));
        }
        return supply;
    }
}

