/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.items;

import com.google.common.collect.ImmutableList;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gregtech.api.GregTech_API;
import gregtech.api.enums.Materials;
import gregtech.api.enums.OrePrefixes;
import gregtech.api.enums.SubTag;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.items.GT_MetaGenerated_Item;
import gregtech.api.util.GT_LanguageManager;
import gregtech.api.util.GT_OreDictUnificator;
import java.util.BitSet;
import java.util.List;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;

public class GT_MetaGenerated_Item_99
extends GT_MetaGenerated_Item {
    public static GT_MetaGenerated_Item_99 INSTANCE;
    private static final ImmutableList<OrePrefixes> CRACKED_CELL_TYPES;
    private static final int NUM_CRACKED_CELL_TYPES;
    private final BitSet enabled = new BitSet();

    public GT_MetaGenerated_Item_99() {
        super("metaitem.99", (short)(10000 + NUM_CRACKED_CELL_TYPES * 1000), (short)0);
        INSTANCE = this;
        for (Materials tMaterial : GregTech_API.sGeneratedMaterials) {
            if (tMaterial == null || tMaterial.mMetaItemSubID < 0 || tMaterial.mMetaItemSubID >= 1000) continue;
            if (tMaterial.contains(SubTag.SMELTING_TO_FLUID) && !tMaterial.contains(SubTag.NO_SMELTING) && !tMaterial.contains(SubTag.SMELTING_TO_GEM)) {
                this.registerMolten(tMaterial, tMaterial.mMetaItemSubID);
                if (tMaterial.mSmeltInto != tMaterial && tMaterial.mSmeltInto.mMetaItemSubID >= 0 && tMaterial.mSmeltInto.mMetaItemSubID < 1000) {
                    this.registerMolten(tMaterial.mSmeltInto, tMaterial.mSmeltInto.mMetaItemSubID);
                }
            }
            if (!tMaterial.canBeCracked()) continue;
            this.registerCracked(tMaterial, tMaterial.mMetaItemSubID);
        }
        this.mEnabledItems.clear();
        this.mVisibleItems.clear();
    }

    private void registerMolten(Materials tMaterial, int i) {
        ItemStack tStack = new ItemStack((Item)this, 1, i);
        this.enabled.set(i);
        GT_LanguageManager.addStringLocalization(this.func_77667_c(tStack) + ".name", OrePrefixes.cellMolten.getDefaultLocalNameFormatForItem(tMaterial));
        GT_LanguageManager.addStringLocalization(this.func_77667_c(tStack) + ".tooltip", tMaterial.getToolTip(OrePrefixes.cellMolten.mMaterialAmount / 3628800L));
        if (OrePrefixes.cellMolten.mIsUnificatable) {
            GT_OreDictUnificator.set(OrePrefixes.cellMolten, tMaterial, tStack);
        } else {
            GT_OreDictUnificator.registerOre(OrePrefixes.cellMolten.get(tMaterial), tStack);
        }
    }

    private void registerCracked(Materials tMaterial, int i) {
        int offset = 10000;
        for (OrePrefixes prefix : CRACKED_CELL_TYPES) {
            ItemStack tStack = new ItemStack((Item)this, 1, offset + i);
            this.enabled.set(offset + i);
            GT_LanguageManager.addStringLocalization(this.func_77667_c(tStack) + ".name", prefix.getDefaultLocalNameFormatForItem(tMaterial));
            GT_LanguageManager.addStringLocalization(this.func_77667_c(tStack) + ".tooltip", tMaterial.getToolTip(prefix.mMaterialAmount / 3628800L));
            if (prefix.mIsUnificatable) {
                GT_OreDictUnificator.set(prefix, tMaterial, tStack);
            } else {
                GT_OreDictUnificator.registerOre(prefix.get(tMaterial), tStack);
            }
            offset += 1000;
        }
    }

    private Materials getMaterial(int damage) {
        if (damage < 0) {
            return null;
        }
        return GregTech_API.sGeneratedMaterials[damage % 1000];
    }

    private OrePrefixes getOrePrefix(int damage) {
        if (damage < 0) {
            return null;
        }
        if (damage < 1000) {
            return OrePrefixes.cellMolten;
        }
        if (damage >= 10000 && damage < 10000 + NUM_CRACKED_CELL_TYPES * 1000) {
            return (OrePrefixes)((Object)CRACKED_CELL_TYPES.get(damage / 1000 - 10));
        }
        return null;
    }

    @Override
    public short[] getRGBa(ItemStack aStack) {
        OrePrefixes prefix = this.getOrePrefix(aStack.func_77960_j());
        Materials material = this.getMaterial(aStack.func_77960_j());
        if (material == null) {
            material = Materials._NULL;
        }
        if (prefix == OrePrefixes.cellMolten) {
            return material.mMoltenRGBa;
        }
        return material.mRGBa;
    }

    public String func_77653_i(ItemStack aStack) {
        String aName = super.func_77653_i(aStack);
        Materials material = this.getMaterial(aStack.func_77960_j());
        if (material != null) {
            return material.getLocalizedNameForItem(aName);
        }
        return aName;
    }

    @Override
    public ItemStack getContainerItem(ItemStack aStack) {
        OrePrefixes prefix = this.getOrePrefix(aStack.func_77960_j());
        if (prefix != null) {
            return prefix.mContainerItem;
        }
        return null;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item aItem, CreativeTabs aCreativeTab, List<ItemStack> aList) {
        this.enabled.stream().mapToObj(i -> new ItemStack((Item)this, 1, i)).forEach(aList::add);
    }

    @Override
    public final IIcon func_77617_a(int aMetaData) {
        IIconContainer iconContainer = this.getIconContainer(aMetaData);
        if (iconContainer != null) {
            return iconContainer.getIcon();
        }
        return null;
    }

    @Override
    public IIconContainer getIconContainer(int aMetaData) {
        Materials material = this.getMaterial(aMetaData);
        OrePrefixes prefix = this.getOrePrefix(aMetaData);
        if (material != null && prefix != null) {
            return material.mIconSet.mTextures[prefix.mTextureIndex];
        }
        return null;
    }

    @Override
    public int getItemStackLimit(ItemStack aStack) {
        OrePrefixes prefix = this.getOrePrefix(aStack.func_77960_j());
        if (prefix != null) {
            return prefix.mDefaultStackSize;
        }
        return 64;
    }

    static {
        CRACKED_CELL_TYPES = ImmutableList.of((Object)((Object)OrePrefixes.cellHydroCracked1), (Object)((Object)OrePrefixes.cellHydroCracked2), (Object)((Object)OrePrefixes.cellHydroCracked3), (Object)((Object)OrePrefixes.cellSteamCracked1), (Object)((Object)OrePrefixes.cellSteamCracked2), (Object)((Object)OrePrefixes.cellSteamCracked3));
        NUM_CRACKED_CELL_TYPES = CRACKED_CELL_TYPES.size();
    }
}

