/*
 * Decompiled with CFR 0.152.
 */
package com.github.technus.tectech.util;

import com.github.technus.tectech.util.CommonValues;
import cpw.mods.fml.common.registry.GameRegistry;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_TieredMachineBlock;
import java.lang.reflect.Field;
import java.util.Formatter;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public final class TT_Utility {
    private static final StringBuilder STRING_BUILDER = new StringBuilder();
    private static final Map<Locale, Formatter> FORMATTER_MAP = new HashMap<Locale, Formatter>();

    private TT_Utility() {
    }

    private static Formatter getFormatter() {
        STRING_BUILDER.setLength(0);
        return FORMATTER_MAP.computeIfAbsent(Locale.getDefault(Locale.Category.FORMAT), locale -> new Formatter(STRING_BUILDER, (Locale)locale));
    }

    public static String formatNumberExp(double value) {
        return TT_Utility.getFormatter().format("%+.5E", value).toString();
    }

    public static String toStandardForm(long number) {
        if (number == 0L) {
            return "0";
        }
        int exponent = (int)Math.floor(Math.log10(Math.abs(number)));
        double mantissa = (double)number / Math.pow(10.0, exponent);
        mantissa = (double)Math.round(mantissa * 100.0) / 100.0;
        return mantissa + "*10^" + exponent;
    }

    public static int bitStringToInt(String bits) {
        if (bits == null) {
            return 0;
        }
        if (bits.length() > 32) {
            throw new NumberFormatException("Too long!");
        }
        return Integer.parseInt(bits, 2);
    }

    public static int hexStringToInt(String hex) {
        if (hex == null) {
            return 0;
        }
        if (hex.length() > 8) {
            throw new NumberFormatException("Too long!");
        }
        return Integer.parseInt(hex, 16);
    }

    public static double stringToDouble(String str) {
        if (str == null) {
            return 0.0;
        }
        return Double.parseDouble(str);
    }

    public static String longBitsToShortString(long number) {
        StringBuilder result = new StringBuilder(71);
        for (int i = 63; i >= 0; --i) {
            long mask = 1L << i;
            result.append((number & mask) != 0L ? ":" : ".");
            if (i % 8 != 0) continue;
            result.append('|');
        }
        result.replace(result.length() - 1, result.length(), "");
        return result.toString();
    }

    public static float map(float x, float in_min, float in_max, float out_min, float out_max) {
        return (x - in_min) * (out_max - out_min) / (in_max - in_min) + out_min;
    }

    public static String getUniqueIdentifier(ItemStack is) {
        return GameRegistry.findUniqueIdentifierFor((Item)is.func_77973_b()).modId + ':' + is.func_77977_a();
    }

    public static byte getTier(long l) {
        byte b = -1;
        do {
            if ((b = (byte)((byte)(b + 1))) < CommonValues.V.length) continue;
            return b;
        } while (l > CommonValues.V[b]);
        return b;
    }

    public static void setTier(int tier, Object me) {
        try {
            Field field = GT_MetaTileEntity_TieredMachineBlock.class.getField("mTier");
            field.setAccessible(true);
            field.set(me, (byte)tier);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Deprecated
    public static double receiveDouble(double previousValue, int startIndex, int index, int value) {
        return Double.longBitsToDouble(TT_Utility.receiveLong(Double.doubleToLongBits(previousValue), startIndex, index, value));
    }

    public static long receiveLong(long previousValue, int startIndex, int index, int value) {
        value &= 0xFFFF;
        switch (index - startIndex) {
            case 0: {
                previousValue &= 0xFFFFFFFFFFFF0000L;
                previousValue |= (long)value;
                break;
            }
            case 1: {
                previousValue &= 0xFFFFFFFF0000FFFFL;
                previousValue |= (long)value << 16;
                break;
            }
            case 2: {
                previousValue &= 0xFFFF0000FFFFFFFFL;
                previousValue |= (long)value << 32;
                break;
            }
            case 3: {
                previousValue &= 0xFFFFFFFFFFFFL;
                previousValue |= (long)value << 48;
            }
        }
        return previousValue;
    }

    @Deprecated
    public static float receiveFloat(float previousValue, int startIndex, int index, int value) {
        return Float.intBitsToFloat(TT_Utility.receiveInteger(Float.floatToIntBits(previousValue), startIndex, index, value));
    }

    public static int receiveInteger(int previousValue, int startIndex, int index, int value) {
        value &= 0xFFFF;
        switch (index - startIndex) {
            case 0: {
                previousValue &= 0xFFFF0000;
                previousValue |= value;
                break;
            }
            case 1: {
                previousValue &= 0xFFFF;
                previousValue |= value << 16;
            }
        }
        return previousValue;
    }

    public static String doubleToString(double value) {
        if (value == (double)((long)value)) {
            return Long.toString((long)value);
        }
        return Double.toString(value);
    }
}

