/*
 * Decompiled with CFR 0.152.
 */
package com.bymarcin.openglasses.network.packet;

import com.bymarcin.openglasses.network.Packet;
import com.bymarcin.openglasses.surface.ServerSurface;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import java.io.IOException;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;

public class BlockInteractPacket
extends Packet<BlockInteractPacket, IMessage> {
    private UUID playerUUID;
    private int x;
    private int y;
    private int z;
    private int side;

    public BlockInteractPacket(EntityPlayer player, int x, int y, int z, int side) {
        this.playerUUID = player.func_146103_bH().getId();
        this.x = x;
        this.y = y;
        this.z = z;
        this.side = side;
    }

    public BlockInteractPacket() {
    }

    @Override
    protected void read() throws IOException {
        this.playerUUID = new UUID(this.readLong(), this.readLong());
        this.x = this.readInt();
        this.y = this.readInt();
        this.z = this.readInt();
        this.side = this.readInt();
    }

    @Override
    protected void write() throws IOException {
        this.writeLong(this.playerUUID.getMostSignificantBits());
        this.writeLong(this.playerUUID.getLeastSignificantBits());
        this.writeInt(this.x);
        this.writeInt(this.y);
        this.writeInt(this.z);
        this.writeInt(this.side);
    }

    @Override
    protected IMessage executeOnClient() {
        return null;
    }

    @Override
    protected IMessage executeOnServer() {
        ServerSurface.instance.playerBlockInteract(this.playerUUID, this.x, this.y, this.z, this.side);
        return null;
    }
}

