/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport.pipes;

import buildcraft.api.tools.IToolWrench;
import buildcraft.core.lib.TileBuffer;
import buildcraft.transport.Pipe;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;

public abstract class PipeLogicWood {
    protected final Pipe<?> pipe;

    public PipeLogicWood(Pipe<?> pipe) {
        this.pipe = pipe;
    }

    private void switchSource() {
        int meta = this.pipe.container.func_145832_p();
        ForgeDirection newFacing = null;
        for (int i = meta + 1; i <= meta + 6; ++i) {
            ForgeDirection facing = ForgeDirection.getOrientation((int)(i % 6));
            if (!this.isValidFacing(facing)) continue;
            newFacing = facing;
            break;
        }
        if (newFacing == null) {
            newFacing = ForgeDirection.UNKNOWN;
        }
        this.setSource(newFacing);
    }

    private void setSource(ForgeDirection newFacing) {
        if (newFacing == ForgeDirection.UNKNOWN || this.isValidFacing(newFacing)) {
            int meta = this.pipe.container.func_145832_p();
            if (newFacing.ordinal() != meta) {
                this.pipe.container.func_145831_w().func_72921_c(this.pipe.container.field_145851_c, this.pipe.container.field_145848_d, this.pipe.container.field_145849_e, newFacing.ordinal(), 3);
                this.pipe.container.scheduleRenderUpdate();
            }
        }
    }

    private void switchSourceIfNeeded() {
        int meta = this.pipe.container.func_145832_p();
        if (meta > 5) {
            this.switchSource();
        } else {
            ForgeDirection facing = ForgeDirection.getOrientation((int)meta);
            if (!this.isValidFacing(facing)) {
                this.switchSource();
            }
        }
    }

    private boolean isValidFacing(ForgeDirection side) {
        TileBuffer[] tileBuffer = this.pipe.container.getTileCache();
        if (tileBuffer == null) {
            return true;
        }
        if (!tileBuffer[side.ordinal()].exists()) {
            return true;
        }
        if (this.pipe.container.hasBlockingPluggable(side)) {
            return false;
        }
        TileEntity tile = tileBuffer[side.ordinal()].getTile();
        return this.isValidConnectingTile(tile);
    }

    protected abstract boolean isValidConnectingTile(TileEntity var1);

    public void initialize() {
        if (!this.pipe.container.func_145831_w().field_72995_K) {
            this.switchSourceIfNeeded();
        }
    }

    @Deprecated
    public boolean blockActivated(EntityPlayer entityplayer) {
        return this.blockActivated(entityplayer, ForgeDirection.UNKNOWN);
    }

    public boolean blockActivated(EntityPlayer entityplayer, ForgeDirection side) {
        Item equipped;
        Item item = equipped = entityplayer.func_71045_bC() != null ? entityplayer.func_71045_bC().func_77973_b() : null;
        if (equipped instanceof IToolWrench && ((IToolWrench)equipped).canWrench(entityplayer, this.pipe.container.field_145851_c, this.pipe.container.field_145848_d, this.pipe.container.field_145849_e)) {
            if (side != ForgeDirection.UNKNOWN) {
                this.setSource(side);
            } else {
                this.switchSource();
            }
            ((IToolWrench)equipped).wrenchUsed(entityplayer, this.pipe.container.field_145851_c, this.pipe.container.field_145848_d, this.pipe.container.field_145849_e);
            return true;
        }
        return false;
    }

    public void onNeighborBlockChange() {
        if (!this.pipe.container.func_145831_w().field_72995_K) {
            this.switchSourceIfNeeded();
        }
    }
}

