/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.blueprints;

import buildcraft.api.blueprints.IBuilderContext;
import buildcraft.api.blueprints.SchematicBlock;
import buildcraft.api.core.BlockIndex;
import buildcraft.api.core.Position;
import buildcraft.core.builders.BuildingSlotBlock;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.Set;

public class IndexRequirementMap {
    private final Multimap<BlockIndex, BlockIndex> requirements = HashMultimap.create();
    private final Multimap<BlockIndex, BlockIndex> requirementsInv = HashMultimap.create();

    public void add(BuildingSlotBlock b, IBuilderContext context) {
        if (b.schematic instanceof SchematicBlock) {
            BlockIndex index = new BlockIndex(b.x, b.y, b.z);
            Set<BlockIndex> prereqs = ((SchematicBlock)b.schematic).getPrerequisiteBlocks(context);
            if (prereqs != null && prereqs.size() > 0) {
                Position min = context.surroundingBox().pMin();
                Position max = context.surroundingBox().pMax();
                for (BlockIndex i : prereqs) {
                    BlockIndex ia = new BlockIndex(i.x + index.x, i.y + index.y, i.z + index.z);
                    if (ia.equals(index) || (double)ia.x < min.x || (double)ia.y < min.y || (double)ia.z < min.z || (double)ia.x > max.x || (double)ia.y > max.y || (double)ia.z > max.z) continue;
                    this.requirements.put((Object)index, (Object)ia);
                    this.requirementsInv.put((Object)ia, (Object)index);
                }
            }
        }
    }

    public boolean contains(BlockIndex index) {
        return this.requirements.containsKey((Object)index);
    }

    public void remove(BuildingSlotBlock b) {
        BlockIndex index = new BlockIndex(b.x, b.y, b.z);
        this.remove(index);
    }

    public void remove(BlockIndex index) {
        for (BlockIndex reqingIndex : this.requirementsInv.get((Object)index)) {
            this.requirements.remove((Object)reqingIndex, (Object)index);
        }
        this.requirementsInv.removeAll((Object)index);
    }
}

