/*
 * Decompiled with CFR 0.152.
 */
package net.glease.tc4tweak;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.eventhandler.EventPriority;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.common.network.FMLNetworkEvent;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import net.glease.tc4tweak.CommonProxy;
import net.glease.tc4tweak.CommonUtils;
import net.glease.tc4tweak.ConfigurationHandler;
import net.glease.tc4tweak.asm.ASMCallhook;
import net.glease.tc4tweak.asm.LoadingPlugin;
import net.glease.tc4tweak.modules.hudNotif.HUDNotification;
import net.glease.tc4tweak.modules.researchBrowser.BrowserPaging;
import net.glease.tc4tweak.modules.researchBrowser.DrawResearchCompletionCounter;
import net.glease.tc4tweak.modules.researchBrowser.ThaumonomiconIndexSearcher;
import net.glease.tc4tweak.network.NetworkedConfiguration;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.IReloadableResourceManager;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.client.resources.IResourceManagerReloadListener;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.event.world.WorldEvent;
import org.lwjgl.input.Mouse;
import thaumcraft.client.fx.other.FXSonic;
import thaumcraft.client.gui.GuiResearchRecipe;
import thaumcraft.client.gui.GuiResearchTable;
import thaumcraft.common.config.ConfigItems;

public class ClientProxy
extends CommonProxy {
    static long lastScroll = 0L;
    static Field fieldPage = null;
    static Field fieldLastPage = null;
    static Method methodPlayScroll = null;
    static Field fieldModel = null;
    static Method GuiResearchRecipeMouseClicked = null;
    private static final int mPrevX = 261;
    private static final int mPrevY = 189;
    private static final int mNextX = -17;
    private static final int mNextY = 189;
    private static final int paneWidth = 256;
    private static final int paneHeight = 181;
    private long updateCounter = 0L;

    public static void handleMouseInput(GuiResearchTable screen) {
        if (fieldLastPage == null || fieldPage == null || methodPlayScroll == null) {
            return;
        }
        int dwheel = Mouse.getEventDWheel();
        if (dwheel == 0) {
            return;
        }
        long currentTimeMillis = System.currentTimeMillis();
        if (currentTimeMillis - lastScroll > 50L) {
            lastScroll = currentTimeMillis;
            try {
                int page = fieldPage.getInt(screen);
                if (dwheel < 0 != ConfigurationHandler.INSTANCE.isInverted()) {
                    int lastPage = fieldLastPage.getInt(screen);
                    if (page < lastPage) {
                        fieldPage.setInt(screen, page + 1);
                        methodPlayScroll.invoke((Object)screen, new Object[0]);
                    }
                } else if (page > 0) {
                    fieldPage.setInt(screen, page - 1);
                    methodPlayScroll.invoke((Object)screen, new Object[0]);
                }
            }
            catch (ReflectiveOperationException err) {
                System.err.println("Error scrolling through aspect list!");
                err.printStackTrace();
            }
        }
    }

    public static void handleMouseInput(GuiResearchRecipe screen) {
        if (GuiResearchRecipeMouseClicked == null) {
            return;
        }
        int dwheel = Mouse.getEventDWheel();
        if (dwheel == 0) {
            return;
        }
        long currentTimeMillis = System.currentTimeMillis();
        if (currentTimeMillis - lastScroll > 50L) {
            int mY;
            int mX;
            lastScroll = currentTimeMillis;
            if (dwheel < 0 != ConfigurationHandler.INSTANCE.isInverted()) {
                mX = 261;
                mY = 189;
            } else {
                mX = -17;
                mY = 189;
            }
            mX += (screen.field_146294_l - 256) / 2;
            mY += (screen.field_146295_m - 181) / 2;
            try {
                GuiResearchRecipeMouseClicked.invoke((Object)screen, mX, mY, 1);
            }
            catch (ReflectiveOperationException err) {
                System.err.println("Error scrolling through research page!");
                err.printStackTrace();
            }
        }
    }

    public ClientProxy() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @Override
    public void preInit(FMLPreInitializationEvent e) {
        super.preInit(e);
        ConfigurationHandler.INSTANCE.setGUISettings();
        try {
            Class<GuiResearchTable> guiResearchTableClass = GuiResearchTable.class;
            fieldPage = guiResearchTableClass.getDeclaredField("page");
            fieldPage.setAccessible(true);
            fieldLastPage = guiResearchTableClass.getDeclaredField("lastPage");
            fieldLastPage.setAccessible(true);
            methodPlayScroll = guiResearchTableClass.getDeclaredMethod("playButtonScroll", new Class[0]);
            methodPlayScroll.setAccessible(true);
            fieldModel = FXSonic.class.getDeclaredField("model");
            fieldModel.setAccessible(true);
        }
        catch (Exception err) {
            System.err.println("Cannot find thaumcraft fields. Aspect list scrolling will not properly function!");
            err.printStackTrace();
        }
        String mouseClicked = LoadingPlugin.isDev() ? "mouseClicked" : "func_73864_a";
        try {
            GuiResearchRecipeMouseClicked = GuiResearchRecipe.class.getDeclaredMethod(mouseClicked, Integer.TYPE, Integer.TYPE, Integer.TYPE);
            GuiResearchRecipeMouseClicked.setAccessible(true);
        }
        catch (Exception err) {
            System.err.println("Cannot find thaumcraft fields. Research page scrolling will not properly function!");
            err.printStackTrace();
        }
        IResourceManager resourceManager = Minecraft.func_71410_x().func_110442_L();
        if (resourceManager instanceof IReloadableResourceManager) {
            ((IReloadableResourceManager)resourceManager).func_110542_a(new IResourceManagerReloadListener(){

                public void func_110549_a(IResourceManager ignored) {
                    try {
                        fieldModel.set(null, null);
                    }
                    catch (IllegalAccessException | NullPointerException err) {
                        err.printStackTrace();
                    }
                }
            });
        }
    }

    @Override
    public void init(FMLInitializationEvent e) {
        super.init(e);
        ThaumonomiconIndexSearcher.init();
        DrawResearchCompletionCounter.init();
        HUDNotification.init();
        BrowserPaging.init();
    }

    @Override
    public void postInit(FMLPostInitializationEvent e) {
        super.postInit(e);
        try {
            Object wgSearcher = Class.forName("witchinggadgets.client.ThaumonomiconIndexSearcher").getField("instance").get(null);
            MinecraftForge.EVENT_BUS.unregister(wgSearcher);
            FMLCommonHandler.instance().bus().unregister(wgSearcher);
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            // empty catch block
        }
    }

    @SubscribeEvent
    public void onWorldLoad(WorldEvent.Load e) {
        if (e.world.field_72995_K) {
            CommonUtils.sortResearchCategories(false);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onTooltip(ItemTooltipEvent e) {
        if (ConfigurationHandler.INSTANCE.isAddTooltip() && e.itemStack != null) {
            if (e.itemStack.func_77973_b() == ConfigItems.itemResearchNotes) {
                e.toolTip.add(EnumChatFormatting.GOLD + StatCollector.func_74838_a((String)"tc4tweaks.enabled_scrolling"));
            } else if (!(e.itemStack.func_77973_b() != ConfigItems.itemWandCasting || ConfigurationHandler.INSTANCE.isCheckWorkbenchRecipes() && NetworkedConfiguration.isCheckWorkbenchRecipes())) {
                e.toolTip.add(EnumChatFormatting.RED + StatCollector.func_74838_a((String)"tc4tweaks.disable_vanilla"));
            }
        }
    }

    @SubscribeEvent
    public void onTickEnd(TickEvent.ClientTickEvent e) {
        if (e.phase == TickEvent.Phase.END && ++this.updateCounter > (long)ConfigurationHandler.INSTANCE.getUpdateInterval()) {
            this.updateCounter = 0L;
            ASMCallhook.updatePostponed();
        }
    }

    @SubscribeEvent
    public void onServerConnected(FMLNetworkEvent.ClientConnectedToServerEvent e) {
        if (!e.isLocal) {
            NetworkedConfiguration.resetClient();
        }
    }
}

