/*
 * Decompiled with CFR 0.152.
 */
package com.sinthoras.visualprospecting.mixins.xaerosworldmap;

import com.sinthoras.visualprospecting.VP;
import com.sinthoras.visualprospecting.integration.model.MapState;
import com.sinthoras.visualprospecting.integration.model.layers.LayerManager;
import com.sinthoras.visualprospecting.integration.xaeroworldmap.XaeroWorldMapState;
import com.sinthoras.visualprospecting.integration.xaeroworldmap.buttons.LayerButton;
import com.sinthoras.visualprospecting.integration.xaeroworldmap.buttons.SizedGuiTexturedButton;
import com.sinthoras.visualprospecting.integration.xaeroworldmap.renderers.InteractableLayerRenderer;
import com.sinthoras.visualprospecting.integration.xaeroworldmap.renderers.LayerRenderer;
import com.sinthoras.visualprospecting.integration.xaeroworldmap.rendersteps.RenderStep;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.Entity;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Slice;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;
import xaero.map.MapProcessor;
import xaero.map.gui.CursorBox;
import xaero.map.gui.GuiMap;
import xaero.map.gui.ScreenBase;
import xaero.map.misc.Misc;

@Mixin(value={GuiMap.class}, remap=false)
public abstract class GuiMapMixin
extends ScreenBase {
    @Unique
    private int oldMouseX = 0;
    @Unique
    private int oldMouseY = 0;
    @Unique
    private long timeLastClick = 0L;
    @Shadow
    private double cameraX;
    @Shadow
    private double cameraZ;
    @Shadow
    private double scale;
    @Shadow
    private int screenScale;

    protected GuiMapMixin(GuiScreen parent, GuiScreen escape) {
        super(parent, escape);
    }

    @Shadow
    public abstract void addGuiButton(GuiButton var1);

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    private void injectConstruct(GuiScreen parent, GuiScreen escape, MapProcessor mapProcessor, Entity player, CallbackInfo ci) {
        MapState.instance.layers.forEach(LayerManager::onOpenMap);
    }

    @Inject(method={"func_73863_a"}, at={@At(value="INVOKE", target="Lorg/lwjgl/opengl/GL11;glPushMatrix()V", ordinal=1)}, locals=LocalCapture.CAPTURE_FAILEXCEPTION)
    private void injectPreRender(int scaledMouseX, int scaledMouseY, float partialTicks, CallbackInfo ci, Minecraft mc) {
        if (mc.field_71474_y.field_74350_i < 255 || mc.field_71474_y.field_74352_v) {
            this.cameraX = (double)Math.round(this.cameraX * this.scale) / this.scale;
            this.cameraZ = (double)Math.round(this.cameraZ * this.scale) / this.scale;
        }
        double mousePosX = (double)((int)Misc.getMouseX((Minecraft)mc) - mc.field_71443_c / 2) / this.scale;
        double mousePosZ = (double)((int)Misc.getMouseY((Minecraft)mc) - mc.field_71440_d / 2) / this.scale;
        for (LayerRenderer layer : XaeroWorldMapState.instance.renderers) {
            if (!(layer instanceof InteractableLayerRenderer)) continue;
            ((InteractableLayerRenderer)layer).updateHovered(mousePosX, mousePosZ, this.scale);
        }
    }

    @Inject(method={"func_73863_a"}, at={@At(value="INVOKE", target="Lorg/lwjgl/opengl/GL11;glEnable(I)V", ordinal=1, shift=At.Shift.AFTER)}, slice={@Slice(from=@At(value="INVOKE", target="Lorg/lwjgl/opengl/GL14;glBlendFuncSeparate(IIII)V"), to=@At(value="INVOKE", target="Lxaero/map/mods/SupportXaeroMinimap;renderWaypoints(Lnet/minecraft/client/gui/GuiScreen;DDIIDDDDLjava/util/regex/Pattern;Ljava/util/regex/Pattern;FLxaero/map/mods/gui/Waypoint;Lnet/minecraft/client/Minecraft;Lnet/minecraft/client/gui/ScaledResolution;)Lxaero/map/mods/gui/Waypoint;"))})
    private void injectDraw(int scaledMouseX, int scaledMouseY, float partialTicks, CallbackInfo ci) {
        for (LayerManager layerManager : MapState.instance.layers) {
            if (!layerManager.isLayerActive()) continue;
            layerManager.recacheFullscreenMap((int)this.cameraX, (int)this.cameraZ, (int)((double)this.field_146297_k.field_71443_c / this.scale) + 20, (int)((double)this.field_146297_k.field_71440_d / this.scale) + 20);
        }
        for (LayerRenderer renderer : XaeroWorldMapState.instance.renderers) {
            if (!renderer.isLayerActive()) continue;
            for (RenderStep step : renderer.getRenderSteps()) {
                step.draw((GuiScreen)this, this.cameraX, this.cameraZ, this.scale);
            }
        }
    }

    @Inject(method={"func_73863_a"}, at={@At(value="INVOKE", target="Lorg/lwjgl/opengl/GL11;glTranslated(DDD)V")}, slice={@Slice(from=@At(value="FIELD", target="Lnet/minecraft/client/Minecraft;field_71462_r:Lnet/minecraft/client/gui/GuiScreen;", opcode=180), to=@At(value="INVOKE", target="Lxaero/map/gui/CursorBox;drawBox(IIII)V"))})
    private void injectDrawTooltip(int scaledMouseX, int scaledMouseY, float partialTicks, CallbackInfo ci) {
        for (LayerRenderer layer : XaeroWorldMapState.instance.renderers) {
            if (!(layer instanceof InteractableLayerRenderer) || !layer.isLayerActive()) continue;
            ((InteractableLayerRenderer)layer).drawTooltip((GuiScreen)this, this.scale, this.screenScale);
        }
    }

    @Inject(method={"func_73866_w_"}, at={@At(value="INVOKE", target="Lorg/lwjgl/input/Keyboard;enableRepeatEvents(Z)V")})
    private void injectInitButtons(CallbackInfo ci) {
        for (int i = 0; i < XaeroWorldMapState.instance.buttons.size(); ++i) {
            LayerButton layerButton = XaeroWorldMapState.instance.buttons.get(i);
            SizedGuiTexturedButton button = new SizedGuiTexturedButton(0, this.field_146295_m - 20 * (i + 1), layerButton.textureLocation, btn -> layerButton.toggle(), new CursorBox(layerButton.getButtonTextKey()));
            layerButton.setButton(button);
            this.addGuiButton((GuiButton)button);
        }
    }

    @Inject(method={"onInputPress"}, at={@At(value="TAIL")})
    private void injectListenKeypress(boolean mouse, int code, CallbackInfoReturnable<Boolean> cir) {
        if (Misc.inputMatchesKeyBinding((boolean)mouse, (int)code, (KeyBinding)VP.keyAction)) {
            for (LayerRenderer layer : XaeroWorldMapState.instance.renderers) {
                if (!(layer instanceof InteractableLayerRenderer)) continue;
                ((InteractableLayerRenderer)layer).doActionKeyPress();
            }
        }
    }

    @Inject(method={"mapClicked"}, at={@At(value="TAIL")})
    private void injectListenClick(int button, int x, int y, CallbackInfo ci) {
        if (button == 0) {
            long timestamp = System.currentTimeMillis();
            boolean isDoubleClick = x == this.oldMouseX && y == this.oldMouseY && timestamp - this.timeLastClick < 500L;
            this.oldMouseX = x;
            this.oldMouseY = y;
            long l = this.timeLastClick = isDoubleClick ? 0L : timestamp;
            if (isDoubleClick) {
                for (LayerRenderer layer : XaeroWorldMapState.instance.renderers) {
                    if (!(layer instanceof InteractableLayerRenderer) || !layer.isLayerActive()) continue;
                    ((InteractableLayerRenderer)layer).doDoubleClick();
                }
            }
        }
    }
}

