/*
 * Decompiled with CFR 0.152.
 */
package com.sinthoras.visualprospecting.integration.journeymap.drawsteps;

import com.sinthoras.visualprospecting.integration.model.locations.DirtyChunkLocation;
import java.awt.geom.Point2D;
import journeymap.client.render.draw.DrawStep;
import journeymap.client.render.draw.DrawUtil;
import journeymap.client.render.map.GridRenderer;

public class DirtyChunkDrawStep
implements DrawStep {
    private final DirtyChunkLocation dirtyChunkLocation;

    public DirtyChunkDrawStep(DirtyChunkLocation dirtyChunkLocation) {
        this.dirtyChunkLocation = dirtyChunkLocation;
    }

    public void draw(double draggedPixelX, double draggedPixelY, GridRenderer gridRenderer, float drawScale, double fontScale, double rotation) {
        int zoom = gridRenderer.getZoom();
        double blockSize = Math.pow(2.0, zoom);
        Point2D.Double blockAsPixel = gridRenderer.getBlockPixelInGrid(this.dirtyChunkLocation.getBlockX(), this.dirtyChunkLocation.getBlockZ());
        Point2D.Double pixel = new Point2D.Double(blockAsPixel.getX() + draggedPixelX, blockAsPixel.getY() + draggedPixelY);
        float alpha = 0.5f;
        alpha *= alpha * 204.0f;
        int color = this.dirtyChunkLocation.isDirty() ? 0xFF0000 : 65450;
        DrawUtil.drawRectangle((double)pixel.getX(), (double)pixel.getY(), (double)(16.0 * blockSize), (double)(16.0 * blockSize), (int)color, (int)((int)alpha));
        if (this.dirtyChunkLocation.isDirty()) {
            int borderColor = 16766720;
            int borderAlpha = 204;
            DrawUtil.drawRectangle((double)pixel.getX(), (double)pixel.getY(), (double)(15.0 * blockSize), (double)blockSize, (int)16766720, (int)204);
            DrawUtil.drawRectangle((double)(pixel.getX() + 15.0 * blockSize), (double)pixel.getY(), (double)blockSize, (double)(15.0 * blockSize), (int)16766720, (int)204);
            DrawUtil.drawRectangle((double)(pixel.getX() + 1.0 * blockSize), (double)(pixel.getY() + 15.0 * blockSize), (double)(15.0 * blockSize), (double)blockSize, (int)16766720, (int)204);
            DrawUtil.drawRectangle((double)pixel.getX(), (double)(pixel.getY() + 1.0 * blockSize), (double)blockSize, (double)(15.0 * blockSize), (int)16766720, (int)204);
            DrawUtil.drawLabel((String)"D", (double)(pixel.getX() + 13.0 * blockSize), (double)(pixel.getY() + 13.0 * blockSize), (DrawUtil.HAlign)DrawUtil.HAlign.Left, (DrawUtil.VAlign)DrawUtil.VAlign.Above, (Integer)0, (int)180, (Integer)0xFFFFFF, (int)255, (double)fontScale, (boolean)false, (double)rotation);
        }
    }
}

