/*
 * Decompiled with CFR 0.152.
 */
package com.sinthoras.visualprospecting.hooks;

import com.sinthoras.visualprospecting.Config;
import com.sinthoras.visualprospecting.VP;
import com.sinthoras.visualprospecting.database.RedoServerCacheCommand;
import com.sinthoras.visualprospecting.database.ServerCache;
import com.sinthoras.visualprospecting.database.WorldIdHandler;
import com.sinthoras.visualprospecting.database.cachebuilder.WorldAnalysis;
import com.sinthoras.visualprospecting.database.veintypes.VeinTypeCaching;
import com.sinthoras.visualprospecting.hooks.HooksEventBus;
import com.sinthoras.visualprospecting.hooks.HooksFML;
import com.sinthoras.visualprospecting.item.ProspectorsLog;
import com.sinthoras.visualprospecting.network.ProspectingNotification;
import com.sinthoras.visualprospecting.network.ProspectingRequest;
import com.sinthoras.visualprospecting.network.ProspectionSharing;
import com.sinthoras.visualprospecting.network.WorldIdNotification;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.event.FMLServerAboutToStartEvent;
import cpw.mods.fml.common.event.FMLServerStartedEvent;
import cpw.mods.fml.common.event.FMLServerStartingEvent;
import cpw.mods.fml.common.event.FMLServerStoppedEvent;
import cpw.mods.fml.common.event.FMLServerStoppingEvent;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import gregtech.api.GregTech_API;
import gregtech.api.enums.GT_Values;
import gregtech.api.enums.Materials;
import gregtech.api.enums.OrePrefixes;
import gregtech.api.util.GT_OreDictUnificator;
import java.io.IOException;
import java.util.zip.DataFormatException;
import net.minecraft.command.ICommand;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.common.MinecraftForge;

public class HooksShared {
    public void fmlLifeCycleEvent(FMLPreInitializationEvent event) {
        Config.syncronizeConfiguration(event.getSuggestedConfigurationFile());
        VP.network = NetworkRegistry.INSTANCE.newSimpleChannel("visualprospecting");
        int networkId = 0;
        VP.network.registerMessage(ProspectingRequest.Handler.class, ProspectingRequest.class, networkId++, Side.SERVER);
        VP.network.registerMessage(ProspectingNotification.Handler.class, ProspectingNotification.class, networkId++, Side.CLIENT);
        VP.network.registerMessage(WorldIdNotification.Handler.class, WorldIdNotification.class, networkId++, Side.CLIENT);
        VP.network.registerMessage(ProspectionSharing.ServerHandler.class, ProspectionSharing.class, networkId++, Side.SERVER);
        VP.network.registerMessage(ProspectionSharing.ClientHandler.class, ProspectionSharing.class, networkId++, Side.CLIENT);
        ProspectorsLog.instance = new ProspectorsLog();
        GameRegistry.registerItem((Item)ProspectorsLog.instance, (String)ProspectorsLog.instance.func_77658_a());
    }

    public void fmlLifeCycleEvent(FMLInitializationEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)new HooksEventBus());
        FMLCommonHandler.instance().bus().register((Object)new HooksFML());
    }

    public void fmlLifeCycleEvent(FMLPostInitializationEvent event) {
        GregTech_API.sAfterGTPostload.add(new VeinTypeCaching());
        GregTech_API.sAfterGTPostload.add(() -> GT_Values.RA.addAssemblerRecipe(new ItemStack[]{GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.plate, (Object)Materials.Wood, (long)2L), new ItemStack(Items.field_151099_bA, 1, Short.MAX_VALUE), new ItemStack(Items.field_151074_bl, 1, Short.MAX_VALUE)}, Materials.Glue.getFluid(20L), new ItemStack((Item)ProspectorsLog.instance, 1, 0), 128, 8));
    }

    public void fmlLifeCycleEvent(FMLServerAboutToStartEvent event) {
    }

    public void fmlLifeCycleEvent(FMLServerStartingEvent event) {
        MinecraftServer minecraftServer = event.getServer();
        WorldIdHandler.load(minecraftServer.field_71305_c[0]);
        if (!ServerCache.instance.loadVeinCache(WorldIdHandler.getWorldId()) || Config.recacheVeins) {
            try {
                WorldAnalysis world = new WorldAnalysis(minecraftServer.func_130014_f_().func_72860_G().func_75765_b());
                world.cacheVeins();
            }
            catch (IOException | DataFormatException e) {
                VP.info("Could not load world save files to build vein cache!");
                e.printStackTrace();
            }
        }
        event.registerServerCommand((ICommand)new RedoServerCacheCommand());
    }

    public void fmlLifeCycleEvent(FMLServerStartedEvent event) {
    }

    public void fmlLifeCycleEvent(FMLServerStoppingEvent event) {
        ServerCache.instance.saveVeinCache();
        ServerCache.instance.reset();
    }

    public void fmlLifeCycleEvent(FMLServerStoppedEvent event) {
    }
}

