/*
 * Decompiled with CFR 0.152.
 */
package com.sinthoras.visualprospecting.shadow.io.xol.enklume.nbt;

import com.sinthoras.visualprospecting.shadow.io.xol.enklume.nbt.NBTList;
import com.sinthoras.visualprospecting.shadow.io.xol.enklume.nbt.NBTNamed;
import com.sinthoras.visualprospecting.shadow.io.xol.enklume.nbt.NBTag;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class NBTCompound
extends NBTNamed
implements Iterable<NBTNamed> {
    Map<String, NBTNamed> tags = new HashMap<String, NBTNamed>();

    @Override
    void feed(DataInputStream is) throws IOException {
        super.feed(is);
        NBTag tag = NBTag.parseInputStream(is);
        while (tag instanceof NBTNamed) {
            NBTNamed namedTag = (NBTNamed)tag;
            this.tags.put(namedTag.getName(), namedTag);
            tag = NBTag.parseInputStream(is);
        }
    }

    public NBTNamed getTag(String path) {
        if (path.startsWith(".")) {
            path = path.substring(1);
        }
        if (path.equals("")) {
            return this;
        }
        String[] s = path.split("\\.");
        String looking = s[0];
        if (this.tags.containsKey(looking)) {
            NBTNamed found = this.tags.get(looking);
            if (s.length > 1) {
                String deeper = path.substring(looking.length() + 1);
                if (found instanceof NBTCompound) {
                    return ((NBTCompound)found).getTag(deeper);
                }
                if (found instanceof NBTList) {
                    return ((NBTList)found).getTag(deeper);
                }
                System.out.println("error: Can't traverse tag " + found + "; not a Compound, nor a List tag.");
            } else {
                return found;
            }
        }
        return null;
    }

    @Override
    public Iterator<NBTNamed> iterator() {
        return this.tags.values().iterator();
    }
}

