/*
 * Decompiled with CFR 0.152.
 */
package com.sinthoras.visualprospecting.mixins.minecraft;

import com.sinthoras.visualprospecting.Utils;
import com.sinthoras.visualprospecting.VP;
import com.sinthoras.visualprospecting.database.ClientCache;
import com.sinthoras.visualprospecting.database.OreVeinPosition;
import com.sinthoras.visualprospecting.database.ServerCache;
import com.sinthoras.visualprospecting.database.UndergroundFluidPosition;
import com.sinthoras.visualprospecting.network.ProspectingNotification;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemEditableBook;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={ItemEditableBook.class}, remap=true)
public class ItemEditableBookMixin {
    @Inject(method={"onItemRightClick"}, at={@At(value="HEAD")}, remap=true, require=1, locals=LocalCapture.CAPTURE_FAILEXCEPTION)
    private void onItemRightClick(ItemStack itemStack, World world, EntityPlayer entityPlayer, CallbackInfoReturnable<ItemStack> callbackInfoReturnable) {
        NBTTagCompound compound;
        if (!world.field_72995_K && (compound = itemStack.func_77978_p()).func_74764_b("is_visualprospecting_data")) {
            int dimensionId = compound.func_74762_e("prospection_dimension_id");
            int blockX = compound.func_74762_e("prospection_block_x");
            int blockZ = compound.func_74762_e("prospection_block_z");
            int blockRadius = compound.func_74762_e("prospection_ore_radius");
            List<OreVeinPosition> foundOreVeins = ServerCache.instance.prospectOreBlockRadius(dimensionId, blockX, blockZ, blockRadius);
            List<UndergroundFluidPosition> foundUndergroundFluids = ServerCache.instance.prospectUndergroundFluidBlockRadius(world, blockX, blockZ, 128);
            if (Utils.isLogicalClient()) {
                ClientCache.instance.putOreVeins(foundOreVeins);
                ClientCache.instance.putUndergroundFluids(foundUndergroundFluids);
            } else {
                VP.network.sendTo((IMessage)new ProspectingNotification(foundOreVeins, foundUndergroundFluids), (EntityPlayerMP)entityPlayer);
            }
        }
    }
}

