/*
 * Decompiled with CFR 0.152.
 */
package com.sinthoras.visualprospecting.integration.xaeroworldmap.rendersteps;

import com.sinthoras.visualprospecting.integration.DrawUtils;
import com.sinthoras.visualprospecting.integration.model.layers.ThaumcraftNodeLayerManager;
import com.sinthoras.visualprospecting.integration.model.locations.IWaypointAndLocationProvider;
import com.sinthoras.visualprospecting.integration.model.locations.ThaumcraftNodeLocation;
import com.sinthoras.visualprospecting.integration.xaeroworldmap.rendersteps.InteractableRenderStep;
import javax.annotation.Nullable;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.client.lib.UtilsFX;

public class ThaumcraftNodeRenderStep
implements InteractableRenderStep {
    private static final ResourceLocation markedTextureLocation = new ResourceLocation("visualprospecting", "textures/node_marked.png");
    private static final ResourceLocation unmarkedTextureLocation = new ResourceLocation("visualprospecting", "textures/node_unmarked.png");
    private final ThaumcraftNodeLocation thaumcraftNodeLocation;
    private double centerPixelX = 0.0;
    private double centerPixelY = 0.0;
    private double clickableRadiusPixelSquared = 0.0;

    public ThaumcraftNodeRenderStep(ThaumcraftNodeLocation thaumcraftNodeLocation) {
        this.thaumcraftNodeLocation = thaumcraftNodeLocation;
    }

    @Override
    public void draw(@Nullable GuiScreen gui, double cameraX, double cameraZ, double scale) {
        double borderSize = 44.0;
        double borderSizeHalf = 22.0;
        double scaleForGui = Math.max(0.5, scale);
        this.centerPixelX = (this.thaumcraftNodeLocation.getBlockX() - cameraX) * scaleForGui;
        this.centerPixelY = (this.thaumcraftNodeLocation.getBlockZ() - cameraZ) * scaleForGui;
        this.clickableRadiusPixelSquared = 484.0;
        GL11.glPushMatrix();
        GL11.glTranslated((double)(this.thaumcraftNodeLocation.getBlockX() - cameraX), (double)(this.thaumcraftNodeLocation.getBlockZ() - cameraZ), (double)0.0);
        GL11.glScaled((double)(1.0 / scaleForGui), (double)(1.0 / scaleForGui), (double)1.0);
        int alpha = 204;
        DrawUtils.drawQuad(this.thaumcraftNodeLocation.isActiveAsWaypoint() ? markedTextureLocation : unmarkedTextureLocation, -22.0, -22.0, 44.0, 44.0, 0xFFFFFF, 204.0f);
        int aspectPixelDiameter = 32;
        DrawUtils.drawAspect(0.0, 0.0, 32.0, this.thaumcraftNodeLocation.getStrongestAspect(), 0);
        GL11.glPopMatrix();
    }

    @Override
    public boolean isMouseOver(double mouseX, double mouseY, double scale) {
        double deltaY;
        double scaleForGui = Math.max(0.5, scale);
        double deltaX = mouseX * scaleForGui - this.centerPixelX;
        return deltaX * deltaX + (deltaY = mouseY * scaleForGui - this.centerPixelY) * deltaY <= this.clickableRadiusPixelSquared;
    }

    @Override
    public void drawTooltip(GuiScreen gui, double mouseX, double mouseY, double scale, int scaleAdj) {
        GL11.glPushMatrix();
        mouseX = (mouseX * scale + (double)(gui.field_146297_k.field_71443_c >> 1)) / (double)scaleAdj;
        mouseY = (mouseY * scale + (double)(gui.field_146297_k.field_71440_d >> 1)) / (double)scaleAdj;
        boolean isWaypoint = this.thaumcraftNodeLocation.isActiveAsWaypoint();
        String asWaypoint = this.thaumcraftNodeLocation.getActiveWaypointHint();
        String title = this.thaumcraftNodeLocation.getTitle();
        String nodeDescription = this.thaumcraftNodeLocation.getDescription();
        String deleteHint = this.thaumcraftNodeLocation.getDeleteHint();
        int maxTextWidth = Math.max(Math.max(gui.field_146297_k.field_71466_p.func_78256_a(title), gui.field_146297_k.field_71466_p.func_78256_a(nodeDescription)), gui.field_146297_k.field_71466_p.func_78256_a(deleteHint));
        if (isWaypoint) {
            maxTextWidth = Math.max(maxTextWidth, gui.field_146297_k.field_71466_p.func_78256_a(asWaypoint));
        }
        if (gui.field_146297_k.field_71466_p.func_78260_a()) {
            maxTextWidth = (int)Math.ceil((float)maxTextWidth * 1.25f);
        }
        int aspectRows = (this.thaumcraftNodeLocation.getAspects().size() + 4) / 5;
        int aspectColumns = Math.min(this.thaumcraftNodeLocation.getAspects().size(), 5);
        int pixelX = (int)(mouseX + 12.0);
        int pixelY = (int)(mouseY - 12.0);
        int tooltipHeight = (isWaypoint ? 44 : 32) + aspectRows * 16;
        int tooltipWidth = Math.max(aspectColumns * 16, maxTextWidth);
        if (pixelX + tooltipWidth > gui.field_146297_k.field_71443_c) {
            pixelX -= 28 + tooltipWidth;
        }
        if (pixelY + tooltipHeight + 6 > gui.field_146297_k.field_71440_d) {
            pixelY = gui.field_146297_k.field_71440_d - tooltipHeight - 6;
        }
        GL11.glDisable((int)2929);
        int backgroundColor = -267386864;
        DrawUtils.drawGradientRect(pixelX - 3, pixelY - 4, pixelX + tooltipWidth + 3, pixelY - 3, -267386864, -267386864);
        DrawUtils.drawGradientRect(pixelX - 3, pixelY + tooltipHeight + 3, pixelX + tooltipWidth + 3, pixelY + tooltipHeight + 4, -267386864, -267386864);
        DrawUtils.drawGradientRect(pixelX - 3, pixelY - 3, pixelX + tooltipWidth + 3, pixelY + tooltipHeight + 3, -267386864, -267386864);
        DrawUtils.drawGradientRect(pixelX - 4, pixelY - 3, pixelX - 3, pixelY + tooltipHeight + 3, -267386864, -267386864);
        DrawUtils.drawGradientRect(pixelX + tooltipWidth + 3, pixelY - 3, pixelX + tooltipWidth + 4, pixelY + tooltipHeight + 3, -267386864, -267386864);
        int offset = 0;
        if (gui.field_146297_k.field_71466_p.func_78260_a()) {
            if (isWaypoint) {
                int asWaypointWidth = (int)Math.ceil((float)gui.field_146297_k.field_71466_p.func_78256_a(asWaypoint) * 1.1f);
                gui.field_146297_k.field_71466_p.func_78276_b(title, pixelX + tooltipWidth - asWaypointWidth, pixelY, -1);
                offset += 12;
            }
            int titleWidth = (int)Math.ceil((float)gui.field_146297_k.field_71466_p.func_78256_a(title) * 1.1f);
            gui.field_146297_k.field_71466_p.func_78276_b(title, pixelX + tooltipWidth - titleWidth, pixelY + offset, -1);
            int nodeDescriptonWidth = (int)Math.ceil((float)gui.field_146297_k.field_71466_p.func_78256_a(nodeDescription) * 1.1f);
            gui.field_146297_k.field_71466_p.func_78276_b(nodeDescription, pixelX + nodeDescriptonWidth - titleWidth, pixelY + (offset += 12), -1);
            int deleteHintWidth = (int)Math.ceil((float)gui.field_146297_k.field_71466_p.func_78256_a(deleteHint) * 1.1f);
            gui.field_146297_k.field_71466_p.func_78276_b(deleteHint, pixelX + tooltipWidth - deleteHintWidth, pixelY + aspectRows * 16 + offset + 12, -1);
        } else {
            if (isWaypoint) {
                gui.field_146297_k.field_71466_p.func_78276_b(asWaypoint, pixelX, pixelY, -1);
                offset += 12;
            }
            gui.field_146297_k.field_71466_p.func_78276_b(title, pixelX, pixelY + offset, -1);
            gui.field_146297_k.field_71466_p.func_78276_b(nodeDescription, pixelX, pixelY + (offset += 12), -1);
            gui.field_146297_k.field_71466_p.func_78276_b(deleteHint, pixelX, pixelY + aspectRows * 16 + offset + 12, -1);
        }
        int aspectX = 0;
        int aspectY = 0;
        for (Aspect aspect : this.thaumcraftNodeLocation.getAspects().getAspectsSortedAmount()) {
            GL11.glPushMatrix();
            UtilsFX.drawTag((int)(pixelX + aspectX * 16), (int)(pixelY + aspectY * 16 + offset + 10), (Aspect)aspect, (float)this.thaumcraftNodeLocation.getAspects().getAmount(aspect), (int)0, (double)0.01, (int)1, (float)1.0f, (boolean)false);
            GL11.glPopMatrix();
            if (++aspectX < 5) continue;
            aspectX = 0;
            ++aspectY;
        }
        GL11.glDisable((int)2896);
        GL11.glPopMatrix();
    }

    @Override
    public void onActionButton() {
        ThaumcraftNodeLayerManager.instance.deleteNode(this.thaumcraftNodeLocation);
    }

    @Override
    public IWaypointAndLocationProvider getLocationProvider() {
        return this.thaumcraftNodeLocation;
    }
}

