/*
 * Decompiled with CFR 0.152.
 */
package com.sinthoras.visualprospecting.database.cachebuilder;

import com.sinthoras.visualprospecting.VP;
import com.sinthoras.visualprospecting.database.ServerCache;
import com.sinthoras.visualprospecting.database.cachebuilder.AnalysisProgressTracker;
import com.sinthoras.visualprospecting.database.cachebuilder.DimensionAnalysis;
import com.sinthoras.visualprospecting.shadow.io.xol.enklume.MinecraftWorld;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.zip.DataFormatException;

public class WorldAnalysis {
    private final MinecraftWorld world;

    public WorldAnalysis(File worldDirectory) throws IOException {
        this.world = new MinecraftWorld(worldDirectory);
    }

    public void cacheVeins() throws IOException, DataFormatException {
        VP.info("Starting to parse world save to cache GT vein locations. This might take some time...");
        ServerCache.instance.reset();
        List<Integer> dimensionIds = this.world.getDimensionIds();
        AnalysisProgressTracker.setNumberOfDimensions(dimensionIds.size());
        for (int dimensionId : dimensionIds) {
            DimensionAnalysis dimension = new DimensionAnalysis(dimensionId);
            dimension.processMinecraftWorld(this.world);
            AnalysisProgressTracker.dimensionProcessed();
        }
        AnalysisProgressTracker.processingFinished();
        VP.info("Saving ore vein cache...");
        ServerCache.instance.saveVeinCache();
    }
}

